/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal;

public class FirDecimator {
    private double[] p_H;
    private int factor_M;
    private double[] p_Z;

    public FirDecimator(double[] fir, int factor) {
        this.p_H = fir;
        this.factor_M = factor;
        this.p_Z = new double[fir.length];
    }

    public double[] getDelayLineArray() {
        return this.p_Z;
    }

    public int decim(double[] p_inp, int offInp, int num_inp, double[] p_out, int offOut) {
        int idxIn = offInp;
        int idxOut = offOut;
        if (num_inp % this.factor_M != 0) {
            return -1;
        }
        int num_out = 0;
        while (num_inp >= this.factor_M) {
            int tap = this.p_H.length - 1;
            while (tap >= this.factor_M) {
                this.p_Z[tap] = this.p_Z[tap - this.factor_M];
                --tap;
            }
            tap = this.factor_M - 1;
            while (tap >= 0) {
                this.p_Z[tap] = p_inp[idxIn++];
                --tap;
            }
            num_inp -= this.factor_M;
            double sum = 0.0;
            tap = 0;
            while (tap < this.p_H.length) {
                sum += this.p_H[tap] * this.p_Z[tap];
                ++tap;
            }
            p_out[idxOut++] = sum;
            ++num_out;
        }
        return num_out;
    }
}

