/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal;

import VisualNumerics.math.DoubleLU;
import VisualNumerics.math.MathException;
import cn.org.gddsn.signal.FilterDB;

public class Filter {
    private String name = "";
    private double[] _b;
    private double[] _a;
    private double[] b;
    private double[] a;
    private double[] zi;

    public Filter() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Filter(double[] b, double[] a) {
        this.set(b, a);
    }

    public void set(double[] b, double[] a) {
        this._b = b;
        this._a = a;
        int len = Math.max(b.length, a.length);
        int nb = b.length;
        int na = a.length;
        this.b = new double[len];
        System.arraycopy(b, 0, this.b, 0, nb);
        this.a = new double[len];
        System.arraycopy(a, 0, this.a, 0, na);
        this.zi = new double[len];
    }

    public double filter(double x) {
        int len = this.zi.length;
        int order = len - 1;
        double y = this.b[0] * x + this.zi[0];
        int j = 0;
        while (j < order - 1) {
            this.zi[j] = this.b[j + 1] * x + this.zi[j + 1] - this.a[j + 1] * y;
            ++j;
        }
        this.zi[order - 1] = this.b[order] * x - this.a[order] * y;
        return y;
    }

    public double[] filter(double[] x) {
        double[] y = new double[x.length];
        int i = 0;
        while (i < x.length) {
            y[i] = this.filter(x[i]);
            ++i;
        }
        return y;
    }

    public double[] filter(int[] x) {
        double[] y = new double[x.length];
        int i = 0;
        while (i < x.length) {
            y[i] = this.filter(x[i]);
            ++i;
        }
        return y;
    }

    public int[] ifilter(int[] x) {
        int[] y = new int[x.length];
        int i = 0;
        while (i < x.length) {
            y[i] = (int)this.filter(x[i]);
            ++i;
        }
        return y;
    }

    public double[] getNumCoef() {
        return this._b;
    }

    public double[] getDenCoef() {
        return this._a;
    }

    public Filter(FilterDB db) {
        this.set(db.getNum(), db.getDen());
    }

    public static double[] filter(double[] b, double[] a, double[] x) {
        Filter f = new Filter(b, a);
        return f.filter(x);
    }

    public static double[] filter(FilterDB filterDB, double[] x) {
        return Filter.filter(filterDB.getNum(), filterDB.getDen(), x);
    }

    public static double[] filtfilt(double[] b, double[] a, double[] x) {
        double swap;
        int len = x.length;
        int nb = b.length;
        int na = a.length;
        int nfilt = Math.max(nb, na);
        int nfact = 3 * (nfilt - 1);
        if (len <= nfact) {
            throw new IllegalArgumentException("Data must have length more than 3 times filter order.");
        }
        if (nb < nfilt) {
            double[] b1 = new double[nfilt];
            System.arraycopy(b, 0, b1, 0, nb);
            b = b1;
        }
        if (na < nfilt) {
            double[] a1 = new double[nfilt];
            System.arraycopy(a, 0, a1, 0, na);
            a = a1;
        }
        double[] B = new double[nfilt - 1];
        double[][] A = new double[nfilt - 1][nfilt - 1];
        int i = 0;
        while (i < nfilt - 1) {
            B[i] = b[i + 1] - a[i + 1] * b[0];
            ++i;
        }
        A[0][0] = 1.0;
        i = 0;
        while (i < nfilt - 1) {
            int j = 0;
            while (j < nfilt - 1) {
                if (j == 0) {
                    double[] dArray = A[i];
                    int n = j;
                    dArray[n] = dArray[n] + a[i + 1];
                } else if (i == j) {
                    A[i][j] = 1.0;
                } else if (i + 1 == j) {
                    A[i][j] = -1.0;
                }
                ++j;
            }
            ++i;
        }
        double[] zi = new double[nfilt - 1];
        try {
            DoubleLU aLU = new DoubleLU(A);
            zi = aLU.solve(B);
        }
        catch (MathException aLU) {
            // empty catch block
        }
        B = null;
        A = null;
        double[] y = new double[len + 2 * nfact];
        int i2 = 0;
        while (i2 < nfact) {
            y[i2] = 2.0 * x[0] - x[nfact - i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < len) {
            y[i2 + nfact] = x[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < nfact) {
            y[i2 + len + nfact] = 2.0 * x[len - 1] - x[len - 2 - i2];
            ++i2;
        }
        double[] tmpZi = new double[zi.length];
        int i3 = 0;
        while (i3 < tmpZi.length) {
            tmpZi[i3] = zi[i3] * y[0];
            ++i3;
        }
        y = Filter.filter(b, a, y, tmpZi);
        int ylen = y.length - 1;
        int i4 = 0;
        while (i4 < y.length / 2) {
            swap = y[i4];
            y[i4] = y[ylen - i4];
            y[ylen - i4] = swap;
            ++i4;
        }
        i4 = 0;
        while (i4 < tmpZi.length) {
            tmpZi[i4] = zi[i4] * y[0];
            ++i4;
        }
        y = Filter.filter(b, a, y, tmpZi);
        ylen = y.length - 1;
        i4 = 0;
        while (i4 < y.length / 2) {
            swap = y[i4];
            y[i4] = y[ylen - i4];
            y[ylen - i4] = swap;
            ++i4;
        }
        double[] ret = new double[len];
        int i5 = 0;
        while (i5 < len) {
            ret[i5] = y[nfact + i5];
            ++i5;
        }
        y = null;
        tmpZi = null;
        return ret;
    }

    public double[] filtfilt(double[] x) {
        return Filter.filtfilt(this._b, this._a, x);
    }

    public int[] filtfilt(int[] x) {
        double[] dx = new double[x.length];
        int i = 0;
        while (i < x.length) {
            dx[i] = x[i];
            ++i;
        }
        double[] ret = this.filtfilt(dx);
        int[] iret = new int[x.length];
        int i2 = 0;
        while (i2 < x.length) {
            iret[i2] = (int)ret[i2];
            ++i2;
        }
        dx = null;
        ret = null;
        return iret;
    }

    public static int[] filtfilt(double[] b, double[] a, int[] x) {
        double[] dx = new double[x.length];
        int i = 0;
        while (i < x.length) {
            dx[i] = x[i];
            ++i;
        }
        double[] ret = Filter.filtfilt(b, a, dx);
        int[] iret = new int[x.length];
        int i2 = 0;
        while (i2 < x.length) {
            iret[i2] = (int)ret[i2];
            ++i2;
        }
        dx = null;
        ret = null;
        return iret;
    }

    public static double[] filtfilt(FilterDB filterDB, double[] x) {
        return Filter.filtfilt(filterDB.getNum(), filterDB.getDen(), x);
    }

    private static double[] filter(double[] b, double[] a, double[] x, double[] Zi) {
        int len = Math.max(b.length, a.length);
        int nb = b.length;
        int na = a.length;
        if (nb < len) {
            double[] b1 = new double[len];
            System.arraycopy(b, 0, b1, 0, nb);
            b = b1;
        }
        if (na < len) {
            double[] a1 = new double[len];
            System.arraycopy(a, 0, a1, 0, na);
            a = a1;
        }
        double[] y = new double[x.length];
        if (len - 1 > Zi.length) {
            new IllegalArgumentException("zi's length is not enough");
        }
        int order = len - 1;
        int i = 0;
        while (i < x.length) {
            y[i] = b[0] * x[i] + Zi[0];
            int j = 0;
            while (j < order - 1) {
                Zi[j] = b[j + 1] * x[i] + Zi[j + 1] - a[j + 1] * y[i];
                ++j;
            }
            Zi[order - 1] = b[order] * x[i] - a[order] * y[i];
            ++i;
        }
        return y;
    }
}

