/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal;

public class FFT {
    double[] fr;
    double[] fi;
    int n;
    int isign;

    public void doFFT(double[] fr, double[] fi, int n, int isign) {
        this.fr = fr;
        this.fi = fi;
        this.n = n;
        this.isign = isign;
        this.fft();
    }

    public double[] getReal() {
        return this.fr;
    }

    public double[] getIm() {
        return this.fi;
    }

    private void fft() {
        int i;
        double ti;
        double tr;
        int l;
        double pisign = Math.PI * (double)this.isign;
        int mr = 0;
        int nn = this.n - 1;
        int m = 1;
        while (m <= nn) {
            l = this.n;
            while (mr + l > nn) {
                l /= 2;
            }
            if ((mr = mr % l + l) > m) {
                tr = this.fr[m];
                this.fr[m] = this.fr[mr];
                this.fr[mr] = tr;
                ti = this.fi[m];
                this.fi[m] = this.fi[mr];
                this.fi[mr] = ti;
            }
            ++m;
        }
        l = 1;
        while (l < this.n) {
            int istep = 2 * l;
            m = 0;
            while (m < l) {
                double a = pisign * (double)m / (double)l;
                double wr = Math.cos(a);
                double wi = Math.sin(a);
                i = m;
                while (i < this.n) {
                    int j = i + l;
                    tr = wr * this.fr[j] - wi * this.fi[j];
                    ti = wr * this.fi[j] + wi * this.fr[j];
                    this.fr[j] = this.fr[i] - tr;
                    this.fi[j] = this.fi[i] - ti;
                    this.fr[i] = this.fr[i] + tr;
                    this.fi[i] = this.fi[i] + ti;
                    i += istep;
                }
                ++m;
            }
            l = istep;
        }
        double w = this.n;
        if (this.isign > 0) {
            i = 0;
            while (i < this.n) {
                int n = i;
                this.fr[n] = this.fr[n] / w;
                int n2 = i++;
                this.fi[n2] = this.fi[n2] / w;
            }
        }
    }

    public static void fft(double[] fr, double[] fi, int n, int isign) {
        FFT.fft(fr, 0, fi, 0, n, isign);
    }

    public static void fft(double[] fr, int fr_off, double[] fi, int fi_off, int n, int isign) {
        int i;
        double ti;
        double tr;
        int l;
        double pisign = Math.PI * (double)isign;
        int mr = 0;
        int nn = n - 1;
        int m = 1;
        while (m <= nn) {
            l = n;
            while (mr + l > nn) {
                l /= 2;
            }
            if ((mr = mr % l + l) > m) {
                tr = fr[fr_off + m];
                fr[fr_off + m] = fr[fr_off + mr];
                fr[fr_off + mr] = tr;
                ti = fi[fi_off + m];
                fi[fi_off + m] = fi[fi_off + mr];
                fi[fi_off + mr] = ti;
            }
            ++m;
        }
        l = 1;
        while (l < n) {
            int istep = 2 * l;
            m = 0;
            while (m < l) {
                double a = pisign * (double)m / (double)l;
                double wr = Math.cos(a);
                double wi = Math.sin(a);
                i = m;
                while (i < n) {
                    int j = i + l;
                    tr = wr * fr[fr_off + j] - wi * fi[fi_off + j];
                    ti = wr * fi[fi_off + j] + wi * fr[fr_off + j];
                    fr[fr_off + j] = fr[fr_off + i] - tr;
                    fi[fi_off + j] = fi[fi_off + i] - ti;
                    fr[fr_off + i] = fr[fr_off + i] + tr;
                    fi[fi_off + i] = fi[fi_off + i] + ti;
                    i += istep;
                }
                ++m;
            }
            l = istep;
        }
        double w = n;
        if (isign > 0) {
            i = 0;
            while (i < n) {
                int n2 = fr_off + i;
                fr[n2] = fr[n2] / w;
                int n3 = fi_off + i;
                fi[n3] = fi[n3] / w;
                ++i;
            }
        }
    }

    public static void fft(float[] fr, float[] fi, int n, int isign) {
        FFT.fft(fr, 0, fi, 0, n, isign);
    }

    public static void fft(float[] fr, int fr_off, float[] fi, int fi_off, int n, int isign) {
        int i;
        float ti;
        float tr;
        int l;
        float pisign = (float)Math.PI * (float)isign;
        int mr = 0;
        int nn = n - 1;
        int m = 1;
        while (m <= nn) {
            l = n;
            while (mr + l > nn) {
                l /= 2;
            }
            if ((mr = mr % l + l) > m) {
                tr = fr[fr_off + m];
                fr[fr_off + m] = fr[fr_off + mr];
                fr[fr_off + mr] = tr;
                ti = fi[fi_off + m];
                fi[fi_off + m] = fi[fi_off + mr];
                fi[fi_off + mr] = ti;
            }
            ++m;
        }
        l = 1;
        while (l < n) {
            int istep = 2 * l;
            m = 0;
            while (m < l) {
                float a = pisign * (float)m / (float)l;
                float wr = (float)Math.cos(a);
                float wi = (float)Math.sin(a);
                i = m;
                while (i < n) {
                    int j = i + l;
                    tr = wr * fr[fr_off + j] - wi * fi[fi_off + j];
                    ti = wr * fi[fi_off + j] + wi * fr[fr_off + j];
                    fr[fr_off + j] = fr[fr_off + i] - tr;
                    fi[fi_off + j] = fi[fi_off + i] - ti;
                    fr[fr_off + i] = fr[fr_off + i] + tr;
                    fi[fi_off + i] = fi[fi_off + i] + ti;
                    i += istep;
                }
                ++m;
            }
            l = istep;
        }
        float w = n;
        if (isign > 0) {
            i = 0;
            while (i < n) {
                int n2 = fr_off + i;
                fr[n2] = fr[n2] / w;
                int n3 = fi_off + i;
                fi[n3] = fi[n3] / w;
                ++i;
            }
        }
    }

    public static void main0(String[] args) {
        double[] xr = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
        double[] xi = new double[xr.length];
        FFT fft = new FFT();
        fft.doFFT(xr, xi, xr.length, -1);
        int i = 0;
        while (i < xr.length) {
            System.out.println(String.valueOf(xr[i]) + "\t" + xi[i]);
            ++i;
        }
    }

    public static void main(String[] args) {
        double sr = 100.0;
        double F = 10.0;
        int n = 1024;
        double[] t = new double[n];
        double[] y = new double[n];
        int i = 0;
        while (i < t.length) {
            t[i] = (double)i / sr;
            y[i] = 0.0 * Math.sin(Math.PI * 2 * F * t[i]);
            ++i;
        }
        FFT fft = new FFT();
        double[] xi = new double[n];
        fft.doFFT(y, xi, y.length, -1);
        int i2 = 0;
        while (i2 < y.length / 2) {
            double f = (double)i2 / (double)n * sr;
            double amp = Math.sqrt(y[i2] * y[i2] + xi[i2] * xi[i2]);
            System.out.println(String.valueOf(f) + "\t" + Math.log10(amp));
            ++i2;
        }
    }
}

