/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal;

import cn.org.gddsn.signal.Filter;
import cn.org.gddsn.signal.filter.design.IIRFilter;
import java.util.Hashtable;

public class ButterFilter {
    private static Hashtable<String, Filter> tbl = new Hashtable(16);
    public static final double[] B_100_3 = new double[]{6.288117987946756E-5, 0.0, -1.886435396384027E-4, 0.0, 1.886435396384027E-4, 0.0, -6.288117987946756E-5};
    public static final double[] A_100_3 = new double[]{1.0, -5.820551184131244, 14.13377218191027, -18.32709423120689, 13.38432593114628, -5.219696906511012, 0.849244364426476};
    public static final double[] B_50_3 = new double[]{4.658486035943513E-4, 0.0, -0.001397545810783054, 0.0, 0.001397545810783054, 0.0, -4.658486035943513E-4};
    public static final double[] A_50_3 = new double[]{1.0, -5.610889893653738, 13.18292400074858, -16.60198442818226, 11.81992863583707, -4.510986960177489, 0.7210178312192462};
    public static final double[] B_40_3 = new double[]{8.765934484990587E-4, 0.0, -0.002629780345497176, 0.0, 0.002629780345497176, 0.0, -8.765934484990587E-4};
    public static final double[] A_40_3 = new double[]{1.0, -5.495633325221005, 12.6823541762846, -15.73157524570015, 11.06331933328642, -4.182662996528784, 0.6642317127298092};
    public static final double[] B_25_3 = new double[]{0.003225393119608567, 0.0, -0.0096761793588257, 0.0, 0.0096761793588257, 0.0, -0.003225393119608567};
    public static final double[] A_25_3 = new double[]{1.0, -5.112358728778053, 11.11072512426947, -13.13981489770242, 8.920309515661458, -3.297054907972555, 0.5186942983931281};
    public static final double[] B_20_3 = new double[]{0.00588621615508377, 0.0, -0.01765864846525131, 0.0, 0.01765864846525131, 0.0, -0.00588621615508377};
    public static final double[] A_20_3 = new double[]{1.0, -4.828954941993375, 10.02913710299433, -11.46569391381708, 7.613073680239918, -2.785021213285825, 0.4392207279464296};
    public static final double[] B_10_3 = new double[]{0.03491360361152892, 0.0, -0.1047408108345868, 0.0, 0.1047408108345868, 0.0, -0.03491360361152892};
    public static final double[] A_10_3 = new double[]{1.0, -3.170034240282229, 4.858224170102804, -4.549932813999856, 2.773040712776214, -1.020506589384758, 0.1844055352662595};
    public static final double[] B_100_4 = new double[]{2.5059666460422506E-6, 0.0, -1.0023866584169002E-5, 0.0, 1.5035799876253503E-5, 0.0, -1.0023866584169002E-5, 0.0, 2.5059666460422506E-6};
    public static final double[] A_100_4 = new double[]{1.0, -7.765064708477666, 26.40304013512583, -51.34650155319646, 62.46466760281004, -48.677164256485206, 23.72926088752661, -6.615979466495606, 0.8077413600314428};
    public static final double[] B_50_4 = new double[]{3.6269682595200775E-5, 0.0, -1.450787303808031E-4, 0.0, 2.1761809557120464E-4, 0.0, -1.450787303808031E-4, 0.0, 3.6269682595200775E-5};
    public static final double[] A_50_4 = new double[]{1.0, -7.489592740997205, 24.628551832502293, -46.44367168549879, 54.93405807188216, -41.73386341468539, 19.887214080258648, -5.434869073959261, 0.6521731237119358};
    public static final double[] B_40_4 = new double[]{8.434814641035752E-5, 0.0, -3.373925856414301E-4, 0.0, 5.060888784621452E-4, 0.0, -3.373925856414301E-4, 0.0, 8.434814641035752E-5};
    public static final double[] A_40_4 = new double[]{1.0, -7.337789569899376, 23.687926407407776, -43.94081711712421, 51.22825447822538, -38.43782303895375, 18.12712158966566, -4.912716550555654, 0.5858448937007075};
    public static final double[] B_25_4 = new double[]{4.8060929577406367E-4, 0.0, -0.0019224371830962547, 0.0, 0.0028836557746443822, 0.0, -0.0019224371830962547, 0.0, 4.8060929577406367E-4};
    public static final double[] A_25_4 = new double[]{1.0, -6.831443530428472, 20.71478797352343, -36.41278315074227, 40.58284463857909, -29.367157245680787, 13.476038837333238, -3.586141911183545, 0.423894454616577};
    public static final double[] B_20_4 = new double[]{0.0010739281487746554, 0.0, -0.0042957125950986216, 0.0, 0.006443568892647932, 0.0, -0.0042957125950986216, 0.0, 0.0010739281487746554};
    public static final double[] A_20_4 = new double[]{1.0, -6.4557706152374905, 18.656818730243227, -31.516992353914937, 34.036639342019726, -24.06291929468204, 10.877684610556422, -2.8761856141583007, 0.3409401520988846};
    public static final double[] B_10_4 = new double[]{0.011623323621399636, 0.0, -0.046493294485598545, 0.0, 0.06973994172839781, 0.0, -0.046493294485598545, 0.0, 0.011623323621399636};
    public static final double[] A_10_4 = new double[]{1.0, -4.243171400361831, 8.794543638787221, -11.52865968460685, 10.445058933171392, -6.650863516783011, 2.905323024482634, -0.7999002508358921, 0.10999905804811869};
    public static final double[] B_10_4_07_5 = new double[]{0.9999999999999999, 0.0, -4.0, 0.0, 5.999999999999999, 0.0, -4.0, 0.0, 0.9999999999999999};
    public static final double[] A_10_4_07_5 = new double[]{1.0, 0.0, -3.999999999999999, 1.332267629550188E-15, 6.0, -4.440892098500626E-16, -3.999999999999999, 4.440892098500626E-16, 0.9999999999999998};
    public static final double[] B_20_4_07_5 = new double[]{0.05851270857137602, 0.0, -0.2340508342855041, 0.0, 0.3510762514282561, 0.0, -0.2340508342855041, 0.0, 0.05851270857137602};
    public static final double[] A_20_4_07_5 = new double[]{1.0, -3.64289886851719, 5.824327386084902, -5.80581787175381, 4.294632886448122, -2.335550618087747, 0.817894371065637, -0.1726316148511272, 0.02359741417722522};
    public static final double[] B_25_4_07_5 = new double[]{0.0288463416066782, 0.0, -0.1153853664267128, 0.0, 0.1730780496400692, 0.0, -0.1153853664267128, 0.0, 0.0288463416066782};
    public static final double[] A_25_4_07_5 = new double[]{1.0, -4.593470872867848, 9.445658427950882, -11.66807405131111, 9.67139701187427, -5.508100256976238, 2.069278464030853, -0.4663718862357812, 0.05043281402470533};
    public static final double[] B_40_4_07_5 = new double[]{0.006164645472359158, 0.0, -0.02465858188943663, 0.0, 0.03698787283415494, 0.0, -0.02465858188943663, 0.0, 0.006164645472359158};
    public static final double[] A_40_4_07_5 = new double[]{1.0, -5.970316156906477, 15.82661215625042, -24.41909494466232, 24.04559739983553, -15.4899668958738, 6.373295611683965, -1.530435738963147, 0.1643341721033605};
    public static final double[] B_50_4_07_5 = new double[]{0.002873999398873326, 0.0, -0.0114959975954933, 0.0, 0.01724399639323996, 0.0, -0.0114959975954933, 0.0, 0.002873999398873326};
    public static final double[] A_50_4_07_5 = new double[]{1.0, -6.409508418509196, 18.15826132447472, -29.74340835606833, 30.84305085002866, -20.7450476350875, 8.839129631215812, -2.181140418321859, 0.2386679631029198};
    public static final double[] B_100_4_07_5 = new double[]{2.394573343157181E-4, 0.0, -9.578293372628726E-4, 0.0, 0.001436744005894309, 0.0, -9.578293372628726E-4, 0.0, 2.394573343157181E-4};
    public static final double[] A_100_4_07_5 = new double[]{1.0, -7.244356376206962, 23.02619061697751, -41.94715982358063, 47.90710878655891, -35.12724526447388, 16.14935243307649, -4.256252730542786, 0.4923623842806801};
    public static final double[] B_20_4_07_10 = new double[]{0.9999999999999999, 0.0, -3.9999999999999996, 0.0, 5.999999999999999, 0.0, -3.9999999999999996, 0.0, 0.9999999999999999};
    public static final double[] A_20_4_07_10 = new double[]{1.0, 0.0, -3.999999999999999, 1.3322676295501878E-15, 6.0, -4.440892098500626E-16, -3.999999999999999, 4.440892098500626E-16, 0.9999999999999998};
    public static final double[] B_25_4_07_10 = new double[]{0.3375345948036123, 0.0, -1.3501383792144492, 0.0, 2.0252075688216737, 0.0, -1.3501383792144492, 0.0, 0.3375345948036123};
    public static final double[] A_25_4_07_10 = new double[]{1.0, -1.1916222595858743, -1.2923199111297028, 1.2137419006640426, 1.3201001829095562, -0.6948993792033167, -0.5979683418042624, 0.13478824196162506, 0.11405155536089591};
    public static final double[] B_40_4_07_10 = new double[]{0.07482839811317366, 0.0, -0.2993135924526946, 0.0, 0.44897038867904193, 0.0, -0.2993135924526946, 0.0, 0.07482839811317366};
    public static final double[] A_40_4_07_10 = new double[]{1.0, -3.8275764702785673, 6.153660821840448, -5.8853208973697875, 4.140283226961419, -2.178301106029674, 0.6989136209195996, -0.12055667893845383, 0.019117848401769517};
    public static final double[] B_50_4_07_10 = new double[]{0.037016848198722, 0.0, -0.148067392794888, 0.0, 0.222101089192332, 0.0, -0.148067392794888, 0.0, 0.037016848198722};
    public static final double[] A_50_4_07_10 = new double[]{1.0, -4.691982744642387, 9.634532056279697, -11.647100077114036, 9.338402453140755, -5.114436803877416, 1.8215088181744612, -0.3796740961574259, 0.0387960424509944};
    public static final double[] B_100_4_07_10 = new double[]{0.003764316308695364, 0.0, -0.015057265234781457, 0.0, 0.022585897852172184, 0.0, -0.015057265234781457, 0.0, 0.003764316308695364};
    public static final double[] A_100_4_07_10 = new double[]{1.0, -6.39038067099778, 17.978324618895375, -29.13839323388367, 29.799720316764887, -19.707369221622226, 8.231402432125014, -1.9848775870770408, 0.2115736443072187};

    private ButterFilter() {
    }

    public static Filter[] getButterFilter(double srate, int nchn, String filterType, int order, double fp1, double fp2) {
        String key = String.valueOf(srate) + "_" + filterType + "_" + order + "_" + fp1 + "_" + fp2;
        Filter[] filter = new Filter[nchn];
        int i = 0;
        while (i < filter.length) {
            Filter flt = tbl.get(key);
            if (flt == null) {
                IIRFilter iirFilter = new IIRFilter();
                iirFilter.setPrototype("Butterworth");
                iirFilter.setFilterType(filterType);
                iirFilter.setOrder(order * 2);
                iirFilter.setFreq1(fp1);
                iirFilter.setFreq2(fp2);
                iirFilter.setFreqPoints(250);
                iirFilter.setRate(srate);
                iirFilter.design();
                iirFilter.filterGain();
                double[] num = iirFilter.getNumCoeff();
                double[] den = iirFilter.getDenCoeff();
                double[] b = new double[num.length];
                System.arraycopy(num, 0, b, 0, num.length);
                double[] a = new double[den.length];
                System.arraycopy(den, 0, a, 0, den.length);
                flt = new Filter(b, a);
                tbl.put(key, flt);
            }
            double[] _b = flt.getNumCoef();
            double[] _a = flt.getDenCoef();
            double[] b = new double[_b.length];
            System.arraycopy(_b, 0, b, 0, _b.length);
            double[] a = new double[_a.length];
            System.arraycopy(_a, 0, a, 0, _a.length);
            filter[i] = new Filter(b, a);
            ++i;
        }
        return filter;
    }

    public static Filter[] buildButterFilter(double srate, int nchn, String filterType, int order, double fp1, double fp2) {
        Filter[] filter = new Filter[nchn];
        IIRFilter iirFilter = new IIRFilter();
        iirFilter.setPrototype("Butterworth");
        iirFilter.setFilterType(filterType);
        iirFilter.setOrder(order * 2);
        iirFilter.setFreq1(fp1);
        iirFilter.setFreq2(fp2);
        iirFilter.setFreqPoints(250);
        iirFilter.setRate(srate);
        iirFilter.design();
        iirFilter.filterGain();
        double[] num = iirFilter.getNumCoeff();
        double[] den = iirFilter.getDenCoeff();
        int i = 0;
        while (i < nchn) {
            double[] b = new double[num.length];
            System.arraycopy(num, 0, b, 0, num.length);
            double[] a = new double[den.length];
            System.arraycopy(den, 0, a, 0, den.length);
            filter[i] = new Filter(b, a);
            ++i;
        }
        return filter;
    }

    public static void main(String[] args) {
        Filter[] filters = ButterFilter.buildButterFilter(50.0, 1, "HP", 4, 0.1, 25.0);
        double[] b = filters[0].getNumCoef();
        double[] a = filters[0].getDenCoef();
        System.out.println(b + ", " + a);
    }
}

