/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.ttt3d;

import java.io.File;
import java.io.IOException;
import java.util.Scanner;

public class TomoTT {
    public static final int meq = 10389;
    public static final int mst = 505;
    public static final int max = 500;
    public static final int mdt = 1500;
    public static final int md = 150000;
    public static final int mu = 150000;
    public static final int mg = 30000000;
    public static final int mpa = 20;
    public static final int mra = 30;
    public static final int mha = 16;
    public static final int mpb = 20;
    public static final int mrb = 30;
    public static final int mhb = 16;
    public static final int mka = 6090;
    public static final int mkb = 6090;
    public static final int np = 20;
    public static final int nr = 30;
    public static final int nh = 16;
    static JBMODV JBMODV = new JBMODV();
    static IASP91 IASP91 = new IASP91();
    static IASPHH IASPHH = new IASPHH();
    static DISCON DISCON = new DISCON();
    static HYPINV HYPINV = new HYPINV();
    static ELLIPS ELLIPS = new ELLIPS();
    static TOYUAN TOYUAN = new TOYUAN();
    static VMOD3D VMOD3D = new VMOD3D();
    static LOCATE LOCATE = new LOCATE();
    static PRHFD PRHFD = new PRHFD();
    static WEIGHT WEIGHT = new WEIGHT();
    static RAYPATH RAYPATH = new RAYPATH();
    static RAYLOC RAYLOC = new RAYLOC();
    static HLASTA HLASTA = new HLASTA();
    static STATIN STATIN = new STATIN();
    static CONTRL CONTRL = new CONTRL();
    static GRINET GRINET = new GRINET();

    public static void input1() throws IOException {
        Scanner sc = new Scanner(new File("../lib/ding/datajp"));
        TomoTT.CONTRL.nsts = sc.nextInt();
        TomoTT.CONTRL.neqs = sc.nextInt();
        TomoTT.CONTRL.nitloc = sc.nextInt();
        TomoTT.CONTRL.rmscut = sc.nextDouble();
        TomoTT.CONTRL.dvmax = sc.nextDouble();
        TomoTT.CONTRL.vdamp = sc.nextDouble();
        TomoTT.CONTRL.nhitct = sc.nextInt();
        TomoTT.CONTRL.nitmax = sc.nextInt();
        TomoTT.CONTRL.rmstop = sc.nextDouble();
        TomoTT.CONTRL.stepl = sc.nextDouble();
        TomoTT.CONTRL.tlim = sc.nextDouble();
        TomoTT.CONTRL.nitpb = sc.nextInt();
        sc.close();
    }

    public static void input23(int mps) throws IOException {
        Scanner sc = new Scanner(new File("../lib/ding/v-model"));
        double pideg = Math.PI / 180;
        int n = 1;
        while (n <= TomoTT.CONTRL.nsts) {
            double ps = sc.nextDouble();
            double rs = sc.nextDouble();
            double hs = sc.nextDouble();
            TomoTT.STATIN.stc[1][n] = (90.0 - ps) * pideg;
            TomoTT.STATIN.stc[2][n] = rs * pideg;
            TomoTT.STATIN.stc[3][n] = -hs;
            TomoTT.STATIN.phis[n] = ps;
            TomoTT.STATIN.rams[n] = rs;
            TomoTT.STATIN.higs[n] = -hs;
            ++n;
        }
        TomoTT.inputjb();
        TomoTT.VMOD3D.npa = sc.nextInt();
        TomoTT.VMOD3D.nra = sc.nextInt();
        TomoTT.VMOD3D.nha = sc.nextInt();
        TomoTT.put3(sc, TomoTT.VMOD3D.npa, TomoTT.VMOD3D.nra, TomoTT.VMOD3D.nha, TomoTT.VMOD3D.pna, TomoTT.VMOD3D.rna, TomoTT.VMOD3D.hna, TomoTT.VMOD3D.dvap, TomoTT.VMOD3D.velap, mps);
        TomoTT.bldmap();
        sc.close();
    }

    public static void put3(Scanner sc, int npx, int nrx, int nhx, double[] pnx, double[] rnx, double[] hnx, double[][][] dvxp, double[][][] velxp, int mps) {
        int nwidth = 5;
        int i = 1;
        while (i <= npx) {
            pnx[i] = sc.nextDouble();
            ++i;
        }
        i = 1;
        while (i <= nrx) {
            rnx[i] = sc.nextDouble();
            ++i;
        }
        i = 1;
        while (i <= nhx) {
            hnx[i] = sc.nextDouble();
            ++i;
        }
        int k = 1;
        while (k <= nhx) {
            int i2 = 1;
            while (i2 <= npx) {
                int j = 1;
                while (j <= nrx) {
                    String line = sc.nextLine();
                    int nlen = line.length() / 5;
                    int n = 0;
                    while (n < nlen) {
                        dvxp[i2][j++][k] = Double.parseDouble(line.substring(n * 5, (n + 1) * 5).trim());
                        ++n;
                    }
                }
                ++i2;
            }
            ++k;
        }
        int[] lay = new int[1];
        double[] v1 = new double[1];
        int k2 = 1;
        while (k2 <= nhx) {
            int j = 1;
            while (j <= nrx) {
                int i3 = 1;
                while (i3 <= npx) {
                    double pp = pnx[i3];
                    double rr = rnx[j];
                    double hh = hnx[k2];
                    TomoTT.layer(pp, rr, hh, lay);
                    TomoTT.vel1d(hh, v1, lay[0], mps);
                    double dv = 0.01 * dvxp[i3][j][k2];
                    velxp[i3][j][k2] = v1[0] * (1.0 + dv);
                    ++i3;
                }
                ++j;
            }
            ++k2;
        }
        int npx2 = npx - 2;
        int nprx2 = npx2 * (nrx - 2);
        int nodesx2 = (nhx - 2) * nprx2;
        TomoTT.GRINET.npa2 = npx2;
        TomoTT.GRINET.npra2 = nprx2;
        TomoTT.GRINET.nodesa2 = nodesx2;
        TomoTT.GRINET.nodetot = nodesx2;
    }

    public static void readubpp() throws IOException {
        int j;
        Scanner sc = new Scanner(new File("../lib/ding/datadis"));
        int np = sc.nextInt();
        int nr = sc.nextInt();
        int i = 1;
        while (i <= np) {
            TomoTT.DISCON.pn[i] = sc.nextDouble();
            ++i;
        }
        i = 1;
        while (i <= nr) {
            TomoTT.DISCON.rn[i] = sc.nextDouble();
            ++i;
        }
        i = np;
        while (i >= 1) {
            j = 1;
            while (j <= nr) {
                TomoTT.DISCON.depa[i][j] = sc.nextDouble();
                ++j;
            }
            --i;
        }
        i = np;
        while (i >= 1) {
            j = 1;
            while (j <= nr) {
                TomoTT.DISCON.depb[i][j] = sc.nextDouble();
                ++j;
            }
            --i;
        }
        i = np;
        while (i >= 1) {
            j = 1;
            while (j <= nr) {
                TomoTT.DISCON.depc[i][j] = sc.nextDouble();
                ++j;
            }
            --i;
        }
        sc.close();
    }

    public static void input5() throws IOException {
        TomoTT.readubpp();
        TomoTT.ellipse();
        TomoTT.strtray();
    }

    public static void strtray() {
        int i;
        double[] hk = new double[1];
        int[] jwv = new int[]{1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1};
        TomoTT.RAYPATH.r0 = 6371.0;
        TomoTT.RAYPATH.pideg = Math.PI / 180;
        TomoTT.RAYPATH.eps = 1.0E-6;
        int j = 1;
        while (j <= 8) {
            i = 1;
            while (i <= 5) {
                TomoTT.RAYPATH.iwv[j][i] = jwv[(i - 1) * 8 + (j - 1)];
                ++i;
            }
            ++j;
        }
        i = 1;
        while (i < 505) {
            double ps = TomoTT.STATIN.stc[1][i];
            double rs = TomoTT.STATIN.stc[2][i];
            j = 1;
            while (j <= 2) {
                int k = j++;
                TomoTT.hlay(ps, rs, hk, k);
                TomoTT.HLASTA.hlss[i][k] = hk[0];
            }
            ++i;
        }
    }

    public static void ttt(double pea, double rea, double hea, double psa, double rsa, double hsa, int kps, double[] del, double[] fstime) {
        boolean debug;
        String phase = "";
        double[] hlae = new double[3];
        int[] lay = new int[1];
        double pid = Math.PI / 180;
        int no = 0;
        double pe = (90.0 - pea) * pid;
        double re = rea * pid;
        double he = hea;
        double ps = (90.0 - psa) * pid;
        double rs = rsa * pid;
        double hs = hsa;
        TomoTT.layhe(pe, re, he, hlae, lay);
        int ns = 1;
        double po = 0.0;
        double[] az = new double[1];
        double[] ve = new double[1];
        TomoTT.travt(pe, re, he, ps, rs, hs, kps, ns, hlae, lay[0], TomoTT.CONTRL.tlim, TomoTT.CONTRL.nitpb, po, del, az, ve, fstime);
        double c0 = 111.19;
        double[] dt = new double[1];
        double delc = del[0] / c0;
        if (del[0] > 250.0) {
            TomoTT.correc(he, delc, kps, pe, az[0], dt);
        }
        fstime[0] = fstime[0] + dt[0];
        ++no;
        if (kps == 1) {
            phase = "P";
        }
        if (kps == 6) {
            phase = "Pb";
        }
        if (kps == 7) {
            phase = "Pn";
        }
        if (debug = false) {
            System.out.printf(" Phase,KPS,DEL,FSTIME = %s, %d, %.4f, %.4f\n", phase, kps, del[0], fstime[0]);
        }
    }

    public static void hlay(double pe, double re, double[] he, int ijk) {
        double pid = 0.017453;
        int i1 = 0;
        int j1 = 0;
        int i = 0;
        int j = 0;
        double[] p = new double[]{90.0 - pe / pid};
        double[] r = new double[]{re / pid};
        TomoTT.limit(TomoTT.DISCON.pn[1], TomoTT.DISCON.pn[TomoTT.DISCON.nnp], p);
        TomoTT.limit(TomoTT.DISCON.rn[1], TomoTT.DISCON.rn[TomoTT.DISCON.nnr], r);
        i = 1;
        while (i <= TomoTT.DISCON.nnp - 1) {
            i1 = i + 1;
            if (p[0] >= TomoTT.DISCON.pn[i] && p[0] < TomoTT.DISCON.pn[i1]) break;
            ++i;
        }
        j = 1;
        while (j <= TomoTT.DISCON.nnr - 1) {
            j1 = j + 1;
            if (r[0] >= TomoTT.DISCON.rn[j] && r[0] < TomoTT.DISCON.rn[j1]) break;
            ++j;
        }
        double pf = (p[0] - TomoTT.DISCON.pn[i]) / (TomoTT.DISCON.pn[i1] - TomoTT.DISCON.pn[i]);
        double rf = (r[0] - TomoTT.DISCON.rn[j]) / (TomoTT.DISCON.rn[j1] - TomoTT.DISCON.rn[j]);
        double pf1 = 1.0 - pf;
        double rf1 = 1.0 - rf;
        double wv1 = pf1 * rf1;
        double wv2 = pf * rf1;
        double wv3 = pf1 * rf;
        double wv4 = pf * rf;
        if (ijk == 1) {
            he[0] = wv1 * TomoTT.DISCON.depa[i][j] + wv2 * TomoTT.DISCON.depa[i1][j] + wv3 * TomoTT.DISCON.depa[i][j1] + wv4 * TomoTT.DISCON.depa[i1][j1];
        } else if (ijk == 2) {
            he[0] = wv1 * TomoTT.DISCON.depb[i][j] + wv2 * TomoTT.DISCON.depb[i1][j] + wv3 * TomoTT.DISCON.depb[i][j1] + wv4 * TomoTT.DISCON.depb[i1][j1];
        } else if (ijk == 3) {
            he[0] = wv1 * TomoTT.DISCON.depc[i][j] + wv2 * TomoTT.DISCON.depc[i1][j] + wv3 * TomoTT.DISCON.depc[i][j1] + wv4 * TomoTT.DISCON.depc[i1][j1];
        }
    }

    public static void layer(double p, double r, double h, int[] lay) {
        double h1 = 22.0;
        double h2 = 55.0;
        if (h <= h1) {
            lay[0] = 1;
        }
        if (h > h1 && h <= h2) {
            lay[0] = 2;
        }
        if (h > h2) {
            lay[0] = 3;
        }
    }

    public static void layhe(double pe, double re, double he, double[] hlae, int[] lay) {
        lay[0] = 1;
        double[] hi = new double[1];
        int k = 1;
        while (k <= 2) {
            int i = k;
            TomoTT.hlay(pe, re, hi, i);
            hlae[i] = hi[0];
            if (he > hi[0]) {
                lay[0] = lay[0] + 1;
            }
            ++k;
        }
    }

    public static void liner(int m, int n, double[][] gf, double[][] ans) {
        double[][] c = new double[6][12];
        int k = 1;
        while (k <= 5) {
            int l = 1;
            while (l <= 11) {
                c[k][l] = gf[k][l];
                ++l;
            }
            ++k;
        }
        k = 1;
        while (k <= m) {
            int kk;
            double w = c[k][k];
            if (Math.abs(w) < 1.0E-5) {
                w = 1.0;
            }
            int j = kk = k + 1;
            while (j <= n) {
                c[k][j] = c[k][j] / w;
                ++j;
            }
            int i = 1;
            while (i <= m) {
                if (i != k) {
                    w = c[i][k];
                    int j2 = kk;
                    while (j2 <= n) {
                        c[i][j2] = c[i][j2] - w * c[k][j2];
                        ++j2;
                    }
                }
                ++i;
            }
            ++k;
        }
        int j = n - m;
        int i = 1;
        while (i <= j) {
            int jj = m + i;
            int k2 = 1;
            while (k2 <= m) {
                ans[k2][i] = c[k2][jj];
                ++k2;
            }
            ++i;
        }
    }

    public static void wthyp(int nobs, double[][] gf, double[] rmswt, int[] nwr) {
        double[] aq = new double[6];
        double epc = 1.0E-5;
        int k = 1;
        while (k <= 5) {
            int j = 1;
            while (j <= 9) {
                gf[k][j] = 0.0;
                ++j;
            }
            int m = k + 5;
            gf[k][m] = 1.0;
            ++k;
        }
        nwr[0] = 0;
        double wnorm = 0.0;
        rmswt[0] = 0.0;
        int i = 1;
        while (i <= nobs) {
            double wi = TomoTT.HYPINV.w[i];
            wnorm += wi * wi;
            double rmsw = TomoTT.HYPINV.res[i] * wi;
            rmswt[0] = rmswt[0] + rmsw * rmsw;
            if (wi > epc) {
                nwr[0] = nwr[0] + 1;
            }
            int j = 1;
            while (j <= 4) {
                aq[j] = TomoTT.HYPINV.dth[i][j] * TomoTT.HYPINV.w[i];
                ++j;
            }
            aq[5] = TomoTT.HYPINV.res[i] * TomoTT.HYPINV.w[i];
            int k2 = 1;
            while (k2 <= 5) {
                int j2 = 1;
                while (j2 <= 5) {
                    gf[k2][j2] = gf[k2][j2] + aq[k2] * aq[j2];
                    ++j2;
                }
                ++k2;
            }
            ++i;
        }
        if (wnorm > epc) {
            rmswt[0] = Math.sqrt(rmswt[0] / wnorm);
        }
    }

    public static void ellipse() {
    }

    public static void correc(double dep, double del, int kps, double phi, double azm, double[] dt) {
        int l = 1;
        while (l <= 5) {
            TomoTT.ELLIPS.deltb[l] = TomoTT.TOYUAN.delra[l];
            ++l;
        }
        int ips = 2;
        if (kps != 2) {
            ips = 1;
        }
        TomoTT.ELLIPS.idel = 0;
        int l2 = 1;
        while (l2 <= 5) {
            if (del >= TomoTT.ELLIPS.deltb[l2]) {
                ++TomoTT.ELLIPS.idel;
            }
            ++l2;
        }
        TomoTT.ELLIPS.idel1 = TomoTT.ELLIPS.idel + 1;
        if (TomoTT.ELLIPS.idel1 >= 5) {
            TomoTT.ELLIPS.idel1 = 5;
        }
        if (ips == 1) {
            if (dep >= 0.0 && dep < 300.0) {
                TomoTT.t012(TomoTT.TOYUAN.pd0t0, TomoTT.TOYUAN.pd3t0, TomoTT.TOYUAN.pd0t1, TomoTT.TOYUAN.pd3t1, TomoTT.TOYUAN.pd0t2, TomoTT.TOYUAN.pd3t2, 0.0, 300.0, dep, del);
            } else if (dep >= 300.0 && dep < 650.0) {
                TomoTT.t012(TomoTT.TOYUAN.pd3t0, TomoTT.TOYUAN.pd6t0, TomoTT.TOYUAN.pd3t1, TomoTT.TOYUAN.pd6t1, TomoTT.TOYUAN.pd3t2, TomoTT.TOYUAN.pd6t2, 300.0, 650.0, dep, del);
            } else {
                TomoTT.t012(TomoTT.TOYUAN.pd6t0, TomoTT.TOYUAN.pd6t0, TomoTT.TOYUAN.pd6t1, TomoTT.TOYUAN.pd6t1, TomoTT.TOYUAN.pd6t2, TomoTT.TOYUAN.pd6t2, 650.0, 651.0, dep, del);
            }
        } else if (ips == 2) {
            if (dep >= 0.0 && dep < 300.0) {
                TomoTT.t012(TomoTT.TOYUAN.sd0t0, TomoTT.TOYUAN.sd3t0, TomoTT.TOYUAN.sd0t1, TomoTT.TOYUAN.sd3t1, TomoTT.TOYUAN.sd0t2, TomoTT.TOYUAN.sd3t2, 0.0, 300.0, dep, del);
            } else if (dep >= 300.0 && dep < 650.0) {
                TomoTT.t012(TomoTT.TOYUAN.sd3t0, TomoTT.TOYUAN.sd6t0, TomoTT.TOYUAN.sd3t1, TomoTT.TOYUAN.sd6t1, TomoTT.TOYUAN.sd3t2, TomoTT.TOYUAN.sd6t2, 300.0, 650.0, dep, del);
            } else {
                TomoTT.t012(TomoTT.TOYUAN.sd6t0, TomoTT.TOYUAN.sd6t0, TomoTT.TOYUAN.sd6t1, TomoTT.TOYUAN.sd6t1, TomoTT.TOYUAN.sd6t2, TomoTT.TOYUAN.sd6t2, 650.0, 651.0, dep, del);
            }
        } else {
            TomoTT.ELLIPS.t0 = 0.0;
            TomoTT.ELLIPS.t1 = 0.0;
            TomoTT.ELLIPS.t2 = 0.0;
        }
        double phi2 = 2.0 * phi;
        double sin2p = Math.sin(phi2);
        double cos2p = Math.cos(phi2);
        double cosaz = Math.cos(azm);
        double cos2az = 2.0 * cosaz * cosaz - 1.0;
        dt[0] = (0.25 + 0.75 * cos2p) * TomoTT.ELLIPS.t0 + 0.866 * sin2p * cosaz * TomoTT.ELLIPS.t1 + 0.433 * (1.0 - cos2p) * cos2az * TomoTT.ELLIPS.t2;
    }

    public static void t012(double[] pd0t0, double[] pd3t0, double[] pd0t1, double[] pd3t1, double[] pd0t2, double[] pd3t2, double dep1, double dep2, double dep, double del) {
        double depp = (dep - dep1) / (dep2 - dep1);
        double delt = (del - TomoTT.ELLIPS.deltb[TomoTT.ELLIPS.idel]) / 5.0;
        double t0a = (pd0t0[TomoTT.ELLIPS.idel1] - pd0t0[TomoTT.ELLIPS.idel]) * delt + pd0t0[TomoTT.ELLIPS.idel];
        double t0b = (pd3t0[TomoTT.ELLIPS.idel1] - pd3t0[TomoTT.ELLIPS.idel]) * delt + pd3t0[TomoTT.ELLIPS.idel];
        double t1a = (pd0t1[TomoTT.ELLIPS.idel1] - pd0t1[TomoTT.ELLIPS.idel]) * delt + pd0t1[TomoTT.ELLIPS.idel];
        double t1b = (pd3t1[TomoTT.ELLIPS.idel1] - pd3t1[TomoTT.ELLIPS.idel]) * delt + pd3t1[TomoTT.ELLIPS.idel];
        double t2a = (pd0t2[TomoTT.ELLIPS.idel1] - pd0t2[TomoTT.ELLIPS.idel]) * delt + pd0t2[TomoTT.ELLIPS.idel];
        double t2b = (pd3t2[TomoTT.ELLIPS.idel1] - pd3t2[TomoTT.ELLIPS.idel]) * delt + pd3t2[TomoTT.ELLIPS.idel];
        TomoTT.ELLIPS.t0 = t0a + (t0b - t0a) * depp;
        TomoTT.ELLIPS.t1 = t1a + (t1b - t1a) * depp;
        TomoTT.ELLIPS.t2 = t2a + (t2b - t2a) * depp;
    }

    public static void bldmap() {
        TomoTT.locx(TomoTT.VMOD3D.pna, TomoTT.VMOD3D.rna, TomoTT.VMOD3D.hna, TomoTT.VMOD3D.npa, TomoTT.VMOD3D.nra, TomoTT.VMOD3D.nha, 6090, TomoTT.LOCATE.pla, TomoTT.LOCATE.rla, TomoTT.LOCATE.hla, TomoTT.LOCATE.iploca, TomoTT.LOCATE.irloca, TomoTT.LOCATE.ihloca);
    }

    public static void locx(double[] pnx, double[] rnx, double[] hnx, int npx, int nrx, int nhx, int mkx, double[] plx, double[] rlx, double[] hlx, int[] iplocx, int[] irlocx, int[] ihlocx) {
        plx[0] = 1.0 - pnx[1] * 100.0;
        int ipmax = (int)(pnx[npx] * 100.0 + plx[0]);
        int ip = 1;
        int i = 1;
        while (i <= ipmax) {
            double pnow = ((double)i - plx[0]) / 100.0;
            int ip1 = ip + 1;
            if (pnow >= pnx[ip1]) {
                ip = ip1;
            }
            iplocx[i] = ip;
            ++i;
        }
        rlx[0] = 1.0 - rnx[1] * 100.0;
        int irmax = (int)(rnx[nrx] * 100.0 + rlx[0]);
        int ir = 1;
        int i2 = 1;
        while (i2 <= irmax) {
            double rnow = ((double)i2 - rlx[0]) / 100.0;
            int ir1 = ir + 1;
            if (rnow >= rnx[ir1]) {
                ir = ir1;
            }
            irlocx[i2] = ir;
            ++i2;
        }
        hlx[0] = 1.0 - hnx[1];
        int ihmax = (int)(hnx[nhx] + hlx[0]);
        int ih = 1;
        int i3 = 1;
        while (i3 <= ihmax) {
            double hnow = (double)i3 - hlx[0];
            int ih1 = ih + 1;
            if (hnow >= hnx[ih1]) {
                ih = ih1;
            }
            ihlocx[i3] = ih;
            ++i3;
        }
    }

    public static void vel3(double pe, double re, double he, double[] v, int lay, int ips) {
        TomoTT.vel1d(he, v, lay, ips);
        TomoTT.vel33(pe, re, he, v, lay, ips);
    }

    public static void vel33(double pe, double re, double he, double[] v, int lay, int ips) {
        double pideg = 0.017453;
        TomoTT.PRHFD.p = 90.0 - pe / pideg;
        TomoTT.PRHFD.r = re / pideg;
        TomoTT.PRHFD.h = he;
        TomoTT.prhf(TomoTT.LOCATE.iploca, TomoTT.LOCATE.irloca, TomoTT.LOCATE.ihloca, TomoTT.LOCATE.pla[0], TomoTT.LOCATE.rla[0], TomoTT.LOCATE.hla[0], TomoTT.VMOD3D.pna, TomoTT.VMOD3D.rna, TomoTT.VMOD3D.hna, 20, 30, 16, 6090);
        TomoTT.WEIGHT.wv[1] = TomoTT.PRHFD.pf1 * TomoTT.PRHFD.rf1 * TomoTT.PRHFD.hf1;
        TomoTT.WEIGHT.wv[2] = TomoTT.PRHFD.pf * TomoTT.PRHFD.rf1 * TomoTT.PRHFD.hf1;
        TomoTT.WEIGHT.wv[3] = TomoTT.PRHFD.pf1 * TomoTT.PRHFD.rf * TomoTT.PRHFD.hf1;
        TomoTT.WEIGHT.wv[4] = TomoTT.PRHFD.pf * TomoTT.PRHFD.rf * TomoTT.PRHFD.hf1;
        TomoTT.WEIGHT.wv[5] = TomoTT.PRHFD.pf1 * TomoTT.PRHFD.rf1 * TomoTT.PRHFD.hf;
        TomoTT.WEIGHT.wv[6] = TomoTT.PRHFD.pf * TomoTT.PRHFD.rf1 * TomoTT.PRHFD.hf;
        TomoTT.WEIGHT.wv[7] = TomoTT.PRHFD.pf1 * TomoTT.PRHFD.rf * TomoTT.PRHFD.hf;
        TomoTT.WEIGHT.wv[8] = TomoTT.PRHFD.pf * TomoTT.PRHFD.rf * TomoTT.PRHFD.hf;
        double[] dv = new double[1];
        double[] v1 = new double[1];
        TomoTT.vabps(20, 30, 16, TomoTT.VMOD3D.dvap, dv);
        TomoTT.vel1d(he, v1, lay, ips);
        v[0] = v1[0] * (1.0 + dv[0] * 0.01);
        if (ips == 2) {
            v[0] = v1[0];
        }
    }

    public static void vabps(int mp, int mr, int mh, double[][][] v, double[] vel) {
        vel[0] = TomoTT.WEIGHT.wv[1] * v[TomoTT.WEIGHT.ip][TomoTT.WEIGHT.jp][TomoTT.WEIGHT.kp] + TomoTT.WEIGHT.wv[2] * v[TomoTT.WEIGHT.ip1][TomoTT.WEIGHT.jp][TomoTT.WEIGHT.kp] + TomoTT.WEIGHT.wv[3] * v[TomoTT.WEIGHT.ip][TomoTT.WEIGHT.jp1][TomoTT.WEIGHT.kp] + TomoTT.WEIGHT.wv[4] * v[TomoTT.WEIGHT.ip1][TomoTT.WEIGHT.jp1][TomoTT.WEIGHT.kp] + TomoTT.WEIGHT.wv[5] * v[TomoTT.WEIGHT.ip][TomoTT.WEIGHT.jp][TomoTT.WEIGHT.kp1] + TomoTT.WEIGHT.wv[6] * v[TomoTT.WEIGHT.ip1][TomoTT.WEIGHT.jp][TomoTT.WEIGHT.kp1] + TomoTT.WEIGHT.wv[7] * v[TomoTT.WEIGHT.ip][TomoTT.WEIGHT.jp1][TomoTT.WEIGHT.kp1] + TomoTT.WEIGHT.wv[8] * v[TomoTT.WEIGHT.ip1][TomoTT.WEIGHT.jp1][TomoTT.WEIGHT.kp1];
    }

    public static void vel1d(double he, double[] v, int lay, int ips) {
        double hm = 0.0;
        if (lay == 1) {
            v[0] = 6.0;
            if (ips == 2) {
                v[0] = 3.5;
            }
        } else if (lay == 2) {
            v[0] = 6.5;
            if (ips == 2) {
                v[0] = 3.8;
            }
        } else if (lay >= 3) {
            hm = 65.0;
            if (he < hm) {
                double[] vm = new double[1];
                TomoTT.jbmodel(ips, hm, vm);
                v[0] = vm[0] - (hm - he) * 0.003;
            } else {
                TomoTT.jbmodel(ips, he, v);
            }
        }
    }

    public static void inputjb() {
        double[] vp1 = new double[]{7.75, 7.94, 8.13, 8.33, 8.54, 8.75, 8.97, 9.5, 9.91, 10.26, 10.55, 10.99, 11.29, 11.5, 11.67, 11.85, 12.03, 12.2, 12.37, 12.54, 12.71, 12.87, 13.02, 13.16, 13.32, 13.46, 13.6, 13.64, 13.64};
        double[] vs1 = new double[]{4.353, 4.444, 4.539, 4.638, 4.741, 4.85, 4.962, 5.227, 5.463, 5.67, 5.85, 6.125, 6.295, 6.395, 6.483, 6.564, 6.637, 6.706, 6.77, 6.833, 6.893, 6.953, 7.012, 7.074, 7.137, 7.199, 7.258, 7.314, 7.304};
        double[] ra1 = new double[]{1.0, 0.99, 0.98, 0.97, 0.96, 0.95, 0.94, 0.93, 0.92, 0.91, 0.9, 0.88, 0.86, 0.84, 0.82, 0.8, 0.78, 0.76, 0.74, 0.72, 0.7, 0.68, 0.66, 0.64, 0.62, 0.6, 0.58, 0.56, 0.55};
        int i = 0;
        while (i < 29) {
            TomoTT.JBMODV.vp[i + 1] = vp1[i];
            TomoTT.JBMODV.vs[i + 1] = vs1[i];
            TomoTT.JBMODV.ra[i + 1] = ra1[i];
            TomoTT.JBMODV.depj[i + 1] = 40.0 + 6325.59 * (1.0 - ra1[i]);
            ++i;
        }
    }

    public static void jbmodel(int ips, double h, double[] v) {
        int k1 = 1;
        double h1 = 0.0;
        double h2 = 0.0;
        int k = 0;
        k = 1;
        while (k <= 28) {
            k1 = k + 1;
            h1 = TomoTT.JBMODV.depj[k];
            h2 = TomoTT.JBMODV.depj[k1];
            if (h >= h1 && h < h2) break;
            ++k;
        }
        double h12 = (h - h1) / (h2 - h1);
        v[0] = ips == 1 ? (TomoTT.JBMODV.vp[k1] - TomoTT.JBMODV.vp[k]) * h12 + TomoTT.JBMODV.vp[k] : (TomoTT.JBMODV.vs[k1] - TomoTT.JBMODV.vs[k]) * h12 + TomoTT.JBMODV.vs[k];
    }

    public static void intmap(double r, int[] irloc, int nr, double rl, int[] ir) {
        int is = (int)(r + rl);
        ir[0] = irloc[is];
    }

    public static void prhf(int[] iplocx, int[] irlocx, int[] ihlocx, double plx, double rlx, double hlx, double[] pnx, double[] rnx, double[] hnx, int mpx, int mrx, int mhx, int mkx) {
        double[] p_ = new double[]{TomoTT.PRHFD.p};
        TomoTT.limit(pnx[1], pnx[mpx], p_);
        TomoTT.PRHFD.p = p_[0];
        double[] r_ = new double[]{TomoTT.PRHFD.r};
        TomoTT.limit(rnx[1], rnx[mrx], r_);
        TomoTT.PRHFD.r = r_[0];
        double[] h_ = new double[]{TomoTT.PRHFD.h};
        TomoTT.limit(hnx[1], hnx[mhx], h_);
        TomoTT.PRHFD.h = h_[0];
        int[] ip_ = new int[]{TomoTT.WEIGHT.ip};
        TomoTT.intmap(TomoTT.PRHFD.p * 100.0, iplocx, mkx, plx, ip_);
        TomoTT.WEIGHT.ip = ip_[0];
        int[] jp_ = new int[]{TomoTT.WEIGHT.jp};
        TomoTT.intmap(TomoTT.PRHFD.r * 100.0, irlocx, mkx, rlx, jp_);
        TomoTT.WEIGHT.jp = jp_[0];
        int[] kp_ = new int[]{TomoTT.WEIGHT.kp};
        TomoTT.intmap(TomoTT.PRHFD.h, ihlocx, mkx, hlx, kp_);
        TomoTT.WEIGHT.kp = kp_[0];
        TomoTT.WEIGHT.ip1 = TomoTT.WEIGHT.ip + 1;
        TomoTT.WEIGHT.jp1 = TomoTT.WEIGHT.jp + 1;
        TomoTT.WEIGHT.kp1 = TomoTT.WEIGHT.kp + 1;
        TomoTT.PRHFD.pd = pnx[TomoTT.WEIGHT.ip1] - pnx[TomoTT.WEIGHT.ip];
        TomoTT.PRHFD.rd = rnx[TomoTT.WEIGHT.jp1] - rnx[TomoTT.WEIGHT.jp];
        TomoTT.PRHFD.hd = hnx[TomoTT.WEIGHT.kp1] - hnx[TomoTT.WEIGHT.kp];
        TomoTT.PRHFD.pf = (TomoTT.PRHFD.p - pnx[TomoTT.WEIGHT.ip]) / TomoTT.PRHFD.pd;
        TomoTT.PRHFD.rf = (TomoTT.PRHFD.r - rnx[TomoTT.WEIGHT.jp]) / TomoTT.PRHFD.rd;
        TomoTT.PRHFD.hf = (TomoTT.PRHFD.h - hnx[TomoTT.WEIGHT.kp]) / TomoTT.PRHFD.hd;
        TomoTT.PRHFD.pf1 = 1.0 - TomoTT.PRHFD.pf;
        TomoTT.PRHFD.rf1 = 1.0 - TomoTT.PRHFD.rf;
        TomoTT.PRHFD.hf1 = 1.0 - TomoTT.PRHFD.hf;
    }

    public static void travt(double pe, double re, double dep, double ps, double rs, double hs, int kps, int nstn, double[] hlae, int lay, double tacc, int nitpb, double po, double[] del, double[] az, double[] ve, double[] fst) {
        double dt0;
        int[] lps = new int[1];
        int[] numsg = new int[1];
        int[] numsga = new int[1];
        double[] hk = new double[1];
        double[] hlas = new double[3];
        int[] ns = new int[6];
        double[][] pa = new double[6][201];
        double[][] ra = new double[6][201];
        double[][] ha = new double[6][201];
        double[][] va = new double[6][201];
        double[][] p = new double[6][201];
        double[][] r = new double[6][201];
        double[][] h = new double[6][201];
        double[][] v = new double[6][201];
        int[] ih = new int[6];
        int[] iv = new int[6];
        int[] nsa = new int[6];
        int[] iva = new int[6];
        int[] iha = new int[6];
        double[] fst1 = new double[1];
        double[] fst2 = new double[1];
        int i = 1;
        while (i <= 2) {
            int k = i;
            TomoTT.hlay(ps, rs, hk, k);
            hlas[i] = hk[0];
            ++i;
        }
        TomoTT.conaz(re, pe, rs, ps, del, az);
        if (lay == 1) {
            double dt1;
            TomoTT.wvtype(del[0], kps, lps);
            if (lps[0] == 1) {
                TomoTT.beeline(pe, re, dep, ps, rs, hs, kps, ve, fst);
                return;
            }
            if (lps[0] == 6 || lps[0] == 7) {
                int ihead = lps[0] - 5;
                TomoTT.find(pe, re, dep, ps, rs, hs, kps, lay, ihead, hlae, hlas, numsg, ns, p, r, h, v, ih, iv, tacc, nitpb, fst);
            } else if (lps[0] == 11) {
                TomoTT.beeline(pe, re, dep, ps, rs, hs, kps, ve, fst);
                TomoTT.find(pe, re, dep, ps, rs, hs, kps, lay, 1, hlae, hlas, numsg, ns, p, r, h, v, ih, iv, tacc, nitpb, fst1);
                dt0 = Math.abs(po - fst[0]);
                dt1 = Math.abs(po - fst1[0]);
                if (dt0 <= dt1) {
                    return;
                }
                if (dt0 > dt1) {
                    fst[0] = fst1[0];
                }
            } else if (lps[0] == 12) {
                TomoTT.find(pe, re, dep, ps, rs, hs, kps, lay, 1, hlae, hlas, numsg, ns, p, r, h, v, ih, iv, tacc, nitpb, fst);
                TomoTT.find(pe, re, dep, ps, rs, hs, kps, lay, 2, hlae, hlas, numsga, nsa, pa, ra, ha, va, iha, iva, tacc, nitpb, fst1);
                dt0 = Math.abs(po - fst[0]);
                dt1 = Math.abs(po - fst1[0]);
                if (dt0 <= dt1) {
                    return;
                }
                if (dt0 > dt1) {
                    fst[0] = fst1[0];
                }
            }
        } else if (lay == 2) {
            TomoTT.wvtype(del[0], kps, lps);
            if (lps[0] == 1 || lps[0] == 6) {
                TomoTT.find(pe, re, dep, ps, rs, hs, kps, lay, 0, hlae, hlas, numsg, ns, p, r, h, v, ih, iv, tacc, nitpb, fst);
            } else if (lps[0] == 7) {
                TomoTT.find(pe, re, dep, ps, rs, hs, kps, lay, 2, hlae, hlas, numsg, ns, p, r, h, v, ih, iv, tacc, nitpb, fst);
            } else {
                TomoTT.find(pe, re, dep, ps, rs, hs, kps, lay, 0, hlae, hlas, numsg, ns, p, r, h, v, ih, iv, tacc, nitpb, fst);
                TomoTT.find(pe, re, dep, ps, rs, hs, kps, lay, 2, hlae, hlas, numsga, nsa, pa, ra, ha, va, iha, iva, tacc, nitpb, fst2);
                dt0 = Math.abs(po - fst[0]);
                double dt2 = Math.abs(po - fst2[0]);
                if (dt2 < dt0) {
                    TomoTT.eq3(fst2[0], numsga[0], nsa, pa, ra, ha, va, iha, iva, fst, numsg, ns, p, r, h, v, ih, iv);
                }
            }
        } else if (lay == 3) {
            TomoTT.find(pe, re, dep, ps, rs, hs, kps, lay, 0, hlae, hlas, numsg, ns, p, r, h, v, ih, iv, tacc, nitpb, fst);
        }
        int na = ns[numsg[0]];
        ve[0] = v[numsg[0]][na];
        TomoTT.RAYLOC.nrp = 0;
        i = 1;
        while (i <= numsg[0]) {
            int ii = ns[i] - 1;
            if (i == numsg[0]) {
                ii = ns[i];
            }
            int j = 1;
            while (j <= ii) {
                ++TomoTT.RAYLOC.nrp;
                TomoTT.RAYLOC.rp[1][TomoTT.RAYLOC.nrp] = p[i][j];
                TomoTT.RAYLOC.rp[2][TomoTT.RAYLOC.nrp] = r[i][j];
                TomoTT.RAYLOC.rp[3][TomoTT.RAYLOC.nrp] = h[i][j];
                TomoTT.RAYLOC.ivk[TomoTT.RAYLOC.nrp] = iv[i];
                TomoTT.RAYLOC.iwk[TomoTT.RAYLOC.nrp] = i;
                ++j;
            }
            ++i;
        }
    }

    public static void wvtype(double del, int kps, int[] lps) {
        double dg = 120.0;
        double dk = 150.0;
        double dn = 200.0;
        lps[0] = kps;
        if (kps >= 3 && kps <= 7) {
            return;
        }
        lps[0] = del < 120.0 ? 1 : (del >= 120.0 && del < 150.0 ? 11 : (del >= 150.0 && del < 200.0 ? 12 : 7));
    }

    public static void find(double pe, double re, double dep, double ps, double rs, double hs, int kps, int lay, int ihead, double[] hlae, double[] hlas, int[] numsg, int[] ns, double[][] p, double[][] r, double[][] h, double[][] v, int[] ih, int[] iv, double tacc, int nitpb, double[] fst) {
        double[][] pg = new double[6][201];
        double[][] rg = new double[6][201];
        double[][] hg = new double[6][201];
        double[][] vg = new double[6][201];
        TomoTT.inipath(pe, re, dep, ps, rs, hs, kps, lay, ihead, hlae, hlas, numsg, pg, rg, hg, vg, ih, iv);
        TomoTT.minima(numsg[0], pg, rg, hg, vg, ns, p, r, h, v, ih, iv, kps, tacc, nitpb, fst);
    }

    public static void inipath(double pe, double re, double dep, double ps, double rs, double hs, int kps, int lay, int ihead, double[] hlae, double[] hlas, int[] numsg, double[][] p, double[][] r, double[][] h, double[][] v, int[] ih, int[] iv) {
        double h1 = 0.0;
        double h2 = 0.0;
        double[] v1 = new double[1];
        double[] v2 = new double[1];
        if (ihead == 0) {
            numsg[0] = lay;
            int j = 1;
            while (j <= numsg[0]) {
                int i = j - 1;
                if (j == 1) {
                    h1 = hs;
                }
                if (j > 1) {
                    h1 = hlas[i];
                }
                if (j < numsg[0]) {
                    h2 = hlas[j];
                }
                if (j == numsg[0]) {
                    h2 = dep;
                }
                int ips = TomoTT.RAYPATH.iwv[kps][j];
                int jj = j;
                TomoTT.vel3(ps, rs, h1, v1, jj, ips);
                TomoTT.vel3(ps, rs, h2, v2, jj, ips);
                p[j][1] = ps;
                r[j][1] = rs;
                h[j][1] = h1;
                v[j][1] = v1[0];
                p[j][2] = ps;
                r[j][2] = rs;
                h[j][2] = h2;
                v[j][2] = v2[0];
                if (j == numsg[0]) {
                    TomoTT.vel3(pe, re, dep, v2, jj, ips);
                    p[j][2] = pe;
                    r[j][2] = re;
                    h[j][2] = dep;
                    v[j][2] = v2[0];
                }
                ih[j] = j;
                iv[j] = j;
                ++j;
            }
        } else {
            int ips;
            numsg[0] = 2 * ihead - lay + 2;
            int j = 1;
            while (j <= ihead) {
                int i = j - 1;
                if (j == 1) {
                    h1 = hs;
                }
                if (j > 1) {
                    h1 = hlas[i];
                }
                h2 = hlas[j];
                ips = TomoTT.RAYPATH.iwv[kps][j];
                int jj = j;
                TomoTT.vel3(ps, rs, h1, v1, jj, ips);
                TomoTT.vel3(ps, rs, h2, v2, jj, ips);
                p[j][1] = ps;
                r[j][1] = rs;
                h[j][1] = h1;
                v[j][1] = v1[0];
                p[j][2] = ps;
                r[j][2] = rs;
                h[j][2] = h2;
                v[j][2] = v2[0];
                ih[j] = j;
                iv[j] = j;
                ++j;
            }
            int ihe = ihead + 1;
            h1 = hlas[ihead];
            h2 = hlae[ihead];
            ips = TomoTT.RAYPATH.iwv[kps][ihe];
            TomoTT.vel3(ps, rs, h1, v1, ihe, ips);
            TomoTT.vel3(ps, rs, h2, v2, ihe, ips);
            p[ihe][1] = ps;
            r[ihe][1] = rs;
            h[ihe][1] = h1;
            v[ihe][1] = v1[0];
            p[ihe][2] = ps;
            r[ihe][2] = rs;
            h[ihe][2] = h2;
            v[ihe][2] = v2[0];
            iv[ihe] = ihe;
            ih[ihe] = ihead;
            int ihea = numsg[0] - ihe;
            int j2 = 1;
            while (j2 <= ihea) {
                int j1 = ihead - j2 + 1;
                int j22 = j1 - 1;
                int j3 = ihe + j2;
                h1 = hlae[j1];
                if (j22 == 0) {
                    h2 = dep;
                }
                if (j22 > 0) {
                    h2 = hlae[j22];
                }
                if (j2 == ihea) {
                    h2 = dep;
                }
                ips = TomoTT.RAYPATH.iwv[kps][j3];
                TomoTT.vel3(pe, re, h1, v1, j1, ips);
                TomoTT.vel3(pe, re, h2, v2, j1, ips);
                p[j3][1] = pe;
                r[j3][1] = re;
                h[j3][1] = h1;
                v[j3][1] = v1[0];
                p[j3][2] = pe;
                r[j3][2] = re;
                h[j3][2] = h2;
                v[j3][2] = v2[0];
                if (j22 == 0) {
                    j22 = 1;
                }
                iv[j3] = j1;
                ih[j3] = j22;
                ++j2;
            }
        }
    }

    public static void minima(int numsg, double[][] pg, double[][] rg, double[][] hg, double[][] vg, int[] ns, double[][] p, double[][] r, double[][] h, double[][] v, int[] ih, int[] iv, int kps, double tacc, int nitpb, double[] fstime) {
        int[] nsg = new int[6];
        double[] sleng = new double[6];
        double[] p2 = new double[1];
        double[] r2 = new double[1];
        double[] h2 = new double[1];
        double[] v2 = new double[1];
        double[] vm = new double[1];
        double[] t1 = new double[1];
        double[] t2 = new double[1];
        double[] t3 = new double[1];
        double[] t4 = new double[1];
        int i = 1;
        while (i <= numsg) {
            ns[i] = 2;
            nsg[i] = 2;
            ++i;
        }
        TomoTT.eq2(numsg, ns, pg, rg, hg, vg, p, r, h, v);
        TomoTT.travel(numsg, ns, p, r, h, v, sleng, fstime);
        int lmn = numsg * 2;
        int kmn = 2;
        int itera = 0;
        boolean gotoL2 = true;
        block1: while (true) {
            double dt;
            int ii;
            int j;
            double fst;
            if (!gotoL2) {
                gotoL2 = false;
                if (++itera >= nitpb) {
                    return;
                }
                fst = fstime[0];
                i = 1;
                while (i <= 2) {
                    j = 1;
                    while (j <= 2) {
                        p[i][j] = pg[i][j];
                        r[i][j] = rg[i][j];
                        h[i][j] = hg[i][j];
                        v[i][j] = vg[i][j];
                        ++j;
                    }
                    ++i;
                }
                j = 1;
                while (j <= numsg) {
                    nsg[j] = ns[j];
                    if (iv[j] > 2 && !(sleng[j] <= 5.0)) {
                        ns[j] = 2 * nsg[j] - 1;
                        int lp = nsg[j];
                        int lq = ns[j];
                        p[j][lq] = pg[j][lp];
                        r[j][lq] = rg[j][lp];
                        h[j][lq] = hg[j][lp];
                        v[j][lq] = vg[j][lp];
                        int ivj = iv[j];
                        int iwj = TomoTT.RAYPATH.iwv[kps][j];
                        i = 1;
                        while (i <= lp - 1) {
                            ii = i + 1;
                            int i2 = 2 * i;
                            int i3 = 2 * i - 1;
                            p[j][i3] = pg[j][i];
                            r[j][i3] = rg[j][i];
                            h[j][i3] = hg[j][i];
                            v[j][i3] = vg[j][i];
                            TomoTT.midpot(pg[j][i], rg[j][i], hg[j][i], pg[j][ii], rg[j][ii], hg[j][ii], p2, r2, h2);
                            TomoTT.vel3(p2[0], r2[0], h2[0], v2, ivj, iwj);
                            p[j][i2] = p2[0];
                            r[j][i2] = r2[0];
                            h[j][i2] = h2[0];
                            v[j][i2] = v2[0];
                            ++i;
                        }
                    }
                    ++j;
                }
                TomoTT.travel(numsg, ns, p, r, h, v, sleng, fstime);
                dt = Math.abs(fst - fstime[0]);
                lmn = 0;
                i = 1;
                while (i <= numsg) {
                    lmn += ns[i];
                    ++i;
                }
                if (lmn >= 200 || lmn > 50 && dt <= tacc) {
                    return;
                }
                TomoTT.eq2(numsg, ns, p, r, h, v, pg, rg, hg, vg);
            }
            gotoL2 = false;
            kmn = lmn / numsg;
            j = 1;
            while (true) {
                if (j > 6) continue block1;
                fst = fstime[0];
                i = 1;
                while (i <= numsg) {
                    int ia = i;
                    int m = i + 1;
                    ii = ns[i];
                    int k = 2;
                    while (k <= ii) {
                        if (i != numsg || k != ii) {
                            int kk = k - 1;
                            int kj = k + 1;
                            if (k < ii) {
                                t1[0] = p[i][k];
                                t2[0] = r[i][k];
                                t3[0] = h[i][k];
                                t4[0] = v[i][k];
                                TomoTT.bend(p[i][kk], r[i][kk], h[i][kk], v[i][kk], p[i][kj], r[i][kj], h[i][kj], v[i][kj], t1, t2, t3, t4, iv[i], ia, kps);
                                p[i][k] = t1[0];
                                r[i][k] = t2[0];
                                h[i][k] = t3[0];
                                v[i][k] = t4[0];
                            } else {
                                int ivi = iv[i];
                                int ivm = iv[m];
                                if (ivi > ivm) {
                                    t1[0] = p[i][k];
                                    t2[0] = r[i][k];
                                    t3[0] = h[i][k];
                                    t4[0] = v[i][k];
                                    TomoTT.snell(p[i][kk], r[i][kk], h[i][kk], v[i][kk], iv[i], ia, p[m][2], r[m][2], h[m][2], v[m][2], iv[m], m, ih[i], kps, t1, t2, t3, t4, vm);
                                    p[i][k] = t1[0];
                                    r[i][k] = t2[0];
                                    h[i][k] = t3[0];
                                    v[i][k] = t4[0];
                                } else if (ivi < ivm) {
                                    t1[0] = p[i][k];
                                    t2[0] = r[i][k];
                                    t3[0] = h[i][k];
                                    t4[0] = v[i][k];
                                    TomoTT.snell(p[m][2], r[m][2], h[m][2], v[m][2], iv[m], m, p[i][kk], r[i][kk], h[i][kk], v[i][kk], iv[i], ia, ih[i], kps, t1, t2, t3, vm, t4);
                                    p[i][k] = t1[0];
                                    r[i][k] = t2[0];
                                    h[i][k] = t3[0];
                                    v[i][k] = t4[0];
                                }
                                p[m][1] = p[i][k];
                                r[m][1] = r[i][k];
                                h[m][1] = h[i][k];
                                v[m][1] = vm[0];
                            }
                        }
                        ++k;
                    }
                    ++i;
                }
                TomoTT.travel(numsg, ns, p, r, h, v, sleng, fstime);
                dt = fst - fstime[0];
                if (kmn <= 2 && j <= 5 || dt > 0.0) {
                    TomoTT.eq2(numsg, ns, p, r, h, v, pg, rg, hg, vg);
                    if ((kmn > 2 || j > 5) && dt < tacc) {
                        continue block1;
                    }
                } else {
                    fstime[0] = fst;
                    continue block1;
                }
                ++j;
            }
            break;
        }
    }

    public static void bend(double a1, double b1, double h1, double v1, double a3, double b3, double h3, double v3, double[] a2, double[] b2, double[] h2, double[] v2, int iv, int iw, int kps) {
        double xfac = 1.15;
        double hmaxm = 1000.0;
        int iww = TomoTT.RAYPATH.iwv[kps][iw];
        double r1 = TomoTT.RAYPATH.r0 - h1;
        double r3 = TomoTT.RAYPATH.r0 - h3;
        double sia1 = Math.sin(a1);
        double sia3 = Math.sin(a3);
        double x1 = r1 * sia1 * Math.cos(b1);
        double y1 = r1 * sia1 * Math.sin(b1);
        double z1 = r1 * Math.cos(a1);
        double x3 = r3 * sia3 * Math.cos(b3);
        double y3 = r3 * sia3 * Math.sin(b3);
        double z3 = r3 * Math.cos(a3);
        double dx = x3 - x1;
        double dy = y3 - y1;
        double dz = z3 - z1;
        double x2 = x1 + dx / 2.0;
        double y2 = y1 + dy / 2.0;
        double z2 = z1 + dz / 2.0;
        double r2 = Math.sqrt(x2 * x2 + y2 * y2 + z2 * z2);
        a2[0] = Math.acos(z2 / r2);
        double sina = Math.sin(a2[0]);
        b2[0] = Math.atan2(y2, x2);
        h2[0] = TomoTT.RAYPATH.r0 - r2;
        TomoTT.vel3(a2[0], b2[0], h2[0], v2, iv, iww);
        double[] va = new double[1];
        double[] vb = new double[1];
        double[] vh = new double[1];
        TomoTT.veld(a2[0], b2[0], h2[0], va, vb, vh, iv, iww);
        double vr = -vh[0];
        double dn = dx * dx + dy * dy + dz * dz;
        double ddn = Math.sqrt(dn);
        double dr = (r3 - r1) / ddn;
        double da = (a3 - a1) / ddn;
        double db = (b3 - b1) / ddn;
        double pr = dr;
        double pa = r2 * da;
        double pb = r2 * sina * db;
        double vrd = pr * vr + pa * va[0] + pb * vb[0];
        double rvr = vr - vrd * pr;
        double rva = va[0] - vrd * pa;
        double rvb = vb[0] - vrd * pb;
        double rvs = Math.sqrt(rvr * rvr + rva * rva + rvb * rvb);
        if (rvs == 0.0) {
            return;
        }
        double cc = (1.0 / v1 + 1.0 / v3) / 2.0;
        double rcur = vr * (rvr /= rvs) + va[0] * (rva /= rvs) + vb[0] * (rvb /= rvs);
        rcur = (cc * v2[0] + 1.0) / (4.0 * cc * rcur);
        rcur = -rcur + Math.sqrt(rcur * rcur + dn / (8.0 * cc * v2[0]));
        double rdr = rvr * rcur;
        double rda = rva * rcur;
        double rdb = rvb * rcur;
        double rp = r2 + rdr;
        double ap = a2[0] + rda / r2;
        double bp = b2[0] + rdb / (r2 * sina);
        r2 = (rp - r2) * xfac + r2;
        a2[0] = (ap - a2[0]) * xfac + a2[0];
        b2[0] = (bp - b2[0]) * xfac + b2[0];
        h2[0] = TomoTT.RAYPATH.r0 - r2;
        TomoTT.limit(0.0, hmaxm, h2);
        TomoTT.vel3(a2[0], b2[0], h2[0], v2, iv, iww);
    }

    public static void length(double pe, double re, double he, double ps, double rs, double hs, double[] ds) {
        double r0 = 6371.0;
        double r0e = r0 - he;
        double r0s = r0 - hs;
        double sinpe = Math.sin(pe);
        double sinps = Math.sin(ps);
        double xe = r0e * sinpe * Math.cos(re);
        double ye = r0e * sinpe * Math.sin(re);
        double ze = r0e * Math.cos(pe);
        double xs = r0s * sinps * Math.cos(rs);
        double ys = r0s * sinps * Math.sin(rs);
        double zs = r0s * Math.cos(ps);
        double dx = xe - xs;
        double dy = ye - ys;
        double dz = ze - zs;
        ds[0] = dx * dx + dy * dy + dz * dz;
        ds[0] = Math.sqrt(ds[0]);
    }

    public static void veld(double pe, double re, double he, double[] vp, double[] vr, double[] vh, int lay, int ips) {
        vp[0] = 0.0;
        vr[0] = 0.0;
        vh[0] = 0.0;
        if (lay <= 2) {
            return;
        }
        double dh = 5.0;
        double h1 = he - dh;
        double h2 = he + dh;
        double[] v1 = new double[1];
        double[] v2 = new double[1];
        TomoTT.vel3(pe, re, h1, v1, lay, ips);
        TomoTT.vel3(pe, re, h2, v2, lay, ips);
        vh[0] = (v2[0] - v1[0]) / (h2 - h1);
    }

    public static void snell(double pe, double re, double he, double ve, int ive, int iwe, double ps, double rs, double hs, double vs, int ivs, int iws, int ih, int kps, double[] pl, double[] rl, double[] hl, double[] vel, double[] vsl) {
        double pi = Math.PI;
        double[] h0 = new double[1];
        TomoTT.midpot(pe, re, he, ps, rs, hs, pl, rl, h0);
        TomoTT.hlay(pl[0], rl[0], hl, ih);
        int iwve = TomoTT.RAYPATH.iwv[kps][iwe];
        int iwvs = TomoTT.RAYPATH.iwv[kps][iws];
        TomoTT.vel3(pl[0], rl[0], hl[0], vel, ive, iwve);
        TomoTT.vel3(pl[0], rl[0], hl[0], vsl, ivs, iwvs);
        double[] del = new double[1];
        double[] az = new double[1];
        TomoTT.conaz(re, pe, rs, ps, del, az);
        if (del[0] < TomoTT.RAYPATH.eps) {
            return;
        }
        double[] hel = new double[1];
        double[] hsl = new double[1];
        TomoTT.hlay(pe, re, hel, ih);
        TomoTT.hlay(ps, rs, hsl, ih);
        double dh = hel[0] - hsl[0];
        double bz = az[0] + pi;
        double azs = az[0];
        double aze = bz;
        if (dh <= 0.0) {
            azs = bz;
            aze = az[0];
        }
        double tanp = Math.abs(dh) * (1.0 + 0.5 * hl[0] / TomoTT.RAYPATH.r0) / del[0];
        double thp = Math.atan(tanp);
        double de = Math.abs(he - hel[0]) * tanp / (TomoTT.RAYPATH.r0 - hel[0]);
        double ds = Math.abs(hsl[0] - hs) * tanp / (TomoTT.RAYPATH.r0 - hsl[0]);
        double[] ree = new double[1];
        double[] pee = new double[1];
        double[] rss = new double[1];
        double[] pss = new double[1];
        double[] hee = new double[1];
        double[] hss = new double[1];
        TomoTT.azin(pe, re, de, aze, ree, pee);
        TomoTT.azin(ps, rs, ds, azs, rss, pss);
        TomoTT.hlay(pee[0], ree[0], hee, ih);
        TomoTT.hlay(pss[0], rss[0], hss, ih);
        double[] d = new double[1];
        TomoTT.length(pee[0], ree[0], hee[0], pss[0], rss[0], hss[0], d);
        double azes = az[0];
        double cthp = Math.cos(thp);
        double s1 = Math.abs(he - hel[0]) * cthp;
        double s2 = Math.abs(hsl[0] - hs) * cthp;
        double sx = 0.001;
        int k = 1;
        while (k <= 3) {
            double v1 = (ve + vel[0]) * 0.5;
            double v2 = (vs + vsl[0]) * 0.5;
            double[] x = new double[1];
            TomoTT.faspo(s1, s2, d[0], v1, v2, x);
            double dx = 0.2 * d[0];
            double ax = Math.min(sx, dx);
            if (x[0] <= ax) {
                x[0] = ax;
            }
            double xc = x[0] * cthp / (TomoTT.RAYPATH.r0 - hl[0]);
            TomoTT.azin(pee[0], ree[0], xc, azes, rl, pl);
            TomoTT.limit(pee[0], pss[0], pl);
            TomoTT.limit(ree[0], rss[0], rl);
            TomoTT.hlay(pl[0], rl[0], hl, ih);
            TomoTT.vel3(pl[0], rl[0], hl[0], vsl, ivs, iwvs);
            TomoTT.vel3(pl[0], rl[0], hl[0], vel, ive, iwve);
            ++k;
        }
    }

    public static void midpot(double p1, double r1, double h1, double p3, double r3, double h3, double[] p2, double[] r2, double[] h2) {
        double r0 = 6371.0;
        double[] del = new double[1];
        double[] az = new double[1];
        TomoTT.conaz(r1, p1, r3, p3, del, az);
        double del2 = 0.5 * del[0] / r0;
        TomoTT.azin(p1, r1, del2, az[0], r2, p2);
        h2[0] = (h1 + h3) * 0.5;
        double dh = (r0 - h2[0]) * (1.0 - Math.cos(del2));
        h2[0] = h2[0] + dh;
        TomoTT.limit(0.0, 2888.0, h2);
    }

    public static void limit(double c1, double c2, double[] c) {
        double a1 = Math.min(c1, c2);
        double a2 = Math.max(c1, c2);
        if (c[0] < a1) {
            c[0] = a1;
        }
        if (c[0] > a2) {
            c[0] = a2;
        }
    }

    public static void travel(int numsg, int[] ns, double[][] p, double[][] r, double[][] h, double[][] v, double[] sleng, double[] fst) {
        double[] ds = new double[1];
        fst[0] = 0.0;
        int i = 1;
        while (i <= numsg) {
            sleng[i] = 0.0;
            int ii = ns[i];
            int j = 2;
            while (j <= ii) {
                int k = j - 1;
                TomoTT.length(p[i][j], r[i][j], h[i][j], p[i][k], r[i][k], h[i][k], ds);
                double vij = v[i][j];
                double vik = v[i][k];
                fst[0] = fst[0] + ds[0] / vij + ds[0] / vik;
                sleng[i] = sleng[i] + ds[0];
                ++j;
            }
            sleng[i] = sleng[i] / ((double)ii - 1.0);
            ++i;
        }
        fst[0] = fst[0] * 0.5;
        if (fst[0] < 0.0) {
            fst[0] = 999.9;
        }
    }

    public static void faspo(double s1, double s2, double d, double v1, double v2, double[] x) {
        double dx;
        double eps = 1.0E-7;
        double dv = 0.0;
        if (Math.abs(s1 * s2) < eps) {
            double v12 = v1 / v2;
            if (v12 > 1.0) {
                v12 = 1.0 / v12;
            }
            dv = v12 / Math.sqrt(1.0 - v12 * v12);
            if (Math.abs(s1) < eps) {
                x[0] = d - s2 * dv;
            }
            if (Math.abs(s2) < eps) {
                x[0] = s1 * dv;
            }
            return;
        }
        double x1 = 0.0;
        double x2 = d;
        double[] y = new double[1];
        double[] f = new double[1];
        TomoTT.fun(s1, s2, d, v1, v2, x1, y);
        int nk = 0;
        double xm = 0.0;
        do {
            ++nk;
            xm = (x1 + x2) * 0.5;
            TomoTT.fun(s1, s2, d, v1, v2, xm, f);
            if (y[0] * f[0] < 0.0) {
                x2 = xm;
            } else {
                x1 = xm;
            }
            dx = Math.abs(x2 - x1);
        } while (nk <= 30 && dx > 0.05);
        x[0] = xm;
    }

    public static void fun(double s1, double s2, double d, double v1, double v2, double x, double[] y) {
        double dx = d - x;
        double d2 = dx * dx;
        double x2 = x * x;
        double y1 = v1 * v1 * d2 * (x2 + s1 * s1);
        double y2 = v2 * v2 * x2 * (d2 + s2 * s2);
        y[0] = y1 - y2;
    }

    public static void beeline(double pe, double re, double he, double ps, double rs, double hs, int kps, double[] ve, double[] fst) {
        double[] sl = new double[1];
        double[] v = new double[1];
        TomoTT.length(pe, re, he, ps, rs, hs, sl);
        double stepl = 5.0;
        int nrp = (int)(sl[0] / stepl) + 2;
        int nrp1 = nrp - 1;
        double ab = 1.0 / (double)nrp1;
        double dp = (pe - ps) * ab;
        double dr = (re - rs) * ab;
        double dh = (he - hs) * ab;
        fst[0] = 0.0;
        int k1 = 0;
        while (k1 <= nrp1) {
            int k = k1 + 1;
            double c = k1;
            TomoTT.RAYLOC.rp[1][k] = ps + dp * c;
            TomoTT.RAYLOC.rp[2][k] = rs + dr * c;
            TomoTT.RAYLOC.rp[3][k] = hs + dh * c;
            TomoTT.RAYLOC.ivk[k] = 1;
            TomoTT.RAYLOC.iwk[k] = 1;
            TomoTT.vel3(TomoTT.RAYLOC.rp[1][k], TomoTT.RAYLOC.rp[2][k], TomoTT.RAYLOC.rp[3][k], v, 1, kps);
            if (k == 1 || k == nrp) {
                v[0] = v[0] * 2.0;
            }
            fst[0] = fst[0] + 1.0 / v[0];
            ++k1;
        }
        fst[0] = fst[0] * sl[0] * ab;
        if (fst[0] < 0.0) {
            fst[0] = 999.9;
        }
        ve[0] = v[0] * 0.5;
    }

    public static void eq1(double pg, double rg, double hg, double vg, double[] p, double[] r, double[] h, double[] v) {
        p[0] = pg;
        r[0] = rg;
        h[0] = hg;
        v[0] = vg;
    }

    public static void eq2(int numsg, int[] ns, double[][] pg, double[][] rg, double[][] hg, double[][] vg, double[][] p, double[][] r, double[][] h, double[][] v) {
        int i = 1;
        while (i <= numsg) {
            int j = 1;
            while (j <= ns[i]) {
                p[i][j] = pg[i][j];
                r[i][j] = rg[i][j];
                h[i][j] = hg[i][j];
                v[i][j] = vg[i][j];
                ++j;
            }
            ++i;
        }
    }

    public static void eq3(double fsta, int numsga, int[] nsa, double[][] pa, double[][] ra, double[][] ha, double[][] va, int[] iha, int[] iva, double[] fst, int[] numsg, int[] ns, double[][] p, double[][] r, double[][] h, double[][] v, int[] ih, int[] iv) {
        fst[0] = fsta;
        numsg[0] = numsga;
        int k = 1;
        while (k <= numsg[0]) {
            ns[k] = nsa[k];
            iv[k] = iva[k];
            ih[k] = iha[k];
            ++k;
        }
        TomoTT.eq2(numsg[0], ns, pa, ra, ha, va, p, r, h, v);
    }

    public static void rminima(double[] rm) {
        double drm;
        double sr = 0.01;
        double rm2 = 2889.0;
        double rm1 = TomoTT.IASP91.rh - 10.0;
        double r22 = TomoTT.IASP91.ra - 100.0;
        double zero = 0.0;
        if (rm1 > r22) {
            rm1 = r22;
        }
        double[] y = new double[1];
        TomoTT.delfun(rm1, y);
        double rmm = 0.0;
        do {
            rmm = (rm1 + rm2) / 2.0;
            double[] f = new double[1];
            TomoTT.delfun(rmm, f);
            if (y[0] * f[0] > zero) {
                rm1 = rmm;
            } else {
                rm2 = rmm;
            }
            drm = rm1 - rm2;
        } while (drm > sr);
        rm[0] = rmm;
    }

    public static void delfun(double rm, double[] y) {
        double pid = 0.017453;
        double[] vm = new double[1];
        TomoTT.vump(rm, vm);
        double p = rm / vm[0];
        double pp = p * p;
        double[] a1 = new double[1];
        double[] a2 = new double[1];
        double[] a3 = new double[1];
        double[] a4 = new double[1];
        double[] a5 = new double[1];
        double[] a6 = new double[1];
        if (TomoTT.IASP91.rh > TomoTT.IASP91.r1) {
            TomoTT.delab(TomoTT.IASP91.rh, TomoTT.IASP91.ra, TomoTT.IASP91.dr1, pp, a1);
            TomoTT.delab(TomoTT.IASP91.r1, TomoTT.IASP91.rh, TomoTT.IASP91.dr1, pp, a2);
            TomoTT.delab(TomoTT.IASP91.r2, TomoTT.IASP91.r1, TomoTT.IASP91.dr1, pp, a3);
            if (rm >= TomoTT.IASP91.r3) {
                TomoTT.delab(rm, TomoTT.IASP91.r2, TomoTT.IASP91.dr2, pp, a4);
                y[0] = a1[0] + 2.0 * (a2[0] + a3[0] + a4[0]);
            } else if (rm >= TomoTT.IASP91.r4 && rm < TomoTT.IASP91.r3) {
                TomoTT.delab(TomoTT.IASP91.r3, TomoTT.IASP91.r2, TomoTT.IASP91.dr2, pp, a4);
                TomoTT.delab(rm, TomoTT.IASP91.r3, TomoTT.IASP91.dr2, pp, a5);
                y[0] = a1[0] + 2.0 * (a2[0] + a3[0] + a4[0] + a5[0]);
            } else if (rm < TomoTT.IASP91.r4) {
                TomoTT.delab(TomoTT.IASP91.r3, TomoTT.IASP91.r2, TomoTT.IASP91.dr2, pp, a4);
                TomoTT.delab(TomoTT.IASP91.r4, TomoTT.IASP91.r3, TomoTT.IASP91.dr2, pp, a5);
                TomoTT.delab(rm, TomoTT.IASP91.r4, TomoTT.IASP91.dr2, pp, a6);
                y[0] = a1[0] + 2.0 * (a2[0] + a3[0] + a4[0] + a5[0] + a6[0]);
            }
        } else if (TomoTT.IASP91.rh > TomoTT.IASP91.r2 && TomoTT.IASP91.rh <= TomoTT.IASP91.r1) {
            TomoTT.delab(TomoTT.IASP91.r1, TomoTT.IASP91.ra, TomoTT.IASP91.dr1, pp, a1);
            TomoTT.delab(TomoTT.IASP91.rh, TomoTT.IASP91.r1, TomoTT.IASP91.dr1, pp, a2);
            TomoTT.delab(TomoTT.IASP91.r2, TomoTT.IASP91.rh, TomoTT.IASP91.dr1, pp, a3);
            if (rm >= TomoTT.IASP91.r3) {
                TomoTT.delab(rm, TomoTT.IASP91.r2, TomoTT.IASP91.dr2, pp, a4);
                y[0] = a1[0] + a2[0] + 2.0 * (a3[0] + a4[0]);
            } else if (rm >= TomoTT.IASP91.r4 && rm < TomoTT.IASP91.r3) {
                TomoTT.delab(TomoTT.IASP91.r3, TomoTT.IASP91.r2, TomoTT.IASP91.dr2, pp, a4);
                TomoTT.delab(rm, TomoTT.IASP91.r3, TomoTT.IASP91.dr2, pp, a5);
                y[0] = a1[0] + a2[0] + 2.0 * (a3[0] + a4[0] + a5[0]);
            } else if (rm < TomoTT.IASP91.r4) {
                TomoTT.delab(TomoTT.IASP91.r3, TomoTT.IASP91.r2, TomoTT.IASP91.dr2, pp, a4);
                TomoTT.delab(TomoTT.IASP91.r4, TomoTT.IASP91.r3, TomoTT.IASP91.dr2, pp, a5);
                TomoTT.delab(rm, TomoTT.IASP91.r4, TomoTT.IASP91.dr2, pp, a6);
                y[0] = a1[0] + a2[0] + 2.0 * (a3[0] + a4[0] + a5[0] + a6[0]);
            }
        } else if (TomoTT.IASP91.rh > TomoTT.IASP91.r3 && TomoTT.IASP91.rh <= TomoTT.IASP91.r2) {
            TomoTT.delab(TomoTT.IASP91.r1, TomoTT.IASP91.ra, TomoTT.IASP91.dr1, pp, a1);
            TomoTT.delab(TomoTT.IASP91.r2, TomoTT.IASP91.r1, TomoTT.IASP91.dr1, pp, a2);
            TomoTT.delab(TomoTT.IASP91.rh, TomoTT.IASP91.r2, TomoTT.IASP91.dr2, pp, a3);
            if (rm >= TomoTT.IASP91.r3) {
                TomoTT.delab(rm, TomoTT.IASP91.rh, TomoTT.IASP91.dr2, pp, a4);
                y[0] = a1[0] + a2[0] + a3[0] + 2.0 * a4[0];
            } else if (rm >= TomoTT.IASP91.r4 && rm < TomoTT.IASP91.r3) {
                TomoTT.delab(TomoTT.IASP91.r3, TomoTT.IASP91.rh, TomoTT.IASP91.dr2, pp, a4);
                TomoTT.delab(rm, TomoTT.IASP91.r3, TomoTT.IASP91.dr2, pp, a5);
                y[0] = a1[0] + a2[0] + a3[0] + 2.0 * (a4[0] + a5[0]);
            } else if (rm < TomoTT.IASP91.r4) {
                TomoTT.delab(TomoTT.IASP91.r3, TomoTT.IASP91.rh, TomoTT.IASP91.dr2, pp, a4);
                TomoTT.delab(TomoTT.IASP91.r4, TomoTT.IASP91.r3, TomoTT.IASP91.dr2, pp, a5);
                TomoTT.delab(rm, TomoTT.IASP91.r4, TomoTT.IASP91.dr2, pp, a6);
                y[0] = a1[0] + a2[0] + a3[0] + 2.0 * (a4[0] + a5[0] + a6[0]);
            }
        } else if (TomoTT.IASP91.rh > TomoTT.IASP91.r4 && TomoTT.IASP91.rh <= TomoTT.IASP91.r3) {
            TomoTT.delab(TomoTT.IASP91.r1, TomoTT.IASP91.ra, TomoTT.IASP91.dr1, pp, a1);
            TomoTT.delab(TomoTT.IASP91.r2, TomoTT.IASP91.r1, TomoTT.IASP91.dr1, pp, a2);
            TomoTT.delab(TomoTT.IASP91.r3, TomoTT.IASP91.r2, TomoTT.IASP91.dr2, pp, a3);
            TomoTT.delab(TomoTT.IASP91.rh, TomoTT.IASP91.r3, TomoTT.IASP91.dr2, pp, a4);
            if (rm >= TomoTT.IASP91.r4) {
                TomoTT.delab(rm, TomoTT.IASP91.rh, TomoTT.IASP91.dr2, pp, a5);
                y[0] = a1[0] + a2[0] + a3[0] + a4[0] + 2.0 * a5[0];
            } else if (rm < TomoTT.IASP91.r4) {
                TomoTT.delab(TomoTT.IASP91.r4, TomoTT.IASP91.rh, TomoTT.IASP91.dr2, pp, a5);
                TomoTT.delab(rm, TomoTT.IASP91.r4, TomoTT.IASP91.dr2, pp, a6);
                y[0] = a1[0] + a2[0] + a3[0] + a4[0] + 2.0 * (a5[0] + a6[0]);
            }
        } else if (TomoTT.IASP91.rh <= TomoTT.IASP91.r4) {
            TomoTT.delab(TomoTT.IASP91.r1, TomoTT.IASP91.ra, TomoTT.IASP91.dr1, pp, a1);
            TomoTT.delab(TomoTT.IASP91.r2, TomoTT.IASP91.r1, TomoTT.IASP91.dr1, pp, a2);
            TomoTT.delab(TomoTT.IASP91.r3, TomoTT.IASP91.r2, TomoTT.IASP91.dr2, pp, a3);
            TomoTT.delab(TomoTT.IASP91.r4, TomoTT.IASP91.r3, TomoTT.IASP91.dr2, pp, a4);
            TomoTT.delab(TomoTT.IASP91.rh, TomoTT.IASP91.r4, TomoTT.IASP91.dr2, pp, a5);
            TomoTT.delab(rm, TomoTT.IASP91.rh, TomoTT.IASP91.dr2, pp, a6);
            y[0] = a1[0] + a2[0] + a3[0] + a4[0] + a5[0] + 2.0 * a6[0];
        }
        y[0] = (p * y[0] - TomoTT.IASP91.del91) / pid;
    }

    public static void delab(double r1, double r2, double drr, double pp, double[] a) {
        double eps = 1.0E-4;
        double h = r2 - r1;
        a[0] = 0.0;
        if (h < eps) {
            return;
        }
        int nn = (int)(h / drr) + 1;
        double dr = h / (double)nn;
        double r12 = r1 + dr / 2.0;
        int i = 1;
        while (i <= nn) {
            double r = r12 + dr * (double)(i - 1);
            double[] v = new double[1];
            TomoTT.vump(r, v);
            double rr = r * r;
            double vv = v[0] * v[0];
            a[0] = a[0] + dr / r / Math.sqrt(Math.abs(rr / vv - pp));
            ++i;
        }
    }

    public static void vump(double r, double[] v) {
        double r0 = 6371.0;
        double h = r0 - r;
        double x = r / r0;
        double x2 = x * x;
        double x3 = x * x2;
        if (h < TomoTT.IASPHH.hz1) {
            v[0] = 6.0;
        } else if (h >= TomoTT.IASPHH.hz1 && h < TomoTT.IASPHH.hz2) {
            v[0] = 6.67;
        } else if (h >= TomoTT.IASPHH.hz2 && h < 120.0) {
            v[0] = 8.78541 - 0.74953 * x;
        } else if (h >= 120.0 && h < 210.0) {
            v[0] = 25.41389 - 17.69722 * x;
        } else if (h >= 210.0 && h < 410.0) {
            v[0] = 30.78765 - 23.25415 * x;
        } else if (h >= 410.0 && h < 660.0) {
            v[0] = 29.38896 - 21.40656 * x;
        } else if (h >= 660.0 && h < 760.0) {
            v[0] = 25.96984 - 16.93412 * x;
        } else if (h >= 760.0 && h < 2740.0) {
            v[0] = 25.1486 - 41.1538 * x + 51.9932 * x2 - 26.6083 * x3;
        } else if (h >= 2740.0 && h < 2889.0) {
            v[0] = 14.4947 - 1.47089 * x;
        } else if (h >= 2889.0 && h < 5153.9) {
            v[0] = 10.03904 + 3.75665 * x - 13.67046 * x2;
        } else if (h >= 5153.9 && h < 6371.0) {
            v[0] = 11.24094 - 4.09689 * x2;
        }
    }

    public static void depdel(double rm, double hh, double[] del) {
        double[] vm = new double[1];
        TomoTT.vump(rm, vm);
        double p = rm / vm[0];
        double pp = p * p;
        double rk = TomoTT.IASP91.ra - hh;
        if (rk < rm) {
            del[0] = TomoTT.IASP91.del91 * 0.5;
            return;
        }
        double[] a1 = new double[1];
        double[] a2 = new double[1];
        double[] a3 = new double[1];
        double[] a4 = new double[1];
        double[] a5 = new double[1];
        TomoTT.delab(TomoTT.IASP91.r1, TomoTT.IASP91.ra, TomoTT.IASP91.dr1, pp, a1);
        TomoTT.delab(TomoTT.IASP91.r2, TomoTT.IASP91.r1, TomoTT.IASP91.dr1, pp, a2);
        if (rk > TomoTT.IASP91.r3 && rk <= TomoTT.IASP91.r2) {
            TomoTT.delab(rk, TomoTT.IASP91.r2, TomoTT.IASP91.dr2, pp, a3);
            del[0] = p * (a1[0] + a2[0] + a3[0]);
        } else if (rk > TomoTT.IASP91.r4 && rk <= TomoTT.IASP91.r3) {
            TomoTT.delab(TomoTT.IASP91.r3, TomoTT.IASP91.r2, TomoTT.IASP91.dr2, pp, a3);
            TomoTT.delab(rk, TomoTT.IASP91.r3, TomoTT.IASP91.dr2, pp, a4);
            del[0] = p * (a1[0] + a2[0] + a3[0] + a4[0]);
        } else if (rk <= TomoTT.IASP91.r4) {
            TomoTT.delab(TomoTT.IASP91.r3, TomoTT.IASP91.r2, TomoTT.IASP91.dr2, pp, a3);
            TomoTT.delab(TomoTT.IASP91.r4, TomoTT.IASP91.r3, TomoTT.IASP91.dr2, pp, a4);
            TomoTT.delab(rk, TomoTT.IASP91.r4, TomoTT.IASP91.dr2, pp, a5);
            del[0] = p * (a1[0] + a2[0] + a3[0] + a4[0] + a5[0]);
        }
    }

    public static void deldep(double rm, double del, double[] hh) {
        double dh;
        double[] del1 = new double[1];
        TomoTT.depdel(rm, rm, del1);
        if (del >= del1[0]) {
            hh[0] = TomoTT.IASP91.ra - rm;
            return;
        }
        double zero = 0.0;
        double dhm = 1.0;
        double h1 = 50.0;
        double h2 = TomoTT.IASP91.ra - rm;
        double y = del;
        double hx = 0.0;
        do {
            hx = (h1 + h2) * 0.5;
            TomoTT.depdel(rm, hx, del1);
            double f = del - del1[0];
            double yf = y * f;
            if (yf > zero) {
                h1 = hx;
            } else {
                h2 = hx;
            }
            dh = h2 - h1;
        } while (dh > dhm);
        hh[0] = hx;
    }

    public static void azin(double p, double r, double dth, double daz, double[] faz, double[] fin) {
        double eps = 1.0E-6;
        double azm = -1.570796 - daz;
        double sdth = Math.sin(dth);
        double x = sdth * Math.cos(azm);
        double y = sdth * Math.sin(azm);
        double z = Math.cos(dth);
        double sr = Math.sin(r);
        double cr = Math.cos(r);
        double sp = Math.sin(p);
        double cp = Math.cos(p);
        double xg = sr * x + cr * cp * y + cr * sp * z;
        double yg = -cr * x + sr * cp * y + sr * sp * z;
        double zg = -sp * y + cp * z;
        double qg = Math.sqrt(xg * xg + yg * yg);
        fin[0] = Math.atan2(qg, zg);
        faz[0] = 0.0;
        if (qg > eps) {
            faz[0] = Math.atan2(yg, xg);
        }
    }

    public static void conaz(double re, double pe, double rs, double ps, double[] del, double[] az) {
        double r0 = 6371.0;
        double eps = 1.0E-7;
        double pi15 = 4.712389;
        double sps = Math.sin(ps);
        double cps = Math.cos(ps);
        double spe = Math.sin(pe);
        double cpe = Math.cos(pe);
        double ses = Math.sin(re - rs);
        double ces = Math.cos(re - rs);
        double x = sps * ses;
        double y = cpe * sps * ces - spe * cps;
        double s = Math.sqrt(x * x + y * y);
        double c = spe * sps * ces + cpe * cps;
        del[0] = Math.atan2(s, c) * 6371.0;
        az[0] = 0.0;
        double ax = Math.abs(x);
        double ay = Math.abs(y);
        if (ax < 1.0E-7 && ay < 1.0E-7) {
            return;
        }
        az[0] = 4.712389 - Math.atan2(y, x);
    }

    public static void prok(double pa, double pb, double p1, double p2, int[] ip, double[] pp) {
        ip[0] = 0;
        pp[0] = 999.0;
        if (pa >= p1 && pa <= p2) {
            ip[0] = 1;
        }
        if (pa <= p1 && pa >= p2) {
            ip[0] = 1;
        }
        if (ip[0] == 1) {
            pp[0] = pa;
            return;
        }
        if (pb >= p1 && pb <= p2) {
            ip[0] = 1;
        }
        if (pb <= p1 && pb >= p2) {
            ip[0] = 1;
        }
        if (ip[0] == 1) {
            pp[0] = pb;
        }
    }

    public static void main(String[] args) throws IOException {
        int mps = 1;
        TomoTT.input1();
        TomoTT.input23(mps);
        TomoTT.input5();
        double pea = 37.523;
        double rea = 115.03;
        double hea = 12.4;
        double psa = 36.433;
        double rsa = 116.034;
        double hsa = 0.0;
        int kps = 1;
        double[] del = new double[1];
        double[] fstime = new double[1];
        TomoTT.ttt(pea, rea, hea, psa, rsa, hsa, kps, del, fstime);
        System.out.printf("KPS,DEL,FSTIME = %d, %.4f, %.4f\n", kps, del[0], fstime[0]);
    }

    public static class CONTRL {
        int nsts;
        int neqs;
        int nitloc;
        double rmscut;
        double dvmax;
        double vdamp;
        int nhitct;
        int nitmax;
        double rmstop;
        double stepl;
        double tlim;
        int nitpb;
    }

    public static class DISCON {
        final int nnp = 20;
        final int nnr = 30;
        double[] pn = new double[21];
        double[] rn = new double[31];
        double[][] depa = new double[21][31];
        double[][] depb = new double[21][31];
        double[][] depc = new double[21][31];
    }

    public static class ELLIPS {
        double[] deltb = new double[6];
        int idel;
        int idel1;
        double t0;
        double t1;
        double t2;
    }

    public static class GRINET {
        int npa2;
        int npra2;
        int nodesa2;
        int nodetot;
    }

    public static class HLASTA {
        double[][] hlss = new double[506][3];
    }

    public static class HYPINV {
        double[] res = new double[501];
        double[][] dth = new double[501][5];
        double[] w = new double[501];
    }

    public static class IASP91 {
        double ra;
        double r1;
        double r2;
        double r3;
        double r4;
        double rh;
        double dr1;
        double dr2;
        double del91;
    }

    public static class IASPHH {
        double hz1;
        double hz2;
    }

    public static class JBMODV {
        double[] vp = new double[30];
        double[] vs = new double[30];
        double[] ra = new double[30];
        double[] depj = new double[30];
    }

    public static class LOCATE {
        double[] pla = new double[1];
        double[] rla = new double[1];
        double[] hla = new double[1];
        int[] iploca = new int[6091];
        int[] irloca = new int[6091];
        int[] ihloca = new int[6091];
    }

    public static class PRHFD {
        double p;
        double r;
        double h;
        double pf;
        double rf;
        double hf;
        double pf1;
        double rf1;
        double hf1;
        double pd;
        double rd;
        double hd;
    }

    public static class RAYLOC {
        int nrp;
        double[][] rp = new double[4][1501];
        int[] ivk = new int[1501];
        int[] iwk = new int[1501];
    }

    public static class RAYPATH {
        int[][] iwv = new int[9][6];
        double r0;
        double pideg;
        double eps;
    }

    public static class STATIN {
        double[] phis = new double[506];
        double[] rams = new double[506];
        double[] higs = new double[506];
        double[][] stc = new double[4][506];
    }

    public static class TOYUAN {
        double[] pd0t0 = new double[]{0.0, 0.0, -0.18, -0.34, -0.48, -0.57};
        double[] pd0t1 = new double[]{0.0, 0.0, -0.02, -0.05, -0.1, -0.16};
        double[] pd0t2 = new double[]{0.0, 0.0, 0.0, -0.01, -0.03, -0.06};
        double[] pd3t0 = new double[]{0.0, -0.12, -0.17, -0.29, -0.38, -0.46};
        double[] pd3t1 = new double[]{0.0, 0.0, -0.11, -0.14, -0.19, -0.24};
        double[] pd3t2 = new double[]{0.0, 0.0, 0.0, -0.01, -0.03, -0.07};
        double[] pd6t0 = new double[]{0.0, -0.26, -0.27, -0.31, -0.37, -0.41};
        double[] pd6t1 = new double[]{0.0, 0.0, -0.2, -0.28, -0.34, -0.37};
        double[] pd6t2 = new double[]{0.0, 0.0, 0.0, -0.02, -0.04, -0.08};
        double[] sd0t0 = new double[]{0.0, 0.0, -0.33, -0.57, -0.82, -1.0};
        double[] sd0t1 = new double[]{0.0, 0.0, -0.02, -0.1, -0.19, -0.3};
        double[] sd0t2 = new double[]{0.0, 0.0, 0.0, -0.02, -0.05, -0.12};
        double[] sd3t0 = new double[]{0.0, -0.22, -0.31, -0.52, -0.68, -0.84};
        double[] sd3t1 = new double[]{0.0, 0.0, -0.2, -0.25, -0.34, -0.43};
        double[] sd3t2 = new double[]{0.0, 0.0, 0.0, -0.02, -0.05, -0.13};
        double[] sd6t0 = new double[]{0.0, -0.47, -0.49, -0.56, -0.66, -0.72};
        double[] sd6t1 = new double[]{0.0, 0.0, -0.36, -0.5, -0.61, -0.67};
        double[] sd6t2 = new double[]{0.0, 0.0, 0.0, -0.03, -0.07, -0.14};
        double[] delra = new double[]{0.0, 0.0, 5.0, 10.0, 15.0, 20.0};
    }

    public static class VMOD3D {
        int npa;
        int nra;
        int nha;
        double[] pna = new double[21];
        double[] rna = new double[31];
        double[] hna = new double[17];
        double[][][] dvap = new double[21][31][17];
        double[][][] velap = new double[21][31][17];
    }

    public static class WEIGHT {
        double[] wv = new double[9];
        int ip;
        int jp;
        int kp;
        int ip1;
        int jp1;
        int kp1;
    }
}

