/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.ttt3d;

import cn.org.gddsn.seis.location.ComputedTravelTime;
import cn.org.gddsn.seis.ttt3d.TTTDing;
import cn.org.gddsn.seis.ttt3d.TomoTT;
import cn.org.gddsn.util.PropsUtil;
import com.sun.jna.Native;
import org.apache.log4j.Logger;

public class TTTDingNative
implements ComputedTravelTime {
    static Logger logger = Logger.getLogger(TTTDingNative.class);
    double ratioPS = 1.73;

    static {
        String libname = PropsUtil.getLibName((String)"traveltime");
        Native.register((String)libname);
        TTTDingNative.init_(new int[]{1});
        int mps = 1;
        try {
            TomoTT.input1();
            TomoTT.input23(mps);
            TomoTT.input5();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setRatioPS(double ratioPS) {
        this.ratioPS = ratioPS;
    }

    public static native int init_(int[] var0);

    public static native int hwh_(float[] var0, float[] var1, float[] var2, float[] var3, float[] var4, float[] var5, float[] var6, float[] var7, float[] var8, float[] var9);

    public double calDelta(double depth, double time, int phaseType) {
        return Double.NaN;
    }

    public double calDelta(double depth, double time, String phaseType) {
        return Double.NaN;
    }

    public double calTravelTime(double[] Src, double[] Stn, int phaseType) {
        String pn = null;
        if (phaseType == 3) {
            pn = "Pg";
        } else if (phaseType == 18) {
            pn = "Pb";
        } else if (phaseType == 1) {
            pn = "Pn";
        } else if (phaseType == 15) {
            pn = "PmP";
        } else if (phaseType == 4) {
            pn = "SG";
        } else if (phaseType == 19) {
            pn = "Sb";
        } else if (phaseType == 2) {
            pn = "Sn";
        } else if (phaseType == 16) {
            pn = "SmS";
        }
        if (pn == null) {
            return Double.NaN;
        }
        return this.calTravelTime(Src, Stn, pn);
    }

    public double calTravelTime(double depth, double Delta, int phaseType) {
        return Double.NaN;
    }

    public double calTravelTime0(double[] Src, double[] Stn, String phaseType) {
        int type = -1;
        double r = 1.0;
        if (phaseType.equals("P")) {
            type = 1;
        } else if (phaseType.equals("Pb")) {
            type = 6;
        } else if (phaseType.equals("Pn")) {
            type = 7;
        } else if (phaseType.equals("S")) {
            type = 1;
            r = this.ratioPS;
        } else if (phaseType.equals("Sb")) {
            type = 6;
            r = this.ratioPS;
        } else if (phaseType.equals("Sn")) {
            type = 7;
            r = this.ratioPS;
        }
        if (type == -1) {
            return Double.NaN;
        }
        double pea = Src[0];
        double rea = Src[1];
        double hea = Src[2];
        double psa = Stn[0];
        double rsa = Stn[1];
        double hsa = Stn[2];
        int kps = type;
        double[] del = new double[1];
        double[] fstime = new double[1];
        if (pea < 35.0 || pea > 45.0 || rea < 108.0 || rea > 122.0 || hea < -5.0 || hea > 600.0) {
            return Double.NaN;
        }
        if (psa < 35.0 || psa > 45.0 || rsa < 108.0 || rsa > 122.0 || hsa < -5.0 || hsa > 600.0) {
            return Double.NaN;
        }
        try {
            TomoTT.ttt(pea, rea, hea, psa, rsa, hsa, kps, del, fstime);
        }
        catch (Exception ex) {
            return Double.NaN;
        }
        return r * fstime[0];
    }

    public double calTravelTime(double[] Src, double[] Stn, String phaseType) {
        int type = -1;
        if (phaseType.equals("Pg")) {
            type = 1;
        } else if (phaseType.equals("PmP")) {
            type = 2;
        } else if (phaseType.equals("Pn")) {
            type = 3;
        } else if (phaseType.equals("Pb")) {
            type = 4;
        } else if (phaseType.equals("Sg")) {
            type = 5;
        } else if (phaseType.equals("SmS")) {
            type = 6;
        } else if (phaseType.equals("Sn")) {
            type = 7;
        } else if (phaseType.equals("Sb")) {
            type = 8;
        }
        if (type == -1) {
            return Double.NaN;
        }
        float[] pea = new float[]{(float)Src[0]};
        float[] rea = new float[]{(float)Src[1]};
        float[] hea = new float[]{(float)Src[2]};
        float[] psa = new float[]{(float)Stn[0]};
        float[] rsa = new float[]{(float)Stn[1]};
        float[] hsa = new float[]{(float)Stn[2]};
        float[] tp = new float[2];
        float[] tp11 = new float[2];
        float[] tpn = new float[2];
        float[] tpstar = new float[2];
        if ((double)pea[0] < 35.0 || pea[0] > 45.0f || (double)rea[0] < 108.0 || (double)rea[0] > 122.0 || (double)hea[0] < -5.0 || (double)hea[0] > 600.0) {
            return Double.NaN;
        }
        if ((double)psa[0] < 35.0 || psa[0] > 45.0f || (double)rsa[0] < 108.0 || (double)rsa[0] > 122.0 || (double)hsa[0] < -5.0 || (double)hsa[0] > 600.0) {
            return Double.NaN;
        }
        try {
            TTTDingNative.hwh_(rea, pea, hea, rsa, psa, hsa, tp, tp11, tpn, tpstar);
        }
        catch (Exception ex) {
            return Double.NaN;
        }
        switch (type) {
            case 1: {
                return tp[0] > 0.0f ? (double)tp[0] : Double.NaN;
            }
            case 2: {
                return tp11[0] > 0.0f ? (double)tp11[0] : Double.NaN;
            }
            case 3: {
                return tpn[0] > 0.0f ? (double)tpn[0] : Double.NaN;
            }
            case 4: {
                return tpstar[0] > 0.0f ? (double)tpstar[0] : Double.NaN;
            }
            case 5: {
                return tp[1] > 0.0f ? (double)tp[1] : Double.NaN;
            }
            case 6: {
                return tp11[1] > 0.0f ? (double)tp11[1] : Double.NaN;
            }
            case 7: {
                return tpn[1] > 0.0f ? (double)tpn[1] : Double.NaN;
            }
            case 8: {
                return tpstar[1] > 0.0f ? (double)tpstar[1] : Double.NaN;
            }
        }
        return Double.NaN;
    }

    public double calTravelTime(double depth, double Delta, String phaseType) {
        return Double.NaN;
    }

    public static void main0(String[] args) {
        String[] phs;
        TTTDing ttt = new TTTDing();
        double[] src = new double[]{39.523, 115.03, 12.4};
        double[] stn = new double[]{36.433, 116.034, 0.0};
        String[] stringArray = phs = new String[]{"P", "Pn", "Pb", "S", "Sn", "Sb"};
        int n = phs.length;
        int n2 = 0;
        while (n2 < n) {
            String ph = stringArray[n2];
            double tt = ttt.calTravelTime(src, stn, ph);
            System.out.println(String.valueOf(ph) + ", tt = " + tt);
            ++n2;
        }
    }

    public static void main(String[] args) {
        String[] phs;
        TTTDing ttt = new TTTDing();
        double[] src = new double[]{37.523, 115.03, 12.4};
        double[] stn = new double[]{37.7134, 115.2411, 0.0579999983};
        String[] stringArray = phs = new String[]{"Pg", "PmP", "Pn", "Pb", "Sg", "SmS", "Sn", "Sb"};
        int n = phs.length;
        int n2 = 0;
        while (n2 < n) {
            String ph = stringArray[n2];
            double tt = ttt.calTravelTime(src, stn, ph);
            System.out.println(String.valueOf(ph) + ", tt = " + tt);
            ++n2;
        }
    }
}

