/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.ttt3d;

import cn.org.gddsn.seis.location.ComputedTravelTime;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class TTTDing
implements ComputedTravelTime {
    static Logger logger = Logger.getLogger(TTTDing.class);
    boolean trace = false;
    PrintStream traceOut;
    String tracefn = "../lib/ding/trace.txt";
    double[][] sb = new double[10001][3];
    double[][] bx = new double[31][21];
    double[][] by = new double[21][21];
    int[] nx = new int[21];
    int[] ny = new int[21];
    int[] nnb = new int[21];
    int[] nbll = new int[21];
    double[][] hmoho = new double[31][21];
    double[][] hconrad = new double[31][21];
    double[][] s = new double[21][3];
    double[] h = new double[21];
    double[] thk = new double[21];
    int nl = 0;
    int jl = 0;
    double tkj = 0.0;
    double e1;
    double e2;
    double e3;
    double[] pt = new double[301];
    int[] istm = new int[301];
    int knobs;
    int nobs;
    double[] stax = new double[4];
    String[] stn = new String[501];
    double[][] x = new double[501][4];
    int nsta;
    int num;

    public TTTDing() {
        try {
            this.init();
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
        }
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void init() throws IOException {
        int n;
        int k;
        double[] pna = new double[]{35.0, 36.33, 36.66, 37.0, 37.33, 37.66, 38.0, 38.33, 38.66, 39.0, 39.33, 39.66, 40.0, 40.33, 40.66, 41.0, 41.33, 41.66, 42.0, 45.0};
        double[] rna = new double[]{108.0, 111.0, 111.33, 111.66, 112.0, 112.33, 112.66, 113.0, 113.33, 113.66, 114.0, 114.33, 114.66, 115.0, 115.33, 115.66, 116.0, 116.33, 116.66, 117.0, 117.33, 117.66, 118.0, 118.33, 118.66, 119.0, 119.33, 119.66, 120.0, 122.0};
        Scanner sc04 = new Scanner(new File("../lib/ding/s04.d"));
        Scanner sc15 = new Scanner(new File("../lib/ding/s15.d"));
        this.num = sc04.nextInt();
        this.nl = sc04.nextInt();
        int ih = sc04.nextInt();
        int j = 1;
        while (j <= this.nl) {
            this.h[j] = sc04.nextDouble();
            if (j != 1) {
                k = j - 1;
                this.thk[k] = this.h[j] - this.h[j - 1];
            }
            ++j;
        }
        sc04.next();
        sc04.next();
        sc04.next();
        sc04.next();
        this.nsta = n = sc04.nextInt();
        int i = 1;
        while (i <= n) {
            String sta = sc04.next();
            double xlat = sc04.nextDouble();
            double xlon = sc04.nextDouble();
            double elev = sc04.nextDouble();
            double dz = -elev / 1000.0;
            this.stn[i] = sta;
            this.x[i][1] = xlon;
            this.x[i][2] = xlat;
            this.x[i][3] = dz;
            ++i;
        }
        int nbl = 0;
        this.nnb[1] = 0;
        int nxs = 30;
        int nys = 20;
        j = 1;
        while (j <= this.nl) {
            this.nx[j] = 30;
            this.ny[j] = 20;
            i = 1;
            while (i <= 30) {
                this.bx[i][j] = rna[i - 1];
                ++i;
            }
            i = 1;
            while (i <= 20) {
                this.by[i][j] = pna[i - 1];
                ++i;
            }
            this.nbll[j] = (nxs - 1) * (nys - 1);
            nbl += this.nbll[j];
            if (j != 1) {
                k = j - 1;
                this.nnb[j] = this.nnb[k] + this.nbll[k];
            }
            ++j;
        }
        if (ih == 0) {
            j = 1;
            while (j <= nys - 1) {
                i = 1;
                while (i <= nxs - 1) {
                    this.hconrad[i][j] = sc04.nextDouble();
                    ++i;
                }
                sc04.next();
                ++j;
            }
        } else {
            j = 1;
            while (j <= nys - 1) {
                i = 1;
                while (i <= nxs - 1) {
                    this.hconrad[i][j] = this.h[4];
                    ++i;
                }
                ++j;
            }
        }
        if (ih == 0) {
            j = 1;
            while (j <= nys - 1) {
                i = 1;
                while (i <= nxs - 1) {
                    this.hmoho[i][j] = sc04.nextDouble();
                    ++i;
                }
                sc04.next();
                ++j;
            }
        } else {
            j = 1;
            while (j <= nys - 1) {
                i = 1;
                while (i <= nxs - 1) {
                    this.hmoho[i][j] = this.h[this.nl];
                    ++i;
                }
                ++j;
            }
        }
        sc04.close();
        i = 1;
        while (i <= nbl) {
            this.sb[i][1] = sc15.nextDouble();
            ++i;
        }
        i = 1;
        while (i <= nbl) {
            this.sb[i][2] = sc15.nextDouble();
            ++i;
        }
        i = 1;
        while (i <= nbl) {
            this.sb[i][1] = 1.0 / this.sb[i][1];
            this.sb[i][2] = 1.0 / this.sb[i][2];
            ++i;
        }
        this.nobs = 0;
    }

    public void traveltime(double ep1, double ep2, double ep3, double s1, double s2, double s3, String ph, double[] tp) throws IOException {
        double[] dis = new double[1];
        if (this.trace) {
            this.traceOut = new PrintStream(new File(this.tracefn));
        }
        int nxs = 30;
        int nys = 20;
        this.e1 = ep1;
        this.e2 = ep2;
        this.e3 = ep3;
        this.stax[1] = s1;
        this.stax[2] = s2;
        this.stax[3] = s3;
        this.bslow(1);
        double xn = this.stax[1];
        double yn = this.stax[2];
        double zn = this.stax[3];
        double x1 = this.e1;
        double y1 = this.e2;
        double z1 = this.e3;
        int k = 1;
        while (k <= this.nl) {
            if (this.e3 <= this.h[k]) break;
            ++k;
        }
        this.jl = k - 1;
        this.tkj = this.e3 - this.h[this.jl];
        TTTDing.dist(x1, y1, xn, yn, dis);
        double delta = dis[0] * 6371.0;
        if (ph.equals("Pg") || ph.equals("Sg")) {
            this.directPS(x1, y1, z1, xn, yn, zn, delta, tp);
        } else if (ph.equals("Pn") || ph.equals("Sn")) {
            this.headPn(x1, y1, z1, xn, yn, zn, delta, tp);
        } else if (ph.equals("PmP") || ph.equals("SmS")) {
            this.reflect(x1, y1, z1, xn, yn, zn, delta, tp);
        } else if (ph.equals("Pb") || ph.equals("Sb")) {
            this.headP(x1, y1, z1, xn, yn, zn, delta, 4, tp);
        }
        if (this.e1 < this.bx[1][1] || this.e1 > this.bx[nxs][1]) {
            tp[1] = -999.0;
            tp[2] = -999.0;
        }
        if (this.e2 < this.by[1][1] || this.e2 > this.by[nys][1]) {
            tp[1] = -999.0;
            tp[2] = -999.0;
        }
        if (this.trace) {
            this.traceOut.printf("%.4f %.4f\n", tp[1], tp[2]);
            this.traceOut.close();
        }
    }

    public void directPS(double x1, double y1, double z1, double xn, double yn, double zn, double delta, double[] tp) {
        double d1 = 0.0;
        double[] p = new double[21];
        double[] xp = new double[21];
        double[] yp = new double[21];
        int ips = 1;
        while (ips <= 2) {
            int lxy;
            double alfa = 0.7853981633974483;
            double sm = 1.0;
            int i = 1;
            while (i <= this.jl - 1) {
                if (this.s[i][ips] < sm) {
                    sm = this.s[i][ips];
                }
                ++i;
            }
            if (sm < this.s[this.jl][ips]) {
                alfa = 0.5 * Math.asin(sm / this.s[this.jl][ips]);
            }
            double fc = alfa;
            int ite = 0;
            while (true) {
                lxy = 1;
                xp[1] = 0.0;
                yp[1] = this.e3;
                if (this.jl == 1) {
                    p[1] = d1 = (this.e3 - zn) * Math.tan(alfa);
                    xp[++lxy] = d1;
                    yp[lxy] = zn;
                }
                if (this.jl != 1) {
                    double cs;
                    double sn;
                    p[this.jl] = d1 = this.tkj * Math.tan(alfa);
                    xp[++lxy] = d1;
                    yp[lxy] = this.h[this.jl];
                    if (this.jl != 2) {
                        i = this.jl - 1;
                        while (i >= 2) {
                            sn = this.s[this.jl][ips] * Math.sin(alfa) / this.s[i][ips];
                            cs = Math.sqrt(1.0 - sn * sn);
                            p[i] = this.thk[i] * sn / cs;
                            xp[++lxy] = d1 += p[i];
                            yp[lxy] = this.h[i];
                            --i;
                        }
                    }
                    sn = this.s[this.jl][ips] * Math.sin(alfa) / this.s[1][ips];
                    cs = Math.sqrt(1.0 - sn * sn);
                    p[1] = (this.h[2] - zn) * sn / cs;
                    xp[++lxy] = d1 += p[1];
                    yp[lxy] = zn;
                }
                fc /= 2.0;
                if (!(Math.abs(d1 - delta) >= 0.001) || ++ite > 50) break;
                if (d1 - delta < 0.0) {
                    alfa += fc;
                    continue;
                }
                if (!(d1 - delta > 0.0)) break;
                alfa -= fc;
            }
            double z11 = z1;
            double t = 0.0;
            i = 1;
            while (i <= this.jl) {
                int l = this.jl - i + 1;
                double z22 = this.h[l];
                if (l == 1) {
                    z22 = zn;
                }
                double c = p[l] * p[l] + (z22 - z11) * (z22 - z11);
                double tcal = Math.sqrt(c) * this.s[l][ips];
                t += tcal;
                z11 = z22;
                ++i;
            }
            tp[ips] = t;
            if (this.trace) {
                i = 1;
                while (i <= lxy) {
                    this.traceOut.printf(" %10.3f %10.3f\n", xp[i], yp[i]);
                    ++i;
                }
                this.traceOut.println();
            }
            ++ips;
        }
    }

    public void headPn(double x1, double y1, double z1, double xn, double yn, double zn, double delta, double[] tpn) {
        double[] x2 = new double[1];
        double[] y2 = new double[1];
        double[] hea = new double[1];
        double[] hc = new double[1];
        double[] hm = new double[1];
        double[] hst = new double[1];
        double[] xp = new double[51];
        double[] yp = new double[51];
        int ips = 1;
        while (ips <= 2) {
            double tni;
            double csi;
            double dh;
            double sni;
            if (this.jl >= this.nl) {
                tpn[ips] = -999.0;
                return;
            }
            double t = 0.0;
            int lxy = 1;
            xp[1] = 0.0;
            yp[1] = this.e3;
            double hd = 0.0;
            double hd0 = 0.0;
            int i = this.jl;
            while (i <= this.nl - 1) {
                sni = this.s[this.nl][ips] / this.s[i][ips];
                if (Math.abs(sni) >= 1.0) {
                    return;
                }
                dh = this.h[i + 1] - this.h[i];
                if (i == this.jl) {
                    dh = this.thk[i] - this.tkj;
                }
                csi = Math.sqrt(1.0 - sni * sni);
                tni = sni / csi;
                hd0 += dh * tni;
                if (i == this.nl - 1) {
                    TTTDing.zsd(x1, y1, xn, yn, hd0, x2, y2);
                    this.disc(x2[0], y2[0], hea, hc);
                    dh = dh + hea[0] - this.h[this.nl];
                }
                xp[++lxy] = hd += dh * tni;
                yp[lxy] = this.h[i + 1];
                if (i == this.nl - 1) {
                    yp[lxy] = hea[0];
                }
                t += dh * this.s[i][ips] / csi;
                ++i;
            }
            double hd1 = hd;
            hd0 = hd;
            while (!((hd0 += 20.0) > delta - 55.0)) {
                TTTDing.zsd(x1, y1, xn, yn, hd0, x2, y2);
                this.disc(x2[0], y2[0], hm, hc);
                xp[++lxy] = hd += 20.0;
                yp[lxy] = hm[0];
                dh = hm[0] - yp[lxy - 1];
                t += Math.sqrt(dh * dh + 400.0) * this.s[this.nl][ips];
            }
            hd = 0.0;
            hd0 = 0.0;
            xp[lxy += this.nl] = delta;
            yp[lxy] = zn;
            i = 1;
            while (i <= this.nl - 1) {
                double hd2;
                sni = this.s[this.nl][ips] / this.s[i][ips];
                if (Math.abs(sni) >= 1.0) {
                    return;
                }
                csi = Math.sqrt(1.0 - sni * sni);
                tni = sni / csi;
                dh = this.thk[i];
                if (i == 1) {
                    dh = this.thk[1] - zn;
                }
                hd0 += dh * tni;
                if (i == this.nl - 1) {
                    TTTDing.zsd(xn, yn, x1, y1, hd0, x2, y2);
                    this.disc(x2[0], y2[0], hst, hc);
                    dh = dh + hst[0] - this.h[this.nl];
                }
                xp[--lxy] = delta - (hd += dh * tni);
                yp[lxy] = this.h[i + 1];
                if (i == this.nl - 1) {
                    yp[lxy] = hst[0];
                }
                if (hd1 + (hd2 = hd) > delta) {
                    tpn[ips] = -999.0;
                    return;
                }
                t += dh * this.s[i][ips] / csi;
                ++i;
            }
            dh = yp[lxy] - yp[lxy - 1];
            double dx = xp[lxy] - xp[lxy - 1];
            tpn[ips] = t += Math.sqrt(dh * dh + dx * dx) * this.s[this.nl][ips];
            lxy = lxy + this.nl - 1;
            if (this.trace) {
                i = 1;
                while (i <= lxy) {
                    this.traceOut.printf(" %10.3f %10.3f\n", xp[i], yp[i]);
                    ++i;
                }
                this.traceOut.println();
            }
            ++ips;
        }
    }

    public void reflect(double x1, double y1, double z1, double xn, double yn, double zn, double delta, double[] tp11) {
        double d1 = 0.0;
        double[] x2 = new double[1];
        double[] y2 = new double[1];
        double[] dc = new double[1];
        double[] hst = new double[1];
        double[] p = new double[21];
        double[] xp = new double[51];
        double[] yp = new double[51];
        int ips = 1;
        while (ips <= 2) {
            int lxy;
            if (this.e3 > this.h[this.nl]) {
                tp11[ips] = -999.0;
                return;
            }
            double t = 0.0;
            double alfa = 0.7853981633974483;
            double sm = 1.0;
            int i = 1;
            while (i <= this.nl - 1) {
                if (this.s[i][ips] < sm) {
                    sm = this.s[i][ips];
                }
                ++i;
            }
            if (sm < this.s[this.jl][ips]) {
                alfa = 0.5 * Math.asin(sm / this.s[this.jl][ips]);
            }
            double fc = alfa;
            int ite = 0;
            while (true) {
                double thicki;
                double cs;
                double sn;
                t = 0.0;
                d1 = 0.0;
                double d2 = 0.0;
                lxy = 1;
                xp[1] = 0.0;
                yp[1] = this.e3;
                i = this.jl;
                while (i <= this.nl - 1) {
                    sn = this.s[this.jl][ips] * Math.sin(alfa) / this.s[i][ips];
                    cs = Math.sqrt(1.0 - sn * sn);
                    thicki = this.thk[i];
                    d2 += thicki * sn / cs;
                    if (i == this.jl) {
                        thicki -= this.tkj;
                    }
                    if (i == this.nl - 1) {
                        double thickj = thicki;
                        int ii = 1;
                        while (ii <= 5) {
                            TTTDing.zsd(x1, y1, xn, yn, d2, x2, y2);
                            this.disc(x2[0], y2[0], hst, dc);
                            thicki = thickj + hst[0] - this.h[this.nl];
                            d2 = d1 + thicki * sn / cs;
                            ++ii;
                        }
                    }
                    p[i] = thicki * sn / cs;
                    t += Math.sqrt(p[i] * p[i] + thicki * thicki) * this.s[i][ips];
                    xp[++lxy] = d1 += p[i];
                    yp[lxy] = this.h[i + 1];
                    if (i == this.nl - 1) {
                        yp[lxy] = hst[0];
                    }
                    ++i;
                }
                i = this.nl - 1;
                while (i >= 1) {
                    thicki = this.thk[i];
                    if (i == this.nl - 1) {
                        thicki = thicki + hst[0] - this.h[this.nl];
                    }
                    if (i == 1) {
                        thicki = this.h[2] - zn;
                    }
                    sn = this.s[this.jl][ips] * Math.sin(alfa) / this.s[i][ips];
                    cs = Math.sqrt(1.0 - sn * sn);
                    p[i] = thicki * sn / cs;
                    t += Math.sqrt(p[i] * p[i] + thicki * thicki) * this.s[i][ips];
                    xp[++lxy] = d1 += p[i];
                    yp[lxy] = this.h[i];
                    if (i == 1) {
                        yp[lxy] = zn;
                    }
                    --i;
                }
                fc /= 2.0;
                if (!(Math.abs(d1 - delta) >= 0.001) || ++ite > 50) break;
                if (d1 - delta < 0.0) {
                    alfa += fc;
                    continue;
                }
                if (!(d1 - delta > 0.0)) break;
                alfa -= fc;
            }
            tp11[ips] = t;
            if (Math.abs(d1 - delta) > 0.5) {
                tp11[ips] = -999.0;
            }
            if (this.trace) {
                i = 1;
                while (i <= lxy) {
                    this.traceOut.printf(" %10.3f %10.3f\n", xp[i], yp[i]);
                    ++i;
                }
                this.traceOut.println();
            }
            ++ips;
        }
    }

    public void headP(double x1, double y1, double z1, double xn, double yn, double zn, double delta, int ll, double[] tpstar) {
        double[] x2 = new double[1];
        double[] y2 = new double[1];
        double[] dm = new double[1];
        double[] hea = new double[1];
        double[] hst = new double[1];
        double[] xp = new double[51];
        double[] yp = new double[51];
        int ips = 1;
        while (ips <= 2) {
            double tni;
            double csi;
            double dh;
            double sni;
            double t = 0.0;
            double hd = 0.0;
            double hd0 = 0.0;
            if (this.jl >= ll) {
                tpstar[ips] = -999.0;
                return;
            }
            xp[1] = 0.0;
            yp[1] = this.e3;
            int lxy = 1;
            int i = this.jl;
            while (i <= ll - 1) {
                sni = this.s[ll][ips] / this.s[i][ips];
                if (Math.abs(sni) >= 1.0) {
                    return;
                }
                dh = this.h[i + 1] - this.h[i];
                if (i == this.jl) {
                    dh = this.thk[i] - this.tkj;
                }
                csi = Math.sqrt(1.0 - sni * sni);
                tni = sni / csi;
                hd0 += dh * tni;
                if (i == ll - 1) {
                    TTTDing.zsd(x1, y1, xn, yn, hd0, x2, y2);
                    this.disc(x2[0], y2[0], dm, hea);
                    dh = dh + hea[0] - this.h[ll];
                }
                xp[++lxy] = hd += dh * tni;
                yp[lxy] = this.h[i + 1];
                if (i == ll - 1) {
                    yp[lxy] = hea[0];
                }
                t += dh * this.s[i][ips] / csi;
                ++i;
            }
            double hd1 = hd;
            hd0 = hd;
            while (!((hd0 += 20.0) > delta - 50.0)) {
                TTTDing.zsd(x1, y1, xn, yn, hd0, x2, y2);
                this.disc(x2[0], y2[0], dm, hea);
                dh = hea[0] - yp[lxy - 1];
                xp[++lxy] = hd += 20.0;
                yp[lxy] = hea[0];
                t += Math.sqrt(dh * dh + 400.0) * this.s[ll][ips];
            }
            hd = 0.0;
            hd0 = 0.0;
            xp[lxy += ll] = delta;
            yp[lxy] = zn;
            i = 1;
            while (i <= ll - 1) {
                double hd2;
                sni = this.s[ll][ips] / this.s[i][ips];
                if (Math.abs(sni) >= 1.0) {
                    return;
                }
                csi = Math.sqrt(1.0 - sni * sni);
                tni = sni / csi;
                dh = this.thk[i];
                if (i == 1) {
                    dh = this.thk[1] - zn;
                }
                hd0 += dh * tni;
                if (i == ll - 1) {
                    TTTDing.zsd(xn, yn, x1, y1, hd0, x2, y2);
                    this.disc(x2[0], y2[0], dm, hst);
                    dh = dh + hst[0] - this.h[ll];
                }
                xp[--lxy] = delta - (hd += dh * sni / csi);
                yp[lxy] = this.h[i + 1];
                if (i == ll - 1) {
                    yp[lxy] = hst[0];
                }
                if (hd1 + (hd2 = hd) > delta) {
                    tpstar[ips] = -999.0;
                    return;
                }
                t += dh * this.s[i][ips] / csi;
                ++i;
            }
            dh = yp[lxy] - yp[lxy - 1];
            double dx = xp[lxy] - xp[lxy - 1];
            tpstar[ips] = t += Math.sqrt(dh * dh + dx * dx) * this.s[ll][ips];
            lxy = lxy + ll - 1;
            if (this.trace) {
                i = 1;
                while (i <= lxy) {
                    this.traceOut.printf(" %10.3f %10.3f\n", xp[i], yp[i]);
                    ++i;
                }
                this.traceOut.println();
            }
            ++ips;
        }
    }

    public static void zsd(double xon1, double xat1, double xon2, double xat2, double d1, double[] xlon, double[] xlat) {
        double[] dis = new double[1];
        double pi1 = Math.PI / 180;
        TTTDing.dist(xon1, xat1, xon2, xat2, dis);
        double xlon1 = xon1 * pi1;
        double xlat1 = xat1 * pi1;
        double xlon2 = xon2 * pi1;
        double xlat2 = xat2 * pi1;
        double snl = Math.sin(xlon2 - xlon1);
        double snang = Math.cos(xlat2) * snl / Math.sin(dis[0]);
        double d = d1 / 6371.0;
        double csang = Math.sqrt(1.0 - snang * snang);
        if (xlat2 < xlat1) {
            csang = -csang;
        }
        double snf = Math.cos(d) * Math.sin(xlat1) + Math.sin(d) * Math.cos(xlat1) * csang;
        double sndf = snang * Math.sin(d) / Math.sqrt(1.0 - snf * snf);
        xlat[0] = Math.asin(snf) / pi1;
        xlon[0] = (xlon1 + Math.asin(sndf)) / pi1;
    }

    public static void dist(double xon1, double xat1, double xon2, double xat2, double[] distn) {
        double c2;
        double b2;
        double pi1 = 0.017453277777777776;
        double xlat1 = xat1 * pi1;
        double xlon1 = xon1 * pi1;
        double xlat2 = xat2 * pi1;
        double xlon2 = xon2 * pi1;
        double a1 = Math.cos(xlat1) * Math.sin(xlon1);
        double b1 = Math.cos(xlat1) * Math.cos(xlon1);
        double c1 = Math.sin(xlat1);
        double a2 = Math.cos(xlat2) * Math.sin(xlon2);
        double csd = a1 * a2 + b1 * (b2 = Math.cos(xlat2) * Math.cos(xlon2)) + c1 * (c2 = Math.sin(xlat2));
        if (csd > 1.0) {
            csd = 1.0;
        }
        distn[0] = Math.acos(csd);
    }

    public void disc(double x2, double y2, double[] dm, double[] dc) {
        int i1 = 1;
        while (i1 <= this.nx[this.nl]) {
            if (x2 < this.bx[i1][this.nl]) break;
            ++i1;
        }
        int isr = i1;
        i1 = 1;
        while (i1 <= this.ny[this.nl]) {
            if (y2 < this.by[i1][this.nl]) break;
            ++i1;
        }
        int isb = i1;
        int icsr = isr - 1;
        int icsb = isb - 1;
        dm[0] = this.hmoho[icsr][icsb];
        dc[0] = this.hconrad[icsr][icsb];
    }

    public void bslow(int n) {
        double sx = this.stax[1];
        double sy = this.stax[2];
        int nbla = 0;
        int l = 1;
        while (l <= this.nl) {
            int kb;
            int nxs = this.nx[l];
            int nys = this.ny[l];
            int nnbl = this.nnb[l];
            int nbm = nxs - 1;
            int i = 1;
            while (i <= nxs) {
                if (sx < this.bx[i][l]) break;
                ++i;
            }
            int isr = i;
            i = 1;
            while (i <= nys) {
                if (sy < this.by[i][l]) break;
                ++i;
            }
            int isb = i;
            i = 1;
            while (i <= nxs) {
                if (this.e1 < this.bx[i][l]) break;
                ++i;
            }
            int ier = i;
            i = 1;
            while (i <= nys) {
                if (this.e2 < this.by[i][l]) break;
                ++i;
            }
            int ieb = i;
            int nxd = isr - ier;
            int nyd = isb - ieb;
            int nbx = Math.abs(nxd) + 1;
            int nby = Math.abs(nyd) + 1;
            int jr = ier;
            if (nxd < 0) {
                jr = isr;
            }
            int jb = ieb;
            if (nyd < 0) {
                jb = isb;
            }
            int indx = jr - 2;
            int indy = jb - 2;
            int mndx = nxs - 1 - (nbx + indx);
            int nbs = nnbl + nbla + indy * nbm;
            double slop = 0.0;
            double slos = 0.0;
            double blss = 0.0;
            int kt = kb = jb - 1;
            i = 1;
            while (i <= nby) {
                int kr;
                nbs += indx;
                double bys = this.by[++kb][l] - this.by[kt][l];
                kt = kb;
                int kl = kr = jr - 1;
                int j = 1;
                while (j <= nbx) {
                    double bls = (this.bx[++kr][l] - this.bx[kl][l]) * bys;
                    kl = kr;
                    slop += this.sb[++nbs][1] * bls;
                    slos += this.sb[nbs][2] * bls;
                    blss += bls;
                    ++j;
                }
                nbs += mndx;
                ++i;
            }
            this.s[l][1] = slop / blss;
            this.s[l][2] = slos / blss;
            ++l;
        }
    }

    public double calDelta(double depth, double time, int phaseType) {
        return Double.NaN;
    }

    public double calDelta(double depth, double time, String phaseType) {
        return Double.NaN;
    }

    public double calTravelTime(double[] Src, double[] Stn, int phaseType) {
        String pn = null;
        if (phaseType == 3) {
            pn = "Pg";
        } else if (phaseType == 18) {
            pn = "Pb";
        } else if (phaseType == 1) {
            pn = "Pn";
        } else if (phaseType == 15) {
            pn = "PmP";
        } else if (phaseType == 4) {
            pn = "SG";
        } else if (phaseType == 19) {
            pn = "Sb";
        } else if (phaseType == 2) {
            pn = "Sn";
        } else if (phaseType == 16) {
            pn = "SmS";
        }
        if (pn == null) {
            return Double.NaN;
        }
        return this.calTravelTime(Src, Stn, pn);
    }

    public double calTravelTime(double depth, double Delta, int phaseType) {
        return Double.NaN;
    }

    public double calTravelTime(double[] src, double[] stn, String phaseType) {
        int type = -1;
        if (phaseType.equals("Pg")) {
            type = 1;
        } else if (phaseType.equals("PmP")) {
            type = 2;
        } else if (phaseType.equals("Pn")) {
            type = 3;
        } else if (phaseType.equals("Pb")) {
            type = 4;
        } else if (phaseType.equals("Sg")) {
            type = 5;
        } else if (phaseType.equals("SmS")) {
            type = 6;
        } else if (phaseType.equals("Sn")) {
            type = 7;
        } else if (phaseType.equals("Sb")) {
            type = 8;
        }
        if (type == -1) {
            return Double.NaN;
        }
        double[] tp = new double[3];
        if (src[0] < 35.0 || src[0] > 45.0 || src[1] < 108.0 || src[1] > 122.0 || src[2] < -5.0 || src[2] > 600.0) {
            return Double.NaN;
        }
        if (stn[0] < 35.0 || stn[0] > 45.0 || stn[1] < 108.0 || stn[1] > 122.0 || stn[2] < -5.0 || stn[2] > 600.0) {
            return Double.NaN;
        }
        try {
            this.traveltime(src[1], src[0], src[2], stn[1], stn[0], stn[2], phaseType, tp);
        }
        catch (Exception ex) {
            return Double.NaN;
        }
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return tp[1] > 0.0 ? tp[1] : Double.NaN;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return tp[2] > 0.0 ? tp[2] : Double.NaN;
            }
        }
        return Double.NaN;
    }

    public double calTravelTime(double depth, double Delta, String phaseType) {
        return Double.NaN;
    }

    public static void main(String[] args) {
        String[] phs;
        TTTDing ttt = new TTTDing();
        double[] src = new double[]{36.5, 115.0, 15.0};
        double[] stn = new double[]{40.0, 120.0, -3.2};
        String[] stringArray = phs = new String[]{"Pg", "PmP", "Pn", "Pb", "Sg", "SmS", "Sn", "Sb"};
        int n = phs.length;
        int n2 = 0;
        while (n2 < n) {
            String ph = stringArray[n2];
            double tt = ttt.calTravelTime(src, stn, ph);
            System.out.println(String.valueOf(ph) + ", tt = " + tt);
            ++n2;
        }
    }
}

