/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.ttt3d;

import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import cn.org.gddsn.util.PropsUtil;
import com.sun.jna.Native;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class TTTChuanDian
implements ComputedTravelTime {
    static Logger logger = Logger.getLogger(TTTChuanDian.class);
    private static List<String> stnList = new ArrayList<String>(512);
    private static int[] nt = new int[1];
    private static String[] PHASE_NAME = new String[]{"Pg", "Sg", "Pb", "Sb", "Pn", "Sn", "PmP", "SmS", "sPn", "Px", "Sx"};
    private static IOFN iofn = new IOFN();
    private static final File ctr = new File("../lib/chuandian/Loc_3D_sb.inp");

    static {
        if (ctr.exists()) {
            try {
                String libname = PropsUtil.getLibName((String)"loc_3d_sb");
                Native.register((String)libname);
                TTTChuanDian.init();
            }
            catch (UnsatisfiedLinkError ex) {
                logger.warn((Object)ex.getMessage());
            }
        }
    }

    public TTTChuanDian() {
    }

    public TTTChuanDian(EvtData evtData) {
        EvtData.generateChuanDianStationList(evtData);
        TTTChuanDian.init();
    }

    public static void init() {
        if (!ctr.exists()) {
            return;
        }
        TTTChuanDian.inputf_();
        TTTChuanDian.inputs_();
        TTTChuanDian.read_model_();
        TTTChuanDian.inputtg_();
        try {
            String line = null;
            Scanner sc = new Scanner(ctr);
            int n = 0;
            while (sc.hasNextLine()) {
                line = sc.nextLine();
                if (line.startsWith("*")) continue;
                switch (n++) {
                    case 0: {
                        Scanner sc1 = new Scanner(line);
                        TTTChuanDian.iofn.fl = sc1.nextInt();
                        TTTChuanDian.iofn.bs = sc1.nextInt();
                        TTTChuanDian.iofn.jw = sc1.nextInt();
                        TTTChuanDian.iofn.tg = sc1.nextInt();
                        sc1.close();
                        break;
                    }
                    case 1: {
                        TTTChuanDian.iofn.fsta = line;
                        break;
                    }
                    case 2: {
                        TTTChuanDian.iofn.fpha = line;
                        break;
                    }
                    case 3: {
                        TTTChuanDian.iofn.fdis = line;
                        break;
                    }
                    case 4: {
                        TTTChuanDian.iofn.fvp = line;
                        break;
                    }
                    case 5: {
                        TTTChuanDian.iofn.fvs = line;
                        break;
                    }
                    case 6: {
                        TTTChuanDian.iofn.fv1d = line;
                        break;
                    }
                    case 7: {
                        TTTChuanDian.iofn.ftg = line;
                        break;
                    }
                    case 8: {
                        TTTChuanDian.iofn.foutDetail = line;
                        break;
                    }
                    case 9: {
                        TTTChuanDian.iofn.foutSummary = line;
                        break;
                    }
                    case 10: {
                        TTTChuanDian.iofn.foutBootstrap = line;
                    }
                }
            }
            sc.close();
            sc = new Scanner(new File(TTTChuanDian.iofn.fsta));
            int nstn = sc.nextInt();
            TTTChuanDian.nt[0] = sc.nextInt();
            stnList.clear();
            int i = 0;
            while (i < nstn) {
                String stn = sc.next();
                stnList.add(stn);
                sc.nextDouble();
                sc.nextDouble();
                sc.nextDouble();
                sc.next();
                sc.next();
                sc.next();
                ++i;
            }
            sc.close();
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public String findPhase(int idx) {
        if (idx < 1 || idx > PHASE_NAME.length) {
            return null;
        }
        return PHASE_NAME[idx - 1];
    }

    public int findPhaseIndex(String pha) {
        int i = 0;
        while (i < PHASE_NAME.length) {
            if (pha.equals(PHASE_NAME[i])) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    public int findStationIndex(String net, String sta) {
        String ns = String.valueOf(net) + sta;
        int n = Collections.binarySearch(stnList, ns);
        if (n < 0) {
            return -1;
        }
        return n + 1;
    }

    public String findStation(int idx) {
        if (idx < 1 || idx > stnList.size()) {
            return null;
        }
        return stnList.get(idx - 1);
    }

    public static native int inputf_();

    public static native int inputs_();

    public static native int read_model_();

    public static native int inpute_(int[] var0);

    public static native int inputtg_();

    public static native int loceqk_sb_(int[] var0);

    public static native int gettt_(float[] var0, float[] var1, float[] var2, int[] var3, int[] var4, int[] var5, float[] var6, float[] var7, int[] var8, float[] var9);

    public double calTravelTime(double[] src, double[] stn, String phaseType) {
        if (stn[0] < 0.0) {
            return Double.NaN;
        }
        int type = -1;
        if (phaseType.equals("Pg")) {
            type = 1;
        } else if (phaseType.equals("Sg")) {
            type = 2;
        } else if (phaseType.equals("Pb")) {
            type = 3;
        } else if (phaseType.equals("Sb")) {
            type = 4;
        } else if (phaseType.equals("Pn")) {
            type = 5;
        } else if (phaseType.equals("Sn")) {
            type = 6;
        } else if (phaseType.equals("PmP")) {
            type = 7;
        } else if (phaseType.equals("SmS")) {
            type = 8;
        } else if (phaseType.equals("sPn")) {
            type = 9;
        }
        if (type == -1) {
            return Double.NaN;
        }
        if (src[0] < 18.0 || src[0] > 36.0 || src[1] < 90.0 || src[1] > 108.0 || src[2] < -5.0 || src[2] > 300.0) {
            return Double.NaN;
        }
        float pid = (float)Math.PI / 180;
        float[] elat = new float[]{(float)(90.0 - src[0]) * ((float)Math.PI / 180)};
        float[] elon = new float[]{(float)src[1] * ((float)Math.PI / 180)};
        float[] edep = new float[]{(float)src[2]};
        int[] kps = new int[]{type};
        int[] ns = new int[]{(int)stn[0]};
        float[] tt = new float[1];
        float[] dt0 = new float[4];
        int[] kps0 = new int[]{type};
        float[] ve = new float[1];
        try {
            TTTChuanDian.gettt_(elat, elon, edep, kps, ns, nt, tt, dt0, kps0, ve);
        }
        catch (Exception ex) {
            return Double.NaN;
        }
        return tt[0];
    }

    public double calTravelTime(double depth, double Delta, String phaseType) {
        return Double.NaN;
    }

    public double calTravelTime(double[] src, double[] Stn, int phaseType) {
        String pn = null;
        if (phaseType == 3) {
            pn = "Pg";
        } else if (phaseType == 4) {
            pn = "Sg";
        } else if (phaseType == 18) {
            pn = "Pb";
        } else if (phaseType == 19) {
            pn = "Sb";
        } else if (phaseType == 1) {
            pn = "Pn";
        } else if (phaseType == 2) {
            pn = "Sn";
        } else if (phaseType == 15) {
            pn = "PmP";
        } else if (phaseType == 16) {
            pn = "SmS";
        } else if (phaseType == 17) {
            pn = "sPn";
        }
        if (pn == null) {
            return Double.NaN;
        }
        return this.calTravelTime(src, Stn, pn);
    }

    public double calDelta(double depth, double time, int phaseType) {
        return Double.NaN;
    }

    public double calDelta(double depth, double time, String phaseType) {
        return Double.NaN;
    }

    public double calTravelTime(double depth, double Delta, int phaseType) {
        return Double.NaN;
    }

    public String getOutFileName() {
        String name = "res_L" + TTTChuanDian.iofn.fl + "W" + TTTChuanDian.iofn.jw + "G" + TTTChuanDian.iofn.tg + ".out";
        return name;
    }

    public String getPhaseFileName() {
        return TTTChuanDian.iofn.fpha;
    }

    public String getStationFileName() {
        return TTTChuanDian.iofn.fsta;
    }

    public int getTG() {
        return TTTChuanDian.iofn.tg;
    }

    public static void main(String[] args) {
        String[] phs;
        TTTChuanDian ttt = new TTTChuanDian();
        double[] src = new double[]{30.1f, 101.2f, 11.3f};
        double[] stn = new double[]{5.0, 0.0, 0.0};
        String[] stringArray = phs = new String[]{"Pg", "Sg", "Pb", "Sb", "Pn", "Sn", "PmP", "SmS", "sPn"};
        int n = phs.length;
        int n2 = 0;
        while (n2 < n) {
            String ph = stringArray[n2];
            double tt = ttt.calTravelTime(src, stn, ph);
            System.out.println(String.valueOf(ph) + ", tt = " + tt);
            ++n2;
        }
    }

    public static class IOFN {
        public int fl;
        public int bs;
        public int jw;
        public int tg;
        public String fsta;
        public String fpha;
        public String fdis;
        public String fvp;
        public String fvs;
        public String fv1d;
        public String ftg;
        public String foutDetail;
        public String foutSummary;
        public String foutBootstrap;
    }
}

