/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.rts;

import cn.org.gddsn.liss.client.LissClient;
import cn.org.gddsn.liss.client.LissException;
import cn.org.gddsn.liss.port.MiniSeedHeaderFilter;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import cn.org.gddsn.seis.rts.NotifyAction;
import cn.org.gddsn.util.Log4jConfig;
import edu.iris.miniseedutils.steim.GenericCompressMiniSeedRecord;
import edu.iris.miniseedutils.steim.MiniSeedHeader;
import edu.iris.timeutils.TimeStamp;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.springframework.context.support.FileSystemXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event2Server
implements Runnable {
    static Logger logger = Logger.getLogger(Event2Server.class);
    private LissClient lissClient = null;
    private MiniSeedHeaderFilter miniSeedHeaderFilter = null;
    private String eventDirectory;
    private Map<String, String> stationMap = null;
    private BufferedOutputStream socketOutputStream = null;
    private EvtData evtData;
    private String defaultNetworkId = "DZ";
    private boolean orderByTime = true;
    private boolean moveToCurrentTime = false;
    private int maxLength = Integer.MAX_VALUE;
    private NotifyAction notifyAction;
    private Hashtable<ChannelLocator, List<byte[]>> glist = new Hashtable();
    private MiniSeedHeader msh = new MiniSeedHeader();
    private boolean packMode = true;

    @Override
    public void run() {
        try {
            this.processDirectory(new File(this.eventDirectory));
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void connectServer(String[] stnCodes) throws Exception {
        this.lissClient.init();
        String[] stringArray = stnCodes;
        int n = stnCodes.length;
        int n2 = 0;
        while (n2 < n) {
            String ns = stringArray[n2];
            try {
                this.lissClient.addStation(new String[]{ns});
            }
            catch (LissException lissException) {
                // empty catch block
            }
            ++n2;
        }
        this.lissClient.setRtServerPassiveMode(true);
        OutputStream lissOutputStream = this.lissClient.storeRealTimeStream(stnCodes).getOutputStream();
        this.socketOutputStream = new BufferedOutputStream(lissOutputStream);
        if (this.notifyAction != null) {
            this.notifyAction.action();
        }
    }

    private void closeServer() throws Exception {
        this.socketOutputStream.close();
        this.lissClient.quit();
    }

    private void processDirectory(File dir) throws Exception {
        if (dir.isFile()) {
            this.processFile(dir);
            return;
        }
        Object[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        Arrays.sort(files);
        int i = 0;
        while (i < files.length) {
            if (((File)files[i]).isDirectory()) {
                this.processDirectory((File)files[i]);
            } else {
                this.processFile((File)files[i]);
            }
            ++i;
        }
    }

    public void processEvtData() throws Exception {
        int tch = this.evtData.getTCN();
        String[] stnCodes = new String[tch];
        int i = 0;
        while (i < tch) {
            String stn;
            String sta;
            ChannelLocator cl = this.evtData.getChannelLocator(i);
            String net = cl.getNetCode();
            if (net.equals("XX")) {
                net = this.defaultNetworkId;
                logger.info((Object)("rename networkID to default: " + this.defaultNetworkId));
            }
            if ((sta = cl.getStationCode()).startsWith("N.")) {
                sta = sta.substring(2);
            }
            if ((stn = this.stationMap.get(sta)) != null) {
                stnCodes[i] = String.valueOf(net) + "/" + stn;
                logger.info((Object)("rename " + sta + " to " + stn));
            } else {
                stnCodes[i] = String.valueOf(net) + "/" + sta;
            }
            ++i;
        }
        if (this.moveToCurrentTime) {
            this.orderByTime = true;
            long startTime = this.evtData.getArrivalTime(0).getTime();
            this.miniSeedHeaderFilter.setMoveToCurrentTime(true, startTime);
        }
        if (this.orderByTime) {
            logger.info((Object)"Processing time series...");
            int maxSize = -1;
            int i2 = 0;
            while (i2 < tch) {
                int size = this.processTimeSeries(this.evtData.getTimeSeries(i2), stnCodes[i2]);
                if (size > maxSize) {
                    maxSize = size;
                }
                ++i2;
            }
            logger.info((Object)"Processed all time series");
            logger.info((Object)"sort waveform by time.");
            this.connectServer(stnCodes);
            logger.info((Object)"connected SSS");
            long baseTime = System.currentTimeMillis() - this.evtData.getArrivalTime(0).getTime();
            if (this.moveToCurrentTime) {
                baseTime = 0L;
            }
            boolean hasData = true;
            boolean busy = true;
            while (hasData) {
                hasData = false;
                if (!busy) {
                    Thread.sleep(100L);
                }
                busy = false;
                Collection<List<byte[]>> c = this.glist.values();
                for (List<byte[]> list : c) {
                    if (list.size() <= 0) continue;
                    hasData = true;
                    byte[] mbuf = list.get(0);
                    this.msh.setHead(mbuf);
                    long now = System.currentTimeMillis();
                    if (!(this.msh.getEndTime() * 1000.0 + (double)baseTime < (double)now)) continue;
                    this.socketOutputStream.write(mbuf);
                    list.remove(0);
                    busy = true;
                }
            }
            logger.info((Object)"sent waveform to SSS");
        } else {
            this.connectServer(stnCodes);
            logger.info((Object)"connected SSS");
            i = 0;
            while (i < tch) {
                this.processTimeSeries(this.evtData.getTimeSeries(i), stnCodes[i]);
                ++i;
            }
            logger.info((Object)"sent waveform to SSS");
        }
        this.closeServer();
        logger.info((Object)"closed SSS");
    }

    private void processFile(File evtFile) throws Exception {
        logger.info((Object)("Processing " + evtFile));
        try {
            this.evtData = EvtData.readEvtData(evtFile.getPath());
        }
        catch (Exception ex) {
            logger.info((Object)ex.getMessage(), (Throwable)ex);
        }
        if (this.evtData != null) {
            this.processEvtData();
        } else {
            logger.warn((Object)("could not process " + evtFile));
        }
    }

    private int processTimeSeries(TimeSeries ts, String netStation) throws IOException {
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        this.glist.put(ts.getChannelLocator(), list);
        short steimLevel = 2;
        short dframes = 7;
        GenericCompressMiniSeedRecord cmsr = new GenericCompressMiniSeedRecord(steimLevel, dframes);
        cmsr.setStartTime(new TimeStamp(ts.getArrivalTime().getTime()));
        cmsr.setSampleRate((double)((int)ts.getSampleRate()));
        int idx = netStation.indexOf(47);
        cmsr.setStationInfo(netStation.substring(0, idx), netStation.substring(idx + 1), ts.getAuxId(), ts.getChannelCode());
        cmsr.setActivityFlag(0);
        cmsr.setCaliFlag(0);
        double[] sdata = ts.getSampData();
        int srate = (int)ts.getSampleRate();
        int nsamps = sdata.length;
        if (this.maxLength > 0) {
            nsamps = Math.min(srate * this.maxLength, sdata.length);
        }
        int[] buf = new int[nsamps];
        int j = 0;
        while (j < buf.length) {
            buf[j] = (int)sdata[j];
            ++j;
        }
        if (this.packMode) {
            int nSamps = cmsr.encodeMiniSeedRecord(buf, buf.length);
            if (nSamps != buf.length) {
                logger.warn((Object)"Error in compressing data");
            }
            Vector vec = cmsr.getComressFrame();
            Enumeration Enum2 = vec.elements();
            while (Enum2.hasMoreElements()) {
                byte[] msBytes = (byte[])Enum2.nextElement();
                if (this.orderByTime) {
                    list.add(this.filtMiniSeedHead(msBytes));
                    continue;
                }
                this.socketOutputStream.write(this.filtMiniSeedHead(msBytes));
            }
        } else {
            int[] samps = new int[srate];
            int n = buf.length / srate;
            int i = 0;
            while (i < n) {
                cmsr.setStartTime(new TimeStamp(ts.getArrivalTime().getTime() + (long)(i * 1000)));
                int j2 = 0;
                while (j2 < srate) {
                    samps[j2] = buf[i * srate + j2];
                    ++j2;
                }
                int nSamps = cmsr.encodeMiniSeedRecord(samps, srate);
                if (nSamps != srate) {
                    logger.warn((Object)"Error in compressing data");
                }
                Vector vec = cmsr.getComressFrame();
                Enumeration Enum3 = vec.elements();
                while (Enum3.hasMoreElements()) {
                    byte[] msBytes = (byte[])Enum3.nextElement();
                    if (this.orderByTime) {
                        list.add(this.filtMiniSeedHead(msBytes));
                        continue;
                    }
                    this.socketOutputStream.write(this.filtMiniSeedHead(msBytes));
                }
                ++i;
            }
        }
        return list.size();
    }

    private byte[] filtMiniSeedHead(byte[] buf) {
        if (this.miniSeedHeaderFilter == null) {
            return buf;
        }
        return this.miniSeedHeaderFilter.filter(buf);
    }

    public String getEventDirectory() {
        return this.eventDirectory;
    }

    public void setEventDirectory(String eventDirectory) {
        this.eventDirectory = eventDirectory;
    }

    public LissClient getLissClient() {
        return this.lissClient;
    }

    public void setLissClient(LissClient lissClient) {
        this.lissClient = lissClient;
    }

    public void setMiniSeedHeaderFilter(MiniSeedHeaderFilter miniSeedHeaderFilter) {
        this.miniSeedHeaderFilter = miniSeedHeaderFilter;
    }

    public static void main(String[] args) throws IOException {
        Log4jConfig.loadForMain((String)"Event2Server.properties");
        FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext(new String[]{"Event2Server.xml"});
        Event2Server event2Server = (Event2Server)ctx.getBean("event2Server");
        event2Server.run();
    }

    public String getDefaultNetworkId() {
        return this.defaultNetworkId;
    }

    public void setDefaultNetworkId(String defaultNetworkId) {
        this.defaultNetworkId = defaultNetworkId;
    }

    public Map<String, String> getStationMap() {
        return this.stationMap;
    }

    public void setStationMap(Map<String, String> stationMap) {
        this.stationMap = stationMap;
    }

    public boolean isOrderByTime() {
        return this.orderByTime;
    }

    public void setOrderByTime(boolean orderByTime) {
        this.orderByTime = orderByTime;
    }

    public void setEvtData(EvtData evtData) {
        this.evtData = evtData;
    }

    public NotifyAction getNotifyAction() {
        return this.notifyAction;
    }

    public void setNotifyAction(NotifyAction notifyAction) {
        this.notifyAction = notifyAction;
    }

    public boolean getPackModel() {
        return this.packMode;
    }

    public void setPackModel(boolean packModel) {
        this.packMode = packModel;
    }

    public void setMoveToCurrentTime(boolean moveToCurrentTime) {
        this.moveToCurrentTime = moveToCurrentTime;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }
}

