/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.rts;

import cn.org.gddsn.liss.client.LissClient;
import cn.org.gddsn.liss.client.LissException;
import cn.org.gddsn.liss.port.MiniSeedHeaderFilter;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import cn.org.gddsn.seis.evtformat.seed.SeedVolume;
import cn.org.gddsn.util.Log4jConfig;
import edu.iris.miniseedutils.steim.GenericCompressMiniSeedRecord;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import edu.iris.timeutils.TimeStamp;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database2Server
implements Runnable {
    static Logger logger = Logger.getLogger(Database2Server.class);
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static ApplicationContext ctx;
    private Map stationMap = null;
    private BufferedOutputStream socketOutputStream = null;
    private SeedVolume seedVolume;
    private String defaultNetworkId = "DZ";
    private String startTime;
    private String endTime;
    private String catalogCause;
    private MiniSeedHeaderFilter miniSeedHeaderFilter = null;
    private LissClient lissClient = null;

    @Override
    public void run() {
        try {
            if (this.endTime == null) {
                this.processFile(this.catalogCause, null);
            } else {
                this.processFile(this.startTime, this.endTime);
            }
        }
        catch (LissException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
        }
        catch (ParseException paEx) {
            logger.warn((Object)paEx.getMessage(), (Throwable)paEx);
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void setLissClient(LissClient lissClient) {
        this.lissClient = lissClient;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setCatalogCause(String catalogCause) {
        this.catalogCause = catalogCause;
    }

    public void setMiniSeedHeaderFilter(MiniSeedHeaderFilter miniSeedHeaderFilter) {
        this.miniSeedHeaderFilter = miniSeedHeaderFilter;
    }

    private void processFile(String arg1, String arg2) throws Exception {
        boolean success = false;
        try {
            if (arg2 != null) {
                Date beg = SDF.parse(arg1);
                Date end = SDF.parse(arg2);
                this.seedVolume.getSeedVolumePlugin().setSource(new Date(beg.getTime() - 30000L), end);
                this.seedVolume.setUniTime(true);
                this.seedVolume.setTimeSpan(beg, end);
                success = this.seedVolume.readEvtFile("");
            } else {
                this.seedVolume.cleanTimeSpan();
                this.seedVolume.getSeedVolumePlugin().setSource(arg1, null);
                this.seedVolume.setUniTime(true);
                success = this.seedVolume.readEvtFile("");
            }
        }
        catch (Exception ex) {
            logger.info((Object)ex.getMessage(), (Throwable)ex);
        }
        if (success) {
            int tch = this.seedVolume.getTCN();
            String[] stnCodes = new String[tch];
            int i = 0;
            while (i < tch) {
                ChannelLocator cl = this.seedVolume.getChannelLocator(i);
                String net = cl.getNetCode();
                if (net.equals("XX")) {
                    net = this.defaultNetworkId;
                    logger.info((Object)("rename networkID to default: " + this.defaultNetworkId));
                }
                if (this.stationMap != null && this.stationMap.get(cl.getStationCode()) != null) {
                    String stn = (String)this.stationMap.get(cl.getStationCode());
                    stnCodes[i] = String.valueOf(net) + "/" + stn;
                    logger.info((Object)("rename " + cl.getStationCode() + " to " + stn));
                } else {
                    stnCodes[i] = String.valueOf(net) + "/" + cl.getStationCode();
                }
                ++i;
            }
            LinkedList<GenericMiniSeedRecord> mainList = new LinkedList<GenericMiniSeedRecord>();
            int i2 = 0;
            while (i2 < tch) {
                List<GenericMiniSeedRecord> list = this.processTimeSeries(this.seedVolume.getTimeSeries(i2), stnCodes[i2]);
                mainList.addAll(list);
                ++i2;
            }
            logger.info((Object)"sorting MiniSeed packet...");
            Collections.sort(mainList);
            this.connectServer(stnCodes);
            logger.info((Object)"sending MiniSeed packet...");
            for (GenericMiniSeedRecord g : mainList) {
                this.socketOutputStream.write(this.filtMiniSeedHead(g.getBytes()));
            }
            this.closeServer();
        } else {
            logger.warn((Object)("could not process " + arg1));
        }
    }

    private List<GenericMiniSeedRecord> processTimeSeries(TimeSeries ts, String netStation) throws IOException {
        short steimLevel = 2;
        short dframes = 7;
        GenericCompressMiniSeedRecord cmsr = new GenericCompressMiniSeedRecord(steimLevel, dframes);
        cmsr.setStartTime(new TimeStamp(ts.getArrivalTime().getTime()));
        cmsr.setSampleRate((double)((int)ts.getSampleRate()));
        logger.info((Object)("process channel: " + ts.getChannelLocator()));
        int idx = netStation.indexOf(47);
        cmsr.setStationInfo(netStation.substring(0, idx), netStation.substring(idx + 1), ts.getAuxId(), ts.getChannelCode());
        cmsr.setActivityFlag(0);
        double[] sdata = ts.getSampData();
        int[] buf = new int[sdata.length];
        int j = 0;
        while (j < buf.length) {
            buf[j] = (int)sdata[j];
            ++j;
        }
        int nSamps = cmsr.encodeMiniSeedRecord(buf, buf.length);
        if (nSamps != buf.length) {
            logger.warn((Object)"Error in handle gaps data");
        }
        LinkedList<GenericMiniSeedRecord> list = new LinkedList<GenericMiniSeedRecord>();
        Vector vec = cmsr.getComressFrame();
        Enumeration Enum2 = vec.elements();
        while (Enum2.hasMoreElements()) {
            byte[] msBytes = (byte[])Enum2.nextElement();
            list.add(GenericMiniSeedRecord.buildMiniSeedRecord((byte[])msBytes));
        }
        return list;
    }

    private void connectServer(String[] stnCodes) throws Exception {
        this.lissClient.init();
        this.lissClient.setRtServerPassiveMode(true);
        OutputStream lissOutputStream = null;
        lissOutputStream = this.lissClient.storeRealTimeStream(stnCodes).getOutputStream();
        this.socketOutputStream = new BufferedOutputStream(lissOutputStream);
    }

    private void closeServer() throws Exception {
        this.socketOutputStream.close();
        this.lissClient.quit();
    }

    private byte[] filtMiniSeedHead(byte[] buf) {
        return this.miniSeedHeaderFilter.filter(buf);
    }

    public MiniSeedHeaderFilter getMiniSeedHeaderFilter() {
        return this.miniSeedHeaderFilter;
    }

    public SeedVolume getSeedVolume() {
        return this.seedVolume;
    }

    public void setSeedVolume(SeedVolume seedVolume) {
        this.seedVolume = seedVolume;
    }

    public static void main(String[] args) throws IOException {
        Log4jConfig.loadForMain((String)"Database2Server.properties");
        ctx = new FileSystemXmlApplicationContext(new String[]{"Database2Server.xml", "jopens.xml"});
        Database2Server database2Server = (Database2Server)ctx.getBean("database2Server");
        database2Server.run();
    }
}

