/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.rts;

import cn.org.gddsn.convert.SphereUtil;
import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.EventInfo;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.jopens.service.ArchiveWaveServerPlugin;
import cn.org.gddsn.jopens.service.EventExportPlugin;
import cn.org.gddsn.jopens.service.SeedExportPlugin;
import cn.org.gddsn.jopens.service.SeedExporterUtil;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import cn.org.gddsn.seis.AbstractCatalogFilter;
import cn.org.gddsn.util.Log4jConfig;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.regexp.RE;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class AutoExportSeedVolume
extends AbstractCatalogFilter
implements Runnable {
    static Logger logger = Logger.getLogger(AutoExportSeedVolume.class);
    public static ApplicationContext ctx;
    private int hourOfDay = 8;
    private int moh = 3;
    private String exportPath;
    private SeedVolumeService seedVolumeService;
    private ArchiveWaveServerPlugin awsPlugin;
    private String netRegexp = ".*";
    private String stationRegexp = ".*";
    private String excludeRegexp;
    private double delta = 180.0;
    private int preSecond = 60;

    public void run() {
        while (true) {
            Date now = new Date();
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(now);
            int hod = c.get(11);
            int amoh = c.get(12);
            long ms = now.getTime() / 86400000L * 86400000L;
            if (hod == this.hourOfDay && this.moh == amoh) {
                this.export(new Date(ms - 86400000L));
            }
            try {
                Thread.sleep(40000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void exportEventByCatalog(Catalog c, int length) {
        Date otime = c.getFullOriginTime();
        String fn = String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS", otime);
        logger.info((Object)("Exporting " + fn));
        File exFile = new File(this.exportPath, String.valueOf(fn) + ".seed");
        this.seedVolumeExport(this.seedVolumeService, c, exFile.getAbsolutePath(), new Date(otime.getTime() - (long)(this.preSecond * 1000)), new Date(otime.getTime() + (long)(length * 1000)));
    }

    public void exportTimespanEvent(Date begDate, int length) {
        String fn = String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS", begDate);
        logger.info((Object)("Exporting " + fn));
        File exFile = new File(this.exportPath, String.valueOf(fn) + ".seed");
        this.seedVolumeExport(this.seedVolumeService, null, exFile.getAbsolutePath(), begDate, new Date(begDate.getTime() + (long)(length * 1000)));
    }

    private void export(Date begDate) {
        Date endDate = new Date(begDate.getTime() + 86400000L);
        List evtList = this.seedVolumeService.findEventInfoList(begDate, endDate);
        logger.info((Object)"Export beginning...");
        for (EventInfo ei : evtList) {
            String eid = ei.getEventId();
            List cs = this.seedVolumeService.findCatalogByEventId(eid);
            if (cs.size() == 0 || !this.feed((Catalog)cs.get(0))) continue;
            logger.info((Object)("Exporting " + eid));
            File exFile = new File(this.exportPath, String.valueOf(eid) + ".seed");
            this.seedVolumeExport(this.seedVolumeService, (Catalog)cs.get(0), exFile.getAbsolutePath(), ei.getStartTime(), ei.getEndTime());
        }
        logger.info((Object)"Export operation finised.");
    }

    private boolean seedVolumeExport(SeedVolumeService exportService, Catalog c, String exportFileName, Date startTime, Date endTime) {
        SeedExporterUtil util = new SeedExporterUtil();
        EventExportPlugin seedExportPlugin = new EventExportPlugin();
        seedExportPlugin.setStationService(exportService);
        seedExportPlugin.setWaveformService(exportService);
        seedExportPlugin.setAwsPlugin(this.awsPlugin);
        util.setSeedExportPlugin((SeedExportPlugin)seedExportPlugin);
        Dataless dl = exportService.findDefaultDataless();
        seedExportPlugin.setDataless(dl);
        util.setStartTime(startTime);
        util.setEndTime(endTime);
        util.setFile(new File(exportFileName));
        Vector<String> netVec = new Vector<String>();
        Vector<String> stationVec = new Vector<String>();
        RE reNet = new RE(this.netRegexp);
        RE reStation = new RE(this.stationRegexp);
        RE reExclude = this.excludeRegexp == null ? null : new RE(this.excludeRegexp);
        for (Station s : dl.getSeedConfig().getStation()) {
            boolean found;
            double slon;
            double slat;
            double clon;
            double clat;
            double del;
            if (reExclude != null && reExclude.match(new String(String.valueOf(s.getBlockette050().getNetworkCode()) + "." + s.getBlockette050().getStation())) || c != null && (double)c.getLat() > -90.0 && (del = SphereUtil.distOnSphere((double)(clat = (double)c.getLat()), (double)(clon = (double)c.getLon()), (double)(slat = s.getBlockette050().getLatitude()), (double)(slon = s.getBlockette050().getLongitude()))) > this.delta) continue;
            boolean bl = found = reNet.match(s.getBlockette050().getNetworkCode()) && reStation.match(s.getBlockette050().getStation());
            if (!found) continue;
            netVec.add(s.getBlockette050().getNetworkCode());
            stationVec.add(s.getBlockette050().getStation());
        }
        String[] net = new String[netVec.size()];
        String[] station = new String[net.length];
        netVec.toArray(net);
        stationVec.toArray(station);
        util.setNetStation(net, station);
        try {
            util.export();
        }
        catch (IOException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        logger.info((Object)("Exported seed volume data into " + util.getFile()));
        return true;
    }

    boolean seedVolumeExport(SeedVolumeService exportService, String exportFileName, String eventId) {
        SeedExporterUtil util = new SeedExporterUtil();
        EventExportPlugin seedExportPlugin = new EventExportPlugin();
        seedExportPlugin.setStationService(exportService);
        seedExportPlugin.setWaveformService(exportService);
        seedExportPlugin.setAwsPlugin(this.awsPlugin);
        util.setSeedExportPlugin((SeedExportPlugin)seedExportPlugin);
        Dataless dl = exportService.findDatalessByEventId(eventId);
        seedExportPlugin.setDataless(dl);
        util.setEventId(eventId);
        util.setFile(new File(exportFileName));
        util.setNetStationRegexp(this.netRegexp, this.stationRegexp);
        try {
            util.export();
        }
        catch (IOException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        logger.info((Object)("Exported seed volume data into " + util.getFile()));
        return true;
    }

    public String getExportPath() {
        return this.exportPath;
    }

    public void setExportPath(String exportPath) {
        this.exportPath = exportPath;
    }

    public int getHourOfDay() {
        return this.hourOfDay;
    }

    public void setHourOfDay(int hourOfDay) {
        this.hourOfDay = hourOfDay;
    }

    public int getMoh() {
        return this.moh;
    }

    public void setMoh(int moh) {
        this.moh = moh;
    }

    public String getNetRegexp() {
        return this.netRegexp;
    }

    public void setNetRegexp(String netRegexp) {
        this.netRegexp = netRegexp;
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    public SeedVolumeService getSeedVolumeService() {
        return this.seedVolumeService;
    }

    public void setSeedVolumeService(SeedVolumeService seedVolumeService) {
        this.seedVolumeService = seedVolumeService;
    }

    public ArchiveWaveServerPlugin getAwsPlugin() {
        return this.awsPlugin;
    }

    public void setAwsPlugin(ArchiveWaveServerPlugin awsPlugin) {
        this.awsPlugin = awsPlugin;
    }

    public String getStationRegexp() {
        return this.stationRegexp;
    }

    public void setStationRegexp(String stationRegexp) {
        this.stationRegexp = stationRegexp;
    }

    private static void usage() {
        System.out.println("Usage: java AutoExportSeedVolume -ts \"yyyy-MM-dd HH:mm:ss\" nsec");
        System.out.println("       java AutoExportSeedVolume -catalog \"yyyy-MM-dd HH:mm:ss\" lat lon depth mag nsec");
        System.out.println("       java AutoExportSeedVolume -batch \"yyyy-MM-dd HH:mm:ss\" nday");
        System.out.println("       java AutoExportSeedVolume -help");
        System.out.println("       java AutoExportSeedVolume");
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain((String)"AutoExportSeedVolume.properties");
        ctx = new FileSystemXmlApplicationContext(new String[]{"AutoExportSeedVolume.xml"});
        AutoExportSeedVolume aesv = (AutoExportSeedVolume)ctx.getBean("aesv");
        if (args.length == 0) {
            System.out.println("Run AutoExportSeedVolume in daemon mode...");
            Thread thr = new Thread(aesv);
            thr.start();
        } else if (args[0].equals("-help")) {
            AutoExportSeedVolume.usage();
            System.exit(-1);
        } else {
            Date beg = null;
            int mode = -1;
            int n = 0;
            if (args[n].equals("-ts")) {
                mode = 0;
            } else if (args[n].equals("-catalog")) {
                mode = 1;
            } else if (args[n].equals("-batch")) {
                mode = 2;
            }
            ++n;
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                beg = sdf.parse(args[n++]);
            }
            catch (Exception ex) {
                AutoExportSeedVolume.usage();
                System.exit(-1);
            }
            if (mode == 0) {
                int nsec = Integer.parseInt(args[n]);
                aesv.exportTimespanEvent(beg, nsec);
            } else if (mode == 1) {
                Catalog c = new Catalog();
                c.setFullOriginTime(beg);
                c.setLat(Float.parseFloat(args[n++]));
                c.setLon(Float.parseFloat(args[n++]));
                c.setDepth(Float.parseFloat(args[n++]));
                c.setM(Float.parseFloat(args[n++]));
                int nsec = Integer.parseInt(args[n]);
                aesv.exportEventByCatalog(c, nsec);
            } else {
                int nday = 1;
                if (args.length > 1) {
                    nday = Integer.parseInt(args[n]);
                }
                int i = 0;
                while (i < nday) {
                    aesv.export(new Date(beg.getTime() + (long)(i * 24 * 3600) * 1000L));
                    ++i;
                }
            }
        }
    }
}

