/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.regions.geotools;

import cn.org.gddsn.convert.SphereUtil;
import cn.org.gddsn.seis.regions.RegionsFE;
import cn.org.gddsn.seis.regions.geotools.DataResource;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoRegion {
    static Logger logger = Logger.getLogger(GeoRegion.class);
    private static List<SimBox> simBoxList = new ArrayList<SimBox>();
    private static Hashtable<String, Geometry> allTbl = new Hashtable();
    private static Hashtable<String, Geometry> ht = new Hashtable();
    private static boolean isZh = Locale.getDefault().getLanguage().equals("zh");
    private static boolean loadAll2HashTable = false;
    private static final String markedStr = "m";
    private static final String dunhao = "\u3001";
    private static final String endStr = "\u4ea4\u754c";

    static {
        String v = System.getProperty("GeoRegion.loadAll");
        if (v != null && v.equalsIgnoreCase("true")) {
            loadAll2HashTable = true;
            logger.debug((Object)"In GeoRegion, loadAll2HashTable = true");
        }
        logger.debug((Object)("isZh ? " + isZh));
        if (isZh) {
            logger.debug((Object)("isZh ? " + isZh + " so loadShpFile"));
            GeoRegion.loadShpFile();
        }
    }

    private static void loadShpFile() {
        long now_ms = System.currentTimeMillis();
        String valiFullName = null;
        try {
            logger.info((Object)DataResource.COUNTY_SHP);
            ShapefileDataStore shpDataStore = new ShapefileDataStore(DataResource.toURL(DataResource.COUNTY_SHP));
            SimpleFeatureSource fs = shpDataStore.getFeatureSource();
            FeatureCollection features = fs.getFeatures();
            logger.debug((Object)("Filter county feature size=" + features.size()));
            FeatureIterator iterator = features.features();
            simBoxList = new ArrayList<SimBox>();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                String nameTmp = (String)feature.getAttribute(4);
                String fullName = new String(nameTmp.getBytes("ISO8859-1"), "GBK");
                nameTmp = (String)feature.getAttribute(2);
                String className3 = new String(nameTmp.getBytes("ISO8859-1"), "GBK");
                nameTmp = (String)feature.getAttribute(6);
                String className1 = new String(nameTmp.getBytes("ISO8859-1"), "GBK");
                nameTmp = (String)feature.getAttribute(5);
                String className2 = new String(nameTmp.getBytes("ISO8859-1"), "GBK");
                SimBox sb = new SimBox();
                String objId = feature.getID();
                sb.setID(objId);
                sb.setFullName(fullName);
                sb.setClassName1(className1);
                sb.setClassName2(className2);
                sb.setClassName3(className3);
                sb.setBbx((Envelope)feature.getBounds());
                Envelope e = new Envelope(sb.getBbx());
                e.expandBy(0.08993614533681087);
                sb.setEnlargedBbx(e);
                if (loadAll2HashTable) {
                    allTbl.put(objId, (Geometry)feature.getDefaultGeometry());
                }
                simBoxList.add(sb);
            }
        }
        catch (NullPointerException ex) {
            logger.debug((Object)("exception   valiFullName=" + valiFullName));
            ex.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.info((Object)("Load shpfile time: " + (System.currentTimeMillis() - now_ms) + "ms"));
    }

    public static String getPointName(double lat, double lon) {
        Point ptG;
        String geoName = null;
        ArrayList<SimBox> sbList = new ArrayList<SimBox>();
        int i = 0;
        while (i < simBoxList.size()) {
            SimBox sb = simBoxList.get(i);
            if (sb.getBbx().contains(lon, lat)) {
                sbList.add(sb);
            }
            ++i;
        }
        if (sbList.size() == 0) {
            return isZh ? RegionsFE.getFeGeoRegionChineseName(lat, lon) : RegionsFE.getRegionName(lat, lon);
        }
        GeoRegion.loadSelectedGeometry(sbList);
        Coordinate ptc = new Coordinate(lon, lat);
        GeometryFactory geomFac = new GeometryFactory();
        Point g_point = ptG = geomFac.createPoint(ptc);
        int j = 0;
        while (j < sbList.size()) {
            SimBox sb = (SimBox)sbList.get(j);
            Geometry g_polygon = ht.get(sb.getID());
            if (g_point.within(g_polygon)) {
                geoName = sb.getFullName();
                break;
            }
            ++j;
        }
        if (geoName == null) {
            return isZh ? RegionsFE.getFeGeoRegionChineseName(lat, lon) : RegionsFE.getRegionName(lat, lon);
        }
        return geoName;
    }

    public static String getBianMuName(double lat, double lon) {
        Point ptG;
        String geoName = null;
        ArrayList<SimBox> sbList = new ArrayList<SimBox>();
        int i = 0;
        while (i < simBoxList.size()) {
            SimBox sb = simBoxList.get(i);
            if (sb.getBbx().contains(lon, lat)) {
                sbList.add(sb);
            }
            ++i;
        }
        if (sbList.size() == 0) {
            return isZh ? RegionsFE.getFeGeoRegionChineseName(lat, lon) : RegionsFE.getRegionName(lat, lon);
        }
        GeoRegion.loadSelectedGeometry(sbList);
        Coordinate ptc = new Coordinate(lon, lat);
        GeometryFactory geomFac = new GeometryFactory();
        Point g_point = ptG = geomFac.createPoint(ptc);
        int j = 0;
        while (j < sbList.size()) {
            SimBox sb = (SimBox)sbList.get(j);
            Geometry g_polygon = ht.get(sb.getID());
            if (g_point.within(g_polygon)) {
                geoName = GeoRegion.assembleBianMuName(sb);
                break;
            }
            ++j;
        }
        if (geoName == null) {
            return isZh ? RegionsFE.getFeGeoRegionChineseName(lat, lon) : RegionsFE.getRegionName(lat, lon);
        }
        return geoName;
    }

    private static String assembleBianMuName(SimBox sb) {
        int len = sb.getClassName1().length();
        String geoName = sb.getClassName1();
        if (geoName.indexOf("\u7701") >= 0) {
            geoName = sb.getClassName1().substring(0, len - 1);
        }
        String className2 = sb.getClassName2();
        String className3 = sb.getClassName3();
        int seaIdx = className3.indexOf("\u9644\u8fd1\u6d77\u57df");
        if (seaIdx > 0) {
            className3 = className3.replace("\u9644\u8fd1\u6d77\u57df", "");
        }
        if (className3.indexOf("\u81ea\u6cbb\u53bf") >= 0) {
            geoName = String.valueOf(geoName) + className3;
        } else if (className3.indexOf("\u5e02") >= 0) {
            len = className3.length();
            geoName = String.valueOf(geoName) + className3.substring(0, len - 1);
        } else if (className3.indexOf("\u533a") >= 0) {
            len = className3.length();
            geoName = String.valueOf(geoName) + className3.substring(0, len - 1);
        } else if (className3.indexOf("\u81ea\u6cbb\u53bf") < 0 && className3.indexOf("\u53bf") >= 0) {
            len = className3.length();
            geoName = String.valueOf(geoName) + className3.substring(0, len - 1);
        } else if (className3.length() == 0 && className2.length() != 0 && className2.indexOf("\u5e02") >= 0) {
            len = className2.length();
            geoName = String.valueOf(geoName) + className2.substring(0, len - 1);
        }
        if (seaIdx > 0) {
            geoName = String.valueOf(geoName) + "\u6d77\u57df";
        }
        return geoName;
    }

    public static String getSuBaoName(double lat, double lon) {
        Point ptG;
        String geoName = null;
        ArrayList<SimBox> sbList = new ArrayList<SimBox>();
        int i = 0;
        while (i < simBoxList.size()) {
            SimBox sb = simBoxList.get(i);
            if (sb.getEnlargedBbx().contains(lon, lat)) {
                sbList.add(sb);
            }
            ++i;
        }
        if (sbList.size() == 0) {
            return isZh ? RegionsFE.getFeGeoRegionChineseName(lat, lon) : RegionsFE.getRegionName(lat, lon);
        }
        GeoRegion.loadSelectedGeometry(sbList);
        ArrayList<NameDist> ndList = new ArrayList<NameDist>();
        Coordinate ptc = new Coordinate(lon, lat);
        GeometryFactory geomFac = new GeometryFactory();
        Point g_point = ptG = geomFac.createPoint(ptc);
        try {
            int j = 0;
            while (j < sbList.size()) {
                SimBox sb = (SimBox)sbList.get(j);
                Geometry g_polygon = ht.get(sb.getID());
                if (g_polygon == null) {
                    logger.debug((Object)(String.valueOf(sb.getID()) + " is null"));
                }
                if (g_point.within(g_polygon)) {
                    ndList.add(new NameDist(sb, -1.0f));
                } else {
                    float dist = GeoRegion.distance(g_point, (MultiPolygon)g_polygon);
                    if ((double)dist <= 0.08993614533681087) {
                        ndList.add(new NameDist(sb, (float)Math.round((double)dist * 111.19 * 10.0) / 10.0f));
                    }
                }
                ++j;
            }
            if (ndList.size() > 0) {
                Collections.sort(ndList, Comparators.byfullName());
                logger.debug((Object)("step1: raw filter, size: " + ndList.size()));
                int i2 = 0;
                while (i2 < ndList.size()) {
                    logger.debug((Object)("i=" + i2 + " " + ndList.get(i2)));
                    ++i2;
                }
                geoName = GeoRegion.assembleSuBaoName(ndList);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        if (geoName == null) {
            geoName = isZh ? RegionsFE.getFeGeoRegionChineseName(lat, lon) : RegionsFE.getRegionName(lat, lon);
        }
        logger.debug((Object)(">>> finalName: " + geoName));
        return geoName;
    }

    public static String assembleSuBaoName(List<NameDist> ndList) {
        String geoName = null;
        boolean haveOneInSea = false;
        ArrayList<NameDist> ndListHaveSeam = new ArrayList<NameDist>();
        int i = 0;
        while (i < ndList.size()) {
            NameDist nd = ndList.get(i);
            if (nd.getFullName().indexOf("\u6d77\u57df") >= 0) {
                ndListHaveSeam.add(nd);
                if (nd.getDistance() < 0.0f) {
                    geoName = nd.getFullName();
                    haveOneInSea = true;
                }
            }
            ++i;
        }
        if (haveOneInSea) {
            return geoName;
        }
        ndList.removeAll(ndListHaveSeam);
        if (GeoRegion.isSamePro(ndList)) {
            ArrayList<NameDist> markedLst = new ArrayList<NameDist>();
            int i2 = 0;
            while (i2 < ndList.size()) {
                NameDist nd = ndList.get(i2);
                if (nd.getDistance() <= 5.0f) {
                    markedLst.add(nd);
                }
                ++i2;
            }
            logger.debug((Object)("step2: delete distance>5 in samePro, size:" + markedLst.size()));
            i2 = 0;
            while (i2 < markedLst.size()) {
                logger.debug((Object)("i=" + i2 + " " + markedLst.get(i2)));
                ++i2;
            }
            if (markedLst.size() > 0) {
                Collections.sort(markedLst, Comparators.byDistance());
                geoName = GeoRegion.genFinalResult(GeoRegion.markDuplicated(markedLst));
            }
        } else {
            NameDist nd;
            String fisrtOrderPro = "NULL";
            int i3 = 0;
            while (i3 < ndList.size()) {
                nd = ndList.get(i3);
                if (nd.getDistance() < 0.0f) {
                    fisrtOrderPro = nd.getFullName();
                    break;
                }
                ++i3;
            }
            logger.debug((Object)("NOT samePro fisrtOrderPro=" + fisrtOrderPro));
            i3 = 0;
            while (i3 < ndList.size()) {
                nd = ndList.get(i3);
                if (nd.getFullName().indexOf(fisrtOrderPro) >= 0) {
                    ndList.get(i3).setPriOrder(-1);
                }
                ++i3;
            }
            logger.debug((Object)"after set fisrtOrder");
            i3 = 0;
            while (i3 < ndList.size()) {
                logger.debug((Object)("i=" + i3 + " " + ndList.get(i3)));
                ++i3;
            }
            logger.debug((Object)"after sortByPriOrder");
            Collections.sort(ndList, Comparators.byPriOrder());
            if (ndList.size() > 0) {
                GeoRegion.secondOrderByDistance(ndList);
                i3 = 0;
                while (i3 < ndList.size()) {
                    logger.debug((Object)("i=" + i3 + " " + ndList.get(i3)));
                    ++i3;
                }
                geoName = GeoRegion.genFinalResult(GeoRegion.markDuplicated(ndList));
            }
        }
        return geoName;
    }

    private static void secondOrderByDistance(List<NameDist> ndList) {
        ArrayList ndList2 = new ArrayList();
        ArrayList<NameDist> ndList_s = new ArrayList<NameDist>();
        int size = ndList.size();
        if (size == 1) {
            return;
        }
        int priOrder_0 = ndList.get(0).getPriOrder();
        ndList_s.add(ndList.get(0));
        int i = 1;
        while (i < size) {
            NameDist nd = ndList.get(i);
            int priOrder_i = nd.getPriOrder();
            if (priOrder_i == priOrder_0) {
                ndList_s.add(nd);
            } else {
                Collections.sort(ndList_s, Comparators.byDistance());
                ndList2.addAll(ndList_s);
                ndList_s.clear();
                ndList_s.add(nd);
                priOrder_0 = priOrder_i;
            }
            ++i;
        }
        Collections.sort(ndList_s, Comparators.byDistance());
        ndList2.addAll(ndList_s);
        ndList_s.clear();
        ndList.clear();
        ndList.addAll(ndList2);
    }

    private static String genFinalResult(List<NameDist> ndLst) {
        StringBuilder strb = new StringBuilder();
        if (ndLst.size() == 1) {
            strb.append(ndLst.get(0).getFullName());
        } else {
            int size = ndLst.size();
            SimBox sb = null;
            int i = 0;
            while (i < size - 1) {
                sb = ndLst.get(i).getSimBox();
                strb.append(String.valueOf(sb.getClassName1()) + sb.getClassName2() + sb.getClassName3() + dunhao);
                ++i;
            }
            sb = ndLst.get(size - 1).getSimBox();
            strb.append(String.valueOf(sb.getClassName1()) + sb.getClassName2() + sb.getClassName3() + endStr);
        }
        String finalName = strb.substring(0).replace(markedStr, "");
        if (finalName.length() > 0) {
            return finalName;
        }
        return null;
    }

    private static List<NameDist> markDuplicated(List<NameDist> lst) {
        NameDist nd;
        ArrayList<NameDist> lst1 = new ArrayList<NameDist>();
        ArrayList<NameDist> lst2 = new ArrayList<NameDist>();
        String strA = null;
        String strB = null;
        int size = lst.size();
        lst1.add(lst.get(0));
        String keepName = lst.get(0).getSimBox().getClassName1();
        int i = 0;
        while (i < size - 1) {
            strA = keepName;
            strB = lst.get(i + 1).getSimBox().getClassName1();
            if (strA.indexOf(strB) >= 0) {
                SimBox sb1 = new SimBox();
                sb1.setID(lst.get(i + 1).getSimBox().getID());
                sb1.setFullName(lst.get(i + 1).getSimBox().getFullName());
                sb1.setClassName1(markedStr);
                sb1.setClassName2(lst.get(i + 1).getSimBox().getClassName2());
                sb1.setClassName3(lst.get(i + 1).getSimBox().getClassName3());
                nd = new NameDist(sb1, lst.get(i + 1).getDistance());
                nd.setPriOrder(lst.get(i + 1).getPriOrder());
                lst1.add(nd);
            } else {
                keepName = lst.get(i + 1).getSimBox().getClassName1();
                lst1.add(lst.get(i + 1));
            }
            ++i;
        }
        lst2.add((NameDist)lst1.get(0));
        keepName = ((NameDist)lst1.get(0)).getSimBox().getClassName2();
        i = 0;
        while (i < size - 1) {
            strA = keepName;
            strB = ((NameDist)lst1.get(i + 1)).getSimBox().getClassName2();
            if (strA.indexOf(strB) >= 0) {
                SimBox sb2 = new SimBox();
                sb2.setID(((NameDist)lst1.get(i + 1)).getSimBox().getID());
                sb2.setFullName(((NameDist)lst1.get(i + 1)).getSimBox().getFullName());
                sb2.setClassName1(((NameDist)lst1.get(i + 1)).getSimBox().getClassName1());
                sb2.setClassName2(markedStr);
                sb2.setClassName3(((NameDist)lst1.get(i + 1)).getSimBox().getClassName3());
                nd = new NameDist(sb2, lst.get(i + 1).getDistance());
                nd.setPriOrder(lst.get(i + 1).getPriOrder());
                lst2.add(nd);
            } else {
                keepName = ((NameDist)lst1.get(i + 1)).getSimBox().getClassName2();
                lst2.add((NameDist)lst1.get(i + 1));
            }
            ++i;
        }
        logger.debug((Object)("markDuplicated result size:" + lst2.size()));
        i = 0;
        while (i < lst2.size()) {
            logger.debug((Object)("i=" + i + " " + lst2.get(i)));
            ++i;
        }
        return lst2;
    }

    public static Hashtable<String, MultiPolygon> getGeometriesNearBy(double lat, double lon, int distance) {
        ArrayList<SimBox> sbList = new ArrayList<SimBox>();
        double degree = (double)distance / 111.19;
        int i = 0;
        while (i < simBoxList.size()) {
            SimBox sb = simBoxList.get(i);
            Envelope ev = sb.getBbx();
            if (lat >= ev.getMinY() && lat <= ev.getMaxY() && lon >= ev.getMinX() && lon <= ev.getMaxX() || SphereUtil.distOnSphere((double)lat, (double)lon, (double)ev.getMinY(), (double)ev.getMinX()) < degree || SphereUtil.distOnSphere((double)lat, (double)lon, (double)ev.getMinY(), (double)ev.getMaxX()) < degree || SphereUtil.distOnSphere((double)lat, (double)lon, (double)ev.getMaxY(), (double)ev.getMinX()) < degree || SphereUtil.distOnSphere((double)lat, (double)lon, (double)ev.getMaxY(), (double)ev.getMaxX()) < degree) {
                sbList.add(sb);
            }
            ++i;
        }
        if (sbList.size() == 0) {
            return null;
        }
        GeoRegion.loadSelectedGeometry(sbList);
        Hashtable<String, MultiPolygon> geometries = new Hashtable<String, MultiPolygon>(sbList.size());
        String name = "";
        int j = 0;
        while (j < sbList.size()) {
            SimBox sb = (SimBox)sbList.get(j);
            if (!sb.className3.isEmpty()) {
                name = sb.className3;
            } else if (!sb.className2.isEmpty()) {
                name = sb.className2;
            } else if (!sb.className1.isEmpty()) {
                name = sb.className1;
            }
            if (!name.endsWith("\u6d77\u57df")) {
                Geometry g_polygon = ht.get(sb.getID());
                geometries.put(name, (MultiPolygon)g_polygon);
            }
            ++j;
        }
        return geometries;
    }

    private static void loadSelectedGeometry(List<SimBox> sbList) {
        if (loadAll2HashTable) {
            for (SimBox sb : sbList) {
                Geometry p = allTbl.get(sb.getID());
                if (p == null) continue;
                ht.put(sb.getID(), p);
            }
        } else {
            ht.clear();
            String fileName = DataResource.COUNTY_DIRECTORY;
            File f = new File(fileName);
            if (!f.exists()) {
                f.mkdir();
            }
            if (!(f = new File(fileName = String.valueOf(DataResource.COUNTY_DIRECTORY) + sbList.get(0).getID())).exists()) {
                GeoRegion.createAllCountyObject();
            }
            int i = 0;
            while (i < sbList.size()) {
                ht.put(sbList.get(i).getID(), GeoRegion.getGeometry(sbList.get(i).getID()));
                ++i;
            }
        }
    }

    private static void createAllCountyObject() {
        try {
            ShapefileDataStore shpDataStore = new ShapefileDataStore(DataResource.toURL(DataResource.COUNTY_SHP));
            SimpleFeatureSource fs = shpDataStore.getFeatureSource();
            FeatureCollection features = fs.getFeatures();
            logger.info((Object)("write county object to file, size:" + features.size()));
            FeatureIterator iterator = features.features();
            String fileName = "";
            ObjectOutputStream out = null;
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                String objId = feature.getID();
                fileName = String.valueOf(DataResource.COUNTY_DIRECTORY) + objId;
                out = null;
                try {
                    try {
                        out = new ObjectOutputStream(new FileOutputStream(new File(fileName)));
                        out.writeObject(feature.getDefaultGeometry());
                    }
                    catch (Exception e) {
                        logger.warn((Object)("write object 2 file error\uff1a" + e.toString()));
                        try {
                            out.close();
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static Geometry getGeometry(String id) {
        Geometry p = null;
        String fileName = String.valueOf(DataResource.COUNTY_DIRECTORY) + id;
        ObjectInputStream in = null;
        try {
            try {
                in = new ObjectInputStream(new FileInputStream(new File(fileName)));
                p = (Geometry)in.readObject();
            }
            catch (Exception e) {
                logger.debug((Object)e.getMessage());
                try {
                    in.close();
                }
                catch (Exception e2) {
                    logger.debug((Object)e2.getMessage());
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                logger.debug((Object)e.getMessage());
            }
        }
        return p;
    }

    public static float distance(Point p, MultiPolygon polygon) {
        Coordinate[] cArray = polygon.getCoordinates();
        int size = cArray.length;
        float minDist = Float.MAX_VALUE;
        int i = 0;
        while (i < size) {
            Coordinate c = cArray[i];
            float tmp = (float)SphereUtil.distOnSphere((double)p.getY(), (double)p.getX(), (double)c.y, (double)c.x);
            if (tmp < minDist) {
                minDist = tmp;
            }
            ++i;
        }
        return minDist;
    }

    private static boolean isSamePro(List<NameDist> ndList) {
        String nameB;
        int size = ndList.size();
        String nameA = ndList.get(0).getSimBox().getClassName1();
        return nameA.indexOf(nameB = ndList.get(size - 1).getSimBox().getClassName1()) >= 0;
    }

    public static void main(String[] args) throws IOException {
        float lat = 25.9f;
        float lon = 119.29f;
        PropertyConfigurator.configureAndWatch((String)"log4j.properties");
        logger.info((Object)GeoRegion.getSuBaoName(20.29, 110.34));
    }

    public static class Comparators {
        public static Comparator byDistance() {
            return new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof NameDist) {
                        return this.compare((NameDist)o1, (NameDist)o2);
                    }
                    System.err.println("\u672a\u627e\u5230\u5408\u9002\u7684\u6bd4\u8f83\u5668");
                    return 1;
                }

                public int compare(NameDist o1, NameDist o2) {
                    float d2;
                    float d1 = o1.getDistance();
                    return d1 < (d2 = o2.getDistance()) ? -1 : (d1 == d2 ? 0 : 1);
                }
            };
        }

        public static Comparator byPriOrder() {
            return new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof NameDist) {
                        return this.compare((NameDist)o1, (NameDist)o2);
                    }
                    System.err.println("\u672a\u627e\u5230\u5408\u9002\u7684\u6bd4\u8f83\u5668");
                    return 1;
                }

                public int compare(NameDist o1, NameDist o2) {
                    int d2;
                    int d1 = o1.getPriOrder();
                    return d1 < (d2 = o2.getPriOrder()) ? -1 : (d1 == d2 ? 0 : 1);
                }
            };
        }

        public static Comparator byfullName() {
            return new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof NameDist) {
                        return this.compare((NameDist)o1, (NameDist)o2);
                    }
                    System.err.println("\u672a\u627e\u5230\u5408\u9002\u7684\u6bd4\u8f83\u5668");
                    return 1;
                }

                public int compare(NameDist o1, NameDist o2) {
                    String d2;
                    String d1 = o1.getFullName();
                    long val = d1.compareTo(d2 = o2.getFullName());
                    return val < 0L ? -1 : (val == 0L ? 0 : 1);
                }
            };
        }
    }

    public static class NameDist {
        private String fullName;
        private SimBox simBox;
        private float distance;
        private int priOrder;

        public NameDist() {
        }

        public NameDist(SimBox simBox, float distance) {
            this.simBox = simBox;
            this.fullName = simBox.getFullName();
            this.distance = distance;
        }

        public SimBox getSimBox() {
            return this.simBox;
        }

        public void setSimBox(SimBox simBox) {
            this.simBox = simBox;
        }

        public String getFullName() {
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public float getDistance() {
            return this.distance;
        }

        public void setDistance(float distance) {
            this.distance = distance;
        }

        public int getPriOrder() {
            return this.priOrder;
        }

        public void setPriOrder(int priOrder) {
            this.priOrder = priOrder;
        }

        public String toString() {
            return "priOrder=" + this.priOrder + " " + this.fullName + " " + this.simBox + " " + this.distance;
        }
    }

    public static class SimBox {
        private String id;
        private String fullName;
        private String className1;
        private String className2 = "";
        private String className3 = "";
        private Envelope bbx;
        private Envelope enlargedBbx;

        public String getID() {
            return this.id;
        }

        public void setID(String id) {
            this.id = id;
        }

        public String getFullName() {
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public String getClassName1() {
            return this.className1;
        }

        public void setClassName1(String className1) {
            this.className1 = className1;
        }

        public String getClassName2() {
            return this.className2;
        }

        public void setClassName2(String className2) {
            this.className2 = className2;
        }

        public String getClassName3() {
            return this.className3;
        }

        public void setClassName3(String className3) {
            this.className3 = className3;
        }

        public Envelope getBbx() {
            return this.bbx;
        }

        public void setBbx(Envelope bbx) {
            this.bbx = bbx;
        }

        public Envelope getEnlargedBbx() {
            return this.enlargedBbx;
        }

        public void setEnlargedBbx(Envelope enlargedBbx) {
            this.enlargedBbx = enlargedBbx;
        }

        public String toString() {
            return "  simbox: " + this.className1 + " " + this.className2 + " " + this.className3;
        }
    }
}

