/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.regions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class RegionsFE {
    private static final short[][] feGeoRegionsArray = new short[182][362];
    private static final String[] feGeoRegionsChineseNames;
    private static final String[] feGeoRegionsNames;

    static {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(RegionsFE.class.getResourceAsStream("ferdata.dat")));
            int i = 0;
            while (i < 182) {
                String line = br.readLine();
                StringTokenizer st = new StringTokenizer(line, " ,");
                int j = 0;
                while (j < 362) {
                    RegionsFE.feGeoRegionsArray[i][j] = Short.parseShort(st.nextToken());
                    ++j;
                }
                ++i;
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Error readding resource ferdata.dat");
        }
        feGeoRegionsChineseNames = new String[]{"\u7f8e\u56fd\u963f\u62c9\u65af\u52a0\u5dde\u4e2d\u90e8", "\u7f8e\u56fd\u963f\u62c9\u65af\u52a0\u5dde\u5357\u90e8", "\u767d\u4ee4\u6d77", "\u79d1\u66fc\u591a\u5c14\u7fa4\u5c9b\u5730\u533a[\u4fc4]", "\u5c3c\u5c14\u7fa4\u5c9b[\u963f\u7559\u7533\u7fa4\u5c9b]", "\u62c9\u7279\u7fa4\u5c9b[\u963f\u7559\u7533\u7fa4\u5c9b]", "\u5b89\u5fb7\u70c8\u4e9a\u8bfa\u592b\u7fa4\u5c9b[\u963f\u7559\u7533\u7fa4\u5c9b]", "\u7f8e\u56fd\u963f\u62c9\u65af\u52a0\u5dde\u666e\u91cc\u6bd4\u6d1b\u592b\u7fa4\u5c9b\u5730\u533a", "\u798f\u514b\u65af\u7fa4\u5c9b[\u963f\u7559\u7533\u7fa4\u5c9b]", "\u7f8e\u56fd\u963f\u62c9\u65af\u52a0\u5dde\u4e4c\u5c3c\u9a6c\u514b\u5c9b\u5730\u533a", "\u5e03\u91cc\u65af\u6258\u5c14\u6e7e[\u7f8e]", "\u7f8e\u56fd\u963f\u62c9\u65af\u52a0\u534a\u5c9b", "\u7f8e\u56fd\u963f\u62c9\u65af\u52a0\u5dde\u79d1\u8fea\u4e9a\u514b\u5c9b\u5730\u533a", "\u7f8e\u56fd\u963f\u62c9\u65af\u52a0\u5dde\u57fa\u5948\u534a\u5c9b", "\u7f8e\u56fd\u963f\u62c9\u65af\u52a0\u6e7e", "\u963f\u7559\u7533\u7fa4\u5c9b\u4ee5\u5357", "\u7f8e\u56fd\u963f\u62c9\u65af\u52a0\u5dde\u4ee5\u5357", "\u52a0\u62ff\u5927\u80b2\u7a7a\u5730\u533a\u5357\u90e8", "\u7f8e\u56fd\u963f\u62c9\u65af\u52a0\u5dde\u4e1c\u5357\u90e8", "\u7f8e\u56fd\u963f\u62c9\u65af\u52a0\u5dde\u4e1c\u5357\u90e8\u6cbf\u5cb8\u8fdc\u6d77", "\u52a0\u62ff\u5927\u6e29\u54e5\u534e\u5c9b\u4ee5\u897f", "\u52a0\u62ff\u5927\u590f\u6d1b\u7279\u7687\u540e\u7fa4\u5c9b\u5730\u533a", "\u52a0\u62ff\u5927\u4e0d\u5217\u98a0\u54e5\u4f26\u6bd4\u4e9a\u7701", "\u52a0\u62ff\u5927\u827e\u4f2f\u5854\u7701", "\u52a0\u62ff\u5927\u6e29\u54e5\u534e\u5c9b\u5730\u533a", "\u7f8e\u56fd\u534e\u76db\u987f\u5dde\u6cbf\u5cb8\u8fdc\u6d77", "\u7f8e\u56fd\u534e\u76db\u987f\u5dde\u6cbf\u5cb8\u8fd1\u6d77", "\u7f8e\u56fd\u534e\u76db\u987f\u5dde-\u4fc4\u52d2\u5188\u5dde\u8fb9\u5883\u5730\u533a", "\u7f8e\u56fd\u534e\u76db\u987f\u5dde", "\u7f8e\u56fd\u4fc4\u52d2\u5188\u5dde\u6cbf\u5cb8\u8fdc\u6d77", "\u7f8e\u56fd\u4fc4\u52d2\u5188\u5dde\u6cbf\u5cb8\u8fd1\u6d77", "\u7f8e\u56fd\u4fc4\u52d2\u5188\u5dde", "\u7f8e\u56fd\u7231\u8fbe\u8377\u5dde\u897f\u90e8", "\u7f8e\u56fd\u52a0\u5229\u798f\u5c3c\u4e9a\u5dde\u5317\u90e8\u6cbf\u5cb8\u8fdc\u6d77", "\u7f8e\u56fd\u52a0\u5229\u798f\u5c3c\u4e9a\u5dde\u5317\u90e8\u6cbf\u5cb8\u8fd1\u6d77", "\u7f8e\u56fd\u52a0\u5229\u798f\u5c3c\u4e9a\u5dde\u5317\u90e8", "\u7f8e\u56fd\u5185\u534e\u8fbe\u5dde", "\u7f8e\u56fd\u52a0\u5229\u798f\u5c3c\u4e9a\u5dde\u6cbf\u5cb8\u8fdc\u6d77", "\u7f8e\u56fd\u52a0\u5229\u798f\u5c3c\u4e9a\u5dde\u4e2d\u90e8", "\u7f8e\u56fd\u52a0\u5229\u798f\u5c3c\u4e9a\u5dde-\u5185\u534e\u8fbe\u5dde\u8fb9\u5883\u5730\u533a", "\u7f8e\u56fd\u5185\u534e\u8fbe\u5dde\u5357\u90e8", "\u7f8e\u56fd\u4e9a\u5229\u6851\u90a3\u5dde\u897f\u90e8", "\u7f8e\u56fd\u52a0\u5229\u798f\u5c3c\u4e9a\u5dde\u5357\u90e8", "\u7f8e\u56fd\u52a0\u5229\u798f\u5c3c\u4e9a\u5dde-\u4e9a\u5229\u6851\u90a3\u5dde\u8fb9\u5883\u5730\u533a", "\u7f8e\u56fd\u52a0\u5229\u798f\u5c3c\u4e9a\u5dde-\u58a8\u897f\u54e5\u4e0b\u52a0\u5229\u798f\u5c3c\u4e9a\u8fb9\u5883\u5730\u533a", "\u7f8e\u56fd\u4e9a\u5229\u6851\u90a3\u5dde\u897f\u90e8-\u58a8\u897f\u54e5\u7d22\u8bfa\u62c9\u5dde\u8fb9\u5883\u5730\u533a", "\u58a8\u897f\u54e5\u4e0b\u52a0\u5229\u798f\u5c3c\u4e9a\u897f\u5cb8\u8fdc\u6d77", "\u58a8\u897f\u54e5\u4e0b\u52a0\u5229\u798f\u5c3c\u4e9a", "\u52a0\u5229\u798f\u5c3c\u4e9a\u6e7e[\u58a8\u897f\u54e5]", "\u58a8\u897f\u54e5\u7d22\u8bfa\u62c9\u5dde", "\u58a8\u897f\u54e5\u4e2d\u90e8\u6cbf\u5cb8\u8fdc\u6d77", "\u58a8\u897f\u54e5\u4e2d\u90e8\u6cbf\u5cb8\u8fd1\u6d77", "\u58a8\u897f\u54e5\u96f7\u7ef4\u4e9a\u5e0c\u8d6b\u591a\u7fa4\u5c9b\u5730\u533a", "\u58a8\u897f\u54e5\u54c8\u5229\u65af\u79d1\u5dde\u6cbf\u5cb8\u8fdc\u6d77", "\u58a8\u897f\u54e5\u54c8\u5229\u65af\u79d1\u5dde\u6cbf\u5cb8\u8fd1\u6d77", "\u58a8\u897f\u54e5\u7c73\u5374\u80af\u5dde\u6cbf\u5cb8\u8fd1\u6d77", "\u58a8\u897f\u54e5\u7c73\u5374\u80af\u5dde", "\u58a8\u897f\u54e5\u683c\u96f7\u7f57\u5dde\u6cbf\u5cb8\u8fd1\u6d77", "\u58a8\u897f\u54e5\u683c\u96f7\u7f57\u5dde", "\u58a8\u897f\u54e5\u74e6\u54c8\u5361\u5dde", "\u58a8\u897f\u54e5\u6070\u5e15\u65af\u5dde", "\u58a8\u897f\u54e5-\u5371\u5730\u9a6c\u62c9\u8fb9\u5883\u5730\u533a", "\u58a8\u897f\u54e5\u6cbf\u5cb8\u8fdc\u6d77", "\u58a8\u897f\u54e5\u7c73\u5374\u80af\u5dde\u6cbf\u5cb8\u8fdc\u6d77", "\u58a8\u897f\u54e5\u683c\u96f7\u7f57\u5dde\u6cbf\u5cb8\u8fdc\u6d77", "\u58a8\u897f\u54e5\u74e6\u54c8\u5361\u5dde\u6cbf\u5cb8\u8fd1\u6d77", "\u58a8\u897f\u54e5\u74e6\u54c8\u5361\u5dde\u6cbf\u5cb8\u8fdc\u6d77", "\u58a8\u897f\u54e5\u6070\u5e15\u65af\u5dde\u6cbf\u5cb8\u8fdc\u6d77", "\u58a8\u897f\u54e5\u6070\u5e15\u65af\u5dde\u6cbf\u5cb8\u8fd1\u6d77", "\u5371\u5730\u9a6c\u62c9", "\u5371\u5730\u9a6c\u62c9\u6cbf\u5cb8\u8fd1\u6d77", "\u6d2a\u90fd\u62c9\u65af", "\u8428\u5c14\u74e6\u591a", "\u5c3c\u52a0\u62c9\u74dc\u6cbf\u5cb8\u8fd1\u6d77", "\u5c3c\u52a0\u62c9\u74dc", "\u4e2d\u7f8e\u6d32\u6cbf\u5cb8\u8fdc\u6d77", "\u54e5\u65af\u8fbe\u9ece\u52a0\u6cbf\u5cb8\u8fdc\u6d77", "\u54e5\u65af\u8fbe\u9ece\u52a0", "\u5df4\u62ff\u9a6c\u4ee5\u5317", "\u5df4\u62ff\u9a6c-\u54e5\u65af\u8fbe\u9ece\u52a0\u8fb9\u5883\u5730\u533a", "\u5df4\u62ff\u9a6c", "\u5df4\u62ff\u9a6c-\u54e5\u4f26\u6bd4\u4e9a\u8fb9\u5883\u5730\u533a", "\u5df4\u62ff\u9a6c\u4ee5\u5357", "\u58a8\u897f\u54e5\u5c24\u5361\u5766\u534a\u5c9b", "\u53e4\u5df4\u5730\u533a", "\u7259\u4e70\u52a0\u5730\u533a", "\u6d77\u5730\u5730\u533a", "\u591a\u7c73\u5c3c\u52a0\u5171\u548c\u56fd\u5730\u533a", "\u83ab\u7eb3\u6d77\u5ce1", "\u6ce2\u591a\u9ece\u5404\u5730\u533a", "\u7ef4\u5c14\u4eac\u7fa4\u5c9b", "\u80cc\u98ce\u7fa4\u5c9b", "\u4f2f\u5229\u5179", "\u52a0\u52d2\u6bd4\u6d77", "\u5411\u98ce\u7fa4\u5c9b", "\u54e5\u4f26\u6bd4\u4e9a\u5317\u5cb8\u8fd1\u6d77", "\u59d4\u5185\u745e\u62c9\u6cbf\u5cb8\u8fd1\u6d77", "\u7279\u7acb\u5c3c\u8fbe", "\u54e5\u4f26\u6bd4\u4e9a\u5317\u90e8", "\u59d4\u5185\u745e\u62c9\u9a6c\u62c9\u5f00\u6ce2\u6e56", "\u59d4\u5185\u745e\u62c9", "\u54e5\u4f26\u6bd4\u4e9a\u897f\u5cb8\u8fd1\u6d77", "\u54e5\u4f26\u6bd4\u4e9a", "\u5384\u74dc\u591a\u5c14\u6cbf\u5cb8\u8fdc\u6d77", "\u5384\u74dc\u591a\u5c14\u6cbf\u5cb8\u8fd1\u6d77", "\u54e5\u4f26\u6bd4\u4e9a-\u5384\u74dc\u591a\u5c14\u8fb9\u5883\u5730\u533a", "\u5384\u74dc\u591a\u5c14", "\u79d8\u9c81\u5317\u90e8\u6cbf\u5cb8\u8fdc\u6d77", "\u79d8\u9c81\u5317\u90e8\u6cbf\u5cb8\u8fd1\u6d77", "\u79d8\u9c81-\u5384\u74dc\u591a\u5c14\u8fb9\u5883\u5730\u533a", "\u79d8\u9c81\u5317\u90e8", "\u79d8\u9c81-\u5df4\u897f\u8fb9\u5883\u5730\u533a", "\u5df4\u897f\u897f\u90e8", "\u79d8\u9c81\u6cbf\u5cb8\u8fdc\u6d77", "\u79d8\u9c81\u6cbf\u5cb8\u8fd1\u6d77", "\u79d8\u9c81\u4e2d\u90e8", "\u79d8\u9c81\u5357\u90e8", "\u79d8\u9c81-\u73bb\u5229\u7ef4\u4e9a\u8fb9\u5883\u5730\u533a", "\u73bb\u5229\u7ef4\u4e9a\u5317\u90e8", "\u73bb\u5229\u7ef4\u4e9a\u4e2d\u90e8", "\u667a\u5229\u5317\u90e8\u6cbf\u5cb8\u8fdc\u6d77", "\u667a\u5229\u5317\u90e8\u6cbf\u5cb8\u8fd1\u6d77", "\u667a\u5229\u5317\u90e8", "\u667a\u5229-\u73bb\u5229\u7ef4\u4e9a\u8fb9\u5883\u5730\u533a", "\u73bb\u5229\u7ef4\u4e9a\u5357\u90e8", "\u5df4\u62c9\u572d", "\u667a\u5229-\u963f\u6839\u5ef7\u8fb9\u5883\u5730\u533a", "\u963f\u6839\u5ef7\u80e1\u80e1\u4f0a\u7701", "\u963f\u6839\u5ef7\u8428\u5c14\u5854\u7701", "\u963f\u6839\u5ef7\u5361\u5854\u9a6c\u5361\u7701", "\u963f\u6839\u5ef7\u56fe\u5e93\u66fc\u7701", "\u963f\u6839\u5ef7\u5723\u5730\u4e9a\u54e5-\u5fb7\u5c14\u57c3\u65af\u7279\u7f57\u7701", "\u963f\u6839\u5ef7\u4e1c\u5317\u90e8", "\u667a\u5229\u4e2d\u90e8\u6cbf\u5cb8\u8fdc\u6d77", "\u667a\u5229\u4e2d\u90e8\u6cbf\u5cb8\u8fd1\u6d77", "\u667a\u5229\u4e2d\u90e8", "\u963f\u6839\u5ef7\u5723\u80e1\u5b89\u7701", "\u963f\u6839\u5ef7\u62c9\u91cc\u5965\u54c8\u7701", "\u963f\u6839\u5ef7\u95e8\u591a\u8428\u7701", "\u963f\u6839\u5ef7\u5723\u8def\u6613\u65af\u7701", "\u963f\u6839\u5ef7\u79d1\u5c14\u591a\u74e6\u7701", "\u4e4c\u62c9\u572d", "\u667a\u5229\u5357\u90e8\u6cbf\u5cb8\u8fdc\u6d77", "\u667a\u5229\u5357\u90e8", "\u667a\u5229\u5357\u90e8-\u963f\u6839\u5ef7\u8fb9\u5883\u5730\u533a", "\u963f\u6839\u5ef7\u5357\u90e8", "\u706b\u5730\u5c9b", "\u5357\u6781\u6d32\u798f\u514b\u5170\u7fa4\u5c9b\u5730\u533a", "\u5fb7\u96f7\u514b\u6d77\u5ce1", "\u5357\u6781\u6d32\u65af\u79d1\u820d\u6d77", "\u5357\u4e54\u6cbb\u4e9a\u5c9b\u5730\u533a[\u5927\u897f\u6d0b]", "\u5357\u4e54\u6cbb\u4e9a\u6d77\u5cad[\u5927\u897f\u6d0b]", "\u5357\u6851\u5a01\u5947\u7fa4\u5c9b\u5730\u533a[\u5927\u897f\u6d0b]", "\u5357\u8bbe\u5f97\u5170\u7fa4\u5c9b[\u5927\u897f\u6d0b]", "\u5357\u6781\u534a\u5c9b", "\u5927\u897f\u6d0b\u897f\u5357\u90e8", "\u5357\u6781\u6d32\u5a01\u5fb7\u5c14\u6d77", "\u65b0\u897f\u5170\u5317\u5c9b\u897f\u5cb8\u8fdc\u6d77", "\u65b0\u897f\u5170\u5317\u5c9b", "\u65b0\u897f\u5170\u5317\u5c9b\u4e1c\u5cb8\u8fdc\u6d77", "\u65b0\u897f\u5170\u5357\u5c9b\u897f\u5cb8\u8fdc\u6d77", "\u65b0\u897f\u5170\u5357\u5c9b", "\u65b0\u897f\u5170\u5e93\u514b\u6d77\u5ce1", "\u65b0\u897f\u5170\u5357\u5c9b\u4e1c\u5cb8\u8fdc\u6d77", "\u9ea6\u5938\u91cc\u5c9b\u4ee5\u5317[\u592a\u5e73\u6d0b]", "\u65b0\u897f\u5170\u5965\u514b\u5170\u7fa4\u5c9b\u5730\u533a", "\u9ea6\u5938\u91cc\u5c9b\u5730\u533a[\u592a\u5e73\u6d0b]", "\u65b0\u897f\u5170\u4ee5\u5357", "\u8428\u6469\u4e9a\u7fa4\u5c9b\u5730\u533a[\u592a\u5e73\u6d0b]", "\u8428\u6469\u4e9a\u7fa4\u5c9b[\u592a\u5e73\u6d0b]", "\u6590\u6d4e\u7fa4\u5c9b\u4ee5\u5357", "\u6c64\u52a0\u7fa4\u5c9b\u4ee5\u897f", "\u6c64\u52a0\u7fa4\u5c9b", "\u6c64\u52a0\u7fa4\u5c9b\u5730\u533a", "\u6c64\u52a0\u7fa4\u5c9b\u4ee5\u5357", "\u65b0\u897f\u5170\u4ee5\u5317", "\u65b0\u897f\u5170\u514b\u9a6c\u5fb7\u514b\u7fa4\u5c9b\u5730\u533a", "\u65b0\u897f\u5170\u514b\u9a6c\u5fb7\u514b\u7fa4\u5c9b", "\u65b0\u897f\u5170\u514b\u9a6c\u5fb7\u514b\u7fa4\u5c9b\u4ee5\u5357", "\u6590\u6d4e\u7fa4\u5c9b\u4ee5\u5317", "\u6590\u6d4e\u7fa4\u5c9b\u5730\u533a", "\u6590\u6d4e\u7fa4\u5c9b", "\u5723\u514b\u9c81\u65af\u7fa4\u5c9b\u5730\u533a[\u6240\u7f57\u95e8\u7fa4\u5c9b]", "\u5723\u514b\u9c81\u65af\u7fa4\u5c9b[\u6240\u7f57\u95e8\u7fa4\u5c9b]", "\u74e6\u52aa\u963f\u56fe\u7fa4\u5c9b\u5730\u533a", "\u74e6\u52aa\u963f\u56fe\u7fa4\u5c9b", "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a", "\u6d1b\u4e9a\u8482\u7fa4\u5c9b[\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a]", "\u6d1b\u4e9a\u8482\u7fa4\u5c9b\u4e1c\u5357[\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a]", "\u65b0\u7231\u5c14\u5170\u5730\u533a[\u5df4\u5e03]", "\u6240\u7f57\u95e8\u7fa4\u5c9b\u4ee5\u5317", "\u65b0\u4e0d\u5217\u98a0\u5c9b\u5730\u533a[\u5df4\u5e03]", "\u6240\u7f57\u95e8\u7fa4\u5c9b", "\u5f53\u7279\u5c14\u5361\u65af\u6258\u7fa4\u5c9b\u5730\u533a[\u5df4\u5e03]", "\u6240\u7f57\u95e8\u7fa4\u5c9b\u4ee5\u5357", "\u5370\u5c3c\u4f0a\u91cc\u5b89\u67e5\u4e9a\u7701\u5730\u533a", "\u5370\u5c3c\u4f0a\u91cc\u5b89\u67e5\u4e9a\u7701\u5317\u5cb8\u8fd1\u6d77", "\u5c3c\u5c3c\u683c\u7fa4\u5c9b\u5730\u533a[\u5df4\u5e03]", "\u963f\u5fb7\u9ed8\u52d2\u5c14\u8482\u7fa4\u5c9b\u5730\u533a[\u5df4\u5e03]", "\u65b0\u51e0\u5185\u4e9a\u5317\u5cb8\u8fd1\u6d77[\u5df4\u5e03]", "\u5370\u5c3c\u4f0a\u91cc\u5b89\u67e5\u4e9a\u7701", "\u65b0\u51e0\u5185\u4e9a[\u5df4\u5e03]", "\u4ffe\u65af\u9ea6\u6d77", "\u5370\u5c3c\u963f\u9c81\u7fa4\u5c9b\u5730\u533a", "\u5370\u5c3c\u4f0a\u91cc\u5b89\u67e5\u4e9a\u7701\u5357\u5cb8\u8fd1\u6d77", "\u65b0\u51e0\u5185\u4e9a\u5357\u5cb8\u8fd1\u6d77[\u5df4\u5e03]", "\u65b0\u51e0\u5185\u4e9a\u4e1c\u90e8\u5730\u533a[\u5df4\u5e03]", "\u963f\u62c9\u5f17\u62c9\u6d77", "\u52a0\u7f57\u6797\u7fa4\u5c9b\u897f\u90e8[\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a]", "\u9a6c\u91cc\u4e9a\u7eb3\u7fa4\u5c9b\u4ee5\u5357", "\u65e5\u672c\u672c\u5dde\u4e1c\u5357", "\u65e5\u672c\u5c0f\u7b20\u539f\u7fa4\u5c9b\u5730\u533a", "\u65e5\u672c\u706b\u5c71\u5217\u5c9b\u5730\u533a", "\u9a6c\u91cc\u4e9a\u7eb3\u7fa4\u5c9b\u4ee5\u897f", "\u9a6c\u91cc\u4e9a\u7eb3\u7fa4\u5c9b\u5730\u533a", "\u9a6c\u91cc\u4e9a\u7eb3\u7fa4\u5c9b", "\u4fc4\u7f57\u65af\u582a\u5bdf\u52a0\u534a\u5c9b", "\u582a\u5bdf\u52a0\u4e1c\u5cb8\u8fd1\u6d77", "\u582a\u5bdf\u52a0\u4e1c\u5cb8\u8fdc\u6d77", "\u5343\u5c9b\u7fa4\u5c9b\u897f\u5317", "\u5343\u5c9b\u7fa4\u5c9b", "\u5343\u5c9b\u7fa4\u5c9b\u4ee5\u4e1c", "\u65e5\u672c\u6d77\u4e1c\u90e8", "\u65e5\u672c\u5317\u6d77\u9053\u5730\u533a", "\u65e5\u672c\u5317\u6d77\u9053\u6cbf\u5cb8\u8fdc\u6d77", "\u65e5\u672c\u672c\u5dde\u897f\u5cb8\u8fd1\u6d77", "\u65e5\u672c\u672c\u5dde\u4e1c\u90e8", "\u65e5\u672c\u672c\u5dde\u4e1c\u5cb8\u8fd1\u6d77", "\u65e5\u672c\u672c\u5dde\u4e1c\u5cb8\u8fdc\u6d77", "\u65e5\u672c\u672c\u5dde\u5357\u5cb8\u8fd1\u6d77", "\u97e9\u56fd", "\u65e5\u672c\u672c\u5dde\u897f\u90e8", "\u65e5\u672c\u672c\u5dde\u897f\u90e8\u5357\u5cb8\u8fd1\u6d77", "\u4e2d\u56fd\u4e1c\u6d77", "\u65e5\u672c\u4e5d\u5dde\u5c9b", "\u65e5\u672c\u56db\u56fd\u5c9b", "\u65e5\u672c\u56db\u56fd\u4e1c\u5357", "\u65e5\u672c\u7409\u7403\u7fa4\u5c9b", "\u65e5\u672c\u7409\u7403\u7fa4\u5c9b\u4e1c\u5357", "\u65e5\u672c\u5c0f\u7b20\u539f\u7fa4\u5c9b\u4ee5\u897f", "\u83f2\u5f8b\u5bbe\u6d77", "\u4e2d\u56fd\u4e1c\u5357\u6cbf\u6d77", "\u4e2d\u56fd\u53f0\u6e7e\u5730\u533a", "\u4e2d\u56fd\u53f0\u6e7e", "\u4e2d\u56fd\u53f0\u6e7e\u4e1c\u5317", "\u65e5\u672c\u7409\u7403\u7fa4\u5c9b\u897f\u5357\u90e8", "\u4e2d\u56fd\u53f0\u6e7e\u4e1c\u5357", "\u83f2\u5f8b\u5bbe\u7fa4\u5c9b\u5730\u533a", "\u83f2\u5f8b\u5bbe\u5415\u5b8b\u5c9b", "\u83f2\u5f8b\u5bbe\u6c11\u90fd\u6d1b\u5c9b", "\u83f2\u5f8b\u5bbe\u8428\u9a6c\u5c9b", "\u83f2\u5f8b\u5bbe\u5df4\u62c9\u671b\u5c9b", "\u82cf\u7984\u6d77", "\u83f2\u5f8b\u5bbe\u73ed\u4e43\u5c9b", "\u83f2\u5f8b\u5bbe\u5bbf\u52a1\u5c9b", "\u83f2\u5f8b\u5bbe\u83b1\u7279\u5c9b", "\u83f2\u5f8b\u5bbe\u5185\u683c\u7f57\u65af\u5c9b", "\u83f2\u5f8b\u5bbe\u82cf\u7984\u7fa4\u5c9b", "\u83f2\u5f8b\u5bbe\u68c9\u5170\u8001\u5c9b", "\u83f2\u5f8b\u5bbe\u7fa4\u5c9b\u4ee5\u4e1c", "\u52a0\u91cc\u66fc\u4e39\u5c9b(\u5a46\u7f57\u6d32)", "\u82cf\u62c9\u5a01\u897f\u6d77(\u897f\u91cc\u4f2f\u65af\u6d77)", "\u5370\u5c3c\u5854\u52b3\u7fa4\u5c9b", "\u5370\u5c3c\u54c8\u9a6c\u9ed1\u62c9\u5c9b\u4ee5\u5317", "\u5370\u5c3c\u7c73\u7eb3\u54c8\u6c99\u534a\u5c9b", "\u5370\u5c3c\u9a6c\u9c81\u53e4\u6d77\u5317\u90e8", "\u5370\u5c3c\u54c8\u9a6c\u9ed1\u62c9\u5c9b", "\u5370\u5c3c\u82cf\u62c9\u5a01\u897f\u5c9b(\u897f\u91cc\u4f2f\u65af\u5c9b)", "\u5370\u5c3c\u9a6c\u9c81\u53e4\u6d77\u5357\u90e8", "\u5370\u5c3c\u585e\u5170\u6d77", "\u5370\u5c3c\u5e03\u9c81\u5c9b", "\u5370\u5c3c\u585e\u5170\u5c9b", "\u5370\u5c3c\u82cf\u95e8\u7b54\u814a\u5c9b\u897f\u5357", "\u5370\u5c3c\u82cf\u95e8\u7b54\u814a\u5c9b\u5357\u90e8", "\u5370\u5c3c\u722a\u54c7\u6d77", "\u5370\u5c3c\u5dfd\u4ed6\u6d77\u5ce1", "\u5370\u5c3c\u722a\u54c7\u5c9b", "\u5370\u5c3c\u5df4\u5398\u6d77", "\u5370\u5c3c\u5f17\u6d1b\u52d2\u65af\u6d77", "\u5370\u5c3c\u73ed\u8fbe\u6d77", "\u5370\u5c3c\u5854\u5b81\u5df4\u5c14\u7fa4\u5c9b\u5730\u533a", "\u5370\u5c3c\u722a\u54c7\u5c9b\u4ee5\u5357", "\u5370\u5c3c\u5df4\u5398\u5c9b\u5730\u533a", "\u5370\u5c3c\u5df4\u5398\u5c9b\u4ee5\u5357", "\u5370\u5c3c\u677e\u5df4\u54c7\u5c9b\u5730\u533a", "\u5370\u5c3c\u5f17\u6d1b\u52d2\u65af\u5c9b\u5730\u533a", "\u5370\u5c3c\u677e\u5df4\u5c9b\u5730\u533a", "\u5370\u5c3c\u8428\u6b66\u6d77", "\u5e1d\u6c76\u5c9b\u5730\u533a", "\u5e1d\u6c76\u6d77", "\u5370\u5c3c\u677e\u5df4\u54c7\u4ee5\u5357", "\u5370\u5c3c\u677e\u5df4\u4ee5\u5357", "\u5e1d\u6c76\u5c9b\u4ee5\u5357", "\u7f05\u7538-\u5370\u5ea6\u8fb9\u5883\u5730\u533a", "\u7f05\u7538-\u5b5f\u52a0\u62c9\u56fd\u8fb9\u5883\u5730\u533a", "\u7f05\u7538", "\u7f05\u7538-\u4e2d\u56fd\u8fb9\u5883\u5730\u533a", "\u7f05\u7538\u5357\u5cb8\u8fd1\u6d77", "\u5370\u5ea6\u652f\u90a3\u534a\u5c9b", "\u4e2d\u56fd\u6d77\u5357\u5c9b", "\u4e2d\u56fd\u5357\u6d77", "\u514b\u4ec0\u7c73\u5c14\u4e1c\u90e8", "\u514b\u4ec0\u7c73\u5c14-\u5370\u5ea6\u8fb9\u5883\u5730\u533a", "\u514b\u4ec0\u7c73\u5c14-\u4e2d\u56fd\u897f\u85cf\u81ea\u6cbb\u533a\u8fb9\u5883\u5730\u533a", "\u4e2d\u56fd\u897f\u85cf\u81ea\u6cbb\u533a\u897f\u90e8-\u5370\u5ea6\u8fb9\u5883\u5730\u533a", "\u4e2d\u56fd\u897f\u85cf\u81ea\u6cbb\u533a", "\u4e2d\u56fd\u56db\u5ddd\u7701", "\u5370\u5ea6\u5317\u90e8", "\u5c3c\u6cca\u5c14-\u5370\u5ea6\u8fb9\u5883\u5730\u533a", "\u5c3c\u6cca\u5c14", "\u9521\u91d1", "\u4e0d\u4e39", "\u4e2d\u56fd\u897f\u85cf\u81ea\u6cbb\u533a-\u5370\u5ea6\u8fb9\u5883\u5730\u533a", "\u5370\u5ea6\u5357\u90e8", "\u5370\u5ea6-\u5b5f\u52a0\u62c9\u56fd\u8fb9\u5883\u5730\u533a", "\u5b5f\u52a0\u62c9\u56fd", "\u5370\u5ea6\u4e1c\u5317\u90e8", "\u4e2d\u56fd\u4e91\u5357\u7701", "\u5b5f\u52a0\u62c9\u6e7e", "\u5409\u5c14\u5409\u65af\u65af\u5766-\u4e2d\u56fd\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a\u8fb9\u5883\u5730\u533a", "\u4e2d\u56fd\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a\u5357\u90e8", "\u4e2d\u56fd\u7518\u8083\u7701", "\u4e2d\u56fd\u5185\u8499\u53e4\u81ea\u6cbb\u533a\u897f\u90e8", "\u514b\u4ec0\u7c73\u5c14-\u4e2d\u56fd\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a\u8fb9\u5883\u5730\u533a", "\u4e2d\u56fd\u9752\u6d77\u7701", "\u4fc4\u7f57\u65af\u897f\u4f2f\u5229\u4e9a\u897f\u5357\u90e8", "\u4fc4\u7f57\u65af\u8d1d\u52a0\u5c14\u6e56\u5730\u533a", "\u4fc4\u7f57\u65af\u8d1d\u52a0\u5c14\u6e56\u4ee5\u4e1c", "\u54c8\u8428\u514b\u65af\u5766\u4e1c\u90e8", "\u5409\u5c14\u5409\u65af\u65af\u5766\u4f0a\u585e\u514b\u6e56\u5730\u533a", "\u54c8\u8428\u514b\u65af\u5766-\u4e2d\u56fd\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a\u8fb9\u5883\u5730\u533a", "\u4e2d\u56fd\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a\u5317\u90e8", "\u4fc4\u7f57\u65af-\u8499\u53e4\u8fb9\u5883\u5730\u533a", "\u8499\u53e4", "\u4fc4\u7f57\u65af\u4e4c\u62c9\u5c14\u5c71\u8109\u5730\u533a", "\u54c8\u8428\u514b\u65af\u5766\u897f\u90e8", "\u9ad8\u52a0\u7d22\u4e1c\u90e8", "\u91cc\u6d77", "\u4e4c\u5179\u522b\u514b\u65af\u5766\u897f\u5317\u90e8", "\u571f\u5e93\u66fc\u65af\u5766", "\u571f\u5e93\u66fc\u65af\u5766-\u4f0a\u6717\u8fb9\u5883\u5730\u533a", "\u571f\u5e93\u66fc\u65af\u5766-\u963f\u5bcc\u6c57\u8fb9\u5883\u5730\u533a", "\u571f\u8033\u5176-\u4f0a\u6717\u8fb9\u5883\u5730\u533a", "\u4e9a\u7f8e\u5c3c\u4e9a-\u963f\u585e\u62dc\u7586-\u4f0a\u6717\u8fb9\u5883\u5730\u533a", "\u4f0a\u6717\u897f\u5317\u90e8", "\u4f0a\u6717-\u4f0a\u62c9\u514b\u8fb9\u5883\u5730\u533a", "\u4f0a\u6717\u897f\u90e8", "\u4f0a\u6717\u4e2d\u5317\u90e8", "\u963f\u5bcc\u6c57\u897f\u5317\u90e8", "\u963f\u5bcc\u6c57\u897f\u5357\u90e8", "\u963f\u62c9\u4f2f\u534a\u5c9b\u4e1c\u90e8", "\u6ce2\u65af\u6e7e", "\u4f0a\u6717\u5357\u90e8", "\u5df4\u57fa\u65af\u5766\u897f\u5357\u90e8", "\u963f\u66fc\u6e7e", "\u5df4\u57fa\u65af\u5766\u6cbf\u5cb8\u8fdc\u6d77", "\u4e4c\u514b\u5170-\u6469\u5c14\u591a\u74e6-\u4fc4\u7f57\u65af\u897f\u5357\u90e8\u8fb9\u5883\u5730\u533a", "\u7f57\u9a6c\u5c3c\u4e9a", "\u4fdd\u52a0\u5229\u4e9a", "\u9ed1\u6d77", "\u4e4c\u514b\u5170\u514b\u91cc\u7c73\u4e9a\u5730\u533a", "\u9ad8\u52a0\u7d22\u897f\u5317\u90e8", "\u5e0c\u814a-\u4fdd\u52a0\u5229\u4e9a\u8fb9\u5883\u5730\u533a", "\u5e0c\u814a", "\u7231\u7434\u6d77", "\u571f\u8033\u5176", "\u683c\u9c81\u5409\u4e9a-\u4e9a\u7f8e\u5c3c\u4e9a-\u571f\u8033\u5176\u8fb9\u5883\u5730\u533a", "\u5e0c\u814a\u5357\u90e8", "\u5e0c\u814a\u4f50\u6cfd\u5361\u5c3c\u7d22\u65af\u7fa4\u5c9b", "\u5e0c\u814a\u514b\u91cc\u7279\u5c9b", "\u5730\u4e2d\u6d77\u4e1c\u90e8", "\u585e\u6d66\u8def\u65af\u5730\u533a", "\u6b7b\u6d77\u5730\u533a", "\u7ea6\u65e6-\u53d9\u5229\u4e9a\u5730\u533a", "\u4f0a\u62c9\u514b", "\u8461\u8404\u7259", "\u897f\u73ed\u7259", "\u6bd4\u5229\u725b\u65af\u5c71\u8109", "\u6cd5\u56fd\u5357\u5cb8\u8fd1\u6d77", "\u6cd5\u56fd\u79d1\u897f\u5609\u5c9b", "\u610f\u5927\u5229\u4e2d\u90e8", "\u4e9a\u5f97\u91cc\u4e9a\u6d77", "\u5df4\u5c14\u5e72\u5730\u533a", "\u76f4\u5e03\u7f57\u9640\u4ee5\u897f", "\u76f4\u5e03\u7f57\u9640\u6d77\u5ce1", "\u897f\u73ed\u7259\u5df4\u5229\u963f\u91cc\u7fa4\u5c9b", "\u5730\u4e2d\u6d77\u897f\u90e8", "\u610f\u5927\u5229\u6492\u4e01\u5c9b", "\u7b2c\u52d2\u5c3c\u5b89\u6d77[\u5730\u4e2d\u6d77]", "\u610f\u5927\u5229\u5357\u90e8", "\u963f\u5c14\u5df4\u5c3c\u4e9a", "\u5e0c\u814a-\u963f\u5c14\u5df4\u5c3c\u4e9a\u8fb9\u5883\u5730\u533a", "\u8461\u8404\u7259\u9a6c\u5fb7\u62c9\u7fa4\u5c9b\u5730\u533a", "\u897f\u73ed\u7259\u52a0\u90a3\u5229\u7fa4\u5c9b\u5730\u533a", "\u6469\u6d1b\u54e5", "\u963f\u5c14\u53ca\u5229\u4e9a\u5317\u90e8", "\u7a81\u5c3c\u65af", "\u610f\u5927\u5229\u897f\u897f\u91cc\u5c9b", "\u4f0a\u5965\u5c3c\u4e9a\u6d77", "\u5730\u4e2d\u6d77\u4e2d\u90e8", "\u5229\u6bd4\u4e9a\u6cbf\u5cb8\u8fd1\u6d77", "\u5317\u5927\u897f\u6d0b", "\u4e2d\u5927\u897f\u6d0b\u6d77\u5cad\u5317\u90e8", "\u8461\u8404\u7259\u4e9a\u901f\u5c14\u7fa4\u5c9b\u5730\u533a", "\u8461\u8404\u7259\u4e9a\u901f\u5c14\u7fa4\u5c9b", "\u4e2d\u5927\u897f\u6d0b\u6d77\u5cad\u4e2d\u90e8", "\u963f\u68ee\u677e\u5c9b\u4ee5\u5317[\u5927\u897f\u6d0b]", "\u963f\u68ee\u677e\u5c9b\u5730\u533a[\u5927\u897f\u6d0b]", "\u5357\u5927\u897f\u6d0b", "\u4e2d\u5927\u897f\u6d0b\u6d77\u5cad\u5357\u90e8", "\u7279\u91cc\u65af\u5766-\u8fbe\u5e93\u5c3c\u4e9a\u5730\u533a", "\u5357\u6781\u6d32\u5e03\u97e6\u5c9b\u5730\u533a", "\u975e\u6d32\u897f\u5357", "\u5927\u897f\u6d0b\u4e1c\u5357\u90e8", "\u4e9a\u4e01\u6e7e\u4e1c\u90e8", "\u7d22\u79d1\u7279\u62c9\u5c9b\u5730\u533a[\u4e5f\u95e8]", "\u963f\u62c9\u4f2f\u6d77", "\u5370\u5ea6\u62c9\u514b\u6c99\u7fa4\u5c9b\u5730\u533a", "\u7d22\u9a6c\u91cc\u4e1c\u5317\u90e8", "\u5317\u5370\u5ea6\u6d0b", "\u5361\u5c14\u65af\u4f2f\u683c\u6d77\u5cad[\u5370\u5ea6\u6d0b]", "\u9a6c\u5c14\u4ee3\u592b\u7fa4\u5c9b\u5730\u533a", "\u62c9\u514b\u4ee3\u592b\u6d77[\u5370\u5ea6\u6d0b]", "\u65af\u91cc\u5170\u5361", "\u5357\u5370\u5ea6\u6d0b", "\u67e5\u6208\u65af\u7fa4\u5c9b\u5730\u533a[\u5370\u5ea6\u6d0b]", "\u6bdb\u91cc\u6c42\u65af-\u7559\u5c3c\u6c6a\u5730\u533a", "\u897f\u5357\u5370\u5ea6\u6d0b\u6d77\u5cad", "\u4e2d\u5370\u5ea6\u6d0b\u6d77\u5cad", "\u975e\u6d32\u4ee5\u5357", "\u7231\u5f97\u534e\u738b\u5b50\u7fa4\u5c9b\u5730\u533a[\u5370\u5ea6\u6d0b]", "\u514b\u7f57\u6cfd\u7fa4\u5c9b\u5730\u533a[\u5370\u5ea6\u6d0b]", "\u51ef\u5c14\u76d6\u6717\u7fa4\u5c9b\u5730\u533a[\u5370\u5ea6\u6d0b]", "\u5e03\u7f57\u80af\u6d77\u5cad[\u5370\u5ea6\u6d0b]", "\u4e1c\u5357\u5370\u5ea6\u6d0b\u6d77\u5cad", "\u51ef\u5c14\u76d6\u6717\u6d77\u5cad\u5357\u90e8", "\u6fb3\u5927\u5229\u4e9a\u4ee5\u5357", "\u52a0\u62ff\u5927\u8428\u65af\u5580\u5f7b\u6e29\u7701", "\u52a0\u62ff\u5927\u9a6c\u5c3c\u6258\u5df4\u7701", "\u52a0\u62ff\u5927\u54c8\u5f97\u5b59\u6e7e", "\u52a0\u62ff\u5927\u5b89\u5927\u7565\u7701", "\u52a0\u62ff\u5927\u54c8\u5f97\u5b59\u6d77\u5ce1\u5730\u533a", "\u52a0\u62ff\u5927\u9b41\u5317\u514b\u7701\u5317\u90e8", "\u6234\u7ef4\u65af\u6d77\u5ce1", "\u52a0\u62ff\u5927\u62c9\u5e03\u62c9\u591a\u5730\u533a", "\u62c9\u5e03\u62c9\u591a\u6d77[\u5927\u897f\u6d0b]", "\u52a0\u62ff\u5927\u9b41\u5317\u514b\u7701\u5357\u90e8", "\u52a0\u62ff\u5927\u52a0\u65af\u4f69\u534a\u5c9b", "\u52a0\u62ff\u5927\u9b41\u5317\u514b\u7701\u4e1c\u90e8", "\u52a0\u62ff\u5927\u5b89\u8482\u79d1\u65af\u8482\u5c9b", "\u52a0\u62ff\u5927\u65b0\u4e0d\u4f26\u745e\u514b\u7701", "\u52a0\u62ff\u5927\u65b0\u65af\u79d1\u820d\u7701", "\u52a0\u62ff\u5927\u7231\u5fb7\u534e\u592a\u5b50\u5c9b\u7701", "\u52a0\u62ff\u5927\u5723\u52b3\u4f26\u65af\u6e7e", "\u52a0\u62ff\u5927\u7ebd\u82ac\u5170\u7701", "\u7f8e\u56fd\u8499\u5927\u62ff\u5dde", "\u7f8e\u56fd\u7231\u8fbe\u8377\u5dde\u4e1c\u90e8", "\u8d6b\u5e03\u6839\u6e56\u5730\u533a[\u7f8e]", "\u7f8e\u56fd\u6000\u4fc4\u660e\u5dde\u9ec4\u77f3\u56fd\u5bb6\u516c\u56ed", "\u7f8e\u56fd\u6000\u4fc4\u660e\u5dde", "\u7f8e\u56fd\u5317\u8fbe\u79d1\u4ed6\u5dde", "\u7f8e\u56fd\u5357\u8fbe\u79d1\u4ed6\u5dde", "\u7f8e\u56fd\u5185\u5e03\u62c9\u65af\u52a0\u5dde", "\u7f8e\u56fd\u660e\u5c3c\u82cf\u8fbe\u5dde", "\u7f8e\u56fd\u8863\u963f\u534e\u5dde", "\u7f8e\u56fd\u5a01\u65af\u5eb7\u661f\u5dde", "\u7f8e\u56fd\u4f0a\u5229\u8bfa\u65af\u5dde", "\u7f8e\u56fd\u5bc6\u6267\u5b89\u5dde", "\u7f8e\u56fd\u5370\u7b2c\u5b89\u7eb3\u5dde", "\u52a0\u62ff\u5927\u5b89\u5927\u7565\u7701\u5357\u90e8", "\u7f8e\u56fd\u4fc4\u4ea5\u4fc4\u5dde", "\u7f8e\u56fd\u7ebd\u7ea6\u5dde", "\u7f8e\u56fd\u5bbe\u5915\u6cd5\u5c3c\u4e9a\u5dde", "\u7f8e\u56fd\u65b0\u82f1\u683c\u5170\u5317\u90e8", "\u7f8e\u56fd\u7f05\u56e0\u5dde", "\u7f8e\u56fd\u65b0\u82f1\u683c\u5170\u5357\u90e8", "\u7f8e\u56fd\u7f05\u56e0\u6e7e", "\u7f8e\u56fd\u72b9\u4ed6\u5dde", "\u7f8e\u56fd\u79d1\u7f57\u62c9\u591a\u5dde", "\u7f8e\u56fd\u582a\u8428\u65af\u5dde", "\u7f8e\u56fd\u8863\u963f\u534e\u5dde-\u5bc6\u82cf\u91cc\u5dde\u8fb9\u5883\u5730\u533a", "\u7f8e\u56fd\u5bc6\u82cf\u91cc\u5dde-\u582a\u8428\u65af\u5dde\u8fb9\u5883\u5730\u533a", "\u7f8e\u56fd\u5bc6\u82cf\u91cc\u5dde", "\u7f8e\u56fd\u5bc6\u82cf\u91cc\u5dde-\u963f\u80af\u8272\u5dde\u8fb9\u5883\u5730\u533a", "\u7f8e\u56fd\u5bc6\u82cf\u91cc\u5dde\u4e1c\u90e8", "\u7f8e\u56fd\u5bc6\u82cf\u91cc\u5dde\u65b0\u9a6c\u5fb7\u91cc\u5730\u533a", "\u7f8e\u56fd\u5bc6\u82cf\u91cc\u5dde\u5f00\u666e\u5409\u62c9\u591a\u5730\u533a", "\u7f8e\u56fd\u4f0a\u5229\u8bfa\u4f0a\u5dde\u5357\u90e8", "\u7f8e\u56fd\u5370\u7b2c\u5b89\u7eb3\u5dde\u5357\u90e8", "\u7f8e\u56fd\u80af\u5854\u57fa\u5dde", "\u7f8e\u56fd\u897f\u5f17\u5409\u5c3c\u4e9a\u5dde", "\u7f8e\u56fd\u5f17\u5409\u5c3c\u4e9a\u5dde", "\u7f8e\u56fd\u5207\u8428\u76ae\u514b\u6e7e\u5730\u533a", "\u7f8e\u56fd\u65b0\u6cfd\u897f\u5dde", "\u7f8e\u56fd\u4e9a\u5229\u6851\u90a3\u5dde\u4e1c\u90e8", "\u7f8e\u56fd\u65b0\u58a8\u897f\u54e5\u5dde", "\u7f8e\u56fd\u5f97\u514b\u8428\u65af\u5dde\u6f58\u6c49\u5fb7\u5c14\u5730\u533a", "\u7f8e\u56fd\u5f97\u514b\u8428\u65af\u5dde\u897f\u90e8", "\u7f8e\u56fd\u4fc4\u514b\u62c9\u4f55\u9a6c\u5dde", "\u7f8e\u56fd\u5f97\u514b\u8428\u65af\u5dde\u4e2d\u90e8", "\u7f8e\u56fd\u963f\u80af\u8272\u5dde-\u4fc4\u514b\u62c9\u4f55\u9a6c\u5dde\u8fb9\u5883\u5730\u533a", "\u7f8e\u56fd\u963f\u80af\u8272\u5dde", "\u7f8e\u56fd\u8def\u6613\u65af\u5b89\u90a3\u5dde-\u5f97\u514b\u8428\u65af\u5dde\u8fb9\u5883\u5730\u533a", "\u7f8e\u56fd\u8def\u6613\u65af\u5b89\u90a3\u5dde", "\u7f8e\u56fd\u5bc6\u897f\u897f\u6bd4\u5dde", "\u7f8e\u56fd\u7530\u7eb3\u897f\u5dde", "\u7f8e\u56fd\u4e9a\u62c9\u5df4\u9a6c\u5dde", "\u7f8e\u56fd\u4f5b\u7f57\u91cc\u8fbe\u5dde\u897f\u90e8", "\u7f8e\u56fd\u4f50\u6cbb\u4e9a\u5dde", "\u7f8e\u56fd\u4f5b\u7f57\u91cc\u8fbe\u5dde-\u4f50\u6cbb\u4e9a\u5dde\u8fb9\u5883\u5730\u533a", "\u7f8e\u56fd\u5357\u5361\u7f57\u6765\u7eb3\u5dde", "\u7f8e\u56fd\u5317\u5361\u7f57\u6765\u7eb3\u5dde", "\u7f8e\u56fd\u4e1c\u5cb8\u8fdc\u6d77", "\u7f8e\u56fd\u4f5b\u7f57\u91cc\u8fbe\u534a\u5c9b", "\u5df4\u54c8\u9a6c\u7fa4\u5c9b", "\u7f8e\u56fd\u4e9a\u5229\u6851\u90a3\u5dde\u4e1c\u90e8-\u58a8\u897f\u54e5\u7d22\u8bfa\u62c9\u5dde\u8fb9\u5883\u5730\u533a", "\u7f8e\u56fd\u65b0\u58a8\u897f\u54e5\u5dde-\u58a8\u897f\u54e5\u5947\u74e6\u74e6\u5dde\u8fb9\u5883\u5730\u533a", "\u7f8e\u56fd\u5f97\u514b\u8428\u65af\u5dde-\u58a8\u897f\u54e5\u8fb9\u5883\u5730\u533a", "\u7f8e\u56fd\u5f97\u514b\u8428\u65af\u5dde\u5357\u90e8", "\u7f8e\u56fd\u5f97\u514b\u8428\u65af\u6e7e\u6cbf\u5cb8\u8fd1\u6d77", "\u58a8\u897f\u54e5\u5947\u74e6\u74e6\u5dde", "\u58a8\u897f\u54e5\u5317\u90e8", "\u58a8\u897f\u54e5\u4e2d\u90e8", "\u58a8\u897f\u54e5\u54c8\u5229\u65af\u79d1\u5dde", "\u58a8\u897f\u54e5\u97e6\u62c9\u514b\u9c81\u65af\u5dde", "\u58a8\u897f\u54e5\u6e7e", "\u58a8\u897f\u54e5\u574e\u4f69\u5207\u6e7e", "\u5df4\u897f", "\u572d\u4e9a\u90a3", "\u82cf\u91cc\u5357", "\u6cd5\u5c5e\u572d\u4e9a\u90a3", "\u7231\u5c14\u5170", "\u82f1\u56fd", "\u5317\u6d77", "\u632a\u5a01\u5357\u90e8", "\u745e\u5178", "\u6ce2\u7f57\u7684\u6d77", "\u6cd5\u56fd", "\u6bd4\u65af\u5f00\u6e7e", "\u8377\u5170", "\u6bd4\u5229\u65f6", "\u4e39\u9ea6", "\u5fb7\u56fd", "\u745e\u58eb", "\u610f\u5927\u5229\u5317\u90e8", "\u5965\u5730\u5229", "\u6377\u514b\u65af\u6d1b\u4f10\u514b", "\u6ce2\u5170", "\u5308\u7259\u5229", "\u975e\u6d32\u897f\u5317", "\u963f\u5c14\u53ca\u5229\u4e9a\u5357\u90e8", "\u5229\u6bd4\u4e9a", "\u57c3\u53ca", "\u7ea2\u6d77", "\u963f\u62c9\u4f2f\u534a\u5c9b\u897f\u90e8", "\u4e4d\u5f97", "\u82cf\u4e39\u4e0d\u507f", "\u57c3\u585e\u4fc4\u6bd4\u4e9a", "\u4e9a\u4e01\u6e7e\u897f\u90e8", "\u7d22\u9a6c\u91cc\u897f\u5317\u90e8", "\u975e\u6d32\u897f\u5317\u90e8\u5357\u5cb8\u8fdc\u6d77", "\u5580\u9ea6\u9686", "\u8d64\u9053\u51e0\u5185\u4e9a", "\u4e2d\u975e\u5171\u548c\u56fd", "\u52a0\u7bf7", "\u521a\u679c", "\u521a\u679c\u6c11\u4e3b\u5171\u548c\u56fd(\u624e\u4f0a\u5c14) ", "\u4e4c\u5e72\u8fbe", "\u7ef4\u591a\u5229\u4e9a\u6e56\u5730\u533a", "\u80af\u5c3c\u4e9a", "\u7d22\u9a6c\u91cc\u5357\u90e8", "\u5766\u5676\u5c3c\u5580\u6e56\u5730\u533a", "\u5766\u6851\u5c3c\u4e9a", "\u9a6c\u8fbe\u52a0\u65af\u52a0\u897f\u5317", "\u5b89\u54e5\u62c9", "\u8d5e\u6bd4\u4e9a", "\u9a6c\u62c9\u7ef4", "\u7eb3\u7c73\u6bd4\u4e9a", "\u535a\u8328\u74e6\u7eb3", "\u6d25\u5df4\u5e03\u97e6", "\u83ab\u6851\u6bd4\u514b", "\u83ab\u6851\u6bd4\u514b\u6d77\u5ce1", "\u9a6c\u8fbe\u52a0\u65af\u52a0", "\u5357\u975e", "\u83b1\u7d22\u6258", "\u65af\u5a01\u58eb\u5170", "\u5357\u975e\u6cbf\u5cb8\u8fdc\u6d77", "\u6fb3\u5927\u5229\u4e9a\u897f\u5317", "\u6fb3\u5927\u5229\u4e9a\u4ee5\u897f", "\u6fb3\u5927\u5229\u4e9a\u897f\u90e8", "\u6fb3\u5927\u5229\u4e9a\u5317\u90e8\u5730\u65b9", "\u6fb3\u5927\u5229\u4e9a\u5357\u6fb3\u5927\u5229\u4e9a\u5dde", "\u6fb3\u5927\u5229\u4e9a\u5361\u5954\u5854\u5229\u4e9a\u6e7e", "\u6fb3\u5927\u5229\u4e9a\u6606\u58eb\u5170\u5dde", "\u73ca\u745a\u6d77", "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a\u897f\u5317", "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a\u897f\u5357", "\u6fb3\u5927\u5229\u4e9a\u897f\u5357", "\u6fb3\u5927\u5229\u4e9a\u5357\u5cb8\u8fdc\u6d77", "\u6fb3\u5927\u5229\u4e9a\u5357\u5cb8\u8fd1\u6d77", "\u6fb3\u5927\u5229\u4e9a\u65b0\u5357\u5a01\u5c14\u58eb\u5dde", "\u6fb3\u5927\u5229\u4e9a\u7ef4\u591a\u5229\u4e9a\u5dde", "\u6fb3\u5927\u5229\u4e9a\u4e1c\u5357\u6cbf\u5cb8\u8fd1\u6d77", "\u6fb3\u5927\u5229\u4e9a\u4e1c\u5cb8\u8fd1\u6d77", "\u6fb3\u5927\u5229\u4e9a\u4ee5\u4e1c", "\u6fb3\u5927\u5229\u4e9a\u8bfa\u798f\u514b\u5c9b\u5730\u533a", "\u65b0\u897f\u5170\u897f\u5317", "\u6fb3\u5927\u5229\u4e9a\u5df4\u65af\u6d77\u5ce1", "\u6fb3\u5927\u5229\u4e9a\u5854\u65af\u9a6c\u5c3c\u4e9a\u5dde\u5730\u533a", "\u6fb3\u5927\u5229\u4e9a\u4e1c\u5357", "\u5317\u592a\u5e73\u6d0b", "\u590f\u5a01\u5937\u7fa4\u5c9b\u5730\u533a", "\u7f8e\u56fd\u590f\u5a01\u5937\u7fa4\u5c9b", "\u52a0\u7f57\u6797\u7fa4\u5c9b\u4ee5\u4e1c[\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a]", "\u9a6c\u7ecd\u5c14\u7fa4\u5c9b\u5730\u533a", "\u57c3\u5c3c\u5a01\u6258\u514b\u73af\u7901\u5730\u533a[\u9a6c\u7ecd\u5c14\u7fa4\u5c9b]", "\u6bd4\u57fa\u5c3c\u73af\u7901\u5730\u533a[\u9a6c\u7ecd\u5c14\u7fa4\u5c9b]", "\u5409\u5c14\u4f2f\u7279\u7fa4\u5c9b\u5730\u533a[\u57fa\u91cc\u5df4\u65af]", "\u7ea6\u7ff0\u65af\u987f\u5c9b\u5730\u533a[\u5927\u6d0b\u6d32]", "\u83b1\u6069\u7fa4\u5c9b\u5730\u533a[\u57fa\u91cc\u5df4\u65af]", "\u5df4\u5c14\u7c73\u62c9\u73af\u7901\u5730\u533a[\u57fa\u91cc\u5df4\u65af]", "\u5723\u8bde\u5c9b\u5730\u533a[\u57fa\u91cc\u5df4\u65af]", "\u56fe\u74e6\u5362\u5730\u533a", "\u83f2\u5c3c\u514b\u65af\u7fa4\u5c9b\u5730\u533a[\u57fa\u91cc\u5df4\u65af]", "\u6258\u514b\u52b3\u7fa4\u5c9b\u5730\u533a[\u5927\u6d0b\u6d32]", "\u65b0\u897f\u5170\u5e93\u514b\u7fa4\u5c9b\u5317\u90e8", "\u65b0\u897f\u5170\u5e93\u514b\u7fa4\u5c9b\u5730\u533a", "\u793e\u4f1a\u7fa4\u5c9b\u5730\u533a[\u6ce2\u5229\u5c3c\u897f\u4e9a]", "\u571f\u5e03\u827e\u7fa4\u5c9b\u5730\u533a[\u6ce2\u5229\u5c3c\u897f\u4e9a]", "\u9a6c\u514b\u8428\u65af\u7fa4\u5c9b\u5730\u533a[\u6ce2\u5229\u5c3c\u897f\u4e9a]", "\u571f\u963f\u83ab\u571f\u7fa4\u5c9b\u5730\u533a[\u6ce2\u5229\u5c3c\u897f\u4e9a]", "\u5357\u592a\u5e73\u6d0b", "\u7f57\u8499\u8bfa\u7d22\u592b\u6d77\u5cad[\u5317\u51b0\u6d0b]", "\u5317\u51b0\u6d0b", "\u683c\u9675\u5170\u5c9b\u5317\u5cb8\u8fd1\u6d77", "\u683c\u9675\u5170\u5c9b\u4e1c\u90e8", "\u51b0\u5c9b\u5730\u533a", "\u51b0\u5c9b", "\u632a\u5a01\u626c\u9a6c\u5ef6\u5c9b\u5730\u533a", "\u683c\u9675\u5170\u6d77", "\u632a\u5a01\u65af\u74e6\u5c14\u5df4\u7fa4\u5c9b\u4ee5\u5317", "\u632a\u5a01\u6d77", "\u632a\u5a01\u65af\u74e6\u5c14\u5df4\u7fa4\u5c9b\u5730\u533a", "\u4fc4\u7f57\u65af\u6cd5\u5170\u58eb\u7ea6\u745f\u592b\u5730\u7fa4\u5c9b\u4ee5\u5317", "\u4fc4\u7f57\u65af\u6cd5\u5170\u58eb\u7ea6\u745f\u592b\u5730\u7fa4\u5c9b", "\u632a\u5a01\u5317\u90e8", "\u5df4\u4f26\u652f\u6d77[\u5317\u51b0\u6d0b]", "\u4fc4\u7f57\u65af\u65b0\u5730\u5c9b", "\u5580\u62c9\u6d77[\u5317\u51b0\u6d0b]", "\u4fc4\u7f57\u65af\u897f\u4f2f\u5229\u4e9a\u897f\u90e8\u6cbf\u5cb8\u8fd1\u6d77", "\u4fc4\u7f57\u65af\u5317\u5730\u7fa4\u5c9b\u4ee5\u5317", "\u4fc4\u7f57\u65af\u5317\u5730\u7fa4\u5c9b", "\u4fc4\u7f57\u65af\u897f\u4f2f\u5229\u4e9a\u4e2d\u90e8\u6cbf\u5cb8\u8fd1\u6d77", "\u4fc4\u7f57\u65af\u5317\u5730\u7fa4\u5c9b\u4ee5\u4e1c", "\u62c9\u666e\u6377\u592b\u6d77[\u5317\u51b0\u6d0b]", "\u4fc4\u7f57\u65af\u897f\u4f2f\u5229\u4e9a\u4e1c\u5357\u90e8", "\u4fc4\u7f57\u65af\u4e1c\u90e8-\u4e2d\u56fd\u4e1c\u5317\u8fb9\u5883\u5730\u533a", "\u4e2d\u56fd\u4e1c\u5317\u90e8", "\u671d\u9c9c", "\u65e5\u672c\u6d77", "\u4fc4\u7f57\u65af\u4e1c\u5357\u6cbf\u5cb8\u8fd1\u6d77", "\u4fc4\u7f57\u65af\u8428\u54c8\u6797\u5c9b(\u5e93\u9875\u5c9b)", "\u9102\u970d\u6b21\u514b\u6d77", "\u4e2d\u56fd\u4e1c\u5357\u90e8", "\u4e2d\u56fd\u9ec4\u6d77", "\u4e2d\u56fd\u4e1c\u90e8\u6cbf\u5cb8\u8fdc\u6d77", "\u4fc4\u7f57\u65af\u65b0\u897f\u4f2f\u5229\u4e9a\u7fa4\u5c9b\u4ee5\u5317", "\u4fc4\u7f57\u65af\u65b0\u897f\u4f2f\u5229\u4e9a\u7fa4\u5c9b", "\u4e1c\u897f\u4f2f\u5229\u4e9a\u6d77", "\u4fc4\u7f57\u65af\u897f\u4f2f\u5229\u4e9a\u4e1c\u90e8\u5317\u5cb8\u8fd1\u6d77", "\u4fc4\u7f57\u65af\u897f\u4f2f\u5229\u4e9a\u4e1c\u90e8", "\u695a\u79d1\u5947\u6d77[\u5317\u51b0\u6d0b]", "\u767d\u4ee4\u6d77\u5ce1", "\u7f8e\u56fd\u963f\u62c9\u65af\u52a0\u5dde\u5723\u52b3\u4f26\u65af\u5c9b\u5730\u533a", "\u6ce2\u5f17\u7279\u6d77[\u5317\u51b0\u6d0b\u6d0b]", "\u7f8e\u56fd\u963f\u62c9\u65af\u52a0\u5dde\u5317\u90e8", "\u52a0\u62ff\u5927\u80b2\u7a7a\u5730\u533a\u5317\u90e8", "\u52a0\u62ff\u5927\u4f0a\u4e3d\u838e\u767d\u5973\u738b\u7fa4\u5c9b", "\u52a0\u62ff\u5927\u897f\u5317\u5730\u533a", "\u683c\u9675\u5170\u5c9b\u897f\u90e8", "\u5df4\u82ac\u6e7e", "\u52a0\u62ff\u5927\u5df4\u82ac\u5c9b\u5730\u533a", "\u4e2d\u592a\u5e73\u6d0b\u4e1c\u5357", "\u4e1c\u592a\u5e73\u6d0b\u6d77\u5cad\u5357\u90e8", "\u590d\u6d3b\u8282\u5c9b\u5730\u533a", "\u897f\u667a\u5229\u6d77\u5cad", "\u667a\u5229\u80e1\u5b89\u00b7\u8d39\u5c14\u5357\u5fb7\u65af\u7fa4\u5c9b\u5730\u533a", "\u65b0\u897f\u5170\u5317\u5c9b\u4ee5\u4e1c", "\u65b0\u897f\u5170\u67e5\u5854\u59c6\u7fa4\u5c9b\u5730\u533a", "\u65b0\u897f\u5170\u67e5\u5854\u59c6\u7fa4\u5c9b\u4ee5\u5357", "\u592a\u5e73\u6d0b-\u5357\u6781\u6d32\u6d77\u5cad", "\u592a\u5e73\u6d0b\u5357\u90e8", "\u4e2d\u592a\u5e73\u6d0b\u4e1c\u90e8", "\u4e1c\u592a\u5e73\u6d0b\u6d77\u5cad\u4e2d\u90e8", "\u5384\u74dc\u591a\u5c14\u52a0\u62c9\u5e15\u6208\u65af\u7fa4\u5c9b\u4ee5\u897f", "\u5384\u74dc\u591a\u5c14\u52a0\u62c9\u5e15\u6208\u65af\u7fa4\u5c9b\u5730\u533a", "\u5384\u74dc\u591a\u5c14\u52a0\u62c9\u5e15\u6208\u65af\u7fa4\u5c9b", "\u5384\u74dc\u591a\u5c14\u52a0\u62c9\u5e15\u6208\u65af\u7fa4\u5c9b\u897f\u5357", "\u5384\u74dc\u591a\u5c14\u52a0\u62c9\u5e15\u6208\u65af\u7fa4\u5c9b\u4e1c\u5357", "\u6fb3\u5927\u5229\u4e9a\u5854\u65af\u9a6c\u5c3c\u4e9a\u5dde\u4ee5\u5357", "\u9ea6\u5938\u91cc\u5c9b\u4ee5\u897f[\u592a\u5e73\u6d0b]", "\u5357\u6781\u6d32\u5df4\u52d2\u5c3c\u7fa4\u5c9b\u5730\u533a", "\u5370\u5ea6\u5b89\u8fbe\u66fc\u7fa4\u5c9b\u5730\u533a", "\u5370\u5ea6\u5c3c\u79d1\u5df4\u7fa4\u5c9b\u5730\u533a  ", "\u5370\u5c3c\u82cf\u95e8\u7b54\u814a\u5c9b\u5317\u90e8\u897f\u5cb8\u8fdc\u6d77", "\u5370\u5c3c\u82cf\u95e8\u7b54\u814a\u5c9b\u5317\u90e8", "\u9a6c\u6765\u534a\u5c9b", "\u6cf0\u56fd\u6e7e", "\u963f\u5bcc\u6c57\u4e1c\u5357\u90e8", "\u5df4\u57fa\u65af\u5766", "\u514b\u4ec0\u7c73\u5c14\u897f\u5357\u90e8", "\u5370\u5ea6-\u5df4\u57fa\u65af\u5766\u8fb9\u5883\u5730\u533a", "\u54c8\u8428\u514b\u65af\u5766\u4e2d\u90e8", "\u4e4c\u5179\u522b\u514b\u65af\u5766\u4e1c\u5357\u90e8", "\u5854\u5409\u514b\u65af\u5766", "\u5409\u5c14\u5409\u65af\u65af\u5766", "\u963f\u5bcc\u6c57-\u5854\u5409\u514b\u65af\u5766\u8fb9\u5883\u5730\u533a", "\u5174\u90fd\u5e93\u4ec0\u5730\u533a", "\u5854\u5409\u514b\u65af\u5766-\u4e2d\u56fd\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a\u8fb9\u5883\u5730\u533a", "\u514b\u4ec0\u7c73\u5c14\u897f\u5317\u90e8", "\u82ac\u5170", "\u632a\u5a01-\u4fc4\u7f57\u65af\u8fb9\u5883\u5730\u533a", "\u82ac\u5170-\u4fc4\u7f57\u65af\u8fb9\u5883\u5730\u533a", "\u6ce2\u7f57\u7684\u6d77-\u767d\u4fc4\u7f57\u65af-\u4fc4\u7f57\u65af\u897f\u5317\u90e8\u8fb9\u5883\u5730\u533a", "\u4fc4\u7f57\u65af\u897f\u4f2f\u5229\u4e9a\u897f\u5317\u90e8", "\u4fc4\u7f57\u65af\u897f\u4f2f\u5229\u4e9a\u4e2d\u5317\u90e8", "\u5357\u6781\u6d32\u7ef4\u591a\u5229\u4e9a\u5730", "\u5357\u6781\u6d32\u7f57\u65af\u6d77", "\u5357\u6781\u6d32", "\u4e1c\u592a\u5e73\u6d0b\u6d77\u5cad\u5317\u90e8", "\u6d2a\u90fd\u62c9\u65af\u4ee5\u5317", "\u5357\u6851\u5a01\u5947\u7fa4\u5c9b\u4ee5\u4e1c[\u5927\u897f\u6d0b]", "\u6cf0\u56fd", "\u8001\u631d", "\u67ec\u57d4\u5be8", "\u8d8a\u5357", "\u5317\u90e8\u6e7e", "\u96f7\u514b\u96c5\u5185\u65af\u6d77\u5cad[\u5927\u897f\u6d0b]", "\u4e9a\u901f\u5c14-\u5723\u6587\u68ee\u7279\u89d2\u6d77\u5cad[\u5927\u897f\u6d0b]", "\u6b27\u6587\u65ad\u88c2\u5e26\u5730\u533a[\u5370\u5ea6\u6d0b]", "\u5370\u5ea6\u6d0b\u6d77\u5cad", "\u897f\u5370\u5ea6\u6d0b-\u5357\u6781\u6d32\u6d77\u5cad", "\u897f\u6492\u54c8\u62c9", "\u6bdb\u91cc\u5854\u5c3c\u4e9a", "\u9a6c\u91cc", "\u5188\u6bd4\u4e9a\u5730\u533a", "\u51e0\u5185\u4e9a\u5730\u533a", "\u585e\u62c9\u5229\u6602", "\u5229\u6bd4\u91cc\u4e9a", "\u79d1\u7279\u8fea\u74e6", "\u5e03\u57fa\u7eb3\u6cd5\u7d22", "\u52a0\u7eb3", "\u8d1d\u5b81-\u591a\u54e5\u5730\u533a", "\u5c3c\u65e5\u5c14", "\u5c3c\u65e5\u5229\u4e9a", "\u590d\u6d3b\u8282\u5c9b\u4e1c\u5357", "\u52a0\u62c9\u5e15\u6208\u65af\u6d77\u5cad\u5730\u533a[\u592a\u5e73\u6d0b]"};
        feGeoRegionsNames = new String[]{"Central Alaska", "Southern Alaska", "Bering Sea", "Komandorskiye Ostrova Region", "Near Islands, Aleutian Islands", "Rat Islands, Aleutian Islands", "Andreanof Islands, Aleutian Islands", "Pribilof Islands, Alaska Region", "Fox Islands, Aleutian Islands", "Unimak Island Region, Alaska", "Bristol Bay", "Alaska Peninsula", "Kodiak Island Region, Alaska", "Kenai Peninsula, Alaska", "Gulf of Alaska", "South of Aleutian Islands", "South of Alaska", "Southern Yukon Territory, Canada", "Southeastern Alaska", "Off Coast of Southeastern Alaska", "West of Vancouver Island", "Queen Charlotte Islands Region", "British Columbia, Canada", "Alberta, Canada", "Vancouver Island, Canada Region", "Off Coast of Washington", "Near Coast of Washington", "Washington-Oregon Border Region", "Washington", "Off Coast of Oregon", "Near Coast of Oregon", "Oregon", "Western Idaho", "Off Coast of N. California", "Near Coast of N. California", "Northern California", "Nevada", "Off Coast of California", "Central California", "California-Nevada Border Region", "Southern Nevada", "Western Arizona", "Southern California", "California-Arizona Border Region", "Calif.-Baja Calif. Border Region", "W. Arizona-Sonora Border Region", "Off W Coast of Baja California", "Baja California, Mexico", "Gulf of California", "Sonora, Mexico", "Off Coast of Central Mexico", "Near Coast of Central Mexico", "Revilla Gigedo Islands Region", "Off Coast of Jalisco, Mexico", "Near Coast of Jalisco, Mexico", "Near Coast of Michoacan, Mexico", "Michoacan, Mexico", "Near Coast of Guerrero, Mexico", "Guerrero, Mexico", "Oaxaca, Mexico", "Chiapas, Mexico", "Mexico-Guatemala Border Region", "Off Coast of Mexico", "Off Coast of Michoacan, Mexico", "Off Coast of Guerrero, Mexico", "Near Coast of Oaxaca, Mexico", "Off Coast of Oaxaca, Mexico", "Off Coast of Chiapas, Mexico", "Near Coast of Chiapas, Mexico", "Guatemala", "Near Coast of Guatemala", "Honduras", "El Salvador", "Near Coast of Nicaragua", "Nicaragua", "Off Coast of Central America", "Off Coast of Costa Rica", "Costa Rica", "North of Panama", "Panama-Costa Rica Border Region", "Panama", "Panama-Colombia Border Region", "South of Panama", "Yucatan Peninsula, Mexico", "Cuba Region", "Jamaica Region", "Haiti Region", "Dominican Republic Region", "Mona Passage", "Puerto Rico Region", "Virgin Islands", "Leeward Islands", "Belize", "Caribbean Sea", "Windward Islands", "Near North Coast of Colombia", "Near Coast of Venezuela", "Trinidad", "Northern Colombia", "Lake Maracaibo, Venezuela", "Venezuela", "Near West Coast of Colombia", "Colombia", "Off Coast of Ecuador", "Near Coast of Ecuador", "Colombia-Ecuador Border Region", "Ecuador", "Off Coast of Northern Peru", "Near Coast of Northern Peru", "Peru-Ecuador Border Region", "Northern Peru", "Peru-Brazil Border Region", "Western Brazil", "Off Coast of Peru", "Near Coast of Peru", "Central Peru", "Southern Peru", "Peru-Bolivia Border Region", "Northern Bolivia", "Central Bolivia", "Off Coast of Northern Chile", "Near Coast of Northern Chile", "Northern Chile", "Chile-Bolivia Border Region", "Southern Bolivia", "Paraguay", "Chile-Argentina Border Region", "Jujuy Province, Argentina", "Salta Province, Argentina", "Catamarca Province, Argentina", "Tucuman Province, Argentina", "Santiago Del Estero Prov., Argentina", "Northeastern Argentina", "Off Coast of Central Chile", "Near Coast of Central Chile", "Central Chile", "San Juan Province, Argentina", "La Rioja Province, Argentina", "Mendoza Province, Argentina", "San Luis Province, Argentina", "Cordoba Province, Argentina", "Uruguay", "Off Coast of Southern Chile", "Southern Chile", "S. Chile-Argentina Border Region", "Southern Argentina", "Tierra Del Fuego", "Falkland Islands Region", "Drake Passage", "Scotia Sea", "South Georgia Island Region", "South Georgia Rise", "South Sandwich Islands Region", "South Shetland Islands", "Antarctic Peninsula", "Southwestern Atlantic Ocean", "Weddell Sea", "Off W. Coast of N. Island, N.Z.", "North Island, New Zealand", "Off E. Coast of N. Island, N.Z.", "Off W. Coast of S. Island, N.Z.", "South Island, New Zealand", "Cook Strait, New Zealand", "Off E. Coast of S. Island, N.Z.", "North of Macquarie Island", "Auckland Islands, N.Z. Region", "Macquarie Island Region", "South of New Zealand", "Samoa Islands Region", "Samoa Islands", "South of Fiji Islands", "West of Tonga Islands", "Tonga Islands", "Tonga Islands Region", "South of Tonga Islands", "North of New Zealand", "Kermadec Islands Region", "Kermadec Islands, New Zealand", "South of Kermadec Islands", "North of Fiji Islands", "Fiji Islands Region", "Fiji Islands", "Santa Cruz Islands Region", "Santa Cruz Islands", "Vanuatu Islands Region", "Vanuatu Islands", "New Caledonia", "Loyalty Islands", "Southeast of Loyalty Islands", "New Ireland Region, P.N.G.", "North of Solomon Islands", "New Britain Region, P.N.G.", "Solomon Islands", "D'Entrecasteaux Islands Region", "South of Solomon Islands", "Irian Jaya Region, Indonesia", "Near North Coast of Irian Jaya", "Ninigo Islands Region, P.N.G.", "Admiralty Islands Region, P.N.G.", "Near N. Coast of New Guinea, PNG.", "Irian Jaya, Indonesia", "New Guinea, Papua New Guinea", "Bismarck Sea", "Aru Islands Region, Indonesia", "Near South Coast of Irian Jaya", "Near S. Coast of New Guinea, PNG.", "Eastern New Guinea Reg., P.N.G.", "Arafura Sea", "W. Caroline Islands, Micronesia", "South of Mariana Islands", "Southeast of Honshu, Japan", "Bonin Islands, Japan Region", "Volcano Islands, Japan Region", "West of Mariana Islands", "Mariana Islands Region", "Mariana Islands", "Kamchatka Peninsula, Russia", "Near East Coast of Kamchatka", "Off East Coast of Kamchatka", "Northwest of Kuril Islands", "Kuril Islands", "East of Kuril Islands", "Eastern Sea of Japan", "Hokkaido, Japan Region", "Off Coast of Hokkaido, Japan", "Near West Coast of Honshu, Japan", "Eastern Honshu, Japan", "Near East Coast of Honshu, Japan", "Off East Coast of Honshu, Japan", "Near S. Coast of Honshu, Japan", "South Korea", "Western Honshu, Japan", "Near S. Coast of Western Honshu", "Northwest of Ryukyu Islands", "Kyushu, Japan", "Shikoku, Japan", "Southeast of Shikoku, Japan", "Ryukyu Islands, Japan", "Southeast of Ryukyu Islands", "West of Bonin Islands", "Philippine Sea", "Near Coast of Southeastern China", "Taiwan Region", "Taiwan", "Northeast of Taiwan", "Southwestern Ryukyu Islands, Japan", "Southeast of Taiwan", "Philippine Islands Region", "Luzon, Philippines", "Mindoro, Philippines", "Samar, Philippines", "Palawan, Philippines", "Sulu Sea", "Panay, Philippines", "Cebu, Philippines", "Leyte, Philippines", "Negros, Philippines", "Sulu Archipelago, Philippines", "Mindanao, Philippines", "East of Philippine Islands", "Borneo", "Celebes Sea", "Talaud Islands, Indonesia", "North of Halmahera, Indonesia", "Minahassa Peninsula, Sulawesi", "Northern Molucca Sea", "Halmahera, Indonesia", "Sulawesi, Indonesia", "Southern Molucca Sea", "Ceram Sea", "Buru, Indonesia", "Seram, Indonesia", "Southwest of Sumatra, Indonesia", "Southern Sumatra, Indonesia", "Java Sea", "Sunda Strait, Indonesia", "Java, Indonesia", "Bali Sea", "Flores Sea", "Banda Sea", "Tanimbar Islands Reg., Indonesia", "South of Java, Indonesia", "Bali Region, Indonesia", "South of Bali, Indonesia", "Sumbawa Region, Indonesia", "Flores Region, Indonesia", "Sumba Region, Indonesia", "Savu Sea", "Timor Region", "Timor Sea", "South of Sumbawa, Indonesia", "South of Sumba, Indonesia", "South of Timor, Indonesia", "Myanmar-India Border Region", "Myanmar-Bangladesh Border Region", "Myanmar", "Myanmar-China Border Region", "Near South Coast of Myanmar", "Southeast Asia", "Hainan Island, China", "South China Sea", "Eastern Kashmir", "Kashmir-India Border Region", "Kashmir-Xizang, China Border Region", "Western-Xizang, China India Border Reg.", "Xizang, China", "Sichuan, China", "Northern India", "Nepal-India Border Region", "Nepal", "Sikkim, India", "Bhutan", "Eastern Xizang, China-India Border Reg.", "Southern India", "India-Bangladesh Border Region", "Bangladesh", "Northeastern India", "Yunnan, China", "Bay of Bengal", "Kyrgyzstan-Xinjiang, China Border Reg.", "Southern Xinjiang, China", "Gansu, China", "Western Nei Mongol, China", "Kashmir-Xinjiang, China Border Region", "Qinghai, China", "Southwestern Siberia, Russia", "Lake Baykal Region, Russia", "East of Lake Baykal, Russia", "Eastern Kazakhstan", "Lake Issyk Kul Region", "Kazakhstan-Xinjiang, China Border Reg.", "Northern Xinjiang, China", "Russia-Mongolia Border Region", "Mongolia", "Ural Mountains Region, Russia", "Western Kazakhstan", "Eastern Caucasus", "Caspian Sea", "Northwestern Uzbekistan", "Turkmenistan", "Turkmenistan-Iran Border Region", "Turkmenistan-Afghanistan Border Reg.", "Turkey-Iran Border Region", "Armenia-Azerbaijan-Iran Border Reg.", "Northwestern Iran", "Iran-Iraq Border Region", "Western Iran", "Northern and Central Iran", "Northwestern Afghanistan", "Southwestern Afghanistan", "Eastern Arabian Peninsula", "Persian Gulf", "Southern Iran", "Southwestern Pakistan", "Gulf of Oman", "Off Coast of Pakistan", "Ukraine/Moldova/SW Russia Region", "Romania", "Bulgaria", "Black Sea", "Crimea Region, Ukraine", "Northwestern Caucasus", "Greece Bulgaria Border Region", "Greece", "Aegean Sea", "Turkey", "Georgia Armenia Turkey Border Reg.", "Southern Greece", "Dodecanese Islands, Greece", "Crete, Greece", "Eastern Mediterranean Sea", "Cyprus Region", "Dead Sea Region", "Jordan/Syria Region", "Iraq", "Portugal", "Spain", "Pyrenees", "Near South Coast of France", "Corsica, France", "Central Italy", "Adriatic Sea", "NW Balkan Region", "West of Gibraltar", "Strait of Gibraltar", "Balearic Islands, Spain", "Western Mediterranean Sea", "Sardinia, Italy", "Tyrrhenian Sea", "Southern Italy", "Albania", "Greece-Albania Border Region", "Madeira Islands, Portugal Region", "Canary Islands, Spain Region", "Morocco", "Northern Algeria", "Tunisia", "Sicily, Italy", "Ionian Sea", "Central Mediterranean Sea", "Near Coast of Libya", "North Atlantic Ocean", "Northern Mid Atlantic Ridge", "Azores Islands Region", "Azores Islands, Portugal", "Central Mid Atlantic Ridge", "North of Ascension Island", "Ascension Island Region", "South Atlantic Ocean", "Southern Mid Atlantic Ridge", "Tristan da Cunha Region", "Bouvet Island Region", "Southwest of Africa", "Southeastern Atlantic Ocean", "Eastern Gulf of Aden", "Socotra Region", "Arabian Sea", "Lakshadweep Region, India", "Northeastern Somalia", "North Indian Ocean", "Carlsberg Ridge", "Maldive Islands Region", "Laccadive Sea", "Sri Lanka", "South Indian Ocean", "Chagos Archipelago Region", "Mauritius/Reunion Region", "Southwest Indian Ridge", "Mid Indian Ridge", "South of Africa", "Prince Edward Islands Region", "Crozet Islands Region", "Kerguelen Islands Region", "Broken Ridge", "Southeast Indian Ridge", "Southern Kerguelen Plateau", "South of Australia", "Saskatchewan, Canada", "Manitoba, Canada", "Hudson Bay", "Ontario, Canada", "Hudson Strait Region, Canada", "Northern Quebec, Canada", "Davis Strait", "Labrador, Canada", "Labrador Sea", "Southern Quebec, Canada", "Gaspe Peninsula, Canada", "Eastern Quebec, Canada", "Anticosti Island, Canada", "New Brunswick, Canada", "Nova Scotia, Canada", "Prince Edward Island, Canada", "Gulf of St. Lawrence", "Newfoundland, Canada", "Montana", "Eastern Idaho", "Hebgen Lake Region", "Yellowstone Region, Wyoming", "Wyoming", "North Dakota", "South Dakota", "Nebraska", "Minnesota", "Iowa", "Wisconsin", "Illinois", "Michigan", "Indiana", "Southern Ontario, Canada", "Ohio", "New York", "Pennsylvania", "Vermont New Hampshire Region", "Maine", "Southern New England", "Gulf of Maine", "Utah", "Colorado", "Kansas", "Iowa-Missouri Border Region", "Missouri-Kansas Border Region", "Missouri", "Missouri-Arkansas Border Region", "Eastern Missouri", "New Madrid, Missouri Region", "Cape Girardeau, Missouri Region", "Southern Illinois", "Southern Indiana", "Kentucky", "West Virginia", "Virginia", "Chesapeake Bay Region", "New Jersey", "Eastern Arizona", "New Mexico", "Texas Panhandle Region", "Western Texas", "Oklahoma", "Central Texas", "Arkansas-Oklahoma Border Region", "Arkansas", "Louisiana-Texas Border Region", "Louisiana", "Mississippi", "Tennessee", "Alabama", "Western Florida", "Georgia, USA", "Florida-Georgia Border Region", "South Carolina", "North Carolina", "Off East Coast of United States", "Florida Peninsula", "Bahama Islands", "E. Arizona-Sonora Border Region", "New Mexico-Chihuahua Border Reg.", "Texas-Mexico Border Region", "Southern Texas", "Near Coast of Texas", "Chihuahua, Mexico", "Northern Mexico", "Central Mexico", "Jalisco, Mexico", "Veracruz, Mexico", "Gulf of Mexico", "Bay of Campeche", "Brazil", "Guyana", "Suriname", "French Guiana", "Ireland", "United Kingdom", "North Sea", "Southern Norway", "Sweden", "Baltic Sea", "France", "Bay of Biscay", "The Netherlands", "Belgium", "Denmark", "Germany", "Switzerland", "Northern Italy", "Austria", "Czech and Slovak Republics", "Poland", "Hungary", "Northwest Africa", "Southern Algeria", "Libya", "Egypt", "Red Sea", "Western Arabian Peninsula", "Chad Region", "Sudan", "Ethiopia", "Western Gulf of Aden", "Northwestern Somalia", "Off S. Coast of Northwest Africa", "Cameroon", "Equatorial Guinea", "Central African Republic", "Gabon", "Republic of Congo", "Democratic Republic of Congo", "Uganda", "Lake Victoria Region", "Kenya", "Southern Somalia", "Lake Tanganyika Region", "Tanzania", "Northwest of Madagascar", "Angola", "Zambia", "Malawi", "Namibia", "Botswana", "Zimbabwe", "Mozambique", "Mozambique Channel", "Madagascar", "South Africa", "Lesotho", "Swaziland", "Off Coast of South Africa", "Northwest of Australia", "West of Australia", "Western Australia", "Northern Territory, Australia", "South Australia", "Gulf of Carpentaria", "Queensland, Australia", "Coral Sea", "Northwest of New Caledonia", "Southwest of New Caledonia", "Southwest of Australia", "Off South Coast of Australia", "Near Coast of South Australia", "New South Wales, Australia", "Victoria, Australia", "Near SE Coast of Australia", "Near East Coast of Australia", "East of Australia", "Norfolk Island, Australia Region", "Northwest of New Zealand", "Bass Strait, Australia", "Tasmania, Australia Region", "Southeast of Australia", "North Pacific Ocean", "Hawaiian Islands Region", "Hawaii", "E. Caroline Islands, Micronesia", "Marshall Islands Region", "Enewetak Atoll Reg, Marshall Islands", "Bikini Atoll Reg., Marshall Islands", "Gilbert Islands, Kiribati Region", "Johnston Island Region", "Line Islands, Kiribati Region", "Palmyra Island Region, Kiribati", "Kiritimati Region, Kiribati", "Tuvalu Region", "Phoenix Islands, Kiribati Region", "Tokelau Islands Region", "Northern Cook Islands", "Cook Islands Region", "Society Islands Region", "Tubuai Islands Region", "Marquesas Islands Region", "Tuamotu Archipelago Region", "South Pacific Ocean", "Lomonosov Ridge", "Arctic Ocean", "Near North Coast of Greenland", "Eastern Greenland", "Iceland Region", "Iceland", "Jan Mayen Island Region", "Greenland Sea", "North of Svalbard", "Norwegian Sea", "Svalbard Region", "North of Franz Josef Land", "Franz Josef Land, Russia", "Northern Norway", "Barents Sea", "Novaya Zemlya, Russia", "Kara Sea", "Near Coast of Western Siberia, Russia", "North of Severnaya Zemlya", "Severnaya Zemlya, Russia", "Near Coast of Central Siberia, Russia", "East of Severnaya Zemlya", "Laptev Sea", "Southeastern Siberia, Russia", "E Russia-NE China Border Region", "Northeastern China", "North Korea", "Sea of Japan", "Primor'ye, Russia", "Sakhalin, Russia", "Sea of Okhotsk", "Southeastern China", "Yellow Sea, China", "Off coast of Eastern China", "North of New Siberian Islands", "New Siberian Islands, Russia", "East Siberian Sea", "Near Northern Coast of Eastern Siberia", "Eastern Siberia, Russia", "Chukchi Sea", "Bering Strait", "St. Lawrence Island, Alaska Reg.", "Beaufort Sea", "Northern Alaska", "Northern Yukon Territory, Canada", "Queen Elizabeth Islands, Canada", "NW Territories - Nunavut, Canada", "Western Greenland", "Baffin Bay", "Baffin Island Region, Canada", "Southeast Central Pacific Ocean", "Southern East Pacific Rise", "Easter Island Region", "West Chile Rise", "Juan Fernandez Islands Region", "East of North Island, N.Z.", "Chatham Islands, N.Z. Region", "South of Chatham Islands", "Pacific Antarctic Ridge", "Southern Pacific Ocean", "East Central Pacific Ocean", "Central East Pacific Rise", "West of Galapagos Islands", "Galapagos Islands Region", "Galapagos Islands, Ecuador", "Southwest of Galapagos Islands", "Southeast of Galapagos Islands", "South of Tasmania", "West of Macquarie Island", "Balleny Islands Region", "Andaman Islands, India Region", "Nicobar Islands, India Region", "Off West Coast of Northern Sumatra", "Northern Sumatra, Indonesia", "Malay Peninsula", "Gulf of Thailand", "Southeastern Afghanistan", "Pakistan", "Southwestern Kashmir", "India-Pakistan Border Region", "Central Kazakhstan", "Southeastern Uzbekistan", "Tajikistan", "Kyrgyzstan", "Afghanistan-Tajikistan Border Region", "Hindu Kush Region, Afghanistan", "Tajikistan-Xinjiang, China Border Region", "Northwestern Kashmir", "Finland", "Norway-Russia Border Region", "Finland-Russia Border Region", "Baltics/Belarus/Northwestern Russia Reg.", "Northwestern Siberia, Russia", "Northcentral Siberia, Russia", "Victoria Land, Antarctica", "Ross Sea", "Antarctica", "Northern East Pacific Rise", "North of Honduras", "East of South Sandwich Islands", "Thailand", "Laos", "Cambodia", "Vietnam", "Gulf of Tongking", "Reykjanes Ridge", "Azores Cape St. Vincent Ridge", "Owen Fracture Zone Region", "Indian Ocean Triple Junction", "Western Indian Antarctic Ridge", "Western Sahara", "Mauritania", "Mali", "Sengal-Gambia Region", "Guinea Region", "Sierra Leone", "Liberia Region", "Cote D'Ivoire", "Burkina Faso", "Ghana", "Benin-Togo Region", "Niger", "Nigeria", "Southeast of Easter Island", "Galapagos Triple Junction Region"};
    }

    public static String getRegionName(double lat, double lon) {
        String name = RegionsFE.getFeGeoRegionName(lat, lon);
        if (name != "") {
            return name;
        }
        return RegionsFE.getFeGeoRegionName(lat, lon);
    }

    public static String getFeGeoRegionName(double lat, double lon) {
        int _lat = (int)lat;
        int _lon = (int)lon;
        if (lat >= 0.0) {
            ++_lat;
        }
        if (lon >= 0.0) {
            ++_lon;
        }
        if (lat >= -90.0 && lat <= 90.0 && lon >= -180.0 && lon <= 180.0) {
            return feGeoRegionsNames[feGeoRegionsArray[_lat + 90][_lon + 180] - 1];
        }
        return "unknown Region";
    }

    public static String getFeGeoRegionChineseName(double lat, double lon) {
        int _lat = (int)lat;
        int _lon = (int)lon;
        if (lat >= 0.0) {
            ++_lat;
        }
        if (lon >= 0.0) {
            ++_lon;
        }
        if (lat >= -90.0 && lat <= 90.0 && lon >= -180.0 && lon <= 180.0) {
            return feGeoRegionsChineseNames[feGeoRegionsArray[_lat + 90][_lon + 180] - 1];
        }
        return "\u672a\u77e5\u533a\u57df";
    }

    public static int getFeGeoRegionNum(double lat, double lon) {
        int _lat = (int)lat;
        int _lon = (int)lon;
        if (lat >= 0.0) {
            ++_lat;
        }
        if (lon >= 0.0) {
            ++_lon;
        }
        if (lat >= -90.0 && lat <= 90.0 && lon >= -180.0 && lon <= 180.0) {
            return feGeoRegionsArray[_lat + 90][_lon + 180];
        }
        return -1;
    }

    public static void main(String[] args) {
        String fe = RegionsFE.getFeGeoRegionName(30.0, 90.0);
        String cfe = RegionsFE.getFeGeoRegionChineseName(30.0, 90.0);
        int num = RegionsFE.getFeGeoRegionNum(30.0, 90.0);
        System.out.println("fe=" + fe + ",cfe=" + cfe + ", " + num);
    }
}

