/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.regions;

import cn.org.gddsn.seis.regions.KMLReader;
import cn.org.gddsn.seis.regions.Polygon2D;
import cn.org.gddsn.seis.regions.PolygonCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class PolygonCreator {
    static Logger logger = Logger.getLogger(PolygonCreator.class);
    private static final String namespace = "http://earth.google.com/kml/2.2";

    public PolygonCollection createPolygonCollection(File filePath, String namePath, String coordinatePath) {
        return this.createPolygonCollection(filePath, namespace, namePath, coordinatePath);
    }

    public PolygonCollection createPolygonCollection(File filePath, String namespace, String namePath, String coordinatePath) {
        String fn = filePath.getAbsolutePath();
        KMLReader kmlReader = new KMLReader();
        kmlReader.setNamespace(namespace);
        List<Element> nameList = kmlReader.getElementList(fn, namePath);
        List<Element> coordinatesList = kmlReader.getElementList(fn, coordinatePath);
        boolean hasName = false;
        if (nameList.size() == coordinatesList.size()) {
            hasName = true;
        }
        ArrayList<Polygon2D> polygonList = new ArrayList<Polygon2D>();
        int i = 0;
        while (i < coordinatesList.size()) {
            String name = hasName ? nameList.get(i).getText() : "";
            Polygon2D newPolygon2D = this.createPolygon(name, coordinatesList.get(i).getText());
            polygonList.add(newPolygon2D);
            ++i;
        }
        String Name = fn.substring(fn.lastIndexOf("/") + 1, fn.lastIndexOf("."));
        return new PolygonCollection(Name, polygonList);
    }

    public Polygon2D createPolygon(String name, String coordinates) {
        StringTokenizer spaceToken = new StringTokenizer(coordinates);
        ArrayList<Double> Xcoordinates = new ArrayList<Double>();
        ArrayList<Double> Ycoordinates = new ArrayList<Double>();
        while (spaceToken.hasMoreTokens()) {
            StringTokenizer commaToken = new StringTokenizer(spaceToken.nextToken(), ",");
            double x = Double.parseDouble(commaToken.nextToken().trim());
            double y = Double.parseDouble(commaToken.nextToken().trim());
            Xcoordinates.add(x);
            Ycoordinates.add(y);
        }
        return new Polygon2D(name, Xcoordinates, Ycoordinates);
    }

    public static void main(String[] args) {
        String namespace = "http://www.opengis.net/kml/2.2";
        File filePath = new File("/Users/szj/Downloads/ttflod.kml");
        String namePath = "//tns:Placemark/tns:name";
        String coordinatePath = "//tns:Placemark/tns:Polygon/tns:outerBoundaryIs/tns:LinearRing/tns:coordinates";
        PolygonCreator pc = new PolygonCreator();
        PolygonCollection polygonCollection = pc.createPolygonCollection(filePath, namespace, namePath, coordinatePath);
        Polygon2D[] polygons = polygonCollection.getPolygons();
        int i = 0;
        while (i < polygons.length) {
            System.out.println(polygons[i].toString());
            ++i;
        }
    }
}

