/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.regions;

import cn.org.gddsn.seis.regions.Bounds2D;
import cn.org.gddsn.seis.regions.Polygon2D;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonCollection {
    List<Polygon2D> polygonList;
    public String NAME;

    public PolygonCollection(String NAME, List<Polygon2D> polygonList) {
        this.NAME = NAME;
        this.polygonList = polygonList;
    }

    public void addPolygon(Polygon2D polygon2D) {
        this.polygonList.add(polygon2D);
    }

    public Polygon2D getPolygonByPoint(double x, double y) {
        boolean boolContains = false;
        int i = 0;
        while (i < this.polygonList.size()) {
            Polygon2D iPolygon2D = this.polygonList.get(i);
            boolContains = iPolygon2D.contains(x, y);
            if (boolContains) {
                return iPolygon2D;
            }
            ++i;
        }
        return null;
    }

    public Bounds2D getBounds() {
        if (this.polygonList.size() == 0) {
            return null;
        }
        double boundsMinX = Double.MAX_VALUE;
        double boundsMinY = Double.MAX_VALUE;
        double boundsMaxX = Double.MIN_VALUE;
        double boundsMaxY = Double.MIN_VALUE;
        int i = 0;
        while (i < this.polygonList.size()) {
            Polygon2D iPolygon2D = this.polygonList.get(i);
            boundsMinX = Math.min(boundsMinX, iPolygon2D.getBounds().getMinX());
            boundsMaxX = Math.max(boundsMaxX, iPolygon2D.getBounds().getMaxX());
            boundsMinY = Math.min(boundsMinY, iPolygon2D.getBounds().getMinY());
            boundsMaxY = Math.max(boundsMaxY, iPolygon2D.getBounds().getMaxY());
            ++i;
        }
        return new Bounds2D(boundsMinX, boundsMaxX, boundsMinY, boundsMaxY);
    }

    public Polygon2D[] getPolygons() {
        Polygon2D[] polygons = new Polygon2D[this.polygonList.size()];
        int i = 0;
        while (i < this.polygonList.size()) {
            polygons[i] = this.polygonList.get(i);
            ++i;
        }
        return polygons;
    }

    public static void main(String[] args) {
    }
}

