/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.regions;

import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMLReader {
    static Logger logger = Logger.getLogger(KMLReader.class);
    private String namespace = "http://earth.google.com/kml/2.2";

    public List<Element> getElementList(String filePath, String elementPath) {
        List elementList = null;
        try {
            SAXBuilder sb = new SAXBuilder();
            Document doc = sb.build(filePath);
            Element root = doc.getRootElement();
            XPath nameXPath = XPath.newInstance((String)elementPath);
            Namespace tns = Namespace.getNamespace((String)"tns", (String)this.namespace);
            nameXPath.addNamespace(tns);
            elementList = nameXPath.selectNodes((Object)root);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return elementList;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public static void main(String[] args) {
        String filePath = "maps/gd_buffer.kml";
        String namePath = "//tns:Placemark/tns:name";
        String coordinatePath = "//tns:Placemark/tns:MultiGeometry/tns:Polygon/tns:outerBoundaryIs/tns:LinearRing/tns:coordinates";
        KMLReader kmlReader = new KMLReader();
        List<Element> nameList = kmlReader.getElementList(filePath, namePath);
        List<Element> coordinatesList = kmlReader.getElementList(filePath, coordinatePath);
        int i = 0;
        while (i < nameList.size()) {
            Element nameElement = nameList.get(i);
            System.out.println(nameElement.getText());
            Element coordinatesElement = coordinatesList.get(i);
            System.out.println(String.valueOf(coordinatesElement.getText()) + "\n");
            ++i;
        }
    }
}

