/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.realtimeplot.gui;

import cn.org.gddsn.liss.port.sss.SSSPort;
import cn.org.gddsn.seis.realtimeplot.gui.IPPlotFrame;
import cn.org.gddsn.util.Log4jConfig;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class IPPlotClass {
    static Logger logger = Logger.getLogger(IPPlotClass.class);
    boolean packFrame = true;
    IPPlotFrame frame = null;
    static ApplicationContext ctx;

    public IPPlotClass() {
        ctx = new FileSystemXmlApplicationContext(new String[]{"IPPlot.xml"});
        IPPlotFrame frame = (IPPlotFrame)ctx.getBean("frame");
        frame.loadConfiguration();
        frame.setSize(1024, 768);
        if (this.packFrame) {
            frame.pack();
        } else {
            frame.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
    }

    public void setExtenalPort(SSSPort amssi) {
        this.frame.setExtenalPort(amssi);
    }

    public static void main(String[] args) {
        Log4jConfig.loadForMain((String)"IPPlotClass.properties");
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        new IPPlotClass();
    }
}

