/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.picker;

import org.apache.log4j.Logger;

public class STALTA {
    static Logger logger = Logger.getLogger(STALTA.class);
    private static final int NO_EVENT = 0;
    private static final int EVENT_DETECTED = 2;
    private double HALARM = 8.0;
    private int Detector_State;
    private int STA_SEC = 1;
    private int LTA_SEC = 30;
    private int r0_stalta;
    private double[] StaBuf;
    private double[] LtaBuf;
    private double[] InitBuf;
    private int KSTA;
    private int KLTA;
    private int ilta;
    private int ista;
    private double LTA;
    private double STA;
    private double halarm;
    private boolean firstOnly = true;
    private int sr;
    int samp_m;
    int samp_end;

    public STALTA(boolean firstOnly, int sr) {
        this.firstOnly = firstOnly;
        this.sr = sr;
    }

    public int detect_stalta(double[] val, int ns, double dt) {
        this.Detector_State = 0;
        this.KSTA = (int)((double)this.STA_SEC / dt);
        this.KLTA = (int)((double)this.LTA_SEC / dt);
        this.halarm = this.HALARM;
        int counter = 0;
        this.StaBuf = new double[this.KSTA];
        this.LtaBuf = new double[this.KLTA];
        this.InitBuf = new double[this.KLTA];
        while (counter < this.KLTA) {
            this.InitBuf[counter] = val[counter];
            ++counter;
        }
        if (counter == this.KLTA) {
            this.init_sta_and_lta();
        }
        int i = this.KLTA;
        while (i < ns) {
            this.update_sta_and_lta(val[i]);
            if (this.firstOnly && this.r0_stalta != 0) break;
            this.compare_sta_lta_ratio(i);
            ++i;
        }
        return this.r0_stalta;
    }

    void init_sta_and_lta() {
        this.LTA = 0.0;
        this.ilta = 0;
        while (this.ilta < this.KLTA) {
            this.LtaBuf[this.ilta] = this.InitBuf[this.ilta] * this.InitBuf[this.ilta];
            this.LTA += this.LtaBuf[this.ilta];
            ++this.ilta;
        }
        if (this.LTA == 0.0) {
            this.LTA = 1.0;
        }
        this.ilta = 0;
        this.STA = 0.0;
        this.ista = 0;
        while (this.ista < this.KSTA) {
            this.StaBuf[this.ista] = this.LtaBuf[this.ilta++];
            this.STA += this.StaBuf[this.ista];
            ++this.ista;
        }
        this.ista = 0;
        while (this.ilta < this.KLTA) {
            double x2new;
            double x2old = this.StaBuf[this.ista];
            this.StaBuf[this.ista] = x2new = this.LtaBuf[this.ilta++];
            ++this.ista;
            this.ista %= this.KSTA;
            this.STA += x2new - x2old;
        }
        this.ilta = 0;
    }

    void update_sta_and_lta(double x) {
        double x2new;
        double x2old = this.StaBuf[this.ista];
        this.StaBuf[this.ista] = x2new = x * x;
        ++this.ista;
        this.ista %= this.KSTA;
        this.STA += x2new - x2old;
        x2old = this.LtaBuf[this.ilta];
        this.LtaBuf[this.ilta] = x2new = x * x;
        ++this.ilta;
        this.ilta %= this.KLTA;
        this.LTA += x2new - x2old;
    }

    void compare_sta_lta_ratio(int S) {
        double ratio = this.STA / this.LTA * (double)(this.KLTA / this.KSTA);
        if (this.Detector_State == 0) {
            if (ratio < this.halarm) {
                this.Detector_State = 0;
            }
            if (ratio >= this.halarm) {
                this.Detector_State = 2;
                this.r0_stalta = S;
            }
        }
        if (this.Detector_State == 2) {
            if (ratio >= this.halarm) {
                this.Detector_State = 2;
                this.samp_m = S;
            }
            if (ratio < this.halarm) {
                this.samp_end = S;
                if (this.samp_end - this.samp_m > 180 * this.sr) {
                    this.Detector_State = 0;
                }
            }
        }
    }
}

