/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.picker;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class PPicker {
    public int tdownmax = 50;
    public int tupevent = 100;
    public float thrshl1 = 5.0f;
    public float thrshl2 = 10.0f;
    public float longTermWindow = 50.0f;
    public int ipkflg = 0;
    public int uptime = 0;
    public int uptime0 = 0;
    public long ptime = 0L;
    public int pamp = 0;
    public long pamptime = 0L;
    public long preptime = 0L;
    public int prepamp = 0;
    public long prepamptime = 0L;
    public int ifrst = 0;
    public String pfm = " ";
    public int noise = 0;
    public long noisetime = 0L;
    public int signal = 0;
    public long signaltime = 0L;
    public int sampleRate = 40;
    private long itar = 0L;
    private int amp = 0;
    private long amptime = 0L;
    private int dtime = 0;
    private int p_dur = 6 * this.sampleRate;
    private long end_dur = 0L;
    private float rawold = 0.0f;
    private double ssx = 0.0;
    private double ssx2 = 0.0;
    private double sdev = 0.0;
    private double mean = 3.4028234663852886E38;
    private double y2 = 1.0;
    private double yt = 1.0;

    public void ppick(float[] reltrc, int _reltrc_offset, int[] trace, int _trace_offset, int npts, long start) {
        float longDecayFactor = 1.0f / (float)this.sampleRate / this.longTermWindow;
        float longDecayConst = 1.0f - longDecayFactor;
        int i = 0;
        while (i < npts) {
            float rdat = reltrc[i + _reltrc_offset];
            double rdif = rdat - this.rawold;
            this.rawold = rdat;
            double rda2 = rdat * rdat;
            double rdi2 = rdif * rdif;
            double edat = rda2 + rdi2 * (double)this.sampleRate * (double)this.sampleRate;
            if (Double.isInfinite(edat *= edat) || edat > Math.sqrt(Double.MAX_VALUE)) {
                edat = Math.sqrt(Double.MAX_VALUE);
            }
            double edev = this.sdev <= (double)1.4E-45f ? 0.0 : (edat - this.mean) / this.sdev;
            int iamp = (int)((float)Math.abs(trace[i + _trace_offset]) + 0.5f);
            if (iamp > this.amp) {
                this.amp = iamp;
                this.amptime = i;
            }
            if ((long)i <= this.end_dur) {
                this.pamp = this.amp;
                this.pamptime = this.amptime;
            }
            if (edev > (double)this.thrshl1) {
                if (this.ipkflg == 0) {
                    this.itar = i;
                    this.ipkflg = 1;
                    if (this.ptime == 0L) {
                        this.end_dur = this.itar + (long)this.p_dur;
                        if (this.noisetime == 0L) {
                            this.noise = this.amp;
                            this.noisetime = this.amptime;
                        }
                        if (rdif < 0.0) {
                            this.ifrst = 1;
                        }
                        if (rdif > 0.0) {
                            this.ifrst = -1;
                        }
                    }
                    if (this.preptime == 0L) {
                        this.preptime = this.itar;
                        this.prepamp = this.amp;
                        this.prepamptime = this.amptime;
                    }
                    this.uptime = 1;
                    this.uptime0 = 1;
                } else if (this.ptime == 0L) {
                    if (edev > 40.0 && this.dtime == 0) {
                        this.ipkflg += 2;
                    }
                    ++this.uptime;
                    ++this.uptime0;
                }
                this.dtime = 0;
            } else if (this.ipkflg != 0) {
                ++this.dtime;
                if (this.ptime == 0L) {
                    ++this.uptime;
                }
                if (this.dtime > this.tdownmax || this.uptime > this.sampleRate * 6) {
                    int itrm = (int)((long)i - this.itar - (long)this.dtime + (long)this.ipkflg);
                    if (itrm >= this.tupevent) {
                        if (this.ptime == 0L) {
                            this.ptime = this.itar;
                            if ((float)this.ifrst < 0.0f) {
                                this.pfm = "U";
                            }
                            if ((float)this.ifrst > 0.0f) {
                                this.pfm = "D";
                            }
                            this.itar = 0L;
                            PICKER p = new PICKER();
                            p.ipkflg = this.ipkflg;
                            p.uptime = this.uptime;
                            p.uptime0 = this.uptime0;
                            p.ptime = this.ptime;
                            p.pamp = this.pamp;
                            p.pamptime = this.pamptime;
                            p.preptime = this.preptime;
                            p.prepamp = this.prepamp;
                            p.prepamptime = this.prepamptime;
                            p.ifrst = this.ifrst;
                            p.pfm = this.pfm;
                            p.noise = this.noise;
                            p.noisetime = this.noisetime;
                            p.signal = this.signal;
                            p.signaltime = this.signaltime;
                            System.out.println(String.valueOf(i) + ": " + p);
                            this.ptime = 0L;
                            this.preptime = 0L;
                            this.noisetime = 0L;
                            this.signaltime = 0L;
                        }
                    } else {
                        this.prepamp = this.amp;
                        this.prepamptime = this.amptime;
                        this.itar = 0L;
                    }
                    this.ipkflg = 0;
                    this.uptime = 0;
                    this.uptime0 = 0;
                }
            }
            if (edev < (double)this.thrshl2) {
                this.y2 = this.y2 * (double)longDecayConst + rda2 * (double)longDecayFactor;
                this.yt = this.yt * (double)longDecayConst + rdi2 * (double)longDecayFactor;
                this.mean = this.ssx = this.ssx * (double)longDecayConst + edat * (double)longDecayFactor;
                double stdDev = edat - this.mean;
                this.ssx2 = this.ssx2 * (double)longDecayConst + stdDev * stdDev * (double)longDecayFactor;
                this.sdev = Math.sqrt(this.ssx2);
                if (this.sdev <= 0.0) {
                    this.sdev = 1.0;
                }
            }
            ++i;
        }
    }

    public void preset(float[] rbuf, int off, int n, long start) {
        float yy = 0.0f;
        float yy2 = 0.0f;
        float yyt = 0.0f;
        float ysv = 0.0f;
        this.rawold = ysv = rbuf[off];
        this.ssx = ysv;
        this.y2 = 0.0;
        this.yt = 0.0;
        int i = 1;
        while (i < n) {
            yy = rbuf[off + i];
            yyt = (yy - ysv) * (float)this.sampleRate;
            ysv = yy;
            yy2 = ysv * ysv;
            this.ssx += (double)yy2;
            this.ssx2 += (double)(yy2 * yy2);
            this.y2 += (double)yy2;
            this.yt += (double)(yyt * yyt);
            ++i;
        }
        this.sdev = (float)Math.sqrt((double)n * this.ssx2 - this.ssx * this.ssx) / (float)(n * n);
        if (this.sdev <= 0.0) {
            this.sdev = 1.0;
        }
        this.mean = this.ssx / (double)n;
    }

    public static void main(String[] args) throws IOException {
        String fname = "TestData/AICPicker/XX_HSH_BHZ_2.txt";
        BufferedReader br = new BufferedReader(new FileReader(fname));
        int count = 0;
        String line = null;
        while ((line = br.readLine()) != null) {
            ++count;
        }
        br.close();
        float[] v = new float[count];
        br = new BufferedReader(new FileReader(fname));
        int i = 0;
        while (i < count) {
            line = br.readLine();
            v[i] = Float.parseFloat(line.trim());
            ++i;
        }
        br.close();
        float[] reltrc = v;
        int _reltrc_offset = 0;
        int[] trace = new int[v.length];
        int i2 = 0;
        while (i2 < v.length) {
            trace[i2] = (int)v[i2];
            ++i2;
        }
        int _trace_offset = 0;
        int npts = v.length;
        PPicker ppicker2 = new PPicker();
        ppicker2.ppick(reltrc, _reltrc_offset, trace, _trace_offset, npts, 0L);
    }

    public static class PICKER {
        public int ipkflg = 0;
        public int uptime = 0;
        public int uptime0 = 0;
        public long ptime = 0L;
        public int pamp = 0;
        public long pamptime = 0L;
        public long preptime = 0L;
        public int prepamp = 0;
        public long prepamptime = 0L;
        public int ifrst = 0;
        public String pfm = " ";
        public int noise = 0;
        public long noisetime = 0L;
        public int signal = 0;
        public long signaltime = 0L;

        public String toString() {
            return String.format("Picker: ipkflg=%d,uptime=%d,uptime0=%d,ptime=%d,pamp=%d,pamptime=%d,preptime=%d,prepamp=%d,prepamptime=%d,ifrst=%d,pfm=%s,noise=%d,noisetime=%d,signal=%d,signaltime=%d", this.ipkflg, this.uptime, this.uptime0, this.ptime, this.pamp, this.pamptime, this.preptime, this.prepamp, this.prepamptime, this.ifrst, this.pfm, this.noise, this.noisetime, this.signal, this.signaltime);
        }
    }
}

