/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.picker;

import cn.org.gddsn.seis.picker.PickData;
import cn.org.gddsn.seis.picker.TimeDomainException;
import cn.org.gddsn.seis.picker.TimeDomainProcess;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicPicker
extends TimeDomainProcess {
    public static final String DIR_FORWARD = "FORWARD";
    public static final String DIR_BACKWARD = "BACKWARD";
    public int direction = 1;
    public static final String RESULT_PICKS = "PICKS";
    public static final String RESULT_CHAR_FUNC = "CHAR_FUNC";
    public static final String RESULT_TRIGGER = "TRIGGERS";
    public static final String RESULT_ERROR = "ERROR";
    public static final int PICKS = 0;
    public static final int CHAR_FUNC = 1;
    public static final int TRIGGER = 2;
    public int resultType = 0;
    public String errorMessage = " ";
    protected Vector<PickData> triggerPickData = new Vector();

    public BasicPicker(int direction) {
        this.direction = direction;
    }

    public void setDirection(int direction) throws TimeDomainException {
        if (direction != 1 && direction != -1) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_direction_value) + ": " + direction);
        }
        this.direction = direction;
    }

    public void setDirection(String str) throws TimeDomainException {
        if (DIR_FORWARD.startsWith(str.toUpperCase())) {
            this.direction = 1;
        } else if (DIR_BACKWARD.startsWith(str.toUpperCase())) {
            this.direction = -1;
        } else {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_direction_value) + ": " + str);
        }
    }

    public String getDirectionString() {
        if (this.direction == 1) {
            return DIR_FORWARD;
        }
        return DIR_BACKWARD;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setResultsType(String str) throws TimeDomainException {
        if (RESULT_PICKS.startsWith(str.toUpperCase())) {
            this.resultType = 0;
        } else if (RESULT_CHAR_FUNC.startsWith(str.toUpperCase())) {
            this.resultType = 1;
        } else if (RESULT_TRIGGER.startsWith(str.toUpperCase())) {
            this.resultType = 2;
        } else {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_result_value) + ": " + str);
        }
    }

    public String getResultsTypeString() {
        if (this.resultType == 0) {
            return RESULT_PICKS;
        }
        if (this.resultType == 1) {
            return RESULT_CHAR_FUNC;
        }
        if (this.resultType == 2) {
            return RESULT_TRIGGER;
        }
        return RESULT_ERROR;
    }

    public int getResultsType() {
        return this.resultType;
    }

    @Override
    public Vector<PickData> getPickData() {
        return this.triggerPickData;
    }

    @Override
    public void clearTriggerPickData() {
        this.triggerPickData.clear();
    }

    @Override
    public String getPickPrefix() {
        return "T";
    }

    @Override
    public void checkSettings() throws TimeDomainException {
        String errMessage = "";
        int badSettings = 0;
        if (this.direction != 1 && this.direction != -1) {
            errMessage = String.valueOf(errMessage) + ": " + TimeDomainException.invalid_direction_value;
            ++badSettings;
        }
        if (badSettings > 0) {
            throw new TimeDomainException(String.valueOf(errMessage) + ".");
        }
        this.clearTriggerPickData();
    }

    @Override
    public abstract double[] apply(double var1, double[] var3);

    @Override
    public boolean amplititudeModified() {
        return this.resultType != 0;
    }
}

