/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.picker;

import cn.org.gddsn.seis.picker.BasicPicker;
import cn.org.gddsn.seis.picker.PickData;
import cn.org.gddsn.seis.picker.TimeDomainException;

public class BaerKradolferPicker
extends BasicPicker {
    private static final double WINDOW_MIN = Double.MIN_VALUE;
    private static final double WINDOW_MAX = Double.MAX_VALUE;
    public double longTermWindow = 100.0;
    public double threshold1 = 10.0;
    public double threshold2 = 20.0;
    public double tUpEvent = 0.5;
    public double tDownMax = 0.25;
    private static final double THRESHOLD_MIN = Double.MIN_VALUE;
    private static final double THRESHOLD_MAX = Double.MAX_VALUE;
    private static final double TIME_MIN = -1.7976931348623157E308;
    private static final double TIME_MAX = Double.MAX_VALUE;

    public BaerKradolferPicker(double longTermWindow, double threshold1, double threshold2, double tUpEvent, double tDownMax, int direction) {
        super(direction);
        this.longTermWindow = longTermWindow;
        this.threshold1 = threshold1;
        this.threshold2 = threshold2;
        this.tUpEvent = tUpEvent;
        this.tDownMax = tDownMax;
    }

    public void setLongTermWindow(double longTermWindowValue) throws TimeDomainException {
        if (longTermWindowValue < Double.MIN_VALUE || longTermWindowValue > Double.MAX_VALUE) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_long_term_window_value) + ": " + longTermWindowValue);
        }
        this.longTermWindow = longTermWindowValue;
    }

    public void setLongTermWindow(String str) throws TimeDomainException {
        double longTermWindowValue;
        try {
            longTermWindowValue = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_long_term_window_value) + ": " + str);
        }
        this.setLongTermWindow(longTermWindowValue);
    }

    public void setThreshold1(double threshold1Value) throws TimeDomainException {
        if (threshold1Value < Double.MIN_VALUE || threshold1Value > Double.MAX_VALUE) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_threshold1_value) + ": " + threshold1Value);
        }
        this.threshold1 = threshold1Value;
    }

    public void setThreshold1(String str) throws TimeDomainException {
        double threshold1Value;
        try {
            threshold1Value = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_threshold1_value) + ": " + str);
        }
        this.setThreshold1(threshold1Value);
    }

    public void setThreshold2(double threshold2Value) throws TimeDomainException {
        if (threshold2Value < Double.MIN_VALUE || threshold2Value > Double.MAX_VALUE) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_threshold2_value) + ": " + threshold2Value);
        }
        this.threshold2 = threshold2Value;
    }

    public void setThreshold2(String str) throws TimeDomainException {
        double threshold2Value;
        try {
            threshold2Value = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_threshold2_value) + ": " + str);
        }
        this.setThreshold2(threshold2Value);
    }

    public void setTUpEvent(double tUpEventValue) throws TimeDomainException {
        if (tUpEventValue < -1.7976931348623157E308 || tUpEventValue > Double.MAX_VALUE) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_tUpEvent_value) + ": " + tUpEventValue);
        }
        this.tUpEvent = tUpEventValue;
    }

    public void setTUpEvent(String str) throws TimeDomainException {
        double tUpEventValue;
        try {
            tUpEventValue = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_tUpEvent_value) + ": " + str);
        }
        this.setTUpEvent(tUpEventValue);
    }

    public void setTDownMax(double tDownMaxValue) throws TimeDomainException {
        if (tDownMaxValue < -1.7976931348623157E308 || tDownMaxValue > Double.MAX_VALUE) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_tDownMax_value) + ": " + tDownMaxValue);
        }
        this.tDownMax = tDownMaxValue;
    }

    public void setTDownMax(String str) throws TimeDomainException {
        double tDownMaxValue;
        try {
            tDownMaxValue = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new TimeDomainException(String.valueOf(TimeDomainException.invalid_tDownMax_value) + ": " + str);
        }
        this.setTDownMax(tDownMaxValue);
    }

    public void checkSettings() throws TimeDomainException {
        super.checkSettings();
        String errMessage = "";
        int badSettings = 0;
        if (this.longTermWindow < Double.MIN_VALUE || this.longTermWindow > Double.MAX_VALUE) {
            errMessage = String.valueOf(errMessage) + ": " + TimeDomainException.invalid_long_term_window_value;
            ++badSettings;
        }
        if (this.threshold1 < Double.MIN_VALUE || this.threshold1 > Double.MAX_VALUE) {
            errMessage = String.valueOf(errMessage) + ": " + TimeDomainException.invalid_threshold1_value;
            ++badSettings;
        }
        if (this.threshold2 < Double.MIN_VALUE || this.threshold2 > Double.MAX_VALUE) {
            errMessage = String.valueOf(errMessage) + ": " + TimeDomainException.invalid_threshold2_value;
            ++badSettings;
        }
        if (this.tUpEvent < -1.7976931348623157E308 || this.tUpEvent > Double.MAX_VALUE) {
            errMessage = String.valueOf(errMessage) + ": " + TimeDomainException.invalid_tUpEvent_value;
            ++badSettings;
        }
        if (this.tDownMax < -1.7976931348623157E308 || this.tDownMax > Double.MAX_VALUE) {
            errMessage = String.valueOf(errMessage) + ": " + TimeDomainException.invalid_tDownMax_value;
            ++badSettings;
        }
        if (badSettings > 0) {
            throw new TimeDomainException(String.valueOf(errMessage) + ".");
        }
    }

    public final double[] apply(double dt, double[] sample) {
        double uncertaintyThreshold = 1.0;
        int indexUncertainty = -1;
        double longDecayConst = 1.0 - dt / this.longTermWindow;
        double longFactor = 1.0 - longDecayConst;
        double sampleLast = 0.0;
        double sum_Xval = 0.0;
        double sum_dXdt = 0.0;
        double sum_mean_E4 = 0.0;
        double sum_var_E4 = 0.0;
        double stdDev_E4 = 0.0;
        double mean_E4 = 0.0;
        double charFunct = 0.0;
        boolean pickFlag = false;
        boolean backwards = this.direction == -1;
        int indexUpEvent = -1;
        int indexUpEventEnd = -1;
        int indexDownEnd = -1;
        int nTUpEvent = 1 + (int)(this.tUpEvent / dt);
        int nTDownMax = 1 + (int)(this.tDownMax / dt);
        boolean acceptedPick = false;
        double ampCharFunctTrigger = 0.0;
        if (this.resultType == 2 || this.resultType == 1) {
            sample[sample.length - 1] = 0.0;
            sample[0] = 0.0;
        }
        int n = 1;
        while (n < sample.length - 1) {
            int i = backwards ? sample.length - n - 1 : n;
            double Xval = sample[i];
            double dXdt = sample[i] - sampleLast;
            sampleLast = sample[i];
            double E2 = Xval * Xval + dXdt * dXdt / (dt * dt);
            double E4 = E2 * E2;
            if (Double.isInfinite(E4) || E4 > Math.sqrt(Double.MAX_VALUE)) {
                E4 = Math.sqrt(Double.MAX_VALUE);
            }
            if ((charFunct = stdDev_E4 <= Double.MIN_VALUE ? 0.0 : (E4 - mean_E4) / stdDev_E4) < this.threshold2) {
                sum_Xval = sum_Xval * longDecayConst + Xval * Xval * longFactor;
                sum_dXdt = sum_dXdt * longDecayConst + dXdt * dXdt * longFactor;
                mean_E4 = sum_mean_E4 = sum_mean_E4 * longDecayConst + E4 * longFactor;
                double stdDev = E4 - mean_E4;
                sum_var_E4 = sum_var_E4 * longDecayConst + stdDev * stdDev * longFactor;
                stdDev_E4 = Math.sqrt(sum_var_E4);
            }
            if (charFunct >= uncertaintyThreshold) {
                if (indexUncertainty < 0) {
                    indexUncertainty = i;
                }
            } else {
                indexUncertainty = -1;
            }
            if (charFunct >= this.threshold1) {
                if (!pickFlag) {
                    pickFlag = true;
                    indexUpEvent = i;
                    indexUpEventEnd = n + nTUpEvent;
                    ampCharFunctTrigger = charFunct;
                } else if (n >= indexUpEventEnd) {
                    acceptedPick = true;
                    pickFlag = false;
                }
                indexDownEnd = -1;
            } else if (pickFlag) {
                if (n < indexUpEventEnd) {
                    if (indexDownEnd < 0) {
                        indexDownEnd = n + nTDownMax;
                    } else if (n >= indexDownEnd) {
                        pickFlag = false;
                    }
                } else {
                    pickFlag = false;
                }
            }
            if (this.resultType == 2) {
                sample[i] = acceptedPick ? 1.0 : 0.0;
            } else if (this.resultType == 1) {
                sample[i] = (float)charFunct;
            } else if (acceptedPick) {
                PickData pickData = new PickData(indexUncertainty == indexUpEvent ? indexUncertainty - 1 : indexUncertainty, indexUpEvent, 0, ampCharFunctTrigger, "_CF");
                this.triggerPickData.add(pickData);
                indexUncertainty = -1;
            }
            acceptedPick = false;
            ++n;
        }
        return sample;
    }
}

