/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.picker;

import cn.org.gddsn.seis.picker.STALTA;
import cn.org.gddsn.signal.ButterFilter;
import cn.org.gddsn.signal.Filter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ARAICPicker {
    static Logger logger = Logger.getLogger(ARAICPicker.class);
    public static double BPF_CO1 = 0.6f;
    public static double BPF_CO2 = 6.0;
    private int AR_ORDER = 8;
    public static double PP_CF1 = 0.7f;
    public static double PP_CF2 = 10.0;
    private double SNR_WLEN = 5.0;
    private int TYPE = 1;
    private double sn;
    private double sn0;
    private double t_pick;
    double pick_type0;
    double pick_type1;
    private int naic;
    private int nar;
    private int r0_prepick;
    private static final double VAL_GAPS = Double.MAX_VALUE;
    private boolean verbose = false;
    private static int MAXELEM = 2000;
    private double[] b1 = new double[MAXELEM];
    private double[] b2 = new double[MAXELEM];
    private double[] aa = new double[MAXELEM];

    public int pick(double[] dz, int srate, int Nsamp, int p_index) {
        double[] f_dz;
        double fp2;
        double fp1;
        int r0_detect = 0;
        int r0_pick = 0;
        double dt = 1.0f / (float)srate;
        double p_time = (double)p_index * dt;
        if (p_index > 0) {
            System.out.printf("Manual P-onset:\t%.2f seconds\n", p_time);
            System.out.printf("p_index = %d\n", p_index);
        }
        ARAICPicker.remove_mean(dz, Nsamp);
        ARAICPicker.taper(dz, Nsamp);
        if (p_index == -1) {
            fp1 = BPF_CO1;
            fp2 = Math.min(BPF_CO2, (double)(srate / 2));
            Filter[] staltaFlt = ButterFilter.getButterFilter(srate, 1, "BP", 4, fp1, fp2);
            f_dz = staltaFlt[0].filter(dz);
            STALTA stalta = new STALTA(true, srate);
            r0_detect = stalta.detect_stalta(f_dz, Nsamp, dt);
            System.out.printf("STALTA onset estimate at r0=%d ", r0_detect);
        } else {
            System.out.printf("USER:  onset estimate at r0=%d, %.2f\n", p_index, p_time);
            r0_detect = p_index;
        }
        fp1 = PP_CF1;
        fp2 = Math.min(PP_CF2, (double)(srate / 2));
        Filter[] aicFlt = ButterFilter.getButterFilter(srate, 1, "BP", 4, fp1, fp2);
        f_dz = aicFlt[0].filter(dz);
        this.sn = ARAICPicker.signal_noise_ratio(f_dz, r0_detect, (int)(this.SNR_WLEN / dt));
        System.out.printf("SNR (bpf):  \t\t%f  at r0=%d\n", this.sn, r0_detect);
        r0_pick = this.araic(f_dz, r0_detect, dt, Nsamp);
        this.sn0 = ARAICPicker.signal_noise_ratio(dz, r0_pick, (int)(this.SNR_WLEN / dt));
        System.out.printf("SNR(raw):  \t\t%f  at r0=%d\n", this.sn0, r0_pick);
        return r0_pick;
    }

    boolean pickup(double[] x, int r1, int ns, double[] y, int type) {
        if (type > 0) {
            int i = 0;
            while (i < ns) {
                if (i + r1 < 0 || i + r1 > x.length - 1) {
                    return false;
                }
                y[i] = x[r1 + i];
                ++i;
            }
            return true;
        }
        int i = 0;
        while (i < ns) {
            if (ns + r1 - i - 1 < 0 || ns + r1 - i - 1 > x.length - 1) {
                return false;
            }
            y[i] = x[ns + r1 - i - 1];
            ++i;
        }
        return true;
    }

    void arcoef(double[] x, int ns, double[] a, int m) {
        int i = 0;
        while (i < MAXELEM) {
            this.b1[i] = 0.0;
            this.b2[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < ns) {
            this.b1[i] = x[i];
            ++i;
        }
        i = 1;
        while (i < ns) {
            this.b2[i - 1] = x[i];
            ++i;
        }
        int k = 0;
        while (k < m) {
            double stn = 0.0;
            double std = 0.0;
            i = 0;
            while (i < ns - k - 1) {
                stn += this.b1[i] * this.b2[i];
                std += this.b1[i] * this.b1[i] + this.b2[i] * this.b2[i];
                ++i;
            }
            a[k] = -2.0 * stn / std;
            if (k > 0) {
                int j = 0;
                while (j <= k - 1) {
                    a[j] = this.aa[j] + a[k] * this.aa[k - j - 1];
                    ++j;
                }
            }
            i = 0;
            while (i <= k) {
                this.aa[i] = a[i];
                ++i;
            }
            if (k == 0) {
                this.aa[0] = a[0];
            }
            i = 0;
            while (i < ns - k - 2) {
                this.b1[i] = this.b1[i] + this.aa[k] * this.b2[i];
                this.b2[i] = this.b2[i + 1] + this.aa[k] * this.b1[i + 1];
                ++i;
            }
            ++k;
        }
        i = 0;
        while (i < m) {
            int n = i++;
            a[n] = a[n] * -1.0;
        }
    }

    void craics(double[] x, double[] y, int n, int m, double[] aic, int model) {
        int k = 1;
        while (k < n - m) {
            int j;
            double s1 = 0.0;
            int i = m;
            while (i < m + k) {
                s1 += x[i] * x[i];
                ++i;
            }
            s1 /= (double)k;
            double s2 = 0.0;
            if (model == 0) {
                j = k + m;
                while (j < n) {
                    s2 += x[j] * x[j];
                    ++j;
                }
            } else {
                j = 0;
                while (j < n - (m + k)) {
                    s2 += y[j] * y[j];
                    ++j;
                }
            }
            if (!(s1 <= 0.0) && !((s2 /= (double)(n - m - k)) <= 0.0)) {
                aic[k + m] = (double)k * Math.log(s1) + (double)(n - m - k) * Math.log(s2);
            }
            ++k;
        }
        k = 0;
        while (k <= m) {
            aic[k] = aic[m + 2];
            ++k;
        }
    }

    void prerror(double[] x, int ns, double[] y, double[] a, int m, int nm) {
        int i = m;
        while (i < ns) {
            double s = 0.0;
            int l = 0;
            while (l < m) {
                s += a[l] * x[i - l - 1];
                ++l;
            }
            y[i] = x[i] - s;
            ++i;
        }
        i = 0;
        while (i < m) {
            y[i] = y[m];
            ++i;
        }
    }

    void preflt(double[] fmdl, double[] smdl, double[] pref, double[] pres, double[] aic, int naic, double[] a, double[] b, int m, int nar, int type) {
        int i = 0;
        while (i < naic) {
            pref[i] = Double.MAX_VALUE;
            pref[i] = Double.MAX_VALUE;
            aic[i] = Double.MAX_VALUE;
            ++i;
        }
        this.arcoef(fmdl, nar, a, m);
        this.prerror(fmdl, naic, pref, a, m, nar);
        if (type != 0) {
            this.arcoef(smdl, nar, b, m);
            this.prerror(smdl, naic, pres, b, m, nar);
        }
        this.craics(pref, pres, naic, m, aic, type);
    }

    void maxmin(double[] x, int n, int[] imax, double[] max, int[] imin, double[] min, int id) {
        imin[0] = 1;
        imax[0] = 1;
        max[0] = min[0] = x[0];
        int start = 0;
        int end = n;
        if (id == 1) {
            start = (int)((double)n * 0.1);
            end = n - start;
        }
        int i = start;
        while (i < end) {
            if (!(x[i] >= Double.MAX_VALUE)) {
                if (x[i] > max[0]) {
                    max[0] = x[i];
                    imax[0] = i;
                }
                if (x[i] < min[0]) {
                    min[0] = x[i];
                    imin[0] = i;
                }
            }
            ++i;
        }
    }

    public int araic(double[] f_dz, int r0_detect, double dt, int Nsamp) {
        int r0_pick = 0;
        double[] max = new double[1];
        double[] min = new double[1];
        int[] imax = new int[1];
        int[] imin = new int[1];
        this.nar = (int)(4.0 / dt);
        this.naic = (int)(13.0 / dt);
        this.r0_prepick = (int)(8.0 / dt);
        int ar_order = 8;
        ar_order = this.AR_ORDER;
        if (this.verbose) {
            System.out.printf("nar = %d  naic = %d  r0_prepick = %d\n", this.nar, this.naic, this.r0_prepick);
        }
        double[] fmdl = new double[this.naic];
        double[] smdl = new double[this.naic];
        double[] pref = new double[this.naic];
        double[] pres = new double[this.naic];
        double[] aic = new double[this.naic];
        double[] a = new double[this.nar];
        double[] b = new double[this.nar];
        int i = 0;
        while (i < this.naic) {
            fmdl[i] = Double.MAX_VALUE;
            smdl[i] = Double.MAX_VALUE;
            pref[i] = Double.MAX_VALUE;
            pres[i] = Double.MAX_VALUE;
            ++i;
        }
        i = 0;
        while (i < this.nar) {
            a[i] = 0.0;
            b[i] = 0.0;
            ++i;
        }
        if (this.verbose) {
            System.out.printf("r0_detect = %d  r0_prepick = %d\n", r0_detect, this.r0_prepick);
        }
        int type = this.TYPE;
        while (type <= 1) {
            boolean ret = this.pickup(f_dz, r0_detect - this.r0_prepick - 1, this.naic, fmdl, 1);
            if (!ret) {
                return r0_pick;
            }
            if (type == 1 && !(ret = this.pickup(f_dz, r0_detect - this.r0_prepick - 1, this.naic, smdl, 0))) {
                return r0_pick;
            }
            this.preflt(fmdl, smdl, pref, pres, aic, this.naic, a, b, ar_order, this.nar, type);
            ARAICPicker.remove_mean(aic, this.naic);
            this.maxmin(aic, this.naic, imax, max, imin, min, 1);
            r0_pick = r0_detect - this.r0_prepick + imin[0];
            this.t_pick = (double)r0_pick * dt;
            if (type == 0) {
                this.pick_type0 = this.t_pick;
            }
            if (type == 1) {
                this.pick_type1 = this.t_pick;
            }
            ++type;
        }
        return r0_pick;
    }

    private static double average(double[] s1, int len) {
        int val = 0;
        int i = 0;
        while (i < len) {
            if (!(s1[i] >= Double.MAX_VALUE)) {
                val = (int)((double)val + s1[i]);
            }
            ++i;
        }
        return val /= len;
    }

    public static double remove_mean(double[] x, int ns) {
        double avg = ARAICPicker.average(x, ns);
        int i = 0;
        while (i < ns) {
            int n = i++;
            x[n] = x[n] - avg;
        }
        return avg;
    }

    public static void taper(double[] x, int Nsamp) {
        int N = (int)((double)Nsamp * 0.05);
        int Nw = N / 2;
        int i = 0;
        while (i < Nw) {
            double w = 0.42 - 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)N) + 0.08 * Math.cos(Math.PI * 4 * (double)i / (double)N);
            int n = i;
            x[n] = x[n] * w;
            int n2 = Nsamp - 1 - i;
            x[n2] = x[n2] * w;
            ++i;
        }
    }

    private static double signal_noise_ratio(double[] x, int r0, int winlen) {
        if (r0 - winlen < 0 || r0 + winlen > x.length) {
            return -1.0;
        }
        double signal = 0.0;
        double noise = 0.0;
        int i = 0;
        while (i < winlen) {
            double f = x[r0 - i];
            noise += f * f;
            f = x[r0 + i];
            signal += f * f;
            ++i;
        }
        return signal / noise;
    }

    public static void main(String[] args) throws IOException {
        String fname = "TestData/AICPicker/GT_LBTB_BHZ_2.txt";
        BufferedReader br = new BufferedReader(new FileReader(fname));
        int count = 0;
        String line = null;
        while ((line = br.readLine()) != null) {
            ++count;
        }
        br.close();
        double[] v = new double[count];
        br = new BufferedReader(new FileReader(fname));
        int i = 0;
        while (i < count) {
            line = br.readLine();
            v[i] = Double.parseDouble(line.trim());
            ++i;
        }
        br.close();
        ARAICPicker araic = new ARAICPicker();
        int srate = 40;
        int p_index = 3000;
        int p_pick = araic.pick(v, srate, v.length, p_index);
        System.out.println(p_pick);
    }
}

