/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor.edas.gui;

import cn.org.gddsn.liss.port.edas.Edas24IPIO;
import cn.org.gddsn.seis.monitor.edas.Controler;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame;
import cn.org.gddsn.seis.monitor.edas.gui.TriggerClockDialog_jButtonCancel_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.TriggerClockDialog_jButtonGet_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.TriggerClockDialog_jButtonSet_actionAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class TriggerClockDialog
extends JDialog {
    static Logger logger = Logger.getLogger(TriggerClockDialog.class);
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    Box vbox1 = Box.createVerticalBox();
    JPanel jPanel1 = new JPanel();
    JButton jButtonCancel = new JButton();
    JButton jButtonGet = new JButton();
    JButton jButtonSet = new JButton();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JPanel jPanel5 = new JPanel();
    JPanel jPanel7 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JComboBox jComboBoxSensor = new JComboBox();
    JCheckBox jCheckBox1 = new JCheckBox();
    JLabel jLabel2 = new JLabel();
    JTextField jTextFieldTime = new JTextField();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel5 = new JLabel();
    JTextField jTextFieldInterval = new JTextField();
    JTextField jTextFieldLength = new JTextField();
    GridLayout gridLayout1 = new GridLayout();
    GridLayout gridLayout3 = new GridLayout();
    GridLayout gridLayout4 = new GridLayout();
    GridLayout gridLayout5 = new GridLayout();
    GridLayout gridLayout6 = new GridLayout();

    public TriggerClockDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            this.setDefaultCloseOperation(2);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.toGUI();
    }

    public TriggerClockDialog() {
        this(new Frame(), "TriggerClockDialog", false);
    }

    private void jbInit() throws Exception {
        this.vbox1 = Box.createVerticalBox();
        this.panel1.setLayout(this.borderLayout1);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new TriggerClockDialog_jButtonCancel_actionAdapter(this));
        this.jButtonGet.setText("Get");
        this.jButtonGet.addActionListener(new TriggerClockDialog_jButtonGet_actionAdapter(this));
        this.jButtonSet.setText("Set");
        this.jButtonSet.addActionListener(new TriggerClockDialog_jButtonSet_actionAdapter(this));
        this.jLabel1.setText("Sensor: ");
        this.jCheckBox1.setText("Repeat Trigger");
        this.jLabel2.setText("Trigger Time: ");
        this.jTextFieldTime.setText("1970-01-01 00:00:00");
        this.jLabel3.setText("Trigger Interval(Sec): ");
        this.jLabel5.setText("Event Length(Sec): ");
        this.jTextFieldInterval.setText("         ");
        this.jPanel7.setLayout(this.gridLayout1);
        this.jPanel5.setLayout(this.gridLayout3);
        this.jPanel4.setLayout(this.gridLayout4);
        this.jPanel2.setLayout(this.gridLayout5);
        this.jPanel3.setLayout(this.gridLayout6);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.vbox1, "Center");
        this.vbox1.add(this.jPanel2);
        this.jPanel2.add(this.jLabel1);
        DefaultComboBoxModel<String> model1 = new DefaultComboBoxModel<String>(new String[]{"Sensor A"});
        this.jComboBoxSensor.setModel(model1);
        this.jPanel2.add(this.jComboBoxSensor);
        this.vbox1.add(this.jPanel3);
        this.jPanel3.add(this.jCheckBox1);
        this.vbox1.add(this.jPanel4);
        this.jPanel4.add(this.jLabel2);
        this.jPanel4.add(this.jTextFieldTime);
        this.vbox1.add(this.jPanel5);
        this.jPanel5.add(this.jLabel3);
        this.jPanel5.add(this.jTextFieldInterval);
        this.vbox1.add(this.jPanel7);
        this.jPanel7.add(this.jLabel5);
        this.jPanel7.add(this.jTextFieldLength);
        this.panel1.add((Component)this.jPanel1, "South");
        this.jPanel1.add(this.jButtonSet);
        this.jPanel1.add(this.jButtonGet);
        this.jPanel1.add(this.jButtonCancel);
    }

    private void toGUI() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            Edas24IPIO.Frame frm = edasIO.inquire(0, 145);
            if (frm == null) {
                EdasFrame frame = (EdasFrame)this.getOwner();
                frame.warnStatusBar("Get Clock Trigger info failt!");
                return;
            }
            Edas24IPIO.TRIGGER_CLOCK info = (Edas24IPIO.TRIGGER_CLOCK)frm.body;
            if (info.repeat.get() == 0) {
                this.jCheckBox1.setSelected(false);
            } else {
                this.jCheckBox1.setSelected(true);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.jTextFieldTime.setText(sdf.format(new Date((long)info.triggerTime.get() * 1000L)));
            this.jTextFieldInterval.setText("" + info.timeInterval.get());
            this.jTextFieldLength.setText("" + info.eventLen.get());
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("IOException: " + ioEx.getMessage());
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("Exception: " + ex.getMessage());
            frame.enableGUI(false);
        }
    }

    private void toModel() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            Edas24IPIO.TRIGGER_CLOCK info = new Edas24IPIO.TRIGGER_CLOCK();
            boolean selected = this.jCheckBox1.isSelected();
            info.repeat.set((short)(selected ? 1 : 0));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            info.triggerTime.set((int)(sdf.parse(this.jTextFieldTime.getText()).getTime() / 1000L));
            info.timeInterval.set(Short.parseShort(this.jTextFieldInterval.getText()));
            info.eventLen.set(Integer.parseInt(this.jTextFieldLength.getText()));
            Edas24IPIO.Frame retFrm = edasIO.config(0, 145, (Edas24IPIO.Body)info);
            if (retFrm == null) {
                EdasFrame frame = (EdasFrame)this.getOwner();
                frame.warnStatusBar("Set Clock Trigger info failt!");
                return;
            }
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("IOException: " + ioEx.getMessage());
            frame.enableGUI(false);
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("Exception: " + ex.getMessage());
            frame.enableGUI(false);
        }
    }

    public void jButtonGet_actionPerformed(ActionEvent e) {
        this.toGUI();
    }

    public void jButtonSet_actionPerformed(ActionEvent e) {
        this.toModel();
    }

    public void jButtonCancel_actionPerformed(ActionEvent e) {
        this.dispose();
    }
}

