/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor.edas.gui;

import cn.org.gddsn.liss.port.edas.Edas24IPIO;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.monitor.edas.Controler;
import cn.org.gddsn.seis.monitor.edas.gui.ConnectDialog;
import cn.org.gddsn.seis.monitor.edas.gui.DasDialog;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_AboutBox;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuFileExit_ActionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuHelpAbout_ActionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuItemAuto_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuItemClock_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuItemConnect_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuItemDas_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuItemEnv_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuItemExternal_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuItemGPSStatus_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuItemIPAddress_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuItemPluse_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuItemRandom_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuItemResetFactory_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuItemResetSystem_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuItemSina_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuItemStaParam_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuItemStartPulse_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuItemStartRandom_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame_jMenuItemStartSine_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EnvParamDialog;
import cn.org.gddsn.seis.monitor.edas.gui.GPSStatusDialog;
import cn.org.gddsn.seis.monitor.edas.gui.IPConfigDialog;
import cn.org.gddsn.seis.monitor.edas.gui.PulseParamDialog;
import cn.org.gddsn.seis.monitor.edas.gui.RandomParamDialog;
import cn.org.gddsn.seis.monitor.edas.gui.SineParamDialog;
import cn.org.gddsn.seis.monitor.edas.gui.StationParamDialog;
import cn.org.gddsn.seis.monitor.edas.gui.TriggerClockDialog;
import cn.org.gddsn.seis.monitor.edas.gui.TriggerExternalDialog;
import cn.org.gddsn.seis.realtimeplot.gui.WavePaint;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class EdasFrame
extends JFrame {
    static Logger logger = Logger.getLogger(EdasFrame.class);
    JPanel contentPane;
    BorderLayout borderLayout1 = new BorderLayout();
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    JToolBar jToolBar = new JToolBar();
    JButton jButton1 = new JButton();
    JButton jButton2 = new JButton();
    JButton jButton3 = new JButton();
    ImageIcon image1 = new ImageIcon(EdasFrame.class.getResource("openFile.png"));
    ImageIcon image2 = new ImageIcon(EdasFrame.class.getResource("closeFile.png"));
    ImageIcon image3 = new ImageIcon(EdasFrame.class.getResource("help.png"));
    JLabel statusBar = new JLabel();
    JMenu jMenuConfig = new JMenu();
    JMenu jMenuCali = new JMenu();
    JMenu jMenuMgr = new JMenu();
    JMenuItem jMenuItemStaParam = new JMenuItem();
    JMenuItem jMenuItemDas = new JMenuItem();
    JMenu jMenu1 = new JMenu();
    JMenuItem jMenuItemPluse = new JMenuItem();
    JMenuItem jMenuItemRandom = new JMenuItem();
    JMenuItem jMenuItemSina = new JMenuItem();
    JMenuItem jMenuItemStartPulse = new JMenuItem();
    JMenuItem jMenuItemStartSine = new JMenuItem();
    JMenuItem jMenuItemStartRandom = new JMenuItem();
    JMenuItem jMenuItemGPSStatus = new JMenuItem();
    JMenuItem jMenuItemEnv = new JMenuItem();
    JMenu jMenu2 = new JMenu();
    JMenuItem jMenuItemClock = new JMenuItem();
    JMenuItem jMenuItemAuto = new JMenuItem();
    JMenuItem jMenuItemExternal = new JMenuItem();
    JMenuItem jMenuItemIPAddress = new JMenuItem();
    JMenuItem jMenuItemResetFactory = new JMenuItem();
    JMenuItem jMenuItemResetSystem = new JMenuItem();
    JMenuItem jMenuItemConnect = new JMenuItem();
    Border border1 = BorderFactory.createEtchedBorder(0, Color.white, new Color(166, 166, 166));
    JPanel waveformPanel = new JPanel();
    GridLayout gridLayout1 = new GridLayout();

    public EdasFrame() {
        try {
            this.setDefaultCloseOperation(3);
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEtchedBorder(0, Color.white, new Color(166, 166, 166));
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(400, 300));
        this.setTitle("Edas Configuration");
        this.statusBar.setBorder(this.border1);
        this.statusBar.setForeground(Color.red);
        this.statusBar.setText(" ");
        this.jMenuFile.setText("File");
        this.jMenuFileExit.setText("Exit");
        this.jMenuFileExit.addActionListener(new EdasFrame_jMenuFileExit_ActionAdapter(this));
        this.jMenuHelp.setText("Help");
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.addActionListener(new EdasFrame_jMenuHelpAbout_ActionAdapter(this));
        this.jMenuConfig.setText("Config");
        this.jMenuCali.setText("Cali");
        this.jMenuMgr.setText("Manager");
        this.jMenuItemStaParam.setText("Sta Param");
        this.jMenuItemStaParam.addActionListener(new EdasFrame_jMenuItemStaParam_actionAdapter(this));
        this.jMenuItemDas.setText("Das Config");
        this.jMenuItemDas.addActionListener(new EdasFrame_jMenuItemDas_actionAdapter(this));
        this.jMenu1.setText("Calibration Param");
        this.jMenuItemPluse.setText("Pulse");
        this.jMenuItemPluse.addActionListener(new EdasFrame_jMenuItemPluse_actionAdapter(this));
        this.jMenuItemRandom.setText("Random");
        this.jMenuItemRandom.addActionListener(new EdasFrame_jMenuItemRandom_actionAdapter(this));
        this.jMenuItemSina.setText("Sine");
        this.jMenuItemSina.addActionListener(new EdasFrame_jMenuItemSina_actionAdapter(this));
        this.jMenuItemStartPulse.setText("Start Pulse");
        this.jMenuItemStartPulse.addActionListener(new EdasFrame_jMenuItemStartPulse_actionAdapter(this));
        this.jMenuItemStartSine.setText("Start Sine");
        this.jMenuItemStartSine.addActionListener(new EdasFrame_jMenuItemStartSine_actionAdapter(this));
        this.jMenuItemStartRandom.setText("Start Random");
        this.jMenuItemStartRandom.addActionListener(new EdasFrame_jMenuItemStartRandom_actionAdapter(this));
        this.jMenuItemGPSStatus.setText("GPS Status");
        this.jMenuItemGPSStatus.addActionListener(new EdasFrame_jMenuItemGPSStatus_actionAdapter(this));
        this.jMenuItemEnv.setText("Enviroment");
        this.jMenuItemEnv.addActionListener(new EdasFrame_jMenuItemEnv_actionAdapter(this));
        this.jMenu2.setText("Trigger");
        this.jMenuItemClock.setText("Clock");
        this.jMenuItemClock.addActionListener(new EdasFrame_jMenuItemClock_actionAdapter(this));
        this.jMenuItemAuto.setText("Auto");
        this.jMenuItemAuto.addActionListener(new EdasFrame_jMenuItemAuto_actionAdapter(this));
        this.jMenuItemExternal.setText("External");
        this.jMenuItemExternal.addActionListener(new EdasFrame_jMenuItemExternal_actionAdapter(this));
        this.jMenuItemIPAddress.setText("Set IP Address");
        this.jMenuItemIPAddress.addActionListener(new EdasFrame_jMenuItemIPAddress_actionAdapter(this));
        this.jMenuItemResetFactory.setText("Reset To Factory");
        this.jMenuItemResetFactory.addActionListener(new EdasFrame_jMenuItemResetFactory_actionAdapter(this));
        this.jMenuItemResetSystem.setText("Reset System");
        this.jMenuItemResetSystem.addActionListener(new EdasFrame_jMenuItemResetSystem_actionAdapter(this));
        this.jMenuItemConnect.setText("Connect");
        this.jMenuItemConnect.addActionListener(new EdasFrame_jMenuItemConnect_actionAdapter(this));
        this.waveformPanel.setLayout(this.gridLayout1);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuConfig);
        this.jMenuFile.add(this.jMenuItemConnect);
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuBar1.add(this.jMenuCali);
        this.jMenuBar1.add(this.jMenuMgr);
        this.jMenuBar1.add(this.jMenuHelp);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.setJMenuBar(this.jMenuBar1);
        this.jButton1.setIcon(this.image1);
        this.jButton1.setToolTipText("Open File");
        this.jButton2.setIcon(this.image2);
        this.jButton2.setToolTipText("Close File");
        this.jButton3.setIcon(this.image3);
        this.jButton3.setToolTipText("Help");
        this.jToolBar.add(this.jButton1);
        this.jToolBar.add(this.jButton2);
        this.jToolBar.add(this.jButton3);
        this.contentPane.add((Component)this.statusBar, "South");
        this.jMenuConfig.add(this.jMenuItemStaParam);
        this.jMenuConfig.add(this.jMenuItemDas);
        this.jMenuConfig.add(this.jMenu1);
        this.jMenuConfig.add(this.jMenuItemGPSStatus);
        this.jMenuConfig.add(this.jMenuItemEnv);
        this.jMenuConfig.add(this.jMenu2);
        this.jMenu1.add(this.jMenuItemPluse);
        this.jMenu1.add(this.jMenuItemSina);
        this.jMenu1.add(this.jMenuItemRandom);
        this.jMenuCali.add(this.jMenuItemStartPulse);
        this.jMenuCali.add(this.jMenuItemStartSine);
        this.jMenuCali.add(this.jMenuItemStartRandom);
        this.jMenu2.add(this.jMenuItemClock);
        this.jMenu2.add(this.jMenuItemExternal);
        this.jMenu2.add(this.jMenuItemAuto);
        this.jMenuMgr.add(this.jMenuItemIPAddress);
        this.jMenuMgr.add(this.jMenuItemResetSystem);
        this.jMenuMgr.add(this.jMenuItemResetFactory);
        this.contentPane.add((Component)this.waveformPanel, "Center");
        this.enableGUI(false);
    }

    public void showWaveform() {
        WavePaint[] wavePaint = new WavePaint[Controler.chan];
        int i = 0;
        while (i < wavePaint.length) {
            wavePaint[i] = new WavePaint();
            wavePaint[i].setWaveData(ChannelLocator.parse((String)Controler.chanDis[i]));
            wavePaint[i].setDisChn(wavePaint.length);
            ++i;
        }
        i = 0;
        while (i < wavePaint.length) {
            this.waveformPanel.add(wavePaint[i]);
            Controler.wrapper.addMiniSeedPortEventListener(wavePaint[i]);
            ++i;
        }
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(Controler.chan);
        this.validate();
        this.invalidate();
    }

    public void cleanStatusBar() {
        this.statusBar.setForeground(Color.black);
        this.statusBar.setText(" ");
    }

    public void infoStatusBar(String info) {
        this.statusBar.setForeground(Color.black);
        this.statusBar.setText(info);
    }

    public void warnStatusBar(String info) {
        this.statusBar.setForeground(Color.red);
        this.statusBar.setText(info);
    }

    public void enableGUI(boolean enable) {
        this.jMenuConfig.setEnabled(enable);
        this.jMenuMgr.setEnabled(enable);
        this.jMenuCali.setEnabled(enable);
    }

    public void showDialog(Dialog dlg) {
        Dimension dlgSize = dlg.getSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocationOnScreen();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.pack();
        dlg.setVisible(true);
    }

    void jMenuFileExit_actionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        this.cleanStatusBar();
        EdasFrame_AboutBox dlg = new EdasFrame_AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.pack();
        dlg.setVisible(true);
    }

    public void jMenuItemStaParam_actionPerformed(ActionEvent e) {
        this.cleanStatusBar();
        StationParamDialog dlg = new StationParamDialog(this, "Station Param", true);
        this.showDialog(dlg);
    }

    public void jMenuItemDas_actionPerformed(ActionEvent e) {
        this.cleanStatusBar();
        DasDialog dlg = new DasDialog(this, "DAS config", true);
        this.showDialog(dlg);
    }

    public void jMenuItemPluse_actionPerformed(ActionEvent e) {
        this.cleanStatusBar();
        PulseParamDialog dlg = new PulseParamDialog(this, "Pluse", true);
        this.showDialog(dlg);
    }

    public void jMenuItemRandom_actionPerformed(ActionEvent e) {
        this.cleanStatusBar();
        RandomParamDialog dlg = new RandomParamDialog(this, "Random", true);
        this.showDialog(dlg);
    }

    public void jMenuItemSina_actionPerformed(ActionEvent e) {
        this.cleanStatusBar();
        SineParamDialog dlg = new SineParamDialog(this, "Sine", true);
        this.showDialog(dlg);
    }

    public void jMenuItemStartSine_actionPerformed(ActionEvent e) {
        this.cleanStatusBar();
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            edasIO.calibrate(0, 37);
            this.statusBar.setText("Start sine calibration successed ");
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            this.statusBar.setText(ioEx.getMessage());
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            this.statusBar.setText(ex.getMessage());
        }
    }

    public void jMenuItemStartRandom_actionPerformed(ActionEvent e) {
        this.cleanStatusBar();
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            edasIO.calibrate(0, 38);
            this.statusBar.setText("Start random calibration successed ");
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            this.statusBar.setText(ioEx.getMessage());
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            this.statusBar.setText(ex.getMessage());
        }
    }

    public void jMenuItemStartPulse_actionPerformed(ActionEvent e) {
        this.cleanStatusBar();
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            edasIO.calibrate(0, 36);
            this.statusBar.setText("Start pulse calibration successed ");
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            this.statusBar.setText(ioEx.getMessage());
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            this.statusBar.setText(ex.getMessage());
        }
    }

    public void jMenuItemGPSStatus_actionPerformed(ActionEvent e) {
        this.cleanStatusBar();
        GPSStatusDialog dlg = new GPSStatusDialog(this, "GPS Status", true);
        this.showDialog(dlg);
    }

    public void jMenuItemEnv_actionPerformed(ActionEvent e) {
        this.cleanStatusBar();
        EnvParamDialog dlg = new EnvParamDialog(this, "Environment", true);
        this.showDialog(dlg);
    }

    public void jMenuItemClock_actionPerformed(ActionEvent e) {
        this.cleanStatusBar();
        TriggerClockDialog dlg = new TriggerClockDialog(this, "Clock Trigger", true);
        this.showDialog(dlg);
    }

    public void jMenuItemExternal_actionPerformed(ActionEvent e) {
        this.cleanStatusBar();
        TriggerExternalDialog dlg = new TriggerExternalDialog(this, "External Trigger", true);
        this.showDialog(dlg);
    }

    public void jMenuItemAuto_actionPerformed(ActionEvent e) {
        this.cleanStatusBar();
    }

    public void jMenuItemIPAddress_actionPerformed(ActionEvent e) {
        this.cleanStatusBar();
        IPConfigDialog dlg = new IPConfigDialog(this, "Config IP", true);
        this.showDialog(dlg);
    }

    public void jMenuItemResetFactory_actionPerformed(ActionEvent e) {
        this.cleanStatusBar();
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            edasIO.config(0, 3829, (Edas24IPIO.Body)new Edas24IPIO.RESET_FACTORY());
            this.statusBar.setText("System will restart to factory after 3 minutes");
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            this.statusBar.setText(ioEx.getMessage());
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            this.statusBar.setText(ex.getMessage());
        }
    }

    public void jMenuItemResetSystem_actionPerformed(ActionEvent e) {
        this.cleanStatusBar();
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            edasIO.config(0, 3828, (Edas24IPIO.Body)new Edas24IPIO.RESET());
            this.statusBar.setText("System will restart after 3 minutes");
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            this.statusBar.setText(ioEx.getMessage());
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            this.statusBar.setText(ex.getMessage());
        }
    }

    public void jMenuItemConnect_actionPerformed(ActionEvent e) {
        this.cleanStatusBar();
        ConnectDialog dlg = new ConnectDialog(this, "Connect...", true);
        this.showDialog(dlg);
    }
}

