/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor.edas.awt;

import cn.org.gddsn.liss.port.edas.Edas24IPIO;
import cn.org.gddsn.seis.monitor.edas.Controler;
import cn.org.gddsn.seis.monitor.edas.awt.EdasFrame;
import cn.org.gddsn.seis.monitor.edas.awt.TriggerClockDialog_Sensor_itemAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.TriggerClockDialog_jButtonCancel_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.TriggerClockDialog_jButtonGet_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.TriggerClockDialog_jButtonSet_actionAdapter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class TriggerClockDialog
extends Dialog {
    static Logger logger = Logger.getLogger(TriggerClockDialog.class);
    Panel panel1 = new Panel();
    BorderLayout borderLayout1 = new BorderLayout();
    Panel vbox1 = new Panel();
    Panel jPanel1 = new Panel();
    Button jButtonCancel = new Button();
    Button jButtonGet = new Button();
    Button jButtonSet = new Button();
    Panel jPanel2 = new Panel();
    Panel jPanel3 = new Panel();
    Panel jPanel4 = new Panel();
    Panel jPanel5 = new Panel();
    Panel jPanel7 = new Panel();
    Label jLabel1 = new Label();
    Choice jComboBoxSensor = new Choice();
    Checkbox jCheckBox1 = new Checkbox();
    Label jLabel2 = new Label();
    TextField jTextFieldTime = new TextField();
    Label jLabel3 = new Label();
    Label jLabel5 = new Label();
    TextField jTextFieldInterval = new TextField();
    TextField jTextFieldLength = new TextField();
    GridLayout gridLayout1 = new GridLayout();
    GridLayout gridLayout3 = new GridLayout();
    GridLayout gridLayout4 = new GridLayout();
    GridLayout gridLayout5 = new GridLayout();
    GridLayout gridLayout6 = new GridLayout();
    GridLayout gridLayout2 = new GridLayout();

    public TriggerClockDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            this.enableEvents(64L);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.toGUI();
    }

    public TriggerClockDialog() {
        this(new Frame(), "TriggerClockDialog", false);
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.jButtonCancel.setLabel("Cancel");
        this.jButtonCancel.addActionListener(new TriggerClockDialog_jButtonCancel_actionAdapter(this));
        this.jButtonGet.setLabel("Get");
        this.jButtonGet.addActionListener(new TriggerClockDialog_jButtonGet_actionAdapter(this));
        this.jButtonSet.setLabel("Set");
        this.jButtonSet.addActionListener(new TriggerClockDialog_jButtonSet_actionAdapter(this));
        this.jLabel1.setText("Sensor: ");
        this.jCheckBox1.setLabel("Repeat Trigger");
        this.jLabel2.setText("Trigger Time: ");
        this.jTextFieldTime.setText("1970-01-01 00:00:00");
        this.jLabel3.setText("Trigger Interval(Sec): ");
        this.jLabel5.setText("Event Length(Sec): ");
        this.jTextFieldInterval.setText("         ");
        this.jPanel7.setLayout(this.gridLayout1);
        this.jPanel5.setLayout(this.gridLayout3);
        this.jPanel4.setLayout(this.gridLayout4);
        this.jPanel2.setLayout(this.gridLayout5);
        this.jPanel3.setLayout(this.gridLayout6);
        this.vbox1.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setRows(5);
        this.add(this.panel1);
        this.panel1.add((Component)this.vbox1, "Center");
        this.vbox1.add(this.jPanel2);
        this.jPanel2.add(this.jLabel1);
        this.jComboBoxSensor.addItem("Sensor A");
        this.jComboBoxSensor.addItem("Sensor B");
        this.jComboBoxSensor.addItemListener(new TriggerClockDialog_Sensor_itemAdapter(this));
        this.jPanel2.add(this.jComboBoxSensor);
        this.vbox1.add(this.jPanel3);
        this.jPanel3.add(this.jCheckBox1);
        this.vbox1.add(this.jPanel4);
        this.jPanel4.add(this.jLabel2);
        this.jPanel4.add(this.jTextFieldTime);
        this.vbox1.add(this.jPanel5);
        this.jPanel5.add(this.jLabel3);
        this.jPanel5.add(this.jTextFieldInterval);
        this.vbox1.add(this.jPanel7);
        this.jPanel7.add(this.jLabel5);
        this.jPanel7.add(this.jTextFieldLength);
        this.panel1.add((Component)this.jPanel1, "South");
        this.jPanel1.add(this.jButtonSet);
        this.jPanel1.add(this.jButtonGet);
        this.jPanel1.add(this.jButtonCancel);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(windowEvent);
    }

    private void toGUI() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        int no = this.jComboBoxSensor.getSelectedIndex();
        try {
            Edas24IPIO.Frame frm = edasIO.inquire(no, 145);
            if (frm == null) {
                EdasFrame frame = (EdasFrame)this.getOwner();
                frame.warnStatusBar("Get Clock Trigger info failt!");
                return;
            }
            Edas24IPIO.TRIGGER_CLOCK info = (Edas24IPIO.TRIGGER_CLOCK)frm.body;
            if (info.repeat.get() == 0) {
                this.jCheckBox1.setState(false);
            } else {
                this.jCheckBox1.setState(true);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.jTextFieldTime.setText(sdf.format(new Date((long)info.triggerTime.get() * 1000L)));
            this.jTextFieldInterval.setText("" + info.timeInterval.get());
            this.jTextFieldLength.setText("" + info.eventLen.get());
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("IOException: " + ioEx.getMessage());
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("Exception: " + ex.getMessage());
            frame.enableGUI(false);
        }
    }

    private void toModel() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        int no = this.jComboBoxSensor.getSelectedIndex();
        try {
            Edas24IPIO.TRIGGER_CLOCK info = new Edas24IPIO.TRIGGER_CLOCK();
            boolean selected = this.jCheckBox1.getState();
            info.repeat.set((short)(selected ? 1 : 0));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            info.triggerTime.set((int)(sdf.parse(this.jTextFieldTime.getText()).getTime() / 1000L));
            info.timeInterval.set(Short.parseShort(this.jTextFieldInterval.getText()));
            info.eventLen.set(Integer.parseInt(this.jTextFieldLength.getText()));
            Edas24IPIO.Frame retFrm = edasIO.config(no, 145, (Edas24IPIO.Body)info);
            if (retFrm == null) {
                EdasFrame frame = (EdasFrame)this.getOwner();
                frame.warnStatusBar("Set Clock Trigger info failt!");
                return;
            }
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("IOException: " + ioEx.getMessage());
            frame.enableGUI(false);
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("Exception: " + ex.getMessage());
            frame.enableGUI(false);
        }
    }

    public void jButtonGet_actionPerformed(ActionEvent e) {
        this.toGUI();
    }

    public void jButtonSet_actionPerformed(ActionEvent e) {
        this.toModel();
        this.dispose();
    }

    public void jButtonCancel_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public void Sensor_itemStateChanged(ItemEvent ie) {
        this.toGUI();
    }
}

