/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor.edas.awt;

import cn.org.gddsn.liss.port.edas.Edas24IPIO;
import cn.org.gddsn.seis.monitor.edas.Controler;
import cn.org.gddsn.seis.monitor.edas.awt.EdasFrame;
import cn.org.gddsn.seis.monitor.edas.awt.StationParamDialog_jButtonCancel_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.StationParamDialog_jButtonGet_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.StationParamDialog_jButtonSet_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.StationParam_itemAdapter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import org.apache.log4j.Logger;

public class StationParamDialog
extends Dialog {
    static Logger logger = Logger.getLogger(StationParamDialog.class);
    Label jLabelStnName = new Label();
    TextField jTextFieldStnName = new TextField(10);
    Label jLabel1_short_name = new Label();
    TextField jTextFieldStn_sn = new TextField(10);
    Label jLabel_stn_sn = new Label();
    TextField jTextFieldShortName = new TextField(10);
    TextField jTextFieldSenNum = new TextField(10);
    Label jLabel_num_of_sen = new Label();
    Label jLabel_num_of_ch = new Label();
    TextField jTextFieldChanNum = new TextField(10);
    TextField jTextFieldLat = new TextField(10);
    Label jLabel_latitude = new Label();
    TextField jTextFieldLong = new TextField(10);
    Label jLabel_longitude = new Label();
    Label jLabel_altitude = new Label();
    Label jLabel_start_time = new Label();
    Label jLabel_net_flag = new Label();
    Label jLabel_version = new Label();
    TextField jTextFieldAlt = new TextField(10);
    TextField jTextFieldStartTime = new TextField(10);
    TextField jTextFieldNetFlag = new TextField(10);
    TextField jTextField1Version = new TextField(10);
    Button jButtonCancel = new Button();
    Button jButtonSet = new Button();
    Button jButtonGet = new Button();
    Panel panel1 = new Panel();
    Panel panel2 = new Panel();
    Panel panel3 = new Panel();
    Panel panel4 = new Panel();
    Panel panel5 = new Panel();
    Choice cardChoice = new Choice();

    public StationParamDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            this.enableEvents(64L);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.toGUI();
    }

    public StationParamDialog() {
        this(new Frame(), "StationParamDialog", false);
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.panel1.setLayout(new CardLayout());
        this.panel2.setLayout(new FlowLayout());
        this.add((Component)this.panel5, "North");
        this.panel5.add(this.cardChoice);
        this.cardChoice.addItem("Station_Info");
        this.cardChoice.addItem("GPS_Info");
        this.cardChoice.addItemListener(new StationParam_itemAdapter(this));
        this.add((Component)this.panel1, "Center");
        this.add((Component)this.panel2, "South");
        this.jLabelStnName.setText("station_Name:");
        this.jLabel1_short_name.setText("short_Name:");
        this.jLabel_stn_sn.setText("statiom_sn:");
        this.jLabel_num_of_sen.setText("num_Sensor:");
        this.jLabel_num_of_ch.setText("num_Channel:");
        this.jLabel_latitude.setText("Latitude:");
        this.jLabel_longitude.setText("Longitude:");
        this.jLabel_altitude.setText("Altitude");
        this.jLabel_start_time.setText("Start_Time:");
        this.jLabel_net_flag.setText("Net_Flag:");
        this.jLabel_version.setText("Version:");
        this.jButtonCancel.setLabel("Cancel");
        this.jButtonCancel.addActionListener(new StationParamDialog_jButtonCancel_actionAdapter(this));
        this.jButtonSet.setLabel("Set");
        this.jButtonSet.addActionListener(new StationParamDialog_jButtonSet_actionAdapter(this));
        this.jButtonGet.setLabel("Get");
        this.jButtonGet.addActionListener(new StationParamDialog_jButtonGet_actionAdapter(this));
        this.jTextField1Version.setEditable(false);
        this.jTextFieldStartTime.setEditable(false);
        this.jTextFieldChanNum.setEditable(false);
        this.jTextFieldSenNum.setEditable(false);
        this.panel3.setLayout(new GridLayout(6, 2));
        this.panel4.setLayout(new GridLayout(6, 2));
        this.panel3.add(this.jLabel_stn_sn);
        this.panel3.add(this.jTextFieldStn_sn);
        this.panel3.add(this.jLabelStnName);
        this.panel3.add(this.jTextFieldStnName);
        this.panel3.add(this.jLabel1_short_name);
        this.panel3.add(this.jTextFieldShortName);
        this.panel3.add(this.jLabel_num_of_sen);
        this.panel3.add(this.jTextFieldSenNum);
        this.panel3.add(this.jLabel_num_of_ch);
        this.panel3.add(this.jTextFieldChanNum);
        this.panel4.add(this.jLabel_latitude);
        this.panel4.add(this.jTextFieldLat);
        this.panel4.add(this.jLabel_longitude);
        this.panel4.add(this.jTextFieldLong);
        this.panel4.add(this.jLabel_altitude);
        this.panel4.add(this.jTextFieldAlt);
        this.panel4.add(this.jLabel_start_time);
        this.panel4.add(this.jTextFieldStartTime);
        this.panel4.add(this.jLabel_net_flag);
        this.panel4.add(this.jTextFieldNetFlag);
        this.panel4.add(this.jLabel_version);
        this.panel4.add(this.jTextField1Version);
        this.panel2.add(this.jButtonSet);
        this.panel2.add(this.jButtonGet);
        this.panel2.add(this.jButtonCancel);
        this.panel1.add((Component)this.panel3, "Station_Info");
        this.panel1.add((Component)this.panel4, "GPS_Info");
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(windowEvent);
    }

    public void jButtonCancel_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public void jButtonGet_actionPerformed(ActionEvent e) {
        this.toGUI();
    }

    public void jButtonSet_actionPerformed(ActionEvent e) {
        this.toModel();
        this.dispose();
    }

    public void toModel() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            Edas24IPIO.STATION_INFO info = new Edas24IPIO.STATION_INFO();
            info.stanum.set(Short.parseShort(this.jTextFieldStn_sn.getText()));
            info.name.set(this.jTextFieldStnName.getText());
            info.abb.set(this.jTextFieldShortName.getText());
            info.lat.set((int)(Float.parseFloat(this.jTextFieldLat.getText()) * 3600000.0f));
            info.lon.set((int)(Float.parseFloat(this.jTextFieldLong.getText()) * 3600000.0f));
            info.alt.set((int)(Float.parseFloat(this.jTextFieldAlt.getText()) * 100000.0f));
            info.netmark.set(this.jTextFieldNetFlag.getText());
            edasIO.config(0, 0, (Edas24IPIO.Body)info);
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("IOException: " + ioEx.getMessage());
            frame.enableGUI(false);
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("Exception: " + ex.getMessage());
            frame.enableGUI(false);
        }
    }

    private void toGUI() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            Edas24IPIO.Frame frm = edasIO.inquire(0, 0);
            Edas24IPIO.STATION_INFO info = (Edas24IPIO.STATION_INFO)frm.body;
            this.jTextFieldStn_sn.setText("" + info.stanum.get());
            this.jTextFieldStnName.setText(info.name.get());
            this.jTextFieldShortName.setText(info.abb.get());
            this.jTextFieldSenNum.setText("" + info.seinum.get());
            this.jTextFieldChanNum.setText("" + info.chnum.get());
            this.jTextFieldLat.setText("" + (double)info.lat.get() / 3600000.0);
            this.jTextFieldLong.setText("" + (double)info.lon.get() / 3600000.0);
            this.jTextFieldAlt.setText("" + (double)info.alt.get() / 100.0 / 1000.0);
            this.jTextFieldStartTime.setText(info.useDate.get());
            this.jTextFieldNetFlag.setText(info.netmark.get());
            this.jTextField1Version.setText(info.version.get());
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("IOException: " + ioEx.getMessage());
            frame.enableGUI(false);
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("Exception: " + ex.getMessage());
            frame.enableGUI(false);
        }
    }

    public void stationParam_itemStateChanged(ItemEvent ie) {
        CardLayout cl = (CardLayout)this.panel1.getLayout();
        cl.show(this.panel1, (String)ie.getItem());
    }
}

