/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor.edas.awt;

import cn.org.gddsn.liss.port.edas.Edas24IPIO;
import cn.org.gddsn.seis.monitor.edas.Controler;
import cn.org.gddsn.seis.monitor.edas.awt.EdasFrame;
import cn.org.gddsn.seis.monitor.edas.awt.GPSStatusDialog_jButtonCancel_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.awt.GPSStatusDialog_jButtonGet_actionAdapter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class GPSStatusDialog
extends Dialog {
    static Logger logger = Logger.getLogger(GPSStatusDialog.class);
    Label jLabelSync = new Label();
    TextField jTextFieldSync = new TextField();
    Label jLabelStnName = new Label();
    TextField jTextFieldDop = new TextField();
    Label jLabel1_short_name = new Label();
    TextField jTextFieldClock = new TextField();
    Label jLabel_stn_sn = new Label();
    TextField jTextFieldRcvStatus = new TextField();
    TextField jTextFieldStar = new TextField();
    Label jLabel_num_of_sen = new Label();
    TextField jTextFieldLat = new TextField();
    Label jLabel_latitude = new Label();
    TextField jTextFieldLong = new TextField();
    Label jLabel_longitude = new Label();
    Label jLabel_altitude = new Label();
    Label jLabel_time_err = new Label();
    Label jLabel_freq_err = new Label();
    TextField jTextFieldAlt = new TextField();
    TextField jTextFieldTimeErr = new TextField();
    TextField jTextFieldFreqErr = new TextField();
    Button jButtonCancel = new Button();
    Button jButtonGet = new Button();
    Panel jpanel1 = new Panel();
    Panel jpanel2 = new Panel();

    public GPSStatusDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            this.enableEvents(64L);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.toGUI();
    }

    public GPSStatusDialog() {
        this(new Frame(), "GPSStatusDialog", false);
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.jpanel1.setLayout(new GridLayout(5, 4));
        this.jpanel2.setLayout(new FlowLayout());
        this.add((Component)this.jpanel1, "Center");
        this.add((Component)this.jpanel2, "South");
        this.jLabelStnName.setText("Dop:");
        this.jLabel1_short_name.setText("Rcv Stat:");
        this.jLabel_stn_sn.setText("GPS Clock:");
        this.jLabel_num_of_sen.setText("Star NO.");
        this.jLabel_latitude.setText("Latitude:");
        this.jLabel_longitude.setText("Longitude:");
        this.jLabel_altitude.setText("Altitude:");
        this.jLabel_time_err.setText("Time Err:");
        this.jLabel_freq_err.setText("Freq Err:");
        this.jLabelSync.setText("Sync Flag:");
        this.jButtonCancel.setLabel("Cancel");
        this.jButtonCancel.addActionListener(new GPSStatusDialog_jButtonCancel_actionAdapter(this));
        this.jButtonGet.setLabel("Get");
        this.jButtonGet.addActionListener(new GPSStatusDialog_jButtonGet_actionAdapter(this));
        this.jTextFieldSync.setEditable(false);
        this.jTextFieldTimeErr.setEditable(false);
        this.jTextFieldStar.setEditable(false);
        this.jTextFieldDop.setEditable(false);
        this.jTextFieldLat.setEditable(false);
        this.jTextFieldAlt.setEditable(false);
        this.jTextFieldFreqErr.setEditable(false);
        this.jTextFieldRcvStatus.setEditable(false);
        this.jTextFieldClock.setEditable(false);
        this.jTextFieldLong.setEditable(false);
        this.jpanel1.add(this.jLabelSync);
        this.jpanel1.add(this.jTextFieldSync);
        this.jpanel1.add((Component)this.jLabel_stn_sn, null);
        this.jpanel1.add((Component)this.jTextFieldClock, null);
        this.jpanel1.add((Component)this.jLabelStnName, null);
        this.jpanel1.add((Component)this.jTextFieldDop, null);
        this.jpanel1.add((Component)this.jLabel1_short_name, null);
        this.jpanel1.add((Component)this.jTextFieldRcvStatus, null);
        this.jpanel1.add((Component)this.jLabel_num_of_sen, null);
        this.jpanel1.add((Component)this.jTextFieldStar, null);
        this.jpanel1.add((Component)this.jLabel_latitude, null);
        this.jpanel1.add((Component)this.jTextFieldLat, null);
        this.jpanel1.add((Component)this.jLabel_longitude, null);
        this.jpanel1.add((Component)this.jTextFieldLong, null);
        this.jpanel1.add((Component)this.jLabel_altitude, null);
        this.jpanel1.add((Component)this.jTextFieldAlt, null);
        this.jpanel1.add((Component)this.jLabel_time_err, null);
        this.jpanel1.add((Component)this.jTextFieldTimeErr, null);
        this.jpanel1.add((Component)this.jLabel_freq_err, null);
        this.jpanel1.add((Component)this.jTextFieldFreqErr, null);
        this.jpanel2.add((Component)this.jButtonGet, null);
        this.jpanel2.add((Component)this.jButtonCancel, null);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(windowEvent);
    }

    public void jButtonCancel_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public void jButtonGet_actionPerformed(ActionEvent e) {
        this.toGUI();
    }

    private void toGUI() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            Edas24IPIO.Frame frm = edasIO.inquire(0, 129);
            Edas24IPIO.GPS_INFO info = (Edas24IPIO.GPS_INFO)frm.body;
            this.jTextFieldSync.setText("" + info.sync.get());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            short year = info.year.get();
            byte month = info.month.get();
            byte day = info.day.get();
            byte hour = info.hour.get();
            byte min = info.minute.get();
            byte second = info.second.get();
            GregorianCalendar cal = new GregorianCalendar(year, month, day, hour, min, second);
            this.jTextFieldClock.setText(sdf.format(cal.getTime()));
            this.jTextFieldDop.setText("" + info.dop.get());
            this.jTextFieldRcvStatus.setText("" + info.rcvStatus.get());
            this.jTextFieldStar.setText("" + info.star.get());
            this.jTextFieldLat.setText("" + (double)info.lat.get() / 3600000.0);
            this.jTextFieldLong.setText("" + (double)info.lon.get() / 3600000.0);
            this.jTextFieldAlt.setText("" + (double)info.alt.get() / 100.0 / 1000.0);
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("IOException: " + ioEx.getMessage());
            frame.enableGUI(false);
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("Exception: " + ex.getMessage());
            frame.enableGUI(false);
        }
    }
}

