/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor.edas;

import cn.org.gddsn.liss.port.MiniSeedStreamInf;
import cn.org.gddsn.liss.port.edas.EdasServPort;
import cn.org.gddsn.liss.port.event.MiniSeedPortEvent;
import cn.org.gddsn.liss.port.event.MiniSeedPortEventListener;
import cn.org.gddsn.seis.monitor.edas.Controler;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class EdasServPortWrapper
implements MiniSeedStreamInf {
    static Logger logger = Logger.getLogger(Controler.class);
    private transient Vector miniSeedPortEventListeners;
    protected Thread sendSeedDataThread = null;
    private EdasServPort edasServPort;

    public void setEdasServPort(EdasServPort comServPort) {
        this.edasServPort = comServPort;
        this.sendSMinieedData();
    }

    public synchronized void addMiniSeedPortEventListener(MiniSeedPortEventListener l) {
        Vector v;
        Vector vector = v = this.miniSeedPortEventListeners == null ? new Vector(2) : (Vector)this.miniSeedPortEventListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.miniSeedPortEventListeners = v;
        }
    }

    public synchronized void removeMiniSeedPortEventListener(MiniSeedPortEventListener l) {
        if (this.miniSeedPortEventListeners != null && this.miniSeedPortEventListeners.contains(l)) {
            Vector v = (Vector)this.miniSeedPortEventListeners.clone();
            v.removeElement(l);
            this.miniSeedPortEventListeners = v;
        }
    }

    protected void fireMiniSeedEvent(MiniSeedPortEvent e) {
        if (this.miniSeedPortEventListeners != null) {
            Vector listeners = this.miniSeedPortEventListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((MiniSeedPortEventListener)listeners.elementAt(i)).miniSeedEvent(e);
                ++i;
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public void close() {
        try {
            if (this.edasServPort != null) {
                this.edasServPort.closeComServPort();
            }
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
        }
    }

    protected void sendSMinieedData() {
        this.sendSeedDataThread = new Thread(){

            public void run() {
                GenericMiniSeedRecord gmsRec = null;
                byte[] bytes = null;
                byte[] buf = new byte[512];
                block6: while (true) {
                    try {
                        bytes = EdasServPortWrapper.this.edasServPort.readMiniSeedFrame();
                    }
                    catch (IOException ioEx) {
                        logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
                        try {
                            EdasServPortWrapper.this.edasServPort.openComServPort();
                        }
                        catch (IOException ex) {
                            logger.warn((Object)ex.getMessage(), (Throwable)ex);
                            try {
                                Thread.sleep(20000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    int c = bytes.length / 512;
                    int i = 0;
                    while (true) {
                        if (i >= c) continue block6;
                        System.arraycopy(bytes, i * 512, buf, 0, 512);
                        gmsRec = GenericMiniSeedRecord.buildMiniSeedRecord((byte[])buf);
                        if (gmsRec != null && EdasServPortWrapper.this.accept(gmsRec)) {
                            MiniSeedPortEvent e = new MiniSeedPortEvent((Object)this, gmsRec);
                            EdasServPortWrapper.this.fireMiniSeedEvent(e);
                        }
                        ++i;
                    }
                    break;
                }
            }
        };
        this.sendSeedDataThread.setName("SendSeedDataThread");
        this.sendSeedDataThread.start();
    }

    public String[] getStationCode() {
        return null;
    }

    public boolean accept(GenericMiniSeedRecord gmsr) {
        return true;
    }

    public EdasServPort getEdasServPort() {
        return this.edasServPort;
    }

    public void closePort() {
    }

    public boolean connectOK() {
        return false;
    }

    public boolean connectServer() {
        return false;
    }

    public void openPort() {
    }

    public byte[] readMiniSeedFrame() throws IOException {
        return null;
    }
}

