/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor;

import cn.org.gddsn.liss.client.LissClient;
import cn.org.gddsn.liss.client.LissException;
import cn.org.gddsn.liss.message.Result;
import cn.org.gddsn.util.Log4jConfig;
import cn.org.gddsn.util.QueueAddElementEventListener;
import cn.org.gddsn.util.SynchronizedFixQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.apache.log4j.Logger;

public class MonitorClient {
    static Logger logger = Logger.getLogger(MonitorClient.class);
    private String host = "192.168.168.10";
    private int port = 5000;
    private String user = "liss";
    private String passwd = "liss";
    private LissClient client = null;
    private InputStream monitorInputStream = null;
    private boolean connectionOK = false;
    private boolean bQuit = false;
    private SynchronizedFixQueue monitorQueue = new SynchronizedFixQueue(50, "monitorQueue");

    public void init() {
        this.receiveMonitorMessage();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public void addMonitorMessageListener(QueueAddElementEventListener listener) {
        this.monitorQueue.addQueueAddElementEventListener(listener);
    }

    public void removeMonitorMessageListener(QueueAddElementEventListener listener) {
        this.monitorQueue.removeQueueAddElementEventListener(listener);
    }

    public boolean isConnectionOK() {
        return this.connectionOK;
    }

    public void connectServer() throws IOException, LissException {
        this.client = new LissClient(this.host, this.port);
        this.client.login(this.user, this.passwd);
        this.monitorInputStream = this.client.retrieveResult("MONITOR").getInputStream();
    }

    public void quit() {
        try {
            this.client.quit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.bQuit = true;
    }

    private void loopConnect() {
        while (!this.bQuit) {
            try {
                this.connectServer();
                logger.info((Object)("Connected " + this.host));
                this.connectionOK = true;
                break;
            }
            catch (Exception ex) {
                this.connectionOK = false;
                logger.warn((Object)ex.getMessage());
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void receiveMonitorMessage() {
        this.loopConnect();
        Thread thread = new Thread("MonitorMessageDispatcher"){

            public void run() {
                Result res = null;
                while (!MonitorClient.this.bQuit) {
                    try {
                        res = null;
                        res = Result.buildResult((InputStream)MonitorClient.this.monitorInputStream);
                        if (res != null) {
                            MonitorClient.this.monitorQueue.addBack((Object)res);
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Got a result: " + res));
                            continue;
                        }
                        MonitorClient.this.loopConnect();
                    }
                    catch (InterruptedIOException iioEx) {
                        logger.warn((Object)("InterruptedIOException: " + iioEx.getMessage()));
                        MonitorClient.this.loopConnect();
                    }
                    catch (IOException ioEx) {
                        ioEx.printStackTrace();
                        logger.warn((Object)("IOException: " + ioEx.getMessage()));
                        MonitorClient.this.loopConnect();
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] args) {
        Log4jConfig.loadForMain((String)"MonitorClient.properties");
        MonitorClient monitorClient1 = new MonitorClient();
        monitorClient1.init();
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }
}

