/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor;

import cn.org.gddsn.liss.message.MemoryStatus;
import cn.org.gddsn.liss.message.MessageParseException;
import cn.org.gddsn.liss.message.Result;
import cn.org.gddsn.seis.monitor.LocaleResource;
import cn.org.gddsn.seis.monitor.MonitorJApplet;
import cn.org.gddsn.util.QueueAddElementEvent;
import cn.org.gddsn.util.QueueAddElementEventListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MemoryMonitor
extends JPanel
implements QueueAddElementEventListener {
    BorderLayout borderLayout1 = new BorderLayout();
    Surface surf;
    float freeMemory = 1.0f;
    float totalMemory = 1.0f;
    private Object lock = new Object();

    public MemoryMonitor() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void config() {
        MonitorJApplet.monitorClient.addMonitorMessageListener(this);
        this.surf.start();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(), LocaleResource.getResourceString("MemoryMonitor")));
        this.surf = new Surface();
        this.add(this.surf);
    }

    public void stop() {
        this.surf.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void QueueAddElementHandler(QueueAddElementEvent e) {
        Result res = (Result)e.getValue();
        if (res.getType() != 131075) {
            return;
        }
        try {
            MemoryStatus mem = new MemoryStatus(res);
            this.freeMemory = mem.getFreeInM();
            this.totalMemory = mem.getTotalInM();
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
        catch (MessageParseException mpEx) {
            mpEx.printStackTrace();
        }
    }

    public static void main(String[] s) {
        MemoryMonitor demo = new MemoryMonitor();
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        JFrame f = new JFrame("NetSeis/IP Srever\ufffd\ufffd-- \ufffd\u06b4\ufffd\ufffd\ufffd\ufffd");
        f.addWindowListener(l);
        f.getContentPane().add("Center", demo);
        f.pack();
        f.setSize(new Dimension(200, 200));
        f.setVisible(true);
        demo.surf.start();
    }

    public class Surface
    extends JPanel
    implements Runnable {
        public Thread thread;
        public long sleepAmount = 1000L;
        private int w;
        private int h;
        private BufferedImage bimg;
        private Graphics2D big;
        private Font font = new Font("Times New Roman", 0, 11);
        private int columnInc;
        private int[] pts;
        private int ptNum;
        private int ascent;
        private int descent;
        private Rectangle graphOutlineRect = new Rectangle();
        private Rectangle2D mfRect = new Rectangle2D.Float();
        private Rectangle2D muRect = new Rectangle2D.Float();
        private Line2D graphLine = new Line2D.Float();
        private Color graphColor = new Color(46, 139, 87);
        private Color mfColor = new Color(0, 100, 0);
        private String usedStr;

        public Surface() {
            this.setBackground(Color.black);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return new Dimension(270, 160);
        }

        public void paint(Graphics g) {
            if (this.big == null) {
                return;
            }
            this.big.setBackground(this.getBackground());
            this.big.clearRect(0, 0, this.w, this.h);
            this.big.setColor(Color.green);
            this.big.drawString(String.valueOf(String.valueOf(MemoryMonitor.this.totalMemory)) + "M allocated", 4.0f, (float)this.ascent + 0.5f);
            this.usedStr = String.valueOf(String.valueOf(MemoryMonitor.this.totalMemory - MemoryMonitor.this.freeMemory)) + "M used";
            this.big.drawString(this.usedStr, 4, this.h - this.descent);
            float ssH = this.ascent + this.descent;
            float remainingHeight = (float)this.h - ssH * 2.0f - 0.5f;
            float blockHeight = remainingHeight / 10.0f;
            float blockWidth = 20.0f;
            this.big.setColor(this.mfColor);
            int MemUsage = (int)(MemoryMonitor.this.freeMemory / MemoryMonitor.this.totalMemory * 10.0f);
            int i = 0;
            while (i < MemUsage) {
                this.mfRect.setRect(5.0, ssH + (float)i * blockHeight, blockWidth, blockHeight - 1.0f);
                this.big.fill(this.mfRect);
                ++i;
            }
            this.big.setColor(Color.green);
            while (i < 10) {
                this.muRect.setRect(5.0, ssH + (float)i * blockHeight, blockWidth, blockHeight - 1.0f);
                this.big.fill(this.muRect);
                ++i;
            }
            this.big.setColor(this.graphColor);
            int graphX = 30;
            int graphY = (int)ssH;
            int graphW = this.w - graphX - 5;
            int graphH = (int)remainingHeight;
            this.graphOutlineRect.setRect(graphX, graphY, graphW, graphH);
            this.big.draw(this.graphOutlineRect);
            int graphRow = graphH / 10;
            int j = graphY;
            while (j <= graphH + graphY) {
                this.graphLine.setLine(graphX, j, graphX + graphW, j);
                this.big.draw(this.graphLine);
                j += graphRow;
            }
            int graphColumn = graphW / 15;
            if (this.columnInc == 0) {
                this.columnInc = graphColumn;
            }
            int j2 = graphX + this.columnInc;
            while (j2 < graphW + graphX) {
                this.graphLine.setLine(j2, graphY, j2, graphY + graphH);
                this.big.draw(this.graphLine);
                j2 += graphColumn;
            }
            --this.columnInc;
            if (this.pts == null) {
                this.pts = new int[graphW];
                this.ptNum = 0;
            } else if (this.pts.length != graphW) {
                int[] tmp = null;
                if (this.ptNum < graphW) {
                    tmp = new int[this.ptNum];
                    System.arraycopy(this.pts, 0, tmp, 0, tmp.length);
                } else {
                    tmp = new int[graphW];
                    System.arraycopy(this.pts, this.pts.length - tmp.length, tmp, 0, tmp.length);
                    this.ptNum = tmp.length - 2;
                }
                this.pts = new int[graphW];
                System.arraycopy(tmp, 0, this.pts, 0, tmp.length);
            } else {
                this.big.setColor(Color.yellow);
                this.pts[this.ptNum] = (int)((float)graphY + (float)graphH * (MemoryMonitor.this.freeMemory / MemoryMonitor.this.totalMemory));
                j2 = graphX + graphW - this.ptNum;
                int k = 0;
                while (k < this.ptNum) {
                    if (k != 0) {
                        if (this.pts[k] != this.pts[k - 1]) {
                            this.big.drawLine(j2 - 1, this.pts[k - 1], j2, this.pts[k]);
                        } else {
                            this.big.fillRect(j2, this.pts[k], 1, 1);
                        }
                    }
                    ++k;
                    ++j2;
                }
                if (this.ptNum + 2 == this.pts.length) {
                    j2 = 1;
                    while (j2 < this.ptNum) {
                        this.pts[j2 - 1] = this.pts[j2];
                        ++j2;
                    }
                    --this.ptNum;
                } else {
                    ++this.ptNum;
                }
            }
            g.drawImage(this.bimg, 0, 0, this);
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("MemoryMonitor");
            this.thread.start();
        }

        public synchronized void stop() {
            this.thread = null;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread me = Thread.currentThread();
            while (this.thread == me && !this.isShowing() || this.getSize().width == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            while (this.thread == me && this.isShowing()) {
                Object fm;
                Dimension d = this.getSize();
                if (d.width != this.w || d.height != this.h) {
                    this.w = d.width;
                    this.h = d.height;
                    this.bimg = (BufferedImage)this.createImage(this.w, this.h);
                    this.big = this.bimg.createGraphics();
                    this.big.setFont(this.font);
                    fm = this.big.getFontMetrics(this.font);
                    this.ascent = ((FontMetrics)fm).getAscent();
                    this.descent = ((FontMetrics)fm).getDescent();
                }
                fm = MemoryMonitor.this.lock;
                synchronized (fm) {
                    try {
                        MemoryMonitor.this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.repaint();
                try {
                    Thread.sleep(this.sleepAmount);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            this.thread = null;
        }
    }
}

