/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor;

import cn.org.gddsn.seis.monitor.AlarmJPanel;
import cn.org.gddsn.util.Log4jConfig;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class AlarmTopicHandler
implements MessageListener {
    static Logger logger = Logger.getLogger(AlarmTopicHandler.class);
    private JmsTemplate jmsTemplate;
    private AlarmJPanel alarmJPanel;

    public void send(final String startOrStop) {
        this.jmsTemplate.send(new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return session.createTextMessage("Alarm/" + startOrStop);
            }
        });
    }

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            TextMessage tm = (TextMessage)message;
            try {
                String msg = tm.getText();
                logger.info((Object)("Got msg: " + msg));
                if (msg.equals("Alarm/Start") && this.alarmJPanel != null) {
                    this.alarmJPanel.startEventAlarm();
                }
                if (msg.equals("Alarm/Stop") && this.alarmJPanel != null) {
                    this.alarmJPanel.stopEventAlarm();
                }
            }
            catch (JMSException ex) {
                logger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setAlarmJPanel(AlarmJPanel alarmJPanel) {
        this.alarmJPanel = alarmJPanel;
    }

    public static void main(String[] args) {
        Log4jConfig.loadForMain((String)"log4j.properties");
        FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext(new String[]{"src/cn/org/gddsn/seis/monitor/MonitorJApplet.xml"});
        AlarmTopicHandler ath = new AlarmTopicHandler();
        DefaultMessageListenerContainer container = (DefaultMessageListenerContainer)ctx.getBean("listenerContainer");
        container.start();
        ath.send("Stop");
    }
}

