/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor;

import cn.org.gddsn.seis.monitor.StationInfo;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlarmStrategy {
    static Logger logger = Logger.getLogger(AlarmStrategy.class);
    private static final int FRS = 1;
    private static final int NRS = 2;
    private static final int UNKNOW = 0;
    private static final int FRAME_RELAY = 1;
    private static final int SDH = 2;
    private static final int SATELLITE = 3;
    private static final int VPDN = 4;
    private static final int ADSL = 5;
    private static final int BROKE = 0;
    private static final int NORMAL = 1;
    private static final int TRIGGER = 2;
    private ArrayList<StationInfo> stationList = null;
    private ArrayList<String> brokeAlarmStations = null;
    private ArrayList<String> triggerAlarmStations = null;
    private ArrayList<String> brokenNet = null;
    private ArrayList<StationInfo> fastReportSta = null;
    private ArrayList<StationInfo> notFastReportSta = null;
    private ArrayList<StationInfo> station_FR = null;
    private ArrayList<StationInfo> station_SDH = null;
    private ArrayList<StationInfo> station_SATELLITE = null;
    private ArrayList<StationInfo> station_VPDN = null;
    private ArrayList<StationInfo> station_ADSL = null;
    private ArrayList<StationInfo> station_UNKNOW = null;
    private ArrayList<StationInfo>[] otherNetSta = null;
    private boolean brokeAlarmStatus = false;
    private boolean triggerAlarmStatus = false;
    private int alarmIntervalTime = 180;
    private int alarmBrokeLeastSta = 3;
    private int startTime = 0;
    private int endTime = 0;
    private int statusSeq = 0;
    private String[] monitorNet = new String[]{"GD"};
    private String[] otherNetwork = new String[]{"GX"};
    private int brokenAlarmType = 0;

    public AlarmStrategy() {
        this.stationList = new ArrayList();
        this.brokeAlarmStations = new ArrayList();
        this.triggerAlarmStations = new ArrayList();
    }

    public AlarmStrategy(String[] stationName) {
        this.stationList = new ArrayList();
        this.brokeAlarmStations = new ArrayList();
        this.triggerAlarmStations = new ArrayList();
        StationInfo sta = null;
        int i = 0;
        while (i < stationName.length) {
            sta = new StationInfo(stationName[i]);
            sta.setReportType(2);
            sta.setTransmitType(0);
            this.stationList.add(sta);
            ++i;
        }
    }

    public void setAlarmIntervalTime(int time) {
        this.alarmIntervalTime = time;
    }

    public int getAlarmIntervalTime() {
        return this.alarmIntervalTime;
    }

    public void setAlarmLeastSta(int num) {
        this.alarmBrokeLeastSta = num;
    }

    public int getAlarmLeastSta() {
        return this.alarmBrokeLeastSta;
    }

    public void setUseStrategyStartTime(int hour) {
        this.startTime = hour;
    }

    public int getUseStartegyStartTime() {
        return this.startTime;
    }

    public void setCancelStrategyTime(int hour) {
        this.endTime = hour;
    }

    public int getCancelStrategyTime() {
        return this.endTime;
    }

    public int getBrokenAlarmType() {
        return this.brokenAlarmType;
    }

    public void setMonitorNet(String[] net) {
        this.monitorNet = net;
    }

    public String[] getMonitorNet() {
        return this.monitorNet;
    }

    public void setOtherNet(String[] net) {
        this.otherNetwork = net;
    }

    public String[] getOtherNet() {
        return this.otherNetwork;
    }

    public String getBrokenNet() {
        return this.brokenNet.toString();
    }

    public void setStations(String[] stationName) {
        StationInfo sta = null;
        int i = 0;
        while (i < stationName.length) {
            sta = new StationInfo(stationName[i]);
            sta.setReportType(2);
            sta.setTransmitType(0);
            this.stationList.add(sta);
            ++i;
        }
    }

    public String[] getFastReportStations() {
        String[] str = new String[this.fastReportSta.size()];
        int i = 0;
        while (i < this.fastReportSta.size()) {
            StationInfo sta = this.fastReportSta.get(i);
            str[i] = sta.getStationName();
            ++i;
        }
        return str;
    }

    public String[] getFRStations() {
        String[] str = new String[this.station_FR.size()];
        int i = 0;
        while (i < this.station_FR.size()) {
            StationInfo sta = this.station_FR.get(i);
            str[i] = sta.getStationName();
            ++i;
        }
        return str;
    }

    public String[] getSDHStations() {
        String[] str = new String[this.station_SDH.size()];
        int i = 0;
        while (i < this.station_SDH.size()) {
            StationInfo sta = this.station_SDH.get(i);
            str[i] = sta.getStationName();
            ++i;
        }
        return str;
    }

    public String[] getSATELLITEStations() {
        String[] str = new String[this.station_SATELLITE.size()];
        int i = 0;
        while (i < this.station_SATELLITE.size()) {
            StationInfo sta = this.station_SATELLITE.get(i);
            str[i] = sta.getStationName();
            ++i;
        }
        return str;
    }

    public String[] getVPDNStations() {
        String[] str = new String[this.station_VPDN.size()];
        int i = 0;
        while (i < this.station_VPDN.size()) {
            StationInfo sta = this.station_VPDN.get(i);
            str[i] = sta.getStationName();
            ++i;
        }
        return str;
    }

    public String[] getADSLStations() {
        String[] str = new String[this.station_ADSL.size()];
        int i = 0;
        while (i < this.station_ADSL.size()) {
            StationInfo sta = this.station_ADSL.get(i);
            str[i] = sta.getStationName();
            ++i;
        }
        return str;
    }

    public void groupSetReportType(String[] stationName, int type) {
        StationInfo sta = null;
        int i = 0;
        while (i < stationName.length) {
            sta = this.getStationObject(stationName[i]);
            if (sta != null) {
                sta.setReportType(type);
            } else {
                sta = new StationInfo(stationName[i]);
                sta.setReportType(type);
                this.stationList.add(sta);
                logger.info((Object)(String.valueOf(stationName[i]) + " station object not exist,add it"));
            }
            ++i;
        }
    }

    public void groupSetTransmitType(String[] stationName, int type) {
        StationInfo sta = null;
        int i = 0;
        while (i < stationName.length) {
            sta = this.getStationObject(stationName[i]);
            if (sta != null) {
                sta.setTransmitType(type);
            } else {
                sta = new StationInfo(stationName[i]);
                sta.setTransmitType(type);
                this.stationList.add(sta);
                logger.info((Object)(String.valueOf(stationName[i]) + " station object not exist,add it"));
            }
            ++i;
        }
    }

    public void groupSetStationStatus(String[] stationName, int[] status) {
        StationInfo sta = null;
        int i = 0;
        while (i < stationName.length) {
            sta = this.getStationObject(stationName[i]);
            if (sta != null) {
                sta.setStatus(this.statusSeq, status[i]);
            } else {
                sta = new StationInfo(stationName[i]);
                sta.setStatus(this.statusSeq, status[i]);
                this.stationList.add(sta);
                logger.info((Object)(String.valueOf(stationName[i]) + " station object not exist,add it"));
            }
            ++i;
        }
        int j = 0;
        while (j < this.stationList.size()) {
            sta = this.stationList.get(j);
            if (!this.findStationObject(sta, stationName)) {
                this.stationList.remove(sta);
            }
            ++j;
        }
        this.processStrategy();
        ++this.statusSeq;
        if (this.statusSeq >= this.alarmIntervalTime / 150) {
            this.statusSeq = 0;
        }
        logger.info((Object)"group set stations status.");
    }

    public void setStationStatus(String stationName, int status, int count) {
        StationInfo sta = this.getStationObject(stationName);
        if (sta != null) {
            sta.setStatus(count, status);
        } else {
            logger.warn((Object)("set report type error:NO this station object: " + stationName));
        }
    }

    public int getStationStatus(String stationName, int count) {
        StationInfo sta = this.getStationObject(stationName);
        if (sta != null) {
            return sta.getStatus(count);
        }
        logger.warn((Object)("get report type error:NO this station object: " + stationName));
        return -1;
    }

    public void setReportType(String stationName, int type) {
        StationInfo sta = this.getStationObject(stationName);
        if (sta != null) {
            sta.setReportType(type);
        } else {
            logger.warn((Object)("set report type error:NO this station object: " + stationName));
        }
    }

    public int getReportType(String stationName) {
        StationInfo sta = this.getStationObject(stationName);
        if (sta != null) {
            return sta.getReportType();
        }
        logger.warn((Object)("get report type error:NO this station object: " + stationName));
        return -1;
    }

    public void setTransmitType(String stationName, int type) {
        StationInfo sta = this.getStationObject(stationName);
        if (sta != null) {
            sta.setTransmitType(type);
        } else {
            logger.warn((Object)("set transmit type error:NO this station object:" + stationName));
        }
    }

    public int getTransmitType(String stationName) {
        StationInfo sta = this.getStationObject(stationName);
        if (sta != null) {
            return sta.getTransmitType();
        }
        logger.warn((Object)("get report type error:NO this station object: " + stationName));
        return -1;
    }

    public void stationListClear() {
        this.stationList.clear();
    }

    public void setStationJoinAlarm(String stationName, boolean joinAlarm) {
        StationInfo sta = this.getStationObject(stationName);
        if (sta != null) {
            sta.setJoinAlarm(joinAlarm);
        } else {
            logger.warn((Object)("set join Alarm error:NO this station object: " + stationName));
        }
    }

    public boolean getStationJoinAlarm(String stationName) {
        StationInfo sta = this.getStationObject(stationName);
        if (sta != null) {
            return sta.getJoinAlarm();
        }
        logger.warn((Object)("get join Alarm error:NO this station object: " + stationName));
        return true;
    }

    private void addBrokeAlarmSta(String name) {
        boolean find = false;
        int i = 0;
        while (i < this.brokeAlarmStations.size()) {
            String brokeStation = this.brokeAlarmStations.get(i);
            if (brokeStation.equalsIgnoreCase(name)) {
                find = true;
                break;
            }
            ++i;
        }
        if (!find) {
            this.brokeAlarmStations.add(name);
        }
    }

    private StationInfo getStationObject(String name) {
        int i = 0;
        while (i < this.stationList.size()) {
            StationInfo sta = this.stationList.get(i);
            if (sta.name.equalsIgnoreCase(name)) {
                return sta;
            }
            ++i;
        }
        return null;
    }

    private boolean findStationObject(StationInfo sta, String[] stationName) {
        int i = 0;
        while (i < stationName.length) {
            if (sta.name.equalsIgnoreCase(stationName[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean getWhetherJoinAlarm(String stationName) {
        StationInfo sta = this.getStationObject(stationName);
        if (sta == null) {
            logger.warn((Object)("get station object from stationList error:NO this station object: " + stationName));
        }
        int activeTime = 0;
        int times = this.alarmIntervalTime / 150;
        int i = 0;
        while (i < times) {
            int status = sta.getStatus(i);
            if (status == 1 | status == 2) {
                ++activeTime;
            }
            ++i;
        }
        return activeTime >= times;
    }

    public void strategyInit() {
        StationInfo sta;
        int i;
        ArrayList<StationInfo> monitorStations = new ArrayList<StationInfo>();
        this.fastReportSta = new ArrayList();
        this.notFastReportSta = new ArrayList();
        this.station_FR = new ArrayList();
        this.station_SDH = new ArrayList();
        this.station_SATELLITE = new ArrayList();
        this.station_VPDN = new ArrayList();
        this.station_ADSL = new ArrayList();
        this.station_UNKNOW = new ArrayList();
        this.brokenNet = new ArrayList();
        if (this.monitorNet == null) {
            i = 0;
            while (i < this.stationList.size()) {
                sta = this.stationList.get(i);
                monitorStations.add(sta);
                System.out.println("add to monitor");
                ++i;
            }
        }
        this.otherNetSta = new ArrayList[this.otherNetwork.length];
        i = 0;
        while (i < this.otherNetwork.length) {
            this.otherNetSta[i] = new ArrayList();
            ++i;
        }
        i = 0;
        while (i < this.stationList.size()) {
            sta = this.stationList.get(i);
            int k = 0;
            while (k < this.monitorNet.length) {
                if (sta.getStationName().startsWith(this.monitorNet[k])) {
                    monitorStations.add(sta);
                    logger.info((Object)("monitor network station:" + sta.name));
                }
                ++k;
            }
            k = 0;
            while (k < this.otherNetwork.length) {
                if (sta.getStationName().startsWith(this.otherNetwork[k])) {
                    this.otherNetSta[k].add(sta);
                    logger.info((Object)("other network station:" + sta.name));
                }
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < monitorStations.size()) {
            sta = (StationInfo)monitorStations.get(i);
            if (sta.getReportType() == 1) {
                this.fastReportSta.add(sta);
            } else if (sta.getReportType() == 2) {
                this.notFastReportSta.add(sta);
            }
            switch (sta.getTransmitType()) {
                case 1: {
                    this.station_FR.add(sta);
                    break;
                }
                case 2: {
                    this.station_SDH.add(sta);
                    break;
                }
                case 3: {
                    this.station_SATELLITE.add(sta);
                    break;
                }
                case 4: {
                    this.station_VPDN.add(sta);
                    break;
                }
                case 5: {
                    this.station_ADSL.add(sta);
                    break;
                }
                default: {
                    this.station_UNKNOW.add(sta);
                }
            }
            ++i;
        }
    }

    public void processStrategy() {
        StationInfo sta;
        int brokeStationNum = 0;
        GregorianCalendar rightNow = new GregorianCalendar();
        int timeNow = rightNow.get(11);
        boolean useTimeStrategy = this.startTime == this.endTime ? true : (this.startTime < this.endTime ? timeNow >= this.startTime && timeNow < this.endTime : timeNow >= this.startTime || timeNow < this.endTime);
        logger.info((Object)("time now:" + timeNow));
        logger.info((Object)("whether use strategy:" + useTimeStrategy));
        this.brokeAlarmStatus = false;
        this.triggerAlarmStatus = false;
        this.brokeAlarmStations.clear();
        this.triggerAlarmStations.clear();
        int i = 0;
        while (i < this.stationList.size()) {
            sta = this.stationList.get(i);
            if (sta.getStatus(this.statusSeq) == 2) {
                this.triggerAlarmStatus = true;
                this.triggerAlarmStations.add(sta.getStationName());
                logger.info((Object)"Alarm: has station trigger");
            }
            ++i;
        }
        i = 0;
        while (i < this.fastReportSta.size()) {
            sta = this.fastReportSta.get(i);
            if (this.checkBroke(sta) && sta.getJoinAlarm()) {
                this.brokeAlarmStatus = true;
                this.brokenAlarmType = 1;
                this.addBrokeAlarmSta(sta.getStationName());
                logger.info((Object)"Alarm: fast report station broke");
            }
            ++i;
        }
        i = 0;
        while (i < this.notFastReportSta.size()) {
            sta = this.notFastReportSta.get(i);
            if (this.checkBroke(sta) && sta.getJoinAlarm()) {
                this.addBrokeAlarmSta(sta.getStationName());
            }
            ++i;
        }
        if (useTimeStrategy) {
            if (this.brokeAlarmStations.size() >= this.alarmBrokeLeastSta) {
                this.brokeAlarmStatus = true;
                this.brokenAlarmType = 3;
                logger.info((Object)"Alarm: use time strategy,but have more station broken");
            }
        } else if (this.brokeAlarmStations.size() > 0) {
            this.brokeAlarmStatus = true;
            this.brokenAlarmType = 2;
            logger.info((Object)"Alarm: not use time strategy,have stations broken");
        }
        logger.info((Object)("broken station numbers: " + this.brokeAlarmStations.size()));
        logger.info((Object)("broken station:" + this.brokeAlarmStations));
        brokeStationNum = 0;
        i = 0;
        while (i < this.station_FR.size()) {
            sta = this.station_FR.get(i);
            if (sta.getStatus(this.statusSeq) == 0 && sta.getJoinAlarm()) {
                ++brokeStationNum;
            }
            ++i;
        }
        if (brokeStationNum >= this.station_FR.size() && this.station_FR.size() > 0) {
            this.brokeAlarmStatus = true;
            this.brokenAlarmType = 4;
            logger.info((Object)"Alarm:Frame relay transmit type station all broke ");
            this.brokeAlarmStations.clear();
            i = 0;
            while (i < this.station_FR.size()) {
                sta = this.station_FR.get(i);
                this.addBrokeAlarmSta(sta.getStationName());
                ++i;
            }
        }
        brokeStationNum = 0;
        i = 0;
        while (i < this.station_SDH.size()) {
            sta = this.station_SDH.get(i);
            if (sta.getStatus(this.statusSeq) == 0 && sta.getJoinAlarm()) {
                ++brokeStationNum;
            }
            ++i;
        }
        if (brokeStationNum >= this.station_SDH.size() && this.station_SDH.size() > 0) {
            this.brokeAlarmStatus = true;
            this.brokenAlarmType = 5;
            logger.info((Object)"Alarm:SDH transmit type station all broke ");
            this.brokeAlarmStations.clear();
            i = 0;
            while (i < this.station_SDH.size()) {
                sta = this.station_SDH.get(i);
                this.addBrokeAlarmSta(sta.getStationName());
                ++i;
            }
        }
        brokeStationNum = 0;
        i = 0;
        while (i < this.station_SATELLITE.size()) {
            sta = this.station_SATELLITE.get(i);
            if (sta.getStatus(this.statusSeq) == 0 && sta.getJoinAlarm()) {
                ++brokeStationNum;
            }
            ++i;
        }
        if (brokeStationNum >= this.station_SATELLITE.size() && this.station_SATELLITE.size() > 0) {
            this.brokeAlarmStatus = true;
            this.brokenAlarmType = 6;
            logger.info((Object)"Alarm:SATELLITE transmit type station all broke ");
            this.brokeAlarmStations.clear();
            i = 0;
            while (i < this.station_SATELLITE.size()) {
                sta = this.station_SATELLITE.get(i);
                this.addBrokeAlarmSta(sta.getStationName());
                ++i;
            }
        }
        brokeStationNum = 0;
        i = 0;
        while (i < this.station_VPDN.size()) {
            sta = this.station_VPDN.get(i);
            if (sta.getStatus(this.statusSeq) == 0 && sta.getJoinAlarm()) {
                ++brokeStationNum;
            }
            ++i;
        }
        if (brokeStationNum >= this.station_VPDN.size() && this.station_VPDN.size() > 0) {
            this.brokeAlarmStatus = true;
            this.brokenAlarmType = 7;
            logger.info((Object)"Alarm:VPDN transmit type station all broke ");
            this.brokeAlarmStations.clear();
            i = 0;
            while (i < this.station_VPDN.size()) {
                sta = this.station_VPDN.get(i);
                this.addBrokeAlarmSta(sta.getStationName());
                ++i;
            }
        }
        brokeStationNum = 0;
        i = 0;
        while (i < this.station_ADSL.size()) {
            sta = this.station_ADSL.get(i);
            if (sta.getStatus(this.statusSeq) == 0 && sta.getJoinAlarm()) {
                ++brokeStationNum;
            }
            ++i;
        }
        if (brokeStationNum >= this.station_ADSL.size() && this.station_ADSL.size() > 0) {
            this.brokeAlarmStatus = true;
            this.brokenAlarmType = 8;
            logger.info((Object)"Alarm:ADSL transmit type station all broke ");
            this.brokeAlarmStations.clear();
            i = 0;
            while (i < this.station_ADSL.size()) {
                sta = this.station_ADSL.get(i);
                this.addBrokeAlarmSta(sta.getStationName());
                ++i;
            }
        }
        brokeStationNum = 0;
        this.brokenNet.clear();
        i = 0;
        while (i < this.otherNetSta.length) {
            brokeStationNum = 0;
            int j = 0;
            while (j < this.otherNetSta[i].size()) {
                sta = this.otherNetSta[i].get(j);
                if (sta.getStatus(this.statusSeq) == 0 && sta.getJoinAlarm()) {
                    ++brokeStationNum;
                }
                ++j;
            }
            if (brokeStationNum >= this.otherNetSta[i].size() && this.otherNetSta[i].size() > 0) {
                this.brokeAlarmStatus = true;
                this.brokenAlarmType = 9;
                this.brokenNet.add(this.otherNetwork[i]);
                logger.info((Object)("Alarm:" + this.otherNetwork[i] + " network station all broke "));
            }
            ++i;
        }
    }

    public boolean checkBroke(StationInfo sta) {
        int brokeTimes = 0;
        int i = 0;
        while (i < this.alarmIntervalTime / 150) {
            int status = sta.getStatus(i);
            if (status == 0) {
                ++brokeTimes;
            } else if (status == 1) {
                brokeTimes = 0;
            }
            ++i;
        }
        return brokeTimes >= this.alarmIntervalTime / 150 && sta.getJoinAlarm();
    }

    public boolean getBrokeAlarmStatus() {
        return this.brokeAlarmStatus;
    }

    public boolean getTriggerAlarmStatus() {
        return this.triggerAlarmStatus;
    }

    public ArrayList<String> getTriggerAlarmStations() {
        return this.triggerAlarmStations;
    }

    public ArrayList<String> getBrokeAlarmStations() {
        return this.brokeAlarmStations;
    }
}

