/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor;

import cn.org.gddsn.liss.message.Result;
import cn.org.gddsn.seis.monitor.AlarmTopicHandler;
import cn.org.gddsn.seis.monitor.LocaleResource;
import cn.org.gddsn.seis.monitor.MonitorJApplet;
import cn.org.gddsn.seis.monitor.StationJPanel;
import cn.org.gddsn.util.QueueAddElementEvent;
import cn.org.gddsn.util.QueueAddElementEventListener;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class AlarmJPanel
extends JPanel
implements QueueAddElementEventListener,
PropertyChangeListener {
    static Logger logger = Logger.getLogger(AlarmJPanel.class);
    AudioClip audioEQ = null;
    AudioClip audioBreakRcv = null;
    String alarmMsg = "";
    private boolean stationAlarm = false;
    GridLayout gridLayout3 = new GridLayout();
    JButton jbttnEventAlarm = new JButton();
    JButton jbttnBrokenAlarm = new JButton();
    JLabel jlblMsg = new JLabel();
    BorderLayout borderLayout1 = new BorderLayout();
    private boolean eventAlarm;
    private AlarmTopicHandler alarmTopicHandler;
    private JButton eqimAlarm = null;

    public AlarmJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jbttnEventAlarm.setText(LocaleResource.getResourceString("StopEventAlarm"));
        this.jbttnEventAlarm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlarmJPanel.this.button1_actionPerformed(e);
            }
        });
        this.jbttnBrokenAlarm.setText(LocaleResource.getResourceString("StopBrokenAlarm"));
        this.jbttnBrokenAlarm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlarmJPanel.this.button2_actionPerformed(e);
            }
        });
        this.jlblMsg.setHorizontalAlignment(0);
        this.jlblMsg.setText(this.alarmMsg);
        this.gridLayout3.setColumns(1);
        this.gridLayout3.setRows(0);
        this.setLayout(this.gridLayout3);
        this.add((Component)this.jbttnEventAlarm, null);
        this.add((Component)this.jbttnBrokenAlarm, null);
        this.add((Component)this.getEqimAlarm(), null);
        this.add((Component)this.jlblMsg, null);
        if (this.eventAlarm) {
            this.jbttnEventAlarm.setEnabled(true);
        } else {
            this.jbttnEventAlarm.setEnabled(false);
        }
        if (this.stationAlarm) {
            this.jbttnBrokenAlarm.setEnabled(true);
        } else {
            this.jbttnBrokenAlarm.setEnabled(false);
        }
    }

    public void stopEventAlarm() {
        this.audioEQ.stop();
        this.eventAlarm = false;
        this.jbttnEventAlarm.setEnabled(false);
        this.jlblMsg.setText("");
    }

    void button1_actionPerformed(ActionEvent e) {
        this.stopEventAlarm();
        this.alarmTopicHandler.send("Stop");
    }

    void button2_actionPerformed(ActionEvent e) {
        this.audioBreakRcv.stop();
        this.stationAlarm = false;
        this.jbttnBrokenAlarm.setEnabled(false);
        this.jlblMsg.setText("");
    }

    public void setEventAlarm(boolean eventAlarm) {
        this.eventAlarm = eventAlarm;
    }

    public void setAlarmTopicHandler(AlarmTopicHandler alarmTopicHandler) {
        this.alarmTopicHandler = alarmTopicHandler;
    }

    public boolean isEventAlarm() {
        return this.eventAlarm;
    }

    public void config() {
        try {
            this.audioEQ = Applet.newAudioClip(new URL(MonitorJApplet.baseURL, "resource/audio/alarm.au"));
            this.audioBreakRcv = Applet.newAudioClip(new URL(MonitorJApplet.baseURL, "resource/audio/danger.au"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        MonitorJApplet.monitorClient.addMonitorMessageListener(this);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(270, 160);
    }

    public void startEqimAlarm(String msg) {
        if (this.audioEQ != null) {
            this.audioEQ.stop();
        }
        this.audioEQ.loop();
        this.eqimAlarm.setEnabled(true);
        this.alarmMsg = msg;
        this.jlblMsg.setText(msg);
    }

    public void stopEqimAlarm() {
        if (this.audioEQ != null) {
            this.audioEQ.stop();
        }
        this.eqimAlarm.setEnabled(false);
        this.jlblMsg.setText("");
    }

    public void startEventAlarm() {
        if (this.audioEQ != null) {
            this.audioEQ.stop();
        }
        this.audioEQ.loop();
        this.eventAlarm = true;
        this.jbttnEventAlarm.setEnabled(true);
    }

    public synchronized void QueueAddElementHandler(QueueAddElementEvent e) {
        Result res = (Result)e.getValue();
        if (res.getType() == 65537 || res.getType() == 65568 || res.getType() == 131079) {
            logger.info((Object)("Got Event Alarm: " + res.getType()));
            this.startEventAlarm();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        logger.info((Object)("propertyName:" + evt.getPropertyName()));
        if (evt.getPropertyName().equals("clientStatus")) {
            if (this.audioBreakRcv != null) {
                this.audioBreakRcv.stop();
            }
            this.audioBreakRcv.loop();
            this.jbttnBrokenAlarm.setEnabled(true);
            Vector vec = (Vector)evt.getNewValue();
            StringBuffer buf = new StringBuffer();
            for (Cloneable c : vec) {
                buf.append(String.valueOf(c.mClientLabel) + " ");
            }
            this.jlblMsg.setText(String.valueOf(buf.toString()) + LocaleResource.getResourceString("LinkBroken"));
        }
        if (evt.getPropertyName().equals("stationStatus")) {
            logger.info((Object)"getPropertyName stationStatus");
            if (this.audioBreakRcv != null) {
                this.audioBreakRcv.stop();
            }
            this.audioBreakRcv.loop();
            this.stationAlarm = true;
            this.jbttnBrokenAlarm.setEnabled(true);
            StringBuffer buf = new StringBuffer();
            Vector vec = (Vector)evt.getNewValue();
            for (Cloneable c : vec) {
                buf.append(String.valueOf(((StationJPanel.StationStatus)c).stnCode) + " ");
            }
            switch (MonitorJApplet.alarm.getBrokenAlarmType()) {
                case 1: {
                    this.jlblMsg.setText("\u901f\u62a5\u53f0\u7ad9\u4e2d\u65ad" + MonitorJApplet.alarm.getBrokeAlarmStations());
                    break;
                }
                case 2: {
                    this.jlblMsg.setText("\u4e0d\u4f7f\u7528\u7b56\u7565\uff0c\u975e\u901f\u62a5\u53f0\u7ad9\u4e2d\u65ad" + MonitorJApplet.alarm.getBrokeAlarmStations());
                    break;
                }
                case 3: {
                    this.jlblMsg.setText("\u4f7f\u7528\u7b56\u7565\uff0c\u591a\u4e2a\u53f0\u7ad9\u4e2d\u65ad" + MonitorJApplet.alarm.getBrokeAlarmStations());
                    break;
                }
                case 4: {
                    this.jlblMsg.setText("\u5e27\u4e2d\u7ee7\u53f0\u7ad9\u5168\u90e8\u4e2d\u65ad" + MonitorJApplet.alarm.getBrokeAlarmStations());
                    break;
                }
                case 5: {
                    this.jlblMsg.setText("SDH\u53f0\u7ad9\u5168\u90e8\u4e2d\u65ad" + MonitorJApplet.alarm.getBrokeAlarmStations());
                    break;
                }
                case 6: {
                    this.jlblMsg.setText("\u536b\u661f\u53f0\u7ad9\u5168\u90e8\u4e2d\u65ad" + MonitorJApplet.alarm.getBrokeAlarmStations());
                    break;
                }
                case 7: {
                    this.jlblMsg.setText("VPDN\u53f0\u7ad9\u5168\u90e8\u4e2d\u65ad" + MonitorJApplet.alarm.getBrokeAlarmStations());
                    break;
                }
                case 8: {
                    this.jlblMsg.setText("ADSL\u53f0\u7ad9\u5168\u90e8\u4e2d\u65ad" + MonitorJApplet.alarm.getBrokeAlarmStations());
                    break;
                }
                case 9: {
                    this.jlblMsg.setText("\u526f\u76d1\u63a7\u53f0\u7f51 " + MonitorJApplet.alarm.getBrokenNet() + " \u53f0\u7ad9\u5168\u90e8\u4e2d\u65ad");
                    break;
                }
                default: {
                    this.jlblMsg.setText("" + MonitorJApplet.alarm.getBrokeAlarmStations());
                }
            }
        }
    }

    private JButton getEqimAlarm() {
        if (this.eqimAlarm == null) {
            this.eqimAlarm = new JButton();
            this.eqimAlarm.setEnabled(false);
            this.eqimAlarm.setText("EQIM\u4e2d\u65ad\u62a5\u8b66");
            this.eqimAlarm.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AlarmJPanel.this.stopEqimAlarm();
                }
            });
        }
        return this.eqimAlarm;
    }
}

