/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor;

import cn.org.gddsn.seis.monitor.AlarmJPanel;
import cn.org.gddsn.util.Log4jConfig;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class AlarmEqimHandler
implements MessageListener {
    static Logger logger = Logger.getLogger(AlarmEqimHandler.class);
    private JmsTemplate jmsTemplate;
    private AlarmJPanel alarmJPanel;

    public void send(final String startOrStop) {
        this.jmsTemplate.send(new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return session.createTextMessage("Alarm/" + startOrStop);
            }
        });
    }

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            TextMessage tm = (TextMessage)message;
            try {
                String msg = tm.getText();
                String m = "\u6765\u81ea" + tm.getStringProperty("Net_code") + ", id=" + msg;
                logger.info((Object)("Got from " + m));
                if (this.alarmJPanel != null) {
                    this.alarmJPanel.startEqimAlarm(m);
                }
            }
            catch (JMSException ex) {
                logger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setAlarmJPanel(AlarmJPanel alarmJPanel) {
        this.alarmJPanel = alarmJPanel;
    }

    public static void main(String[] args) {
        Log4jConfig.loadForMain((String)"log4j.properties");
        FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext(new String[]{"src/cn/org/gddsn/seis/monitor/MonitorJApplet.xml"});
        AlarmEqimHandler ath = new AlarmEqimHandler();
        DefaultMessageListenerContainer container = (DefaultMessageListenerContainer)ctx.getBean("listenerContainer");
        container.start();
        ath.send("Stop");
    }
}

