/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.DataBuffer;
import cn.org.gddsn.seis.location.rstt.VelocityIntegrate;
import java.io.PrintWriter;

class VelocityQuadratic
extends VelocityIntegrate {
    private double vNormRadius;
    private double va0;
    private double va1;
    private double va2;

    public VelocityQuadratic() {
        this.va0 = 0.0;
        this.va1 = 0.0;
        this.va2 = 0.0;
    }

    public VelocityQuadratic(double a0, double a1, double a2, double rt, double rb, String layrnam, double normradius) {
        super(rt, rb, layrnam);
        this.va0 = a0;
        this.va1 = a1;
        this.va2 = a2;
        this.vNormRadius = normradius;
        this.init();
    }

    public VelocityQuadratic(VelocityQuadratic vq) {
        super(vq);
        this.va0 = vq.va0;
        this.va1 = vq.va1;
        this.va2 = vq.va2;
        this.vNormRadius = vq.vNormRadius;
    }

    public VelocityQuadratic(DataBuffer buffer) {
        this.deserialize(buffer);
    }

    public VelocityQuadratic copy(VelocityQuadratic vq) {
        this.copy(vq);
        this.va0 = vq.va0;
        this.va1 = vq.va1;
        this.va2 = vq.va2;
        this.vNormRadius = vq.vNormRadius;
        return this;
    }

    public double funk(double r) {
        double rn = r / this.vNormRadius;
        return this.va0 + rn * (this.va1 + rn * this.va2);
    }

    public double rAtP(double p) {
        if (p == 0.0) {
            return 0.0;
        }
        double b = p * this.va1 / this.vNormRadius - 1.0;
        double a = p * this.va2 / this.vNormRadius / this.vNormRadius;
        double c = p * this.va0;
        double sqarg = b * b - 4.0 * a * c;
        if (sqarg < 0.0) {
            return 0.0;
        }
        if (sqarg == 0.0) {
            return -b / 2.0 / a;
        }
        double cc = 2.0 * a;
        double aa = -b / cc;
        double sq = Math.sqrt(sqarg) / cc;
        double r1 = aa - sq;
        if (r1 <= this.vlRt && r1 >= this.vlRb) {
            return r1;
        }
        return aa + sq;
    }

    public void writeNormRadius(PrintWriter os) {
        if (this.vNormRadius == 1.0) {
            os.printf("    NormalizedRadius = False\n", new Object[0]);
        } else {
            os.printf("    NormalizedRadius = True\n", new Object[0]);
        }
    }

    public void writeVelocity(PrintWriter os) {
        os.printf("%12.4f %12.4f %12.4f Quadratic\n", this.va0, this.va1, this.va2);
    }

    public void toStream(PrintWriter os, String indent) {
        os.printf("%sVelocity Definition          = ", indent);
        this.writeVelocity(os);
        os.println();
        super.toStream(os, indent);
    }

    public static String class_name() {
        return "VelocityQuadratic";
    }

    public String get_class_name() {
        return VelocityQuadratic.class_name();
    }

    public boolean isVelocityQuadratic() {
        return true;
    }

    public int bufferSize() {
        return 40 + super.bufferSize();
    }

    public void serialize(DataBuffer buffer) {
        buffer.writeDouble(this.va0);
        buffer.writeRawDouble(this.va1);
        buffer.writeRawDouble(this.va2);
        buffer.writeRawDouble(this.vNormRadius);
        super.serialize(buffer);
    }

    public void deserialize(DataBuffer buffer) {
        this.va0 = buffer.readDouble();
        this.va1 = buffer.readRawDouble();
        this.va2 = buffer.readRawDouble();
        this.vNormRadius = buffer.readRawDouble();
        super.deserialize(buffer);
    }
}

