/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.DataBuffer;
import cn.org.gddsn.seis.location.rstt.VelocityIntegrate;
import java.io.PrintWriter;

class VelocityPower
extends VelocityIntegrate {
    private double vp0;
    private double vp1;
    private double vpB;
    private double vp1_B;

    public VelocityPower() {
        this.vp0 = 0.0;
        this.vp1 = 0.0;
        this.vpB = 0.0;
    }

    public VelocityPower(double vt, double vb, double rt, double rb, String layrnam) {
        super(rt, rb, layrnam);
        this.vp0 = vt;
        this.vp1 = vb;
        this.vpB = Math.log(vb / vt) / Math.log(this.vlRb / this.vlRt);
        this.vp1_B = 1.0 - this.vpB;
        this.init();
    }

    public VelocityPower(VelocityPower vp) {
        super(vp);
        this.vp0 = vp.vp0;
        this.vp1 = vp.vp1;
        this.vp1_B = vp.vp1_B;
        this.vpB = vp.vpB;
    }

    public VelocityPower(DataBuffer buffer) {
        this.deserialize(buffer);
    }

    public VelocityPower copy(VelocityPower vp) {
        super.copy(vp);
        this.vp0 = vp.vp0;
        this.vp1 = vp.vp1;
        this.vpB = vp.vpB;
        this.vp1_B = vp.vp1_B;
        return this;
    }

    public double funk(double r) {
        return this.vp0 * Math.pow(r / this.vlRt, this.vpB);
    }

    public double rAtP(double p) {
        return Math.pow(p * this.vp0 * Math.pow(1.0 / this.vlRt, this.vpB), 1.0 / this.vp1_B);
    }

    public double B() {
        return this.vpB;
    }

    public double integrateDistance(double p, double ra, boolean r_open) {
        double pva = p * this.funk(ra);
        double pvb = p * this.vlVt;
        return (Math.asin(Math.min(pva / ra, 1.0)) - Math.asin(Math.min(pvb / this.vlRt, 1.0))) / this.vp1_B;
    }

    public double integrateDistance(double p, double ra, double rb, boolean r_open) {
        double pva = p * this.funk(ra);
        double pvb = p * this.funk(rb);
        return (Math.asin(Math.min(pva / ra, 1.0)) - Math.asin(Math.min(pvb / rb, 1.0))) / this.vp1_B;
    }

    public double integrateTime(double p, double ra) {
        double prb = this.vlRt / this.vlVt;
        double pra = ra / this.funk(ra);
        return (Math.sqrt(Math.abs(prb - p) * (prb + p)) - Math.sqrt(Math.abs(pra - p) * (pra + p))) / this.vp1_B;
    }

    public double integrateTime(double p, double ra, double rb) {
        double pra = ra / this.funk(ra);
        double prb = rb / this.funk(rb);
        return (Math.sqrt(Math.abs(pra - p) * (pra + p)) - Math.sqrt(Math.abs(prb - p) * (prb + p))) / this.vp1_B;
    }

    public boolean isTimeIntegralTau() {
        return false;
    }

    public void writeVelocity(PrintWriter os) {
        os.printf("%12.4f %12.4f Power\n", this.vp0, this.vp1);
    }

    public void toStream(PrintWriter os, String indent) {
        os.printf(indent + "Velocity Definition          = ", new Object[0]);
        this.writeVelocity(os);
        os.println();
        super.toStream(os, indent);
    }

    public static String class_name() {
        return "VelocityPower";
    }

    public String get_class_name() {
        return VelocityPower.class_name();
    }

    public boolean isVelocityPowerLaw() {
        return true;
    }

    public int bufferSize() {
        return 40 + super.bufferSize();
    }

    public void serialize(DataBuffer buffer) {
        buffer.writeDouble(this.vp0);
        buffer.writeRawDouble(this.vp1);
        buffer.writeRawDouble(this.vpB);
        buffer.writeRawDouble(this.vp1_B);
        this.serialize(buffer);
    }

    public void deserialize(DataBuffer buffer) {
        this.vp0 = buffer.readDouble();
        this.vp1 = buffer.readRawDouble();
        this.vpB = buffer.readRawDouble();
        this.vp1_B = buffer.readRawDouble();
        super.deserialize(buffer);
    }
}

