/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.DataBuffer;
import cn.org.gddsn.seis.location.rstt.VelocityIntegrate;
import java.io.PrintWriter;

class VelocityLinear
extends VelocityIntegrate {
    private double vNormRadius;
    private double va0;
    private double va1;

    public VelocityLinear() {
        this.va0 = 0.0;
        this.va1 = 0.0;
    }

    public VelocityLinear(double a0, double a1, double rt, double rb, String layrnam, double normradius) {
        super(rt, rb, layrnam);
        this.va0 = a0;
        this.va1 = a1;
        this.vNormRadius = normradius;
        this.init();
    }

    public VelocityLinear(VelocityLinear vl) {
        super(vl);
        this.va0 = vl.va0;
        this.va1 = vl.va1;
        this.vNormRadius = vl.vNormRadius;
    }

    public VelocityLinear(DataBuffer buffer) {
        this.deserialize(buffer);
    }

    public VelocityLinear copy(VelocityLinear vl) {
        super.copy(vl);
        this.va0 = vl.va0;
        this.va1 = vl.va1;
        this.vNormRadius = vl.vNormRadius;
        return this;
    }

    public double funk(double r) {
        double rn = r / this.vNormRadius;
        return this.va1 * rn + this.va0;
    }

    public double rAtP(double p) {
        return p * this.va0 / (1.0 - p * this.va1 / this.vNormRadius);
    }

    public double integrateDistance(double p, double r, boolean r_open) {
        double v1 = this.va1 / this.vNormRadius;
        double pv = p * (this.va0 + v1 * r) / r;
        double rslt = pv >= 1.0 ? 1.5707963267948966 : Math.asin(pv);
        pv = p * this.vlVt / this.vlRt;
        rslt -= Math.asin(pv);
        double pv0 = p * this.va0;
        double pv1 = p * v1;
        pv = pv1 * pv1;
        double c = 1.0 - pv;
        if (c < 0.0) {
            double b = -pv0 * pv1;
            double arg = (c * r + b) / pv0;
            rslt = arg >= 1.0 ? (rslt += pv1 * (1.5707963267948966 - Math.asin((c * this.vlRt + b) / pv0)) / Math.sqrt(-c)) : (rslt += pv1 * (Math.asin(arg) - Math.asin((c * this.vlRt + b) / pv0)) / Math.sqrt(-c));
        } else if (c == 0.0) {
            rslt += Math.sqrt(-2.0 * v1 * r / this.va0 - 1.0) - Math.sqrt(-2.0 * v1 * this.vlRt / this.va0 - 1.0);
        } else {
            double b = -2.0 * pv0 * pv1;
            double a = -pv0 * pv0;
            double sc = Math.sqrt(c);
            double Rrt = a + this.vlRt * (b + c * this.vlRt);
            double Rr = a + r * (b + c * r);
            rslt += pv1 * (Math.log(2.0 * sc * Math.sqrt(Math.abs(Rrt)) + 2.0 * c * this.vlRt + b) - Math.log(2.0 * sc * Math.sqrt(Math.abs(Rr)) + 2.0 * c * r + b)) / sc;
        }
        return rslt;
    }

    public double integrateDistance(double p, double ra, double rb, boolean r_open) {
        double v1 = this.va1 / this.vNormRadius;
        double pv = p * (this.va0 + v1 * ra) / ra;
        double rslt = pv >= 1.0 ? 1.5707963267948966 : Math.asin(pv);
        pv = p * (this.va0 + v1 * rb) / rb;
        rslt = pv >= 1.0 ? (rslt -= 1.5707963267948966) : (rslt -= Math.asin(pv));
        double pv0 = p * this.va0;
        double pv1 = p * v1;
        pv = pv1 * pv1;
        double c = 1.0 - pv;
        if (c < 0.0) {
            double b = -pv0 * pv1;
            double arg = (c * ra + b) / pv0;
            rslt = arg >= 1.0 ? (rslt += pv1 * (1.5707963267948966 - Math.asin((c * rb + b) / pv0)) / Math.sqrt(-c)) : (rslt += pv1 * (Math.asin(arg) - Math.asin((c * rb + b) / pv0)) / Math.sqrt(-c));
        } else if (c == 0.0) {
            rslt += Math.sqrt(-2.0 * v1 * ra / this.va0 - 1.0) - Math.sqrt(-2.0 * v1 * rb / this.va0 - 1.0);
        } else {
            double b = -2.0 * pv0 * pv1;
            double a = -pv0 * pv0;
            double sc = Math.sqrt(c);
            double Rrb = a + rb * (b + c * rb);
            double Rra = a + ra * (b + c * ra);
            rslt += pv1 * (Math.log(2.0 * sc * Math.sqrt(Math.abs(Rrb)) + 2.0 * c * rb + b) - Math.log(2.0 * sc * Math.sqrt(Math.abs(Rra)) + 2.0 * c * ra + b)) / sc;
        }
        return rslt;
    }

    public void writeNormRadius(PrintWriter os) {
        if (this.vNormRadius == 1.0) {
            os.printf("    NormalizedRadius = False\n", new Object[0]);
        } else {
            os.printf("    NormalizedRadius = True\n", new Object[0]);
        }
    }

    public void writeVelocity(PrintWriter os) {
        os.printf("%12.4f %12.4f Linear\n", this.va0, this.va1);
    }

    public void toStream(PrintWriter os, String indent) {
        os.printf(indent + "Velocity Definition          = ", new Object[0]);
        this.writeVelocity(os);
        os.println();
        super.toStream(os, indent);
    }

    public static String class_name() {
        return "VelocityLinear";
    }

    public String get_class_name() {
        return VelocityLinear.class_name();
    }

    public boolean isVelocityLinear() {
        return true;
    }

    public int bufferSize() {
        return 32 + super.bufferSize();
    }

    public void serialize(DataBuffer buffer) {
        buffer.writeDouble(this.va0);
        buffer.writeRawDouble(this.va1);
        buffer.writeRawDouble(this.vNormRadius);
        super.serialize(buffer);
    }

    public void deserialize(DataBuffer buffer) {
        this.va0 = buffer.readDouble();
        this.va1 = buffer.readRawDouble();
        this.vNormRadius = buffer.readRawDouble();
        super.deserialize(buffer);
    }
}

