/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.IntegrateFunction;
import cn.org.gddsn.seis.location.rstt.TPVelocityLayer;
import cn.org.gddsn.seis.location.rstt.TPdDistdr;
import cn.org.gddsn.seis.location.rstt.TPdTaudr;
import com.nr.UniVarRealValueFun;

abstract class VelocityIntegrate
extends TPVelocityLayer {
    protected static final double vmIntegTol = 1.0E-6;
    protected TPdDistdr vmDist = null;
    protected TPdTaudr vmTau = null;
    protected IntegrateFunction vmDistNI = null;
    protected IntegrateFunction vmTauNI = null;

    protected void createNumericObjects(UniVarRealValueFun v) {
        this.vmDist = new TPdDistdr(v);
        this.vmDistNI = new IntegrateFunction(this.vmDist, 1.0E-6);
        this.vmTau = new TPdTaudr(v);
        this.vmTauNI = new IntegrateFunction(this.vmTau, 1.0E-6);
    }

    public VelocityIntegrate() {
    }

    public VelocityIntegrate(double rt, double rb, String layrnam) {
        super(rt, rb, layrnam);
    }

    public VelocityIntegrate(VelocityIntegrate vi) {
        super(vi);
    }

    public VelocityIntegrate copy(VelocityIntegrate vi) {
        if (this.vmDist != null) {
            this.vmDist = null;
            this.vmTau = null;
            this.vmDistNI = null;
            this.vmTauNI = null;
        }
        super.copy(vi);
        return this;
    }

    public double integrateDistance(double p, double ra, double rb, boolean r_open) {
        if (this.vmDist == null) {
            this.createNumericObjects(this);
        }
        this.vmDist.setP(p);
        if (r_open) {
            return this.vmDistNI.integrateAOpenS(ra, rb);
        }
        return this.vmDistNI.integrateClosed(ra, rb);
    }

    public double integrateDistance(double p, double ra, boolean r_open) {
        return this.integrateDistance(p, ra, this.vlRt, r_open);
    }

    public double integrateTime(double p, double ra, double rb) {
        if (this.vmTau == null) {
            this.createNumericObjects(this);
        }
        this.vmTau.setP(p);
        if (ra == 0.0) {
            return this.vmTauNI.integrateAOpenS(ra, rb);
        }
        return this.vmTauNI.integrateClosed(ra, rb);
    }

    public double integrateTime(double p, double ra) {
        return this.integrateTime(p, ra, this.vlRt);
    }

    public void setIntegTolerance(double tol) {
        if (this.vmDist == null) {
            this.createNumericObjects(this);
        }
        this.vmDistNI.setTolerance(tol);
        this.vmTauNI.setTolerance(tol);
    }
}

