/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.Brents;
import cn.org.gddsn.seis.location.rstt.DataBuffer;
import cn.org.gddsn.seis.location.rstt.VZero;
import cn.org.gddsn.seis.location.rstt.VelocityIntegrate;
import java.io.PrintWriter;

class VelocityCubic
extends VelocityIntegrate {
    private double vNormRadius;
    private double va0;
    private double va1;
    private double va2;
    private double va3;

    public VelocityCubic() {
        this.va0 = 0.0;
        this.va1 = 0.0;
        this.va2 = 0.0;
        this.va3 = 0.0;
        this.vNormRadius = 1.0;
    }

    public VelocityCubic(double a0, double a1, double a2, double a3, double rt, double rb, String layrnam, double normradius) {
        super(rt, rb, layrnam);
        this.va0 = a0;
        this.va1 = a1;
        this.va2 = a2;
        this.va3 = a3;
        this.vNormRadius = normradius;
        this.init();
    }

    public VelocityCubic(VelocityCubic vc) {
        super(vc);
        this.va0 = vc.va0;
        this.va1 = vc.va1;
        this.va2 = vc.va2;
        this.va3 = vc.va3;
        this.vNormRadius = vc.vNormRadius;
    }

    public VelocityCubic(DataBuffer buffer) {
        this.deserialize(buffer);
    }

    public VelocityCubic copy(VelocityCubic vc) {
        super.copy(vc);
        this.va0 = vc.va0;
        this.va1 = vc.va1;
        this.va2 = vc.va2;
        this.va3 = vc.va3;
        this.vNormRadius = vc.vNormRadius;
        return this;
    }

    public double funk(double r) {
        double rn = r / this.vNormRadius;
        return this.va0 + rn * (this.va1 + rn * (this.va2 + rn * this.va3));
    }

    public double rAtP(double p) {
        VZero vz = new VZero(p, this);
        Brents zb = new Brents(vz, 1.0E-8);
        return zb.zeroF(this.vlRt, this.vlRb);
    }

    public void writeNormRadius(PrintWriter os) {
        if (this.vNormRadius == 1.0) {
            os.printf("    NormalizedRadius = False\n", new Object[0]);
        } else {
            os.printf("    NormalizedRadius = True\n", new Object[0]);
        }
    }

    public void writeVelocity(PrintWriter os) {
        os.printf("%12.4f %12.4f %12.4f %12.4f Cubic\n", this.va0, this.va1, this.va2, this.va3);
    }

    public void toStream(PrintWriter os, String indent) {
        os.printf(indent + "Velocity Definition          = ", new Object[0]);
        this.writeVelocity(os);
        os.println();
        super.toStream(os, indent);
    }

    public static String class_name() {
        return "VelocityCubic";
    }

    public String get_class_name() {
        return VelocityCubic.class_name();
    }

    public boolean isVelocityCubic() {
        return true;
    }

    public int bufferSize() {
        return 48 + super.bufferSize();
    }

    public void serialize(DataBuffer buffer) {
        buffer.writeDouble(this.va0);
        buffer.writeRawDouble(this.va1);
        buffer.writeRawDouble(this.va2);
        buffer.writeRawDouble(this.va3);
        buffer.writeRawDouble(this.vNormRadius);
        super.serialize(buffer);
    }

    public void deserialize(DataBuffer buffer) {
        this.va0 = buffer.readDouble();
        this.va1 = buffer.readRawDouble();
        this.va2 = buffer.readRawDouble();
        this.va3 = buffer.readRawDouble();
        this.vNormRadius = buffer.readRawDouble();
        super.deserialize(buffer);
    }
}

