/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.DataBuffer;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import java.util.Vector;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Uncertainty {
    private int phaseNum;
    private String phaseStr;
    private int attributeNum;
    private String attributeStr;
    private String fname;
    private Vector<Double> errDistances = new Vector();
    private Vector<Double> errDepths = new Vector();
    private Vector<Vector<Double>> errVal = new Vector();

    public Uncertainty() {
        this.phaseNum = -1;
        this.phaseStr = "";
    }

    public Uncertainty(DataBuffer buffer) {
        this.deserialize(buffer);
    }

    public Uncertainty(String modelPath, int phase, int attribute) {
        switch (phase) {
            case 0: {
                this.phaseStr = "Pn";
                break;
            }
            case 1: {
                this.phaseStr = "Sn";
                break;
            }
            case 2: {
                this.phaseStr = "Pg";
                break;
            }
            case 3: {
                this.phaseStr = "Lg";
                break;
            }
            default: {
                this.phaseStr = "Pn";
            }
        }
        switch (attribute) {
            case 0: {
                this.attributeStr = "TT";
                break;
            }
            case 1: {
                this.attributeStr = "Sh";
                break;
            }
            case 2: {
                this.attributeStr = "Az";
                break;
            }
            default: {
                this.attributeStr = "TT";
            }
        }
        this.phaseNum = phase;
        this.attributeNum = attribute;
        this.fname = new File(modelPath, "Uncertainty_" + this.phaseStr + "_" + this.attributeStr + ".txt").getPath();
        this.readFile(this.fname);
    }

    public Uncertainty(String modelPath, String phase, int phasenum) {
        this.phaseStr = phase;
        this.phaseNum = phasenum;
        this.fname = String.valueOf(modelPath) + "/Uncertainty_" + this.phaseStr + ".txt";
        this.readFile(this.fname);
    }

    public Uncertainty(Uncertainty u) {
        this.phaseNum = u.phaseNum;
        this.phaseStr = u.phaseStr;
        this.fname = u.fname;
        this.errDistances = u.errDistances;
        this.errVal = u.errVal;
    }

    public Uncertainty copy(Uncertainty u) {
        this.phaseNum = u.phaseNum;
        this.phaseStr = u.phaseStr;
        this.fname = u.fname;
        this.errDistances = u.errDistances;
        this.errVal = u.errVal;
        return this;
    }

    public void deserialize(DataBuffer buffer) {
        this.phaseNum = buffer.readInt32();
        this.phaseStr = buffer.readString();
        this.fname = buffer.readString();
        int ndist = buffer.readInt32();
        int ndpth = buffer.readInt32();
        this.errDistances.setSize(ndist);
        buffer.readDoubleArray(this.errDistances, ndist);
        if (ndpth > 0) {
            this.errDepths.setSize(ndpth);
            buffer.readDoubleArray(this.errDepths, ndpth);
        } else {
            ndpth = 1;
            this.errDepths.clear();
        }
        this.errVal.setSize(ndpth);
        int i = 0;
        while (i < ndpth) {
            this.errVal.get(i).setSize(ndist);
            buffer.readDoubleArray(this.errVal.get(i), ndist);
            ++i;
        }
    }

    public int getBufferSize() {
        int buffsize = 32 + this.phaseStr.length() + this.fname.length();
        buffsize += (this.errDistances.size() + 1) * 8;
        if (this.errVal.size() > 1) {
            buffsize += this.errDepths.size() * 8;
            buffsize += this.errDepths.size() * this.errDistances.size() * 8;
        } else {
            buffsize += this.errDistances.size() * 8;
        }
        return buffsize;
    }

    private void getIndex(double x, Vector<Double> v, intW index, doubleW w) {
        if (v.size() == 2) {
            index.val = 0;
        } else {
            int inc = v.size();
            index.val = inc >>= 1;
            while (true) {
                if (inc > 1) {
                    inc >>= 1;
                }
                if (v.get(index.val + 1) <= x) {
                    index.val += inc;
                    continue;
                }
                if (!(v.get(index.val) > x)) break;
                index.val -= inc;
            }
        }
        w.val = (x - v.get(index.val)) / (v.get(index.val + 1) - v.get(index.val));
    }

    public int getPhase() {
        return this.phaseNum;
    }

    public String getPhaseStr() {
        return this.phaseStr;
    }

    public double getUncertainty(double distance, double depth) {
        double distanceDeg = distance * 57.29577951308232;
        intW idist = new intW(0);
        intW idepth = new intW(0);
        doubleW wdepth = new doubleW(0.0);
        doubleW wdist = new doubleW(0.0);
        if (this.errVal.size() == 1 || depth >= this.errDepths.lastElement()) {
            if (this.errVal.size() > 1) {
                idepth.val = this.errDepths.size() - 1;
            }
            if (distanceDeg >= this.errDistances.lastElement()) {
                return this.errVal.get(idepth.val).lastElement();
            }
            this.getIndex(distanceDeg, this.errDistances, idist, wdist);
            return this.getUncertainty(wdist.val, idist.val, idepth.val);
        }
        this.getIndex(depth, this.errDepths, idepth, wdepth);
        if (distanceDeg >= this.errDistances.lastElement()) {
            return wdepth.val * (this.errVal.get(idepth.val + 1).lastElement() - this.errVal.get(idepth.val).lastElement()) + this.errVal.get(idepth.val).lastElement();
        }
        this.getIndex(distanceDeg, this.errDistances, idist, wdist);
        return wdepth.val * (this.getUncertainty(wdist.val, idist.val, idepth.val + 1) - this.getUncertainty(wdist.val, idist.val, idepth.val)) + this.getUncertainty(wdist.val, idist.val, idepth.val);
    }

    public double getVariance(double distance, double depth) {
        double distanceDeg = distance * 57.29577951308232;
        intW idist = new intW(0);
        intW idepth = new intW(0);
        doubleW wdepth = new doubleW(0.0);
        doubleW wdist = new doubleW(0.0);
        if (this.errVal.size() == 1 || depth >= this.errDepths.lastElement()) {
            if (this.errVal.size() > 1) {
                idepth.val = this.errDepths.size() - 1;
            }
            if (distanceDeg >= this.errDistances.lastElement()) {
                return this.errVal.get(idepth.val).lastElement();
            }
            this.getIndex(distanceDeg, this.errDistances, idist, wdist);
            return this.getVariance(wdist.val, idist.val, idepth.val);
        }
        this.getIndex(depth, this.errDepths, idepth, wdepth);
        if (distanceDeg >= this.errDistances.lastElement()) {
            return wdepth.val * (this.errVal.get(idepth.val + 1).lastElement() - this.errVal.get(idepth.val).lastElement()) + this.errVal.get(idepth.val).lastElement();
        }
        this.getIndex(distanceDeg, this.errDistances, idist, wdist);
        return wdepth.val * (this.getVariance(wdist.val, idist.val, idepth.val + 1) - this.getVariance(wdist.val, idist.val, idepth.val)) + this.getVariance(wdist.val, idist.val, idepth.val);
    }

    private double getVariance(double f, int idist, int idepth) {
        return f * (this.errVal.get(idepth).get(idist + 1) * this.errVal.get(idepth).get(idist + 1) - this.errVal.get(idepth).get(idist) * this.errVal.get(idepth).get(idist)) + this.errVal.get(idepth).get(idist) * this.errVal.get(idepth).get(idist);
    }

    private double getUncertainty(double f, int idist, int idepth) {
        return f * (this.errVal.get(idepth).get(idist + 1) - this.errVal.get(idepth).get(idist)) + this.errVal.get(idepth).get(idist);
    }

    private void readFile(String filename) {
        try {
            Scanner sc = new Scanner(new File(filename));
            String delimiter = "((#.*\n)+|(#.*\r\n)+|(#.*\r)+|\\p{javaWhitespace}+)+";
            sc.useDelimiter(delimiter);
            int numdistances = -1;
            int numdepths = 1;
            numdistances = sc.nextInt();
            int i = 0;
            while (i < numdistances) {
                this.errDistances.add(sc.nextDouble());
                ++i;
            }
            if (numdepths > 1) {
                i = 0;
                while (i < numdepths) {
                    this.errDepths.add(sc.nextDouble());
                    ++i;
                }
            }
            int j = 0;
            while (j < numdepths) {
                this.errVal.add(new Vector());
                int i2 = 0;
                while (i2 < numdistances) {
                    double temp = sc.nextDouble();
                    if (this.attributeNum == 1) {
                        temp /= Math.PI / 180;
                    } else if (this.attributeNum == 2) {
                        temp *= Math.PI / 180;
                    }
                    this.errVal.get(j).add(temp);
                    ++i2;
                }
                ++j;
            }
            sc.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void serialize(DataBuffer buffer) {
        buffer.writeInt32(this.phaseNum);
        buffer.writeString(this.phaseStr);
        buffer.writeString(this.fname);
        buffer.writeInt32(this.errDistances.size());
        if (this.errVal.size() == 1) {
            buffer.writeInt32(0);
        } else {
            buffer.writeInt32(this.errDepths.size());
        }
        buffer.writeDoubleArray(this.errDistances, this.errDistances.size());
        if (this.errVal.size() > 1) {
            buffer.writeDoubleArray(this.errDepths, this.errDepths.size());
        }
        int i = 0;
        while (i < this.errVal.size()) {
            buffer.writeDoubleArray(this.errVal.get(i), this.errDistances.size());
            ++i;
        }
    }
}

