/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.GridProfile;
import cn.org.gddsn.seis.location.rstt.Location;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Triangle {
    private int index;
    private GridProfile[] nodes = new GridProfile[3];
    private Triangle[] neighbors = new Triangle[3];

    public int getIndex() {
        return this.index;
    }

    public GridProfile getNode(int i) {
        return this.nodes[i];
    }

    public void setNeighbor(int i, Triangle neighbor) {
        this.neighbors[i] = neighbor;
    }

    public Triangle getNeighbor(int i) {
        return this.neighbors[i];
    }

    public void findNodeNeighbors(int node0, Set<Integer> neighborNodes) {
        TreeSet<Triangle> visitedTriangles = new TreeSet<Triangle>();
        this.findNodeNeighbors(node0, neighborNodes, visitedTriangles);
    }

    public Triangle walk(Location position, double[] coeff) {
        int i = 0;
        while (i < 3) {
            int j = (i + 1) % 3;
            coeff[i] = position.scalarTripleProduct(this.nodes[j], this.nodes[(j + 1) % 3]);
            if (coeff[i] > 1.0E-15) {
                return this.neighbors[j].walk(position, coeff);
            }
            ++i;
        }
        double sum = 0.0;
        i = 0;
        while (i < 3) {
            if (coeff[i] > 0.0) {
                coeff[i] = 0.0;
            }
            sum += coeff[i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            int n = i++;
            coeff[n] = coeff[n] / sum;
        }
        return this;
    }

    private void findNodeNeighbors(int node0, Set<Integer> neighborNodes, TreeSet<Triangle> visitedTriangles) {
        visitedTriangles.add(this);
        int i = 0;
        while (i < 3) {
            if (this.nodes[i].getNodeId() == node0) {
                int j = 0;
                while (j < 3) {
                    if (this.nodes[j].getNodeId() != node0) {
                        neighborNodes.add(this.nodes[j].getNodeId());
                    }
                    ++j;
                }
                j = 0;
                while (j < 3) {
                    if (visitedTriangles.contains(this.neighbors[j]) && this.neighbors[j] == visitedTriangles.last()) {
                        this.neighbors[j].findNodeNeighbors(node0, neighborNodes, visitedTriangles);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public int findNeighborIndex(Triangle neighbor) {
        int i = 0;
        while (i < 3) {
            if (neighbor.getNeighbor(i) == this) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Triangle() {
        this.index = -1;
        this.nodes[0] = null;
        this.nodes[1] = null;
        this.nodes[2] = null;
        this.neighbors[0] = null;
        this.neighbors[1] = null;
        this.neighbors[2] = null;
    }

    public Triangle(int i, GridProfile loc0, GridProfile loc1, GridProfile loc2) {
        this.index = i;
        this.nodes[0] = loc0;
        this.nodes[1] = loc1;
        this.nodes[2] = loc2;
        this.neighbors[0] = null;
        this.neighbors[1] = null;
        this.neighbors[2] = null;
    }

    public Triangle(Triangle other) {
        this.index = other.index;
        this.nodes[0] = other.nodes[0];
        this.nodes[1] = other.nodes[1];
        this.nodes[2] = other.nodes[2];
        this.neighbors[0] = other.neighbors[0];
        this.neighbors[1] = other.neighbors[1];
        this.neighbors[2] = other.neighbors[2];
    }

    public Triangle copy(Triangle other) {
        this.index = other.index;
        this.nodes[0] = other.nodes[0];
        this.nodes[1] = other.nodes[1];
        this.nodes[2] = other.nodes[2];
        this.neighbors[0] = other.neighbors[0];
        this.neighbors[1] = other.neighbors[1];
        this.neighbors[2] = other.neighbors[2];
        return this;
    }
}

