/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.TPVelocityLayer;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class TravelTimeResult {
    public TPVelocityLayer ttrVelLayer;
    public String ttrPhaseName;
    public String ttrPhaseEval;
    public String ttrRayType;
    public int ttrLayerIndex;
    public boolean ttrIsInterfaceUpper;
    public boolean ttrIsInterfaceLower;
    public boolean ttrIsSplitUpper;
    public boolean ttrIsSplitLower;
    public double ttrP;
    public double ttrR;
    public double ttrV;
    public double ttrT;
    public double ttrDRay;
    public double ttrTRay;
    public double ttrDSrc;
    public double ttrTSrc;
    public double ttrDRcvr;
    public double ttrTRcvr;
    public double ttrDIntrfc;
    public double ttrTIntrfc;
    public double[] ttrDerivs = new double[4];

    public String toString(String indent) {
        CharArrayWriter caw = new CharArrayWriter(128);
        PrintWriter os = new PrintWriter(caw);
        this.toStream(os, indent);
        return caw.toString();
    }

    public void toStream(PrintWriter os, String indent) {
        os.printf("\n", new Object[0]);
        if (this.ttrPhaseName.length() != 0) {
            os.printf("Input Assigned Phase Name             = %s\n", this.ttrPhaseName);
        }
        os.printf("%sEvaluated Phase Name                  = %s\n", indent, this.ttrPhaseEval);
        os.printf("%sRay Type                              = %s\n", indent, this.ttrRayType);
        os.printf("%sTurning Layer Index (0=top)           = %s\n", indent, this.ttrLayerIndex);
        if (this.ttrIsInterfaceUpper) {
            os.printf("%sRay is diffracted along bottom boundary ...\n", indent);
        }
        if (this.ttrIsInterfaceLower) {
            os.printf("%sRay is diffracted along next layers upper boundary ... \n", indent);
        }
        if (this.ttrIsSplitUpper) {
            os.printf("%sRay turned in upper half of a retrograde layer ...\n", indent);
        }
        if (this.ttrIsSplitLower) {
            os.printf("%sRay turned in lower half of a retrograde layer ...\n", indent);
        }
        os.printf("%sRay Parameter (sec/deg)               = %.3f\n", indent, this.ttrP * (Math.PI / 180));
        os.printf("%sTurning Radius (km)                   = %.3f\n", indent, this.ttrR);
        os.printf("%sTotal Travel Time (sec)               = %.3f\n", indent, this.ttrT);
        os.printf("%sSurf-to-Surf Distance (deg)           = %.3f\n", indent, 2.0 * this.ttrDRay * 57.29577951308232);
        os.printf("%sSurf-to-Surf Travel Time (sec)        = %.3f\n", indent, 2.0 * this.ttrTRay);
        os.printf("%sSurf-to_Source Distance (deg)         = %.3f\n", indent, this.ttrDSrc * 57.29577951308232);
        os.printf("%sSurf-to-Source Travel TIme (sec)      = %.3f\n", indent, this.ttrTSrc);
        os.printf("%sSurf-to_Recvr Distance (deg)          = %.3f\n", indent, this.ttrDRcvr * 57.29577951308232);
        os.printf("%sSurf-to-Recvr Travel TIme (sec)       = %.3f\n", indent, this.ttrTRcvr);
        if (this.ttrIsInterfaceUpper || this.ttrIsInterfaceLower) {
            os.printf("%sDiffracted dist. along boundary (deg) = %.3f\n", indent, this.ttrDIntrfc * 57.29577951308232);
            os.printf("%sDiffracted time along boundary (sec)  = %.3f\n", indent, this.ttrTIntrfc);
        }
        if (this.ttrDerivs[0] != -999999.0) {
            os.printf("%sdT/dDistance (sec/deg)             = %.3f\n", indent, this.ttrDerivs[0] * (Math.PI / 180));
            os.printf("%sdT/dDepth (sec/km)                 = %.3f\n", indent, this.ttrDerivs[1]);
            os.printf("%sd^2T/dDistance/dDepth (sec/deg/km) = %.3f\n", indent, this.ttrDerivs[2] * (Math.PI / 180));
            os.printf("%sd^2T/dDistance^2 (sec/deg^2)       = %.3f\n", indent, this.ttrDerivs[3] * (Math.PI / 180) * (Math.PI / 180));
        }
        os.printf("\n", new Object[0]);
    }
}

