/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.TPVelocityLayer;
import cn.org.gddsn.seis.location.rstt.TauPSite;
import com.nr.UniVarRealValueFun;
import java.util.Vector;
import org.netlib.util.doubleW;

public class TPZeroFunctional
implements UniVarRealValueFun {
    private boolean tpzIsTurningZero;
    private boolean tpzIsRayLegValid;
    private boolean tpzIsRcvrLegValid;
    private boolean tpzIsSrcLegValid;
    private double tpzPLast;
    private double tpzDLast;
    private double tpzPT;
    private double tpzD;
    private double tpzRSrc;
    private double tpzRSrcSgn;
    private double tpzRRcvr;
    private double tpzRRcvrSgn;
    private double tpzRayLegDist;
    private double tpzSrcLegDist;
    private double tpzRcvrLegDist;
    private double tpzRayLegTime;
    private double tpzSrcLegTime;
    private double tpzRcvrLegTime;
    private double tpzRadius;
    private TauPSite tpzTPS;

    public TPZeroFunctional() {
        this.tpzTPS = null;
        this.tpzRSrc = 0.0;
        this.tpzRSrcSgn = 1.0;
        this.tpzRRcvr = 0.0;
        this.tpzRRcvrSgn = 1.0;
        this.tpzPLast = -1.0;
        this.tpzDLast = -1.0;
        this.tpzD = 0.0;
        this.tpzPT = 0.0;
        this.tpzRayLegDist = 0.0;
        this.tpzRayLegTime = 0.0;
        this.tpzSrcLegDist = 0.0;
        this.tpzSrcLegTime = 0.0;
        this.tpzRcvrLegDist = 0.0;
        this.tpzRcvrLegTime = 0.0;
        this.tpzIsTurningZero = true;
        this.tpzIsRayLegValid = false;
        this.tpzIsRcvrLegValid = false;
        this.tpzIsSrcLegValid = false;
        this.tpzRadius = 6371.0;
    }

    public TPZeroFunctional(TauPSite tps) {
        this.tpzTPS = tps;
        this.tpzRSrc = 0.0;
        this.tpzRSrcSgn = 1.0;
        this.tpzRRcvr = 0.0;
        this.tpzRRcvrSgn = 1.0;
        this.tpzPLast = -1.0;
        this.tpzDLast = -1.0;
        this.tpzD = 0.0;
        this.tpzPT = 0.0;
        this.tpzRayLegDist = 0.0;
        this.tpzRayLegTime = 0.0;
        this.tpzSrcLegDist = 0.0;
        this.tpzSrcLegTime = 0.0;
        this.tpzRcvrLegDist = 0.0;
        this.tpzRcvrLegTime = 0.0;
        this.tpzIsTurningZero = true;
        this.tpzIsRayLegValid = false;
        this.tpzIsRcvrLegValid = false;
        this.tpzIsSrcLegValid = false;
        this.tpzRadius = 6371.0;
    }

    public TPZeroFunctional(TPZeroFunctional tpzf) {
        this.tpzRadius = tpzf.tpzRadius;
        this.tpzTPS = tpzf.tpzTPS;
        this.tpzD = tpzf.tpzD;
        this.tpzPT = tpzf.tpzPT;
        this.tpzRSrc = tpzf.tpzRSrc;
        this.tpzRSrcSgn = tpzf.tpzRSrcSgn;
        this.tpzRRcvr = tpzf.tpzRRcvr;
        this.tpzRRcvrSgn = tpzf.tpzRRcvrSgn;
        this.tpzPLast = tpzf.tpzPLast;
        this.tpzDLast = tpzf.tpzDLast;
        this.tpzRayLegDist = tpzf.tpzRayLegDist;
        this.tpzRayLegTime = tpzf.tpzRayLegTime;
        this.tpzSrcLegDist = tpzf.tpzSrcLegDist;
        this.tpzSrcLegTime = tpzf.tpzSrcLegTime;
        this.tpzRcvrLegDist = tpzf.tpzRcvrLegDist;
        this.tpzRcvrLegTime = tpzf.tpzRcvrLegTime;
        this.tpzIsTurningZero = tpzf.tpzIsTurningZero;
        this.tpzIsRayLegValid = tpzf.tpzIsRayLegValid;
        this.tpzIsRcvrLegValid = tpzf.tpzIsRcvrLegValid;
        this.tpzIsSrcLegValid = tpzf.tpzIsSrcLegValid;
    }

    public TPZeroFunctional copy(TPZeroFunctional tpzf) {
        this.tpzD = tpzf.tpzD;
        this.tpzPT = tpzf.tpzPT;
        this.tpzRSrc = tpzf.tpzRSrc;
        this.tpzRSrcSgn = tpzf.tpzRSrcSgn;
        this.tpzRRcvr = tpzf.tpzRRcvr;
        this.tpzRRcvrSgn = tpzf.tpzRRcvrSgn;
        this.tpzPLast = tpzf.tpzPLast;
        this.tpzDLast = tpzf.tpzDLast;
        this.tpzRayLegDist = tpzf.tpzRayLegDist;
        this.tpzRayLegTime = tpzf.tpzRayLegTime;
        this.tpzSrcLegDist = tpzf.tpzSrcLegDist;
        this.tpzSrcLegTime = tpzf.tpzSrcLegTime;
        this.tpzRcvrLegDist = tpzf.tpzRcvrLegDist;
        this.tpzRcvrLegTime = tpzf.tpzRcvrLegTime;
        this.tpzRadius = tpzf.tpzRadius;
        this.tpzTPS = tpzf.tpzTPS;
        this.tpzIsTurningZero = tpzf.tpzIsTurningZero;
        this.tpzIsRayLegValid = tpzf.tpzIsRayLegValid;
        this.tpzIsRcvrLegValid = tpzf.tpzIsRcvrLegValid;
        this.tpzIsSrcLegValid = tpzf.tpzIsSrcLegValid;
        this.tpzPLast = -1.0;
        return this;
    }

    public void distance(double p) {
        this.tpzIsRayLegValid = true;
        this.tpzIsSrcLegValid = true;
        this.tpzIsRcvrLegValid = true;
        this.tpzRcvrLegDist = 0.0;
        this.tpzSrcLegDist = 0.0;
        this.tpzRayLegDist = 0.0;
        TauPSite tps = this.tpzTPS;
        TPVelocityLayer vl0 = tps.getVelocityModels().get(0);
        if (this.tpzIsTurningZero) {
            doubleW w_d = new doubleW(this.tpzRayLegDist);
            this.tpzIsRayLegValid = p == this.tpzPT ? tps.integrateDistance(p, w_d, true) : tps.integrateDistance(p, w_d, false);
            this.tpzRayLegDist = w_d.val;
            if (this.tpzRRcvr != vl0.getRt()) {
                if (this.tpzRRcvrSgn == -1.0) {
                    this.tpzRcvrLegDist = vl0.integrateDistance(p, this.tpzRRcvr, false);
                } else {
                    w_d = new doubleW(this.tpzRcvrLegDist);
                    this.tpzIsRcvrLegValid = tps.integrateDistance(p, this.tpzRRcvr, w_d);
                    this.tpzRcvrLegDist = w_d.val;
                }
            }
            if (this.tpzRSrc != vl0.getRt()) {
                if (this.tpzRSrcSgn == -1.0) {
                    this.tpzSrcLegDist = vl0.integrateDistance(p, this.tpzRSrc, false);
                } else {
                    w_d = new doubleW(this.tpzSrcLegDist);
                    this.tpzIsSrcLegValid = tps.integrateDistance(p, this.tpzRSrc, w_d);
                    this.tpzSrcLegDist = w_d.val;
                }
            }
        } else {
            double r1 = this.tpzRRcvr;
            double r2 = this.tpzRSrc;
            if (r1 < r2) {
                r1 = this.tpzRSrc;
                r2 = this.tpzRRcvr;
            }
            this.tpzRayLegDist = -999999.0;
            this.tpzRcvrLegDist = -999999.0;
            doubleW w_d = new doubleW(this.tpzSrcLegDist);
            this.tpzIsSrcLegValid = tps.integrateDistance(p, r1, r2, w_d);
            this.tpzSrcLegDist = w_d.val;
        }
    }

    public double funk(double p) {
        if (p != this.tpzPLast) {
            this.tpzPLast = p;
            this.distance(p);
            this.tpzDLast = this.tpzIsTurningZero ? this.getTurningZero() : this.getUpGoingZero();
        }
        return this.tpzDLast;
    }

    public double getDist() {
        return this.tpzD;
    }

    public double getMinP() {
        TauPSite tps = this.tpzTPS;
        Vector<TPVelocityLayer> v = tps.getVelocityModels();
        double minR = this.tpzRSrc < this.tpzRRcvr ? this.tpzRSrc : this.tpzRRcvr;
        double maxR = this.tpzRSrc > this.tpzRRcvr ? this.tpzRSrc : this.tpzRRcvr;
        int i = 0;
        double pmin = Double.MAX_VALUE;
        while (i < v.size() && maxR < v.get(i).getRb()) {
            ++i;
        }
        while (i < v.size() && minR < v.get(i).getRt()) {
            double ptt = maxR > v.get(i).getRt() ? v.get(i).getPt() : v.get(i).pAtR(maxR);
            double ptb = minR > v.get(i).getRb() ? v.get(i).pAtR(minR) : v.get(i).getPb();
            if (ptt < pmin) {
                pmin = ptt;
            }
            if (ptb < pmin) {
                pmin = ptb;
            }
            ++i;
        }
        return pmin;
    }

    public double getPlanetRadius() {
        return this.tpzRadius;
    }

    public double getPTop() {
        return this.tpzPT;
    }

    public int getRadiusLayerId(double r) {
        TauPSite tps = this.tpzTPS;
        Vector<TPVelocityLayer> v = tps.getVelocityModels();
        int i = 0;
        while (r < v.get(i).getRb()) {
            ++i;
        }
        return i;
    }

    public double getRayDistance() {
        return this.tpzRayLegDist;
    }

    public double getRayTime() {
        return this.tpzRayLegTime;
    }

    public double getReceiverDepth() {
        return this.tpzRadius - this.tpzRRcvr;
    }

    public int getReceiverLayerId() {
        return this.getRadiusLayerId(this.tpzRRcvr);
    }

    public double getReceiverLegDistance() {
        return this.tpzRRcvrSgn * this.tpzRcvrLegDist;
    }

    public double getReceiverLegTime() {
        return this.tpzRRcvrSgn * this.tpzRcvrLegTime;
    }

    public double getReceiverRadius() {
        return this.tpzRRcvr;
    }

    public double getSourceDepth() {
        return this.tpzRadius - this.tpzRSrc;
    }

    public int getSourceLayerId() {
        return this.getRadiusLayerId(this.tpzRSrc);
    }

    public double getSourceLegDistance() {
        return this.tpzRSrcSgn * this.tpzSrcLegDist;
    }

    public double getSourceLegTime() {
        return this.tpzRSrcSgn * this.tpzSrcLegTime;
    }

    public double getSourceRadius() {
        return this.tpzRSrc;
    }

    public TauPSite getTauPSite() {
        return this.tpzTPS;
    }

    public double getTurningZero() {
        return this.tpzD - (2.0 * this.tpzRayLegDist - this.tpzRSrcSgn * this.tpzSrcLegDist - this.tpzRRcvrSgn * this.tpzRcvrLegDist);
    }

    public double getUpGoingZero() {
        return this.tpzD - this.tpzSrcLegDist;
    }

    public boolean isTurningRayValid() {
        return this.tpzIsRayLegValid && this.tpzIsRcvrLegValid && this.tpzIsSrcLegValid;
    }

    public boolean isTurningZero() {
        return this.tpzIsTurningZero;
    }

    public boolean isUpGoingRayValid() {
        return this.tpzIsRcvrLegValid && this.tpzIsSrcLegValid;
    }

    public boolean isUpGoingZero() {
        return !this.tpzIsTurningZero;
    }

    public void setDist(double d) {
        this.tpzD = d;
        this.tpzPLast = -1.0;
    }

    public void setPlanetRadius(double pr) {
        this.tpzRadius = pr;
        this.tpzPLast = -1.0;
    }

    public void setPTop(double p) {
        this.tpzPT = p;
        this.tpzPLast = -1.0;
    }

    private double setRadius(doubleW r) {
        double rsgn = 1.0;
        if (r.val > this.tpzRadius) {
            r.val = 2.0 * this.tpzRadius - r.val;
            rsgn = -1.0;
        }
        return rsgn;
    }

    public void setReceiverDepth(double d) {
        this.setReceiverRadius(this.tpzRadius - d);
    }

    public void setReceiverRadius(double r) {
        doubleW w_r = new doubleW(r);
        this.tpzRRcvrSgn = this.setRadius(w_r);
        this.tpzRRcvr = w_r.val;
        this.tpzPLast = -1.0;
    }

    public void setSourceDepth(double d) {
        this.setSourceRadius(this.tpzRadius - d);
    }

    public void setSourceRadius(double r) {
        doubleW w_r = new doubleW(r);
        this.tpzRSrcSgn = this.setRadius(w_r);
        this.tpzRSrc = w_r.val;
        this.tpzPLast = -1.0;
    }

    public void setTauPSite(TauPSite tps) {
        this.tpzTPS = tps;
        this.tpzPLast = -1.0;
    }

    public void setTurningZero() {
        this.tpzIsTurningZero = true;
    }

    public void setUpGoingZero() {
        this.tpzIsTurningZero = false;
    }

    public double time(double p) {
        this.tpzRcvrLegTime = 0.0;
        this.tpzSrcLegTime = 0.0;
        this.tpzRayLegTime = 0.0;
        TauPSite tps = this.tpzTPS;
        TPVelocityLayer vl0 = tps.getVelocityModels().get(0);
        if (this.tpzIsTurningZero) {
            doubleW w_d = new doubleW(this.tpzRayLegTime);
            if (p == this.tpzPT) {
                tps.integrateTime(p, w_d, true);
            } else {
                tps.integrateTime(p, w_d, false);
            }
            this.tpzRayLegTime = w_d.val;
            if (this.tpzRRcvrSgn == -1.0) {
                this.tpzRcvrLegTime = vl0.integrateTime(p, this.tpzRRcvr);
            } else {
                w_d = new doubleW(this.tpzRcvrLegTime);
                tps.integrateTime(p, this.tpzRRcvr, w_d);
                this.tpzRcvrLegTime = w_d.val;
            }
            if (this.tpzRSrcSgn == -1.0) {
                this.tpzSrcLegTime = vl0.integrateTime(p, this.tpzRSrc);
            } else {
                w_d = new doubleW(this.tpzSrcLegTime);
                tps.integrateTime(p, this.tpzRSrc, w_d);
                this.tpzSrcLegTime = w_d.val;
            }
            return 2.0 * this.tpzRayLegTime - this.tpzRSrcSgn * this.tpzSrcLegTime - this.tpzRRcvrSgn * this.tpzRcvrLegTime;
        }
        double r1 = this.tpzRRcvr;
        double r2 = this.tpzRSrc;
        if (r1 < r2) {
            r1 = this.tpzRSrc;
            r2 = this.tpzRRcvr;
        }
        this.tpzRayLegTime = -999999.0;
        this.tpzRcvrLegTime = -999999.0;
        doubleW w_d = new doubleW(this.tpzSrcLegTime);
        this.tpzIsSrcLegValid = tps.integrateTime(p, r1, r2, w_d);
        this.tpzSrcLegTime = w_d.val;
        return this.tpzSrcLegTime;
    }
}

