/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.DataBuffer;
import cn.org.gddsn.seis.location.rstt.VelocityConst;
import cn.org.gddsn.seis.location.rstt.VelocityCubic;
import cn.org.gddsn.seis.location.rstt.VelocityLinear;
import cn.org.gddsn.seis.location.rstt.VelocityPower;
import cn.org.gddsn.seis.location.rstt.VelocityQuadratic;
import com.nr.UniVarRealValueFun;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

abstract class TPVelocityLayer
implements UniVarRealValueFun {
    protected String vlLayerName = "";
    protected String vlPhaseType;
    protected String vlPhase;
    protected String vlPhaseUpper;
    protected String vlPhaseLower;
    protected String vlPhaseIUpper;
    protected String vlPhaseILower;
    protected int vlLayerType;
    protected boolean vlSplitLayer;
    protected boolean vlInvalidRay;
    protected boolean vlPassingRay;
    protected boolean vlTurningRay;
    protected boolean vlPhaseUpperIDef;
    protected boolean vlPhaseLowerIDef;
    protected double vlRt;
    protected double vlRb;
    protected double vlIRt;
    protected double vlIRb;
    protected double vlVt;
    protected double vlVb;
    protected double vlPt;
    protected double vlPb;
    protected double vlRTurn;
    protected double vlVTurn;
    protected double vlRLast;
    protected double vlDistT;
    protected double vlDistB;
    protected double vldDistdP_T;
    protected double vldDistdP_B;
    protected double vlPmin;
    protected double vlPCrit;
    protected double vlDistCrit;

    public TPVelocityLayer() {
        this.vlRt = 0.0;
        this.vlRb = 0.0;
        this.vlVt = -1.0;
        this.vlVb = -1.0;
        this.vlPt = -1.0;
        this.vlPb = -1.0;
        this.vlRLast = -1.0;
        this.vlDistT = 0.0;
        this.vlDistB = 0.0;
        this.vlIRt = 0.0;
        this.vlIRb = 0.0;
        this.vlPmin = -1.0;
        this.vlLayerType = -1;
        this.vlPCrit = -1.0;
        this.vlRTurn = -1.0;
        this.vlDistCrit = -1.0;
        this.vlSplitLayer = false;
        this.vlInvalidRay = false;
        this.vlPassingRay = false;
        this.vlTurningRay = false;
        this.vldDistdP_T = 0.0;
        this.vldDistdP_B = 0.0;
        this.vlVTurn = -1.0;
        this.vlPhaseUpperIDef = false;
        this.vlPhaseLowerIDef = false;
        this.vlLayerName = "";
        this.vlPhaseType = "";
        this.vlPhaseLower = "";
        this.vlPhaseUpper = "";
        this.vlPhase = "";
        this.vlPhaseILower = "";
        this.vlPhaseIUpper = "";
    }

    public TPVelocityLayer(double rt, double rb, String layrnam) {
        this.vlRt = rt;
        this.vlRb = rb;
        this.vlVt = -1.0;
        this.vlVb = -1.0;
        this.vlPt = -1.0;
        this.vlPb = -1.0;
        this.vlRLast = -1.0;
        this.vlDistT = 0.0;
        this.vlDistB = 0.0;
        this.vlIRt = 0.0;
        this.vlIRb = 0.0;
        this.vldDistdP_T = 0.0;
        this.vldDistdP_B = 0.0;
        this.vlRTurn = -1.0;
        this.vlPmin = -1.0;
        this.vlLayerType = -1;
        this.vlPCrit = -1.0;
        this.vlDistCrit = -1.0;
        this.vlSplitLayer = false;
        this.vlVTurn = -1.0;
        this.vlInvalidRay = false;
        this.vlPassingRay = false;
        this.vlPhaseUpperIDef = false;
        this.vlPhaseLowerIDef = false;
        this.vlTurningRay = false;
        this.vlLayerName = layrnam;
        this.vlPhaseType = "";
        this.vlPhaseLower = "";
        this.vlPhaseUpper = "";
        this.vlPhase = "";
        this.vlPhaseILower = "";
        this.vlPhaseIUpper = "";
    }

    public TPVelocityLayer(TPVelocityLayer vl) {
        this.vlRt = vl.vlRt;
        this.vlRb = vl.vlRb;
        this.vlVt = vl.vlVt;
        this.vlVb = vl.vlVb;
        this.vlPt = vl.vlPt;
        this.vlPb = vl.vlPb;
        this.vlRLast = vl.vlRLast;
        this.vlIRt = vl.vlIRt;
        this.vlIRb = vl.vlIRb;
        this.vlDistT = vl.vlDistT;
        this.vlDistB = vl.vlDistB;
        this.vldDistdP_T = vl.vldDistdP_T;
        this.vldDistdP_B = vl.vldDistdP_B;
        this.vlInvalidRay = vl.vlInvalidRay;
        this.vlRTurn = vl.vlRTurn;
        this.vlPmin = vl.vlPmin;
        this.vlLayerType = vl.vlLayerType;
        this.vlPCrit = vl.vlPCrit;
        this.vlDistCrit = vl.vlDistCrit;
        this.vlSplitLayer = vl.vlSplitLayer;
        this.vlVTurn = vl.vlVTurn;
        this.vlPassingRay = vl.vlPassingRay;
        this.vlTurningRay = vl.vlTurningRay;
        this.vlLayerName = vl.vlLayerName;
        this.vlPhase = vl.vlPhase;
        this.vlPhaseUpper = vl.vlPhaseUpper;
        this.vlPhaseLower = vl.vlPhaseLower;
        this.vlPhaseType = vl.vlPhaseType;
        this.vlPhaseIUpper = vl.vlPhaseIUpper;
        this.vlPhaseUpperIDef = vl.vlPhaseUpperIDef;
        this.vlPhaseLowerIDef = vl.vlPhaseLowerIDef;
        this.vlPhaseILower = vl.vlPhaseILower;
    }

    public TPVelocityLayer copy(TPVelocityLayer vl) {
        this.vlRt = vl.vlRt;
        this.vlRb = vl.vlRb;
        this.vlVt = vl.vlVt;
        this.vlVb = vl.vlVb;
        this.vlPt = vl.vlPt;
        this.vlPb = vl.vlPb;
        this.vlRTurn = vl.vlRTurn;
        this.vlVTurn = vl.vlVTurn;
        this.vlLayerName = vl.vlLayerName;
        this.vlPhaseType = vl.vlPhaseType;
        this.vlPhase = vl.vlPhase;
        this.vlPhaseUpper = vl.vlPhaseUpper;
        this.vlPhaseLower = vl.vlPhaseLower;
        this.vlPhaseIUpper = vl.vlPhaseIUpper;
        this.vlPhaseILower = vl.vlPhaseILower;
        this.vlPhaseUpperIDef = vl.vlPhaseUpperIDef;
        this.vlPhaseLowerIDef = vl.vlPhaseLowerIDef;
        this.vlIRt = vl.vlIRt;
        this.vlIRb = vl.vlIRb;
        this.vlRLast = vl.vlRLast;
        this.vlDistT = vl.vlDistT;
        this.vlDistB = vl.vlDistB;
        this.vldDistdP_T = vl.vldDistdP_T;
        this.vldDistdP_B = vl.vldDistdP_B;
        this.vlPmin = vl.vlPmin;
        this.vlLayerType = vl.vlLayerType;
        this.vlPCrit = vl.vlPCrit;
        this.vlDistCrit = vl.vlDistCrit;
        this.vlSplitLayer = vl.vlSplitLayer;
        this.vlPassingRay = vl.vlPassingRay;
        this.vlTurningRay = vl.vlTurningRay;
        this.vlInvalidRay = vl.vlInvalidRay;
        return this;
    }

    public abstract double funk(double var1);

    public void init() {
        this.vlVt = this.funk(this.vlRt);
        this.vlVb = this.funk(this.vlRb);
        this.vlPt = this.pAtR(this.vlRt);
        this.vlPb = this.pAtR(this.vlRb);
    }

    public static TPVelocityLayer newModelCopy(TPVelocityLayer tpvl) {
        if (tpvl.isVelocityConstant()) {
            return new VelocityConst((VelocityConst)tpvl);
        }
        if (tpvl.isVelocityPowerLaw()) {
            return new VelocityPower((VelocityPower)tpvl);
        }
        if (tpvl.isVelocityLinear()) {
            return new VelocityLinear((VelocityLinear)tpvl);
        }
        if (tpvl.isVelocityQuadratic()) {
            return new VelocityQuadratic((VelocityQuadratic)tpvl);
        }
        if (tpvl.isVelocityCubic()) {
            return new VelocityCubic((VelocityCubic)tpvl);
        }
        return null;
    }

    public static TPVelocityLayer newModelCopy(String cnam, DataBuffer buffer) {
        if (cnam.equals("VelocityConst")) {
            return new VelocityConst(buffer);
        }
        if (cnam.equals("VelocityPower")) {
            return new VelocityPower(buffer);
        }
        if (cnam.equals("VelocityLinear")) {
            return new VelocityLinear(buffer);
        }
        if (cnam.equals("VelocityQuadratic")) {
            return new VelocityQuadratic(buffer);
        }
        if (cnam.equals("VelocityCubic")) {
            return new VelocityCubic(buffer);
        }
        return null;
    }

    public void writeNormRadius(PrintWriter os) {
    }

    public abstract void writeVelocity(PrintWriter var1);

    public abstract double rAtP(double var1);

    public double pAtR(double r) {
        return r / this.funk(r);
    }

    public double integDistance(double p, double r) {
        double dist = 0.0;
        this.setRay(p);
        if (!this.vlInvalidRay) {
            double rb = this.vlRTurn;
            boolean tflg = this.vlTurningRay;
            if (r != -1.0 && r > this.vlRTurn) {
                rb = r;
                tflg = false;
            }
            this.vlRLast = rb;
            dist = this.integrateDistance(p, rb, tflg);
        }
        return dist;
    }

    public double integDistance(double p, double r1, double r2) {
        double dist = 0.0;
        this.setUpDownRay(p, r1, r2);
        if (!this.vlInvalidRay) {
            dist = this.integrateDistance(p, this.vlIRb, this.vlIRt, this.vlTurningRay);
        } else if (this.vlTurningRay) {
            dist = this.integrateDistance(p, this.vlRTurn, this.vlIRt, true);
        }
        return dist;
    }

    public double integTime(double p, double r) {
        double tim = 0.0;
        double d = this.integDistance(p, r);
        if (!this.vlInvalidRay) {
            tim = this.integrateTime(p, this.vlRLast);
            if (this.isTimeIntegralTau()) {
                tim += p * d;
            }
        }
        return tim;
    }

    public double integTime(double p, double r1, double r2) {
        double r;
        double tim = 0.0;
        this.setUpDownRay(p, r1, r2);
        if (!this.vlInvalidRay) {
            r = this.vlIRb;
        } else if (this.vlTurningRay) {
            r = this.vlRTurn;
        } else {
            return tim;
        }
        tim = this.integrateTime(p, r, this.vlIRt);
        if (this.isTimeIntegralTau()) {
            tim += p * this.integrateDistance(p, r, this.vlIRt, false);
        }
        return tim;
    }

    public abstract double integrateDistance(double var1, double var3, boolean var5);

    public abstract double integrateDistance(double var1, double var3, double var5, boolean var7);

    public abstract double integrateTime(double var1, double var3);

    public abstract double integrateTime(double var1, double var3, double var5);

    public boolean isTimeIntegralTau() {
        return true;
    }

    public double getRt() {
        return this.vlRt;
    }

    public double getRb() {
        return this.vlRb;
    }

    public double getVt() {
        return this.vlVt;
    }

    public double getVb() {
        return this.vlVb;
    }

    public double getPt() {
        return this.vlPt;
    }

    public double getPb() {
        return this.vlPb;
    }

    public double getTurningRadius() {
        return this.vlRTurn;
    }

    public double getTurningVelocity() {
        return this.vlVTurn;
    }

    public void setPmin(double pmin) {
        this.vlPmin = pmin;
    }

    public double getPmin() {
        return this.vlPmin;
    }

    public void setDistT(double d) {
        this.vlDistT = d;
    }

    public double getDistT() {
        return this.vlDistT;
    }

    public void setDistB(double d) {
        this.vlDistB = d;
    }

    public double getDistB() {
        return this.vlDistB;
    }

    public void setdDistdPT(double dDdP) {
        this.vldDistdP_T = dDdP;
    }

    public double getdDistdPT() {
        return this.vldDistdP_T;
    }

    public void setdDistdPB(double dDdP) {
        this.vldDistdP_B = dDdP;
    }

    public double getdDistdPB() {
        return this.vldDistdP_B;
    }

    public void setLayerType(int lt) {
        this.vlLayerType = lt;
    }

    public int getLayerType() {
        return this.vlLayerType;
    }

    public final String getLayerName() {
        return this.vlLayerName;
    }

    public void setPhaseTypeP() {
        this.vlPhaseType = "P";
    }

    public void setPhaseTypeS() {
        this.vlPhaseType = "S";
    }

    public void setPhaseType(String phtype) {
        this.vlPhaseType = phtype;
    }

    public final String getPhaseType() {
        return this.vlPhaseType;
    }

    public void setPhaseName(String name) {
        this.vlPhase = name;
    }

    public final String getPhaseName() {
        return this.vlPhase;
    }

    public void setPhaseNameUpper(String name) {
        this.vlPhaseUpper = name;
    }

    public final String getPhaseNameUpper() {
        return this.vlPhaseUpper;
    }

    public void setPhaseNameLower(String name) {
        this.vlPhaseLower = name;
    }

    public final String getPhaseNameLower() {
        return this.vlPhaseLower;
    }

    public void setPhaseNameDiff(String name) {
        this.vlPhaseIUpper = name;
    }

    public final String getPhaseNameDiff() {
        return this.vlPhaseIUpper;
    }

    public void setPhaseNameDiffLower(String name) {
        this.vlPhaseILower = name;
    }

    public final String getPhaseNameDiffLower() {
        return this.vlPhaseILower;
    }

    public void setPhaseDiffDef(boolean def) {
        this.vlPhaseUpperIDef = def;
    }

    public void setPhaseDiffLowerDef(boolean def) {
        this.vlPhaseLowerIDef = def;
    }

    public boolean isPhaseDiffDefined() {
        return this.vlPhaseUpperIDef;
    }

    public boolean isPhaseDiffLowerDefined() {
        return this.vlPhaseLowerIDef;
    }

    public double getPCrit() {
        return this.vlPCrit;
    }

    public double getDistCrit() {
        return this.vlDistCrit;
    }

    public boolean isSplitLayer() {
        return this.vlSplitLayer;
    }

    public void setSplitLayer(double pcrit, double dcrit) {
        this.vlPCrit = pcrit;
        this.vlDistCrit = dcrit;
        this.vlSplitLayer = true;
    }

    public boolean invalidRay() {
        return this.vlInvalidRay;
    }

    public boolean passingRay() {
        return this.vlPassingRay;
    }

    public boolean turningRay() {
        return this.vlTurningRay;
    }

    public String toString() {
        CharArrayWriter caw = new CharArrayWriter();
        PrintWriter os = new PrintWriter(caw);
        this.toStream(os, "  ");
        return caw.toString();
    }

    public void toStream(PrintWriter os, String indent) {
    }

    public static String class_name() {
        return "TPVelocityLayer";
    }

    public String get_class_name() {
        return TPVelocityLayer.class_name();
    }

    public boolean isVelocityConstant() {
        return false;
    }

    public boolean isVelocityPowerLaw() {
        return false;
    }

    public boolean isVelocityLinear() {
        return false;
    }

    public boolean isVelocityQuadratic() {
        return false;
    }

    public boolean isVelocityCubic() {
        return false;
    }

    public int bufferSize() {
        int bs = this.vlLayerName.length() + this.vlPhaseType.length() + this.vlPhase.length() + this.vlPhaseUpper.length() + this.vlPhaseLower.length() + this.vlPhaseIUpper.length() + this.vlPhaseILower.length() + 56;
        return bs += 139;
    }

    public void serialize(DataBuffer buffer) {
        buffer.writeString(this.vlLayerName);
        buffer.writeString(this.vlPhaseType);
        buffer.writeString(this.vlPhase);
        buffer.writeString(this.vlPhaseUpper);
        buffer.writeString(this.vlPhaseLower);
        buffer.writeString(this.vlPhaseIUpper);
        buffer.writeString(this.vlPhaseILower);
        buffer.writeInt32(this.vlLayerType);
        buffer.writeByte(this.vlSplitLayer ? (byte)1 : 0);
        buffer.writeByte(this.vlPhaseUpperIDef ? (byte)1 : 0);
        buffer.writeByte(this.vlPhaseLowerIDef ? (byte)1 : 0);
        buffer.writeDouble(this.vlRt);
        buffer.writeRawDouble(this.vlRb);
        buffer.writeRawDouble(this.vlVt);
        buffer.writeRawDouble(this.vlVb);
        buffer.writeRawDouble(this.vlPt);
        buffer.writeRawDouble(this.vlPb);
        buffer.writeRawDouble(this.vlRTurn);
        buffer.writeRawDouble(this.vlVTurn);
        buffer.writeRawDouble(this.vlDistT);
        buffer.writeRawDouble(this.vlDistB);
        buffer.writeRawDouble(this.vldDistdP_T);
        buffer.writeRawDouble(this.vldDistdP_B);
        buffer.writeRawDouble(this.vlPmin);
        buffer.writeRawDouble(this.vlPCrit);
        buffer.writeRawDouble(this.vlDistCrit);
    }

    public void deserialize(DataBuffer buffer) {
        this.vlLayerName = buffer.readString();
        this.vlPhaseType = buffer.readString();
        this.vlPhase = buffer.readString();
        this.vlPhaseUpper = buffer.readString();
        this.vlPhaseLower = buffer.readString();
        this.vlPhaseIUpper = buffer.readString();
        this.vlPhaseILower = buffer.readString();
        this.vlLayerType = buffer.readInt32();
        this.vlSplitLayer = buffer.readByte() != 0;
        this.vlPhaseUpperIDef = buffer.readByte() != 0;
        this.vlPhaseLowerIDef = buffer.readByte() != 0;
        this.vlRt = buffer.readDouble();
        this.vlRb = buffer.readRawDouble();
        this.vlVt = buffer.readRawDouble();
        this.vlVb = buffer.readRawDouble();
        this.vlPt = buffer.readRawDouble();
        this.vlPb = buffer.readRawDouble();
        this.vlRTurn = buffer.readRawDouble();
        this.vlVTurn = buffer.readRawDouble();
        this.vlDistT = buffer.readRawDouble();
        this.vlDistB = buffer.readRawDouble();
        this.vldDistdP_T = buffer.readRawDouble();
        this.vldDistdP_B = buffer.readRawDouble();
        this.vlPmin = buffer.readRawDouble();
        this.vlPCrit = buffer.readRawDouble();
        this.vlDistCrit = buffer.readRawDouble();
    }

    protected void setRay(double p) {
        this.vlTurningRay = false;
        this.vlPassingRay = false;
        this.vlInvalidRay = false;
        if (p < this.vlPt) {
            if (p < this.vlPb) {
                this.vlRTurn = this.vlRb;
                this.vlVTurn = this.vlVb;
                this.vlPassingRay = true;
            } else if (p == this.vlPb) {
                this.vlRTurn = this.vlRb;
                this.vlVTurn = this.vlVb;
                this.vlTurningRay = true;
            } else {
                this.vlRTurn = this.rAtP(p);
                this.vlVTurn = this.funk(this.vlRTurn);
                this.vlTurningRay = true;
            }
        } else {
            this.vlInvalidRay = true;
        }
    }

    protected void setUpDownRay(double p, double r1, double r2) {
        this.vlTurningRay = false;
        this.vlPassingRay = false;
        this.vlInvalidRay = true;
        if (r2 < this.vlRt && r1 > this.vlRb) {
            double pbb;
            double rtt = this.vlRt;
            if (r1 < this.vlRt) {
                rtt = r1;
            }
            double rbb = this.vlRb;
            if (r2 > this.vlRb) {
                rbb = r2;
            }
            double ptt = this.pAtR(rtt);
            double pmin = pbb = this.pAtR(rbb);
            double pmax = ptt;
            if (ptt < pbb) {
                pmin = ptt;
                pmax = pbb;
            }
            if (p < pmin) {
                this.vlRLast = rbb;
                this.vlIRt = rtt;
                this.vlIRb = rbb;
                this.vlPassingRay = true;
                this.vlInvalidRay = false;
            } else if (p < pmax) {
                this.vlRTurn = this.rAtP(p);
                this.vlVTurn = this.funk(this.vlRTurn);
                this.vlRLast = this.vlRTurn;
                this.vlIRt = rtt;
                this.vlIRb = this.vlRTurn;
                this.vlTurningRay = true;
                if (p == pmin) {
                    this.vlInvalidRay = false;
                }
            }
        }
    }
}

