/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.CrustalProfile;
import cn.org.gddsn.seis.location.rstt.DataBuffer;
import cn.org.gddsn.seis.location.rstt.GeoStack;
import cn.org.gddsn.seis.location.rstt.GreatCircle;
import cn.org.gddsn.seis.location.rstt.GreatCircle_Xn;
import cn.org.gddsn.seis.location.rstt.Grid;
import cn.org.gddsn.seis.location.rstt.GridProfile;
import cn.org.gddsn.seis.location.rstt.GridWeight;
import cn.org.gddsn.seis.location.rstt.InterpolatedProfile;
import cn.org.gddsn.seis.location.rstt.LayerProfile;
import cn.org.gddsn.seis.location.rstt.Location;
import cn.org.gddsn.seis.location.rstt.QueryNeighborInfo;
import cn.org.gddsn.seis.location.rstt.QueryProfile;
import cn.org.gddsn.seis.location.rstt.SLBMException;
import cn.org.gddsn.seis.location.rstt.Uncertainty;
import cn.org.gddsn.seis.location.rstt.ZhaoParameters;
import java.io.File;
import java.util.Vector;
import org.netlib.util.StringW;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlbmInterface {
    protected Grid grid = null;
    protected GreatCircle greatCircle = null;
    protected Uncertainty[][] uncertainty = new Uncertainty[3][4];
    protected String modelPath;
    protected static double CH_MAX = 0.2;
    protected boolean valid = false;

    protected void clearGreatCircles() {
        if (this.greatCircle != null) {
            this.greatCircle = null;
        }
    }

    protected void loadVelocityModelBinary(DataBuffer buffer) {
        if (this.grid != null) {
            this.grid = null;
        }
        this.grid = new Grid();
        this.modelPath = buffer.readString();
        this.grid.loadVelocityModelBinary(buffer);
    }

    protected int getBufferSize() {
        int bsiz = 8 + this.modelPath.length();
        if (this.grid != null) {
            bsiz += this.grid.getBufferSize();
        }
        return bsiz;
    }

    protected void saveVelocityModelBinary(DataBuffer buffer) {
        if (this.grid == null) {
            String err = "\nERROR in saveVelocityModelBinary\nThere is no grid in memory to save.\n";
            throw new SLBMException(err, 109);
        }
        buffer.writeString(this.modelPath);
        this.grid.saveVelocityModelBinary(buffer);
    }

    public SlbmInterface() {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 4) {
                this.uncertainty[i][j] = null;
                ++j;
            }
            ++i;
        }
    }

    public SlbmInterface(double earthRadius) {
        Location.EARTH_RADIUS = earthRadius;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 4) {
                this.uncertainty[i][j] = null;
                ++j;
            }
            ++i;
        }
    }

    protected void finalize() {
        this.clear();
        this.grid = null;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 4) {
                this.uncertainty = null;
                ++j;
            }
            ++i;
        }
        this.valid = false;
    }

    public String getVersion() {
        return "2.8.4";
    }

    public void loadVelocityModel(String modelFileName) {
        if (this.grid != null) {
            this.grid = null;
        }
        this.grid = new Grid();
        this.grid.loadVelocityModel(modelFileName);
        this.modelPath = new File(modelFileName).getPath();
    }

    public void loadVelocityModelBinary(String modelFileName) {
        if (this.grid != null) {
            this.grid = null;
        }
        this.grid = new Grid();
        this.grid.loadVelocityModelBinary(modelFileName);
        this.modelPath = new File(modelFileName).getPath();
    }

    public void specifyOutputDirectory(String directoryName) {
        if (this.grid == null) {
            String err = "\nERROR in sepecifyOutputDirectory\nThere is no grid in memory to save.\n";
            throw new SLBMException(err, 109);
        }
        this.grid.specifyOutputDirectory(directoryName);
    }

    public void saveVelocityModelBinary() {
        if (this.grid == null) {
            String err = "\nERROR in saveVelocityModelBinary\nThere is no grid in memory to save.\n";
            throw new SLBMException(err, 109);
        }
        this.grid.saveVelocityModelBinary();
    }

    public void createGreatCircle(int phase, double sourceLat, double sourceLon, double sourceDepth, double receiverLat, double receiverLon, double receiverDepth) {
        this.clearGreatCircles();
        this.valid = false;
        this.greatCircle = GreatCircle.create(phase, this.grid, sourceLat, sourceLon, sourceDepth, receiverLat, receiverLon, receiverDepth, CH_MAX);
        this.valid = true;
    }

    public void clear() {
        this.clearGreatCircles();
        if (this.grid != null) {
            this.grid.clearCrustalProfiles();
        }
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getPhase() {
        return this.greatCircle.getPhaseString();
    }

    public double getDistance() {
        if (!this.isValid()) {
            String err = "\nERROR in getDistance\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        return this.greatCircle.getDistance();
    }

    public double getSourceDistance() {
        if (!this.isValid()) {
            String err = "\nERROR in getSourceDistance\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        return this.greatCircle.getSourceDistance();
    }

    public double getReceiverDistance() {
        if (!this.isValid()) {
            String err = "\nERROR in getReceiverDistance\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        return this.greatCircle.getReceiverDistance();
    }

    public double getHeadwaveDistance() {
        if (!this.isValid()) {
            String err = "\nERROR in getHeadwaveDistance\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        return this.greatCircle.getHeadwaveDistance();
    }

    public double getTravelTime() {
        if (!this.isValid()) {
            String err = "\nERROR in getTravelTime\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        return this.greatCircle.getTravelTime();
    }

    public void getTravelTimeComponents(doubleW tTotal, doubleW tSource, doubleW tReceiver, doubleW tHeadwave, doubleW tGradient) {
        if (!this.isValid()) {
            tTotal.val = -999999.0;
            tSource.val = -999999.0;
            tReceiver.val = -999999.0;
            tHeadwave.val = -999999.0;
            tGradient.val = -999999.0;
            String err = "\nERROR in getTravelTimeComponents\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        this.greatCircle.getTravelTime(tTotal, tSource, tReceiver, tHeadwave, tGradient);
    }

    public double getSlowness() {
        if (!this.isValid()) {
            String err = "\nERROR in getSlowness\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        return this.greatCircle.get_dtt_ddist();
    }

    public double get_dtt_dlat() {
        doubleW value = new doubleW(-999999.0);
        if (!this.isValid()) {
            value.val = -999999.0;
            String err = "\nERROR in get_dtt_dlat\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        this.greatCircle.get_dtt_dlat(value);
        return value.val;
    }

    public double get_dtt_dlon() {
        doubleW value = new doubleW(-999999.0);
        if (!this.isValid()) {
            value.val = -999999.0;
            String err = "\nERROR in get_dtt_dlon\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        this.greatCircle.get_dtt_dlon(value);
        return value.val;
    }

    public double get_dtt_ddepth() {
        doubleW value = new doubleW(-999999.0);
        if (!this.isValid()) {
            value.val = -999999.0;
            String err = "\nERROR in get_dtt_ddepth\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        this.greatCircle.get_dtt_ddepth(value);
        return value.val;
    }

    public GridWeight getWeights() {
        if (!this.isValid()) {
            String err = "\nERROR in getWeights\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        GridWeight gw = new GridWeight();
        Vector<Integer> nodeId = new Vector<Integer>();
        Vector<Double> weight = new Vector<Double>();
        this.greatCircle.getWeights(nodeId, weight);
        gw.node = new int[nodeId.size()];
        gw.weight = new double[nodeId.size()];
        int i = 0;
        while (i < nodeId.size()) {
            gw.node[i] = nodeId.get(i);
            gw.weight[i] = weight.get(i);
            ++i;
        }
        return gw;
    }

    public GridWeight getActiveNodeWeights() {
        GridWeight gw = this.getWeights();
        int i = 0;
        while (i < gw.node.length) {
            gw.node[i] = this.grid.getActiveNodeId(gw.node[i]);
            ++i;
        }
        return gw;
    }

    public void getWeights(Vector<Integer> nodeId, Vector<Double> weight) {
        if (!this.isValid()) {
            nodeId.clear();
            weight.clear();
            String err = "\nERROR in getWeights\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        this.greatCircle.getWeights(nodeId, weight);
    }

    public void getActiveNodeWeights(Vector<Integer> nodeId, Vector<Double> weight) {
        this.getWeights(nodeId, weight);
        int i = 0;
        while (i < nodeId.size()) {
            nodeId.set(i, this.grid.getActiveNodeId(nodeId.get(i)));
            ++i;
        }
    }

    public GridWeight getWeightsSource() {
        if (!this.isValid()) {
            String err = "\nERROR in getWeightsSource\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        GridWeight gw = this.getWeights();
        gw.node = new int[3];
        gw.weight = new double[3];
        this.greatCircle.getSourceProfile().getNodeIds(gw.node);
        this.greatCircle.getSourceProfile().getCoefficients(gw.weight);
        return gw;
    }

    public GridWeight getActiveNodeWeightsSource() {
        GridWeight gw = this.getWeightsSource();
        int i = 0;
        while (i < 3) {
            gw.node[i] = this.grid.getActiveNodeId(gw.node[i]);
            ++i;
        }
        return gw;
    }

    public GridWeight getWeightsReceiver() {
        if (!this.isValid()) {
            String err = "\nERROR in getWeightsReceiver\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        GridWeight gw = this.getWeights();
        gw.node = new int[3];
        gw.weight = new double[3];
        this.greatCircle.getReceiverProfile().getNodeIds(gw.node);
        this.greatCircle.getReceiverProfile().getCoefficients(gw.weight);
        return gw;
    }

    public GridWeight getActiveNodeWeightsReceiver() {
        GridWeight gw = this.getWeightsReceiver();
        int i = 0;
        while (i < 3) {
            gw.node[i] = this.grid.getActiveNodeId(gw.node[i]);
            ++i;
        }
        return gw;
    }

    public String toString(int verbosity) {
        if (!this.isValid()) {
            String err = "\nERROR in toString\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        double slowness = this.getSlowness();
        String msg = String.format("\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\nGreat Circle \n\n" + this.greatCircle.toString(verbosity) + "\nHorizontal slowness = %.9f sec/radian\n\n", slowness);
        return msg;
    }

    public int getNGridNodes() {
        if (this.grid == null) {
            String err = "\nERROR in getNGridNodes\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        return this.grid.getNNodes();
    }

    public int getNHeadWavePoints() {
        if (this.greatCircle == null) {
            String err = "\nERROR in getNGridNodes\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        return this.greatCircle.getNProfiles();
    }

    public void getGridData(int nodeId, doubleW latitude, doubleW longitude, double[] depth, double[] pvelocity, double[] svelocity, double[] gradient) {
        if (nodeId < 0 || nodeId >= this.grid.getNNodes()) {
            String err = "\nERROR in getGridData\nSpecified grid nodeId, " + nodeId + ", " + " is out of range.  Must be less than " + this.grid.getNNodes() + "\n";
            throw new SLBMException(err, 110);
        }
        GridProfile profile = this.grid.getProfile(nodeId);
        latitude.val = profile.getLat();
        longitude.val = profile.getLon();
        profile.getData(depth, pvelocity, svelocity, gradient);
    }

    public void getActiveNodeData(int nodeId, doubleW latitude, doubleW longitude, double[] depth, double[] pvelocity, double[] svelocity, double[] gradient) {
        this.getGridData(this.grid.getGridNodeId(nodeId), latitude, longitude, depth, pvelocity, svelocity, gradient);
    }

    public void setGridData(int nodeId, double[] depths, double[] pvelocity, double[] svelocity, double[] gradient) {
        if (nodeId < 0 || nodeId >= this.grid.getNNodes()) {
            String err = "\nERROR in setGridData\nSpecified grid nodeId, " + nodeId + ",  is out of range.  Must be less than " + this.grid.getNNodes() + "\n";
            throw new SLBMException(err, 111);
        }
        this.grid.getProfile(nodeId).setData(depths, pvelocity, svelocity, gradient);
    }

    public void setActiveNodeData(int nodeId, double[] depths, double[] pvelocity, double[] svelocity, double[] gradient) {
        this.setGridData(this.grid.getGridNodeId(nodeId), depths, pvelocity, svelocity, gradient);
    }

    public void getGreatCircleData(StringW phase, doubleW actual_path_increment, double[] sourceDepth, double[] sourceVelocity, double[] receiverDepth, double[] receiverVelocity, double[] headWaveVelocity, double[] gradient, int[][] neighbors, double[][] coefficients, intW npoints) {
        if (!this.isValid()) {
            phase.val = "";
            actual_path_increment.val = -999999.0;
            String err = "\nERROR in getGreatCircleData\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        intW p = new intW(0);
        npoints.val = this.greatCircle.getNProfiles();
        this.greatCircle.getData(p, actual_path_increment, sourceDepth, sourceVelocity, receiverDepth, receiverVelocity, headWaveVelocity, gradient, neighbors, coefficients);
        phase.val = p.val == 0 ? "Pn" : (p.val == 1 ? "Sn" : (p.val == 2 ? "Pg" : (p.val == 3 ? "Lg" : "unknown phase")));
    }

    public void getInterpolatedPoint(double lat, double lon, int[] nodeId, double[] coefficients, double[] depth, double[] pvelocity, double[] svelocity, doubleW pgradient, doubleW sgradient) {
        Location location = new Location(lat, lon, 0.0);
        QueryProfile profile = null;
        profile = this.grid.getQueryProfile(location);
        profile.getData(nodeId, coefficients, depth, pvelocity, svelocity, pgradient, sgradient);
        profile = null;
    }

    /*
     * Unable to fully structure code
     */
    public void getInterpolatedTransect(double[] lat, double[] lon, int nLatLon, int[][] nodeId, double[][] coefficients, double[][] depth, double[][] pvelocity, double[][] svelocity, double[] pgradient, double[] sgradient, intW nInvalid) {
        nInvalid.val = 0;
        i = 0;
        while (i < nLatLon) {
            block5: {
                try {
                    w1 = new doubleW(pgradient[i]);
                    w2 = new doubleW(sgradient[i]);
                    this.getInterpolatedPoint(lat[i], lon[i], nodeId[i], coefficients[i], depth[i], pvelocity[i], svelocity[i], w1, w2);
                    pgradient[i] = w1.val;
                    sgradient[i] = w2.val;
                    break block5;
                }
                catch (SLBMException ex) {
                    j = 0;
                    ** while (j < 3)
                }
lbl-1000:
                // 1 sources

                {
                    nodeId[i][j] = -1;
                    coefficients[i][j] = -999999.0;
                    ++j;
                    continue;
                }
lbl18:
                // 1 sources

                j = 0;
                while (j < 9) {
                    depth[i][j] = -999999.0;
                    pvelocity[i][j] = -999999.0;
                    svelocity[i][j] = -999999.0;
                    ++j;
                }
                pgradient[i] = -999999.0;
                sgradient[i] = -999999.0;
                ++nInvalid.val;
            }
            ++i;
        }
    }

    public void initializeActiveNodes(double latmin, double lonmin, double latmax, double lonmax) {
        if (this.grid == null) {
            String err = "\nERROR in initializeActiveNodes\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        this.grid.initializeActiveNodes(latmin, lonmin, latmax, lonmax);
    }

    public int getNActiveNodes() {
        if (this.grid == null) {
            String err = "\nERROR in nextActiveNode\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        return this.grid.getNActiveNodes();
    }

    public int getGridNodeId(int activeNodeId) {
        if (this.grid == null) {
            String err = "\nERROR in getGridNodeId\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        return this.grid.getGridNodeId(activeNodeId);
    }

    public int getActiveNodeId(int gridNodeId) {
        if (this.grid == null) {
            String err = "\nERROR in getNGridNode\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        return this.grid.getActiveNodeId(gridNodeId);
    }

    public int getNodeHitCount(int nodeId) {
        if (this.grid == null) {
            String err = "\nERROR in getNodeHitCount\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        intW hitCount = new intW(0);
        this.grid.getNodeHitCount(nodeId, hitCount);
        return hitCount.val;
    }

    public void getNodeNeighbors(int nid, int[] neighbors, intW nNeighbors) {
        if (this.grid == null) {
            String err = "\nERROR in getNodeNeighbors\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        this.grid.getNodeNeighbors(nid, neighbors, nNeighbors);
    }

    public void getActiveNodeNeighbors(int nid, int[] neighbors, intW nNeighbors) {
        if (this.grid == null) {
            String err = "\nERROR in getActiveNodeNeighbors\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        this.grid.getActiveNodeNeighbors(nid, neighbors, nNeighbors);
    }

    public void getNodeNeighbors(int nid, Vector<Integer> neighbors) {
        if (this.grid == null) {
            String err = "\nERROR in getNodeNeighbors\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        this.grid.getNodeNeighbors(nid, neighbors);
    }

    public void getActiveNodeNeighbors(int nid, Vector<Integer> neighbors) {
        if (this.grid == null) {
            String err = "\nERROR in getActiveNodeNeighbors\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        this.grid.getActiveNodeNeighbors(nid, neighbors);
    }

    public QueryNeighborInfo getNodeNeighborInfo(int nid) {
        if (this.grid == null) {
            String err = "\nERROR in getNGridNodes\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        QueryNeighborInfo neighborinfo = new QueryNeighborInfo();
        neighborinfo.nid = nid;
        Vector<Integer> nbs = new Vector<Integer>();
        this.grid.getNodeNeighbors(nid, nbs);
        neighborinfo.neighbors = new int[nbs.size()];
        int i = 0;
        for (int n : nbs) {
            neighborinfo.neighbors[i++] = n;
        }
        neighborinfo.nNeighbors = neighborinfo.neighbors.length;
        double[] tempDist = new double[neighborinfo.neighbors.length];
        double[] tempAz = new double[neighborinfo.neighbors.length];
        i = 0;
        while (i < neighborinfo.neighbors.length) {
            tempDist[i] = this.getNodeSeparation(nid, neighborinfo.neighbors[i]);
            tempAz[i] = this.getNodeAzimuth(nid, neighborinfo.neighbors[i]);
            ++i;
        }
        neighborinfo.distance = tempDist;
        neighborinfo.azimuth = tempAz;
        return neighborinfo;
    }

    public QueryNeighborInfo getActiveNodeNeighborInfo(int actnid, int[] neighbors, double[] distance, double[] azimuth, intW nNeighbors) {
        if (this.grid == null) {
            String err = "\nERROR in getActiveNodeNeighborInfo\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        QueryNeighborInfo neighborinfo = new QueryNeighborInfo();
        neighborinfo.nid = actnid;
        Vector<Integer> nbs = new Vector<Integer>();
        this.grid.getActiveNodeNeighbors(actnid, nbs);
        neighborinfo.neighbors = new int[nbs.size()];
        int i = 0;
        for (int n : nbs) {
            neighborinfo.neighbors[i++] = n;
        }
        neighborinfo.nNeighbors = neighborinfo.neighbors.length;
        double[] tempDist = new double[neighborinfo.neighbors.length];
        double[] tempAz = new double[neighborinfo.neighbors.length];
        i = 0;
        while (i < neighborinfo.neighbors.length) {
            tempDist[i] = this.getNodeSeparation(this.getGridNodeId(actnid), this.getGridNodeId(neighborinfo.neighbors[i]));
            tempAz[i] = this.getNodeAzimuth(this.getGridNodeId(actnid), this.getGridNodeId(neighborinfo.neighbors[i]));
            ++i;
        }
        neighborinfo.distance = tempDist;
        neighborinfo.azimuth = tempAz;
        return neighborinfo;
    }

    public void getActiveNodeNeighborInfo(int nid, Vector<Integer> neighbors, Vector<Double> distance, Vector<Double> azimuth) {
        if (this.grid == null) {
            String err = "\nERROR in getActiveNodeNeighborInfo\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        this.grid.getActiveNodeNeighborInfo(nid, neighbors, distance, azimuth);
    }

    public double getNodeSeparation(int node1, int node2) {
        if (this.grid == null) {
            String err = "\nERROR in getNodeSepration\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        doubleW distance = new doubleW(0.0);
        this.grid.getNodeSeparation(node1, node2, distance);
        return distance.val;
    }

    public double getNodeAzimuth(int node1, int node2) {
        if (this.grid == null) {
            String err = "\nERROR in getNodeAzimuth\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        doubleW azimuth = new doubleW(0.0);
        this.grid.getNodeAzimuth(node1, node2, azimuth);
        return azimuth.val;
    }

    public GreatCircle getGreatCircleObject() {
        return this.greatCircle;
    }

    public Grid getGridObject() {
        return this.grid;
    }

    public double getTravelTimeUncertainty(int phase, double distance) {
        double uncert = -999999.0;
        if (this.uncertainty[0][phase] == null) {
            this.uncertainty[0][phase] = new Uncertainty(this.modelPath, phase, 0);
        }
        if (this.uncertainty[0][phase] == null) {
            String err = "\nERROR in getTravelTimeUncertainty\nUncertainty object is invalid.\n";
            throw new SLBMException(err, 602);
        }
        uncert = this.uncertainty[0][phase].getUncertainty(distance, 0.0);
        return uncert;
    }

    public double getTravelTimeUncertainty() {
        return this.getTravelTimeUncertainty(this.greatCircle.getPhase(), this.greatCircle.getDistance());
    }

    public double getSlownessUncertainty(int phase, double distance) {
        doubleW uncert = new doubleW(-999999.0);
        if (this.uncertainty[1][phase] == null) {
            this.uncertainty[1][phase] = new Uncertainty(this.modelPath, phase, 1);
        }
        if (this.uncertainty[1][phase] == null) {
            String err = "\nERROR in getTravelTimeUncertainty\nUncertainty object is invalid.\n";
            throw new SLBMException(err, 602);
        }
        uncert.val = this.uncertainty[1][phase].getUncertainty(distance, 0.0);
        return uncert.val;
    }

    public ZhaoParameters getZhaoParameters() {
        if (this.greatCircle == null) {
            String err = "\nERROR in getZhaoParameters\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        doubleW Vm = new doubleW(0.0);
        doubleW Gm = new doubleW(0.0);
        doubleW H = new doubleW(0.0);
        doubleW C = new doubleW(0.0);
        doubleW Cm = new doubleW(0.0);
        intW udSign = new intW(0);
        this.greatCircle.getZhaoParameters(Vm, Gm, H, C, Cm, udSign);
        ZhaoParameters zpar = new ZhaoParameters();
        zpar.Vm = Vm.val;
        zpar.Gm = Gm.val;
        zpar.H = H.val;
        zpar.C = C.val;
        zpar.Cm = Cm.val;
        zpar.udSign = udSign.val;
        return zpar;
    }

    public void getPgLgComponents(doubleW tTotal, doubleW tTaup, doubleW tHeadwave, doubleW pTaup, doubleW pHeadwave, doubleW trTaup, doubleW trHeadwave) {
        if (this.greatCircle == null) {
            String err = "\nERROR in getPgLgComponents\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        this.greatCircle.getPgLgComponents(tTotal, tTaup, tHeadwave, pTaup, pHeadwave, trTaup, trHeadwave);
    }

    public static void setCHMax(double chMax) {
        CH_MAX = chMax;
    }

    public static double getCHMax() {
        return CH_MAX;
    }

    public double getAverageMantleVelocity(int type) {
        if (this.grid == null) {
            String err = "\nERROR in getAverageMantleVelocity\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        return this.grid.getAverageMantleVelocity(type);
    }

    public void setAverageMantleVelocity(int type, double velocity) {
        if (this.grid == null) {
            String err = "\nERROR in setAverageMantleVelocity\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        this.grid.setAverageMantleVelocity(type, velocity);
    }

    public String getTessId() {
        if (this.grid == null) {
            String err = "\nERROR in getTessId\nGreatCircle is invalid. Has the earth model been loaded with call to loadVelocityModel()?\n";
            throw new SLBMException(err, 114);
        }
        return this.grid.getTessId();
    }

    public double getFractionActive() {
        if (!this.isValid()) {
            String err = "\nERROR in \nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        return this.greatCircle.getFractionActive();
    }

    public static void setMaxDistance(double maxDistance) {
        GreatCircle.MAX_DISTANCE = maxDistance;
    }

    public static double getMaxDistance() {
        return GreatCircle.MAX_DISTANCE;
    }

    public static void setMaxDepth(double maxDepth) {
        GreatCircle_Xn.MAX_DEPTH = maxDepth;
    }

    public static double getMaxDepth() {
        return GreatCircle_Xn.MAX_DEPTH;
    }

    public static String getClassCount() {
        String msg = String.format("Class counts:\nGreatCircle         = %d\nGridProfile         = %d\nGeoStack            = %d\nInterpolatedProfile = %d\nCrustalProfile      = %d\nLayerProfile        = %d\nQueryProfile        = %d\nLocation            = %d\n", GreatCircle.getClassCount(), GridProfile.getClassCount(), GeoStack.getClassCount(), InterpolatedProfile.getClassCount(), CrustalProfile.getClassCount(), LayerProfile.getClassCount(), QueryProfile.getClassCount(), Location.getClassCount());
        return msg;
    }

    public final String getModelPath() {
        return this.modelPath;
    }

    public void getDistAz(double aLat, double aLon, double bLat, double bLon, doubleW distance, doubleW azimuth, double naValue) {
        Location ptA = new Location(aLat, aLon, 0.0);
        Location ptB = new Location(bLat, bLon, 0.0);
        distance.val = ptA.distance(ptB);
        azimuth.val = ptA.azimuth(ptB, naValue);
    }

    public void movePoint(double aLat, double aLon, double distance, double azimuth, doubleW bLat, doubleW bLon) {
        Location ptA = new Location(aLat, aLon, 0.0);
        Location ptB = new Location();
        ptA.move(azimuth, distance, ptB);
        bLat.val = ptB.getLat();
        bLon.val = ptB.getLon();
    }

    public void getGreatCircleLocations(double[] lat, double[] lon, double[] depth, intW npoints) {
        if (!this.isValid()) {
            String err = "\nERROR in getGreatCircleData\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        npoints.val = this.greatCircle.getNProfiles();
        Location loc = new Location();
        int i = 0;
        while (i < this.greatCircle.getNProfiles()) {
            this.greatCircle.getLayerProfileLocation(i, loc);
            lat[i] = loc.getLat();
            lon[i] = loc.getLon();
            depth[i] = loc.getDepth();
            ++i;
        }
    }

    public void getPiercePointSource(doubleW lat, doubleW lon, doubleW depth) {
        if (!this.isValid()) {
            lon.val = -999999.0;
            lat.val = -999999.0;
            String err = "\nERROR in getPiercePointSource\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        if (this.greatCircle.getPhase() == 2 || this.greatCircle.getPhase() == 3) {
            lon.val = -999999.0;
            lat.val = -999999.0;
            String err = "\nERROR in getPiercePointSource\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        if (!this.greatCircle.getSourceProfile().isInCrust()) {
            lon.val = -999999.0;
            lat.val = -999999.0;
            String err = "\nERROR in getPiercePointSource\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        Location loc = new Location();
        this.greatCircle.getGreatCircleLocation(this.greatCircle.getSourceDistance(), loc);
        lat.val = loc.getLat();
        lon.val = loc.getLon();
        QueryProfile profile = null;
        profile = this.grid.getQueryProfile(loc);
        depth.val = profile.getDepth()[8];
        profile = null;
    }

    public void getPiercePointReceiver(doubleW lat, doubleW lon, doubleW depth) {
        if (!this.isValid()) {
            lon.val = -999999.0;
            lat.val = -999999.0;
            String err = "\nERROR in getPiercePointReceiver\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        if (this.greatCircle.getPhase() == 2 || this.greatCircle.getPhase() == 3) {
            lon.val = -999999.0;
            lat.val = -999999.0;
            String err = "\nERROR in getPiercePointReceiver\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        if (!this.greatCircle.getReceiverProfile().isInCrust()) {
            lon.val = -999999.0;
            lat.val = -999999.0;
            String err = "\nERROR in getPiercePointReceiver\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        Location loc = new Location();
        this.greatCircle.getGreatCircleLocation(this.greatCircle.getDistance() - this.greatCircle.getReceiverDistance(), loc);
        lat.val = loc.getLat();
        lon.val = loc.getLon();
        QueryProfile profile = null;
        profile = this.grid.getQueryProfile(loc);
        depth.val = profile.getDepth()[8];
        profile = null;
    }

    public void getGreatCirclePoints(double aLat, double aLon, double bLat, double bLon, int npoints, double[] latitude, double[] longitude) {
        Location a = new Location(aLat, aLon, 0.0);
        Location b = new Location(bLat, bLon, 0.0);
        double dx = a.distance(b) / (double)(npoints - 1);
        double[] moveDirection = new double[3];
        a.vectorTripleProduct(b, moveDirection);
        int i = 0;
        while (i < npoints) {
            a.move(moveDirection, (double)i * dx, b);
            latitude[i] = b.getLat();
            longitude[i] = b.getLon();
            ++i;
        }
    }

    public void getGreatCirclePointsOnCenters(double aLat, double aLon, double bLat, double bLon, int npoints, double[] latitude, double[] longitude) {
        Location a = new Location(aLat, aLon, 0.0);
        Location b = new Location(bLat, bLon, 0.0);
        double dx = a.distance(b) / (double)npoints;
        double[] moveDirection = new double[3];
        a.vectorTripleProduct(b, moveDirection);
        int i = 0;
        while (i < npoints) {
            a.move(moveDirection, ((double)i + 0.5) * dx, b);
            latitude[i] = b.getLat();
            longitude[i] = b.getLon();
            ++i;
        }
    }

    public static void setDelDistance(double del_distance) {
        GreatCircle.setDelDistance(del_distance);
    }

    public static double getDelDistance() {
        doubleW del_distance = new doubleW(0.0);
        GreatCircle.getDelDistance(del_distance);
        return del_distance.val;
    }

    public static void setDelDepth(double del_depth) {
        GreatCircle.setDelDepth(del_depth);
    }

    public static double getDelDepth() {
        doubleW del_depth = new doubleW(0.0);
        GreatCircle.getDelDepth(del_depth);
        return del_depth.val;
    }

    public static void setPathIncrement(double path_increment) {
        GreatCircle.setPathIncrement(path_increment);
    }

    public static double getPathIncrement() {
        doubleW path_increment = new doubleW(0.0);
        GreatCircle.getPathIncrement(path_increment);
        return path_increment.val;
    }

    public void createGreatCircle(String p, double sourceLat, double sourceLon, double sourceDepth, double receiverLat, double receiverLon, double receiverDepth) {
        int iphase;
        int n = p.equals("Pn") ? 0 : (p.equals("Sn") ? 1 : (p.equals("Pg") ? 2 : (iphase = p.equals("Lg") ? 3 : -1)));
        if (iphase == -1) {
            String err = "\nERROR in createGreatCircle\n" + p + " is not a recognized phase.  Must be one of Pn, Sn, Pg, Lg\n";
            throw new SLBMException(err, 112);
        }
        this.createGreatCircle(iphase, sourceLat, sourceLon, sourceDepth, receiverLat, receiverLon, receiverDepth);
    }

    public double getHeadwaveDistanceKm() {
        if (!this.isValid()) {
            String err = "\nERROR in getHeadwaveDistanceKm\nGreatCircle is invalid.\n";
            throw new SLBMException(err, 113);
        }
        return this.greatCircle.getHeadwaveDistanceKm();
    }

    public double getSlownessUncertainty() {
        return this.getSlownessUncertainty(this.greatCircle.getPhase(), this.greatCircle.getDistance());
    }

    public void saveVelocityModel(String fname) {
        if (this.grid == null) {
            String err = "\nERROR in saveVelocityModel\nThere is no grid in memory to save.\n";
            throw new SLBMException(err, 109);
        }
        this.grid.saveVelocityModel(fname);
    }
}

