/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.SLBMException;
import cn.org.gddsn.seis.location.rstt.SlbmInterface;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Scanner;

public class SLBMTest {
    public static void main(String[] args) {
        if (args.length == 2) {
            SLBMTest.run_regression_test(args);
        } else if (args.length == 3) {
            SLBMTest.generate_regression_test_data(args);
        } else if (args.length == 8) {
            SLBMTest.simple_test(args);
        } else {
            System.out.println("Expecting either 2 or 8 command line parameters:");
            System.out.println();
            System.out.println("2 parameters - run a regression test:");
            System.out.println("    1: directory where slbm velocity model can be found");
            System.out.println("    2: file containing the regression test data");
            System.out.println("    If running this program from SLBM_Root, try:");
            System.out.println("    java -jar bin/slbmtest.jar models/na1010pn models/na1010pn/regression_na1010pn.dat");
            System.out.println();
            System.out.println("8 parameters - run a single path test:");
            System.out.println("    1: directory where slbm velocity model can be found");
            System.out.println("    2: phase (one of Pn, Sn, Pg, Lg)");
            System.out.println("    3: source latitude in degees");
            System.out.println("    4: source longitude in degrees");
            System.out.println("    5: source depth in km below sea level");
            System.out.println("    6: receiver latitude in degees");
            System.out.println("    7: receiver longitude in degrees");
            System.out.println("    8: receiver DEPTH (!!!) in km BELOW sea level");
            System.out.println("    If running this program from SLBM_Root, try:");
            System.out.println("    java -jar bin/slbmtest.jar models/na1010pn Pn 10 20 5 15 25 -0.1");
            System.out.println();
            System.exit(1);
        }
    }

    public static void simple_test(String[] args) {
        System.out.println("SLBM Java Regression Test");
        try {
            File modelDirectory = new File(args[0]);
            SlbmInterface slbm = new SlbmInterface();
            System.out.println("Running SLBM Version " + slbm.getVersion());
            slbm.loadVelocityModelBinary(modelDirectory.getCanonicalPath());
            String phase = args[1];
            double srclatDegrees = Double.parseDouble(args[2]);
            double srclonDegrees = Double.parseDouble(args[3]);
            double srcdepthKm = Double.parseDouble(args[4]);
            double rcvlatDegrees = Double.parseDouble(args[5]);
            double rcvlonDegrees = Double.parseDouble(args[6]);
            double rcvdepthKm = Double.parseDouble(args[7]);
            System.out.printf("Phase  = %s%n", phase);
            System.out.printf("Source   Lat   = %9.4f deg%n", srclatDegrees);
            System.out.printf("Source   Lon   = %9.4f deg%n", srclonDegrees);
            System.out.printf("Source   Depth = %9.4f km%n", srcdepthKm);
            System.out.printf("Receiver Lat   = %9.4f deg%n", rcvlatDegrees);
            System.out.printf("Receiver Lon   = %9.4f deg%n", rcvlonDegrees);
            System.out.printf("Receiver Depth = %9.4f km%n", rcvdepthKm);
            System.out.println();
            double DEG_TO_RAD = Math.toRadians(1.0);
            slbm.createGreatCircle(phase, srclatDegrees * DEG_TO_RAD, srclonDegrees * DEG_TO_RAD, srcdepthKm, rcvlatDegrees * DEG_TO_RAD, rcvlonDegrees * DEG_TO_RAD, rcvdepthKm);
            System.out.printf("Distance       = %9.4f deg%n", slbm.getDistance() / DEG_TO_RAD);
            System.out.printf("Travel time    = %9.4f sec%n", slbm.getTravelTime());
            System.out.printf("TT uncertainty = %9.4f sec%n", slbm.getTravelTimeUncertainty());
            System.out.printf("Slowness       = %9.4f sec/deg%n", slbm.getSlowness() * DEG_TO_RAD);
            System.out.printf("dtt/dlat       = %9.4f sec/deg%n", slbm.get_dtt_dlat() * DEG_TO_RAD);
            System.out.printf("dtt/dlat       = %9.4f sec/deg%n", slbm.get_dtt_dlon() * DEG_TO_RAD);
            System.out.printf("dtt/ddepth     = %9.4f sec/deg%n", slbm.get_dtt_ddepth());
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void run_regression_test(String[] args) {
        System.out.println("SLBM Java Regression Test");
        try {
            File modelDirectory = new File(args[0]);
            File dataFile = new File(args[1]);
            SlbmInterface slbm = new SlbmInterface();
            System.out.println("Running SLBM Version " + slbm.getVersion());
            slbm.loadVelocityModelBinary(modelDirectory.getCanonicalPath());
            Scanner input = new Scanner(dataFile);
            String line = input.nextLine();
            while (line.trim().length() > 0) {
                System.out.println(line);
                line = input.nextLine();
            }
            int nrecords = 0;
            int ndifferent = 0;
            double tolerance = 0.02;
            while (input.hasNext()) {
                double slow;
                double tt_uncertainty;
                double tt;
                double distance;
                String phase = input.next();
                double srcLat = input.nextDouble();
                double srcLon = input.nextDouble();
                double srcDepth = input.nextDouble();
                double rcvLat = input.nextDouble();
                double rcvLon = input.nextDouble();
                double rcvDepth = input.nextDouble();
                double distance0 = input.nextDouble();
                double tt0 = input.nextDouble();
                double tt_uncertainty0 = input.nextDouble();
                double slow0 = input.nextDouble();
                try {
                    slbm.createGreatCircle(phase, Math.toRadians(srcLat), Math.toRadians(srcLon), srcDepth, Math.toRadians(rcvLat), Math.toRadians(rcvLon), rcvDepth);
                    distance = Math.toDegrees(slbm.getDistance());
                    tt = slbm.getTravelTime();
                    tt_uncertainty = slbm.getTravelTimeUncertainty();
                    slow = Math.toRadians(slbm.getSlowness());
                }
                catch (SLBMException ex) {
                    slow = -999.0;
                    tt_uncertainty = -999.0;
                    tt = -999.0;
                    distance = -999.0;
                }
                ++nrecords;
                if (!(Math.abs(distance - distance0) > tolerance || Math.abs(tt - tt0) > tolerance || Math.abs(tt_uncertainty - tt_uncertainty0) > tolerance) && !(Math.abs(slow - slow0) > tolerance)) continue;
                if (++ndifferent == 1) {
                    System.out.printf("%n%n#ph   srcLat      srcLon srcDepth    rcvLat     rcvLon  rcvDepth    dist0     dist     tt0       tt   uncert0   uncert    slow0     slow%n", new Object[0]);
                }
                System.out.printf("%s %10.6f %11.6f %7.3f %10.6f %11.6f %7.3f %8.3f %8.3f %8.3f %8.3f %8.3f %8.3f %8.3f %8.3f%n", phase, srcLat, srcLon, srcDepth, rcvLat, rcvLon, rcvDepth, distance0, distance, tt0, tt, tt_uncertainty0, tt_uncertainty, slow0, slow);
            }
            System.out.println();
            System.out.printf("%d of %d travel times differences exceeded tolerance of %1.3f seconds%n%n", ndifferent, nrecords, tolerance);
            if (ndifferent == 0) {
                System.out.printf("PASSED%n%n", new Object[0]);
            } else {
                System.out.printf("FAILED%n%n", new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void generate_regression_test_data(String[] args) {
        System.out.println("Start generate_regression_test_data()");
        try {
            if (args.length != 3) {
                throw new Exception("Must speficy three command line arguments: model directory, output file and input file.");
            }
            File modelDirectory = new File(args[0]);
            File outputFile = new File(args[1]);
            File inputFile = new File(args[2]);
            SlbmInterface slbm = new SlbmInterface();
            slbm.loadVelocityModelBinary(modelDirectory.getCanonicalPath());
            Scanner input = null;
            input = new Scanner(inputFile);
            BufferedWriter output = new BufferedWriter(new FileWriter(outputFile));
            String line = input.nextLine();
            while (line.trim().length() > 0) {
                line = input.nextLine();
            }
            output.write(String.format("# Regression data computed with model = %s, SLBM version %s%n", modelDirectory.getName(), slbm.getVersion()));
            output.write(String.format("#ph   srcLat      srcLon srcDepth    rcvLat     rcvLon  rcvDepth    dist     tt     uncert    slow%n", new Object[0]));
            output.newLine();
            int nrecords = 0;
            while (input.hasNext()) {
                double tt_uncertainty;
                double sh;
                double distance;
                double tt;
                String phase = input.next();
                double slat = input.nextDouble();
                double slon = input.nextDouble();
                double sdepth = input.nextDouble();
                double rlat = input.nextDouble();
                double rlon = input.nextDouble();
                double rdepth = input.nextDouble();
                input.nextLine();
                try {
                    slbm.createGreatCircle(phase, Math.toRadians(slat), Math.toRadians(slon), sdepth, Math.toRadians(rlat), Math.toRadians(rlon), rdepth);
                    tt = slbm.getTravelTime();
                    distance = Math.toDegrees(slbm.getDistance());
                    sh = Math.toRadians(slbm.getSlowness());
                    tt_uncertainty = slbm.getTravelTimeUncertainty();
                }
                catch (SLBMException ex) {
                    tt_uncertainty = -999.0;
                    sh = -999.0;
                    distance = -999.0;
                    tt = -999.0;
                }
                output.write(String.format("%s %10.6f %11.6f %7.3f %10.6f %11.6f %7.3f %8.3f %8.3f %8.3f %8.3f%n", phase, slat, slon, sdepth, rlat, rlon, rdepth, distance, tt, tt_uncertainty, sh));
                ++nrecords;
            }
            System.out.println();
            System.out.printf("%d ray paths generated and written to file %s%n%n", nrecords, outputFile.getCanonicalPath());
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Done with generate_regression_test_data()");
        System.out.println();
    }
}

