/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

public class Location {
    static double EARTH_RADIUS = -1.0;
    protected static int locationClassCount = 0;
    protected double radius;
    protected double[] v = new double[3];

    public Location() {
        this.radius = 6378.137;
        ++locationClassCount;
        this.v[0] = 1.0;
        this.v[2] = 0.0;
        this.v[1] = 0.0;
    }

    public Location(double[] u, double r) {
        ++locationClassCount;
        this.v[0] = u[0];
        this.v[1] = u[1];
        this.v[2] = u[2];
        this.radius = r;
    }

    public Location(double latitude, double longitude, double depth) {
        ++locationClassCount;
        this.setLocation(latitude, longitude, depth);
    }

    public Location(Location other) {
        this.radius = other.radius;
        ++locationClassCount;
        this.v[0] = other.v[0];
        this.v[1] = other.v[1];
        this.v[2] = other.v[2];
    }

    public Location(Location loc1, Location loc2) {
        ++locationClassCount;
        this.v[0] = loc1.v[0] + loc2.v[0];
        this.v[1] = loc1.v[1] + loc2.v[1];
        this.v[2] = loc1.v[2] + loc2.v[2];
        this.normalize(this.v);
        this.radius = 0.5 * (loc1.radius + loc2.radius);
    }

    public double angle(double[] u, double[] w) {
        return Math.acos(Math.max(Math.min(this.dot(u, w), 1.0), -1.0));
    }

    public double azimuth(Location other) {
        return this.azimuth(other, 0.0);
    }

    public double azimuth(Location other, double errorValue) {
        double[] c;
        double azim = errorValue;
        double[] c2 = new double[3];
        if (this.cross(this.v, other.v, c2) > 0.0 && this.crossNorth(this.v, c = new double[3]) > 0.0) {
            azim = this.angle(c, c2);
            if (c2[2] < 0.0) {
                azim = Math.PI * 2 - azim;
            }
        }
        return azim;
    }

    public double azimuthDegrees(Location other) {
        return this.azimuth(other) * 57.29577951308232;
    }

    public double azimuthDegrees(Location other, double errorValue) {
        double az = this.azimuth(other, errorValue);
        if (az != errorValue) {
            az *= 57.29577951308232;
        }
        return az;
    }

    public Location copy(Location other) {
        this.v[0] = other.v[0];
        this.v[1] = other.v[1];
        this.v[2] = other.v[2];
        this.radius = other.radius;
        return this;
    }

    public double cross(double[] u, double[] s, double[] w) {
        w[0] = u[1] * s[2] - u[2] * s[1];
        w[1] = u[2] * s[0] - u[0] * s[2];
        w[2] = u[0] * s[1] - u[1] * s[0];
        return this.normalize(w);
    }

    public boolean cross(Location x, Location loc) {
        loc.radius = this.cross(this.v, x.v, loc.v) > 0.0 ? this.radius : -1.0;
        return loc.radius > 0.0;
    }

    public double crossNorth(double[] u, double[] w) {
        double len = u[0] * u[0] + u[1] * u[1];
        if (len <= 0.0) {
            len = 0.0;
            w[0] = 0.0;
            w[1] = 0.0;
            w[2] = 0.0;
        } else {
            len = Math.sqrt(len);
            w[0] = u[1] / len;
            w[1] = -u[0] / len;
            w[2] = 0.0;
        }
        return len;
    }

    public double distance(Location other) {
        return this.angle(this.v, other.v);
    }

    public double distanceDegrees(Location other) {
        return this.angle(this.v, other.v) * 57.29577951308232;
    }

    public double distanceKm(Location other) {
        double distance = this.angle(this.v, other.v);
        if (EARTH_RADIUS > 0.0) {
            return distance * EARTH_RADIUS;
        }
        int n = (int)Math.ceil(distance / (Math.PI / 180));
        if (n == 1) {
            return distance * 0.5 * (this.getEarthRadius() + other.getEarthRadius());
        }
        double dx = distance / (double)n;
        double[] vtp = new double[3];
        Location loc = new Location();
        this.vectorTripleProduct(other, vtp);
        distance = 0.0;
        int i = 0;
        while (i < n) {
            this.move(vtp, dx * ((double)i + 0.5), loc);
            distance += dx * loc.getEarthRadius();
            ++i;
        }
        return distance;
    }

    public double dot(Location other) {
        return this.v[0] * other.v[0] + this.v[1] * other.v[1] + this.v[2] * other.v[2];
    }

    public double dot(double[] u, double[] s) {
        return u[0] * s[0] + u[1] * s[1] + u[2] * s[2];
    }

    public boolean equals(Object o) {
        if (o instanceof Location) {
            Location other = (Location)o;
            return this.v[0] == other.v[0] && this.v[1] == other.v[1] && this.v[2] == other.v[2] && this.radius == other.radius;
        }
        return false;
    }

    protected void finalize() {
        --locationClassCount;
    }

    public static int getClassCount() {
        return locationClassCount;
    }

    public double getDepth() {
        return this.getEarthRadius() - this.radius;
    }

    public double getEarthRadius() {
        if (EARTH_RADIUS > 0.0) {
            return EARTH_RADIUS;
        }
        return 6378.137 / Math.sqrt(1.0 + this.v[2] * this.v[2] * 0.006694380022900787 / 0.9933056199770992);
    }

    public double getGeocentricLat() {
        return Math.asin(this.v[2]);
    }

    public double getGeocentricLatDegrees() {
        return Math.asin(this.v[2]) * 57.29577951308232;
    }

    public double getLat() {
        return Math.atan(Math.tan(Math.asin(this.v[2])) / 0.9933056199770992);
    }

    public double getLatDegrees() {
        return 57.29577951308232 * this.getLat();
    }

    public double getLon() {
        return Math.atan2(this.v[1], this.v[0]);
    }

    public double getLonDegrees() {
        return 57.29577951308232 * this.getLon();
    }

    public double getRadius() {
        return this.radius;
    }

    public double[] getUnitVector() {
        return this.v;
    }

    public void getUnitVector(double[] x) {
        x[0] = this.v[0];
        x[1] = this.v[1];
        x[2] = this.v[2];
    }

    public double length(double[] u) {
        double l = this.dot(u, u);
        if (l > 0.0) {
            return Math.sqrt(l);
        }
        return 0.0;
    }

    public void move(double azimuth, double distance, Location loc) {
        double[] x = new double[3];
        this.move_north(this.v, distance, x);
        this.rotate(x, this.v, -azimuth, loc.v);
        loc.radius = this.radius;
    }

    public void move(double[] vtp, double a, Location loc) {
        this.move(this.v, vtp, a, loc.v);
        loc.radius = this.radius;
    }

    public void move(double[] w, double[] vtp, double a, double[] u) {
        double cosa = Math.cos(a);
        double sina = Math.sin(a);
        u[0] = cosa * w[0] + sina * vtp[0];
        u[1] = cosa * w[1] + sina * vtp[1];
        u[2] = cosa * w[2] + sina * vtp[2];
    }

    public void move_north(double distance, Location loc) {
        double[] vtp = new double[3];
        this.vectorTripleProductNorthPole(this.v, vtp);
        this.move(this.v, vtp, distance, loc.v);
    }

    public void move_north(double[] x, double distance, double[] z) {
        double[] c = new double[3];
        this.vectorTripleProductNorthPole(x, c);
        this.move(x, c, distance, z);
    }

    public double normalize(double[] u) {
        double len = this.length(u);
        if (len == 0.0) {
            u[2] = 0.0;
            u[1] = 0.0;
            u[0] = 0.0;
        } else {
            u[0] = u[0] / len;
            u[1] = u[1] / len;
            u[2] = u[2] / len;
        }
        return len;
    }

    public void rotate(Location p, double a, Location loc) {
        this.rotate(this.v, p.v, a, loc.v);
        loc.radius = this.radius;
    }

    public void rotate(double[] x, double[] p, double a, double[] z) {
        double d = x[0] * p[0] + x[1] * p[1] + x[2] * p[2];
        if (d <= -1.0 || d >= 1.0) {
            z[0] = x[0];
            z[1] = x[1];
            z[2] = x[2];
        } else {
            double cosa = Math.cos(a);
            double sina = Math.sin(a);
            z[0] = cosa * x[0] + (d *= 1.0 - cosa) * p[0] + sina * (p[1] * x[2] - p[2] * x[1]);
            z[1] = cosa * x[1] + d * p[1] + sina * (p[2] * x[0] - p[0] * x[2]);
            z[2] = cosa * x[2] + d * p[2] + sina * (p[0] * x[1] - p[1] * x[0]);
            double len = Math.sqrt(z[0] * z[0] + z[1] * z[1] + z[2] * z[2]);
            z[0] = z[0] / len;
            z[1] = z[1] / len;
            z[2] = z[2] / len;
        }
    }

    public double scalarTripleProduct(Location loc1, Location loc2) {
        return this.scalarTripleProduct(loc1.v, loc2.v, this.v);
    }

    public double scalarTripleProduct(double[] v1, double[] v2) {
        return this.scalarTripleProduct(v1, v2, this.v);
    }

    public double scalarTripleProduct(double[] u, double[] p, double[] w) {
        return u[0] * p[1] * w[2] + p[0] * w[1] * u[2] + w[0] * u[1] * p[2] - w[0] * p[1] * u[2] - u[0] * w[1] * p[2] - p[0] * u[1] * w[2];
    }

    public void setDepth(double depth) {
        this.radius = this.getEarthRadius() - depth;
    }

    public void setLocation(double latitude, double longitude, double depth) {
        double x = Math.atan(0.9933056199770992 * Math.tan(latitude));
        this.v[2] = Math.sin(x);
        x = Math.cos(x);
        this.v[0] = x * Math.cos(longitude);
        this.v[1] = x * Math.sin(longitude);
        this.radius = this.getEarthRadius() - depth;
    }

    public void setRadius(double r) {
        this.radius = r;
    }

    public void setUnitVector(double[] x) {
        this.v[0] = x[0];
        this.v[1] = x[1];
        this.v[2] = x[2];
    }

    public String toString() {
        return String.format("%9.4f %10.4f %10.3f", this.getLatDegrees(), this.getLonDegrees(), this.getDepth());
    }

    public boolean vectorTripleProduct(Location other, double[] vtp) {
        return this.vectorTripleProduct(this.v, other.v, vtp);
    }

    public boolean vectorTripleProduct(double[] u, double[] s, double[] w) {
        double q0 = u[1] * s[2] - u[2] * s[1];
        double q1 = u[2] * s[0] - u[0] * s[2];
        double q2 = u[0] * s[1] - u[1] * s[0];
        w[0] = q1 * u[2] - q2 * u[1];
        w[1] = q2 * u[0] - q0 * u[2];
        w[2] = q0 * u[1] - q1 * u[0];
        return this.normalize(w) != 0.0;
    }

    public boolean vectorTripleProductNorthPole(double[] u, double[] w) {
        w[0] = -u[0] * u[2];
        w[1] = -u[1] * u[2];
        w[2] = u[1] * u[1] + u[0] * u[0];
        return this.normalize(w) != 0.0;
    }
}

