/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.Grid;
import cn.org.gddsn.seis.location.rstt.GridProfile;
import cn.org.gddsn.seis.location.rstt.Location;

public class InterpolatedProfile {
    protected static int interpolatedProfileClassCount;
    protected GridProfile[] neighbors = new GridProfile[3];
    protected double[] coefficients = new double[3];

    public InterpolatedProfile() {
        ++interpolatedProfileClassCount;
    }

    public InterpolatedProfile(Grid grid, Location location) {
        ++interpolatedProfileClassCount;
        grid.findProfile(location, this.neighbors, this.coefficients);
    }

    public InterpolatedProfile(InterpolatedProfile other) {
        ++interpolatedProfileClassCount;
        int i = 0;
        while (i < 3) {
            this.neighbors[i] = other.neighbors[i];
            this.coefficients[i] = other.coefficients[i];
            ++i;
        }
    }

    public InterpolatedProfile copy(InterpolatedProfile other) {
        int i = 0;
        while (i < 3) {
            this.neighbors[i] = other.neighbors[i];
            this.coefficients[i] = other.coefficients[i];
            ++i;
        }
        return this;
    }

    public boolean equals(InterpolatedProfile other) {
        int i = 0;
        while (i < 3) {
            if (this.neighbors[i] != other.neighbors[i] || this.coefficients[i] != other.coefficients[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals_no(InterpolatedProfile other) {
        return !this.equals(other);
    }

    protected void finalize() {
        --interpolatedProfileClassCount;
    }

    public static int getClassCount() {
        return interpolatedProfileClassCount;
    }

    public double[] getCoefficients() {
        return this.coefficients;
    }

    public void getCoefficients(double[] coeff) {
        int i = 0;
        while (i < 3) {
            coeff[i] = this.coefficients[i];
            ++i;
        }
    }

    public GridProfile[] getNeighbors() {
        return this.neighbors;
    }

    public void getNodeIds(int[] nodeIds) {
        int i = 0;
        while (i < 3) {
            nodeIds[i] = this.neighbors[i].getNodeId();
            ++i;
        }
    }

    public void interpDepth(int k, double[] depth, int kk) {
        depth[kk] = 0.0;
        int i = 0;
        while (i < 3) {
            if (this.neighbors[i] != null) {
                int n = kk;
                depth[n] = depth[n] + this.neighbors[i].getInterfaceDepth(k) * this.coefficients[i];
            }
            ++i;
        }
    }

    public void interpGradient(int type, double[] gradient, int k) {
        gradient[k] = 0.0;
        int i = 0;
        while (i < 3) {
            if (this.neighbors[i] != null) {
                int n = k;
                gradient[n] = gradient[n] + this.neighbors[i].getMantleGradient(type) * this.coefficients[i];
            }
            ++i;
        }
    }

    public void interpRadius(int k, double[] radius, int kk) {
        radius[kk] = 0.0;
        int i = 0;
        while (i < 3) {
            if (this.neighbors[i] != null) {
                int n = kk;
                radius[n] = radius[n] + this.neighbors[i].getInterfaceRadius(k) * this.coefficients[i];
            }
            ++i;
        }
    }

    public void interpVelocity(int type, int k, double[] velocity, int kk) {
        velocity[kk] = 0.0;
        int i = 0;
        while (i < 3) {
            if (this.neighbors[i] != null) {
                int n = kk;
                velocity[n] = velocity[n] + this.neighbors[i].getVelocity(type, k) * this.coefficients[i];
            }
            ++i;
        }
    }

    public boolean isActiveProfile() {
        int i = 0;
        while (i < 3) {
            if (this.neighbors[i].getActiveNodeId() < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

