/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import com.nr.UniVarRealValueFun;
import org.netlib.util.doubleW;

public class IntegrateFunction {
    private double ifTol;
    private UniVarRealValueFun ifF;

    public IntegrateFunction(UniVarRealValueFun f, double tol) {
        this.ifF = f;
        this.ifTol = tol;
    }

    public IntegrateFunction(IntegrateFunction ifctn) {
        this.ifF = ifctn.ifF;
        this.ifTol = ifctn.ifTol;
    }

    public IntegrateFunction copy(IntegrateFunction ifnctn) {
        this.ifTol = ifnctn.ifTol;
        return this;
    }

    public double integrateClosed(double a, double b) {
        double[] fr = new double[]{this.ifF.funk(a), this.ifF.funk(0.5 * (a + b)), this.ifF.funk(b)};
        return this.integrateClosedRcrsv(a, b, fr, 0);
    }

    public double integrateAOpenS(double a, double b) {
        double senew;
        double s = 0.0;
        double e = (b - a) * this.ifTol;
        double fa = Math.abs(a);
        double minstep = 2.220446049250313E-15;
        if (fa > 1.0) {
            minstep *= fa;
        }
        double ae = a + e;
        s = this.integrateClosed(ae, b);
        double be = ae;
        ae = a + 0.1 * e;
        do {
            senew = this.integrateClosed(ae, be);
            double fs = Math.abs(s += senew);
            if (Math.abs(senew) < this.ifTol * fs || fs < this.ifTol) {
                return s;
            }
            be = ae;
            ae = a + 0.1 * (e /= 10.0);
        } while (e > minstep && be > ae && ae > a);
        if (Math.abs(senew) > this.ifTol) {
            System.err.printf("  Error:: Function Error Tolerance Exceeded ... \n", new Object[0]);
            System.err.printf("          Tolerance Condition Was Not Met.\n", new Object[0]);
        }
        return s;
    }

    public UniVarRealValueFun getF() {
        return this.ifF;
    }

    public void setTolerance(double tol) {
        this.ifTol = tol;
    }

    public double getTolerance() {
        return this.ifTol;
    }

    private double integrateClosedRcrsv(double a, double b, double[] fr, int off) {
        double fs;
        doubleW s = new doubleW(0.0);
        double[] fa = new double[5];
        fa[0] = fr[off + 0];
        fa[2] = fr[off + 1];
        fa[4] = fr[off + 2];
        double se = this.simpson(a, b, fa, s);
        if (se < this.ifTol * (fs = Math.abs(s.val)) || fs < this.ifTol) {
            return s.val;
        }
        double m = 0.5 * (a + b);
        if (m <= a | b <= m) {
            if (se > this.ifTol) {
                System.err.printf("  Error:: Function Error Tolerance Exceeded ... \n", new Object[0]);
                System.err.printf("          Tolerance Condition Was Not Met.\n", new Object[0]);
            }
            return s.val;
        }
        return this.integrateClosedRcrsv(a, m, fa, 0) + this.integrateClosedRcrsv(m, b, fa, 2);
    }

    private double simpson(double a, double b, double[] fa, doubleW s) {
        double h = b - a;
        fa[1] = this.ifF.funk(a + 0.25 * h);
        fa[3] = this.ifF.funk(a + 0.75 * h);
        double dh = (h *= 0.5) / 6.0;
        double s1 = 2.0 * dh * (fa[0] + 4.0 * fa[2] + fa[4]);
        s.val = dh * (fa[0] + 4.0 * (fa[1] + fa[3]) + 2.0 * fa[2] + fa[4]);
        return Math.abs(s.val - s1);
    }
}

