/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

public class GridProfileData {
    public int nodeId = -1;
    public double lat;
    public double lon;
    public double[] depth = new double[0];
    public double[][] velocity = new double[2][0];
    public double[] gradient = new double[0];

    public String getLatLon() {
        return String.format("%8.4f %9.4f", Math.toDegrees(this.lat), Math.toDegrees(this.lon));
    }

    public int getNIntervals() {
        return this.depth.length;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("GridProfile:\n\n");
        s.append(String.format("  Node ID  : %10d%n  Latitude : %10.4f%n  Longitude: %10.4f%n%n", this.nodeId, Math.toDegrees(this.lat), Math.toDegrees(this.lon)));
        s.append("     Depth        Thick      P Vel      S Vel\n");
        int i = 0;
        while (i < this.getNIntervals() - 1) {
            s.append(String.format("%12.6f %10.4f %10.4f %10.4f%n", this.depth[i], this.depth[i + 1] - this.depth[i], this.velocity[0][i], this.velocity[1][i]));
            ++i;
        }
        i = this.getNIntervals() - 1;
        s.append(String.format("%12.6f %10s %10.4f %10.4f%n", this.depth[i], " ", this.velocity[0][i], this.velocity[1][i]));
        s.append("               P Grad     S Grad\n");
        s.append(String.format("%10s %10.6f %10.6f%n%n", "", this.gradient[0], this.gradient[1]));
        return s.toString();
    }
}

